/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc;

import com.inet.annotations.InternalApi;
import com.inet.cache.font.SerializableGeneralFont;
import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigKey;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.config.LicenseInfo;
import com.inet.config.ModulePriority;
import com.inet.config.TempConfiguration;
import com.inet.config.recovery.RecoveryLauncher;
import com.inet.config.structure.core.CoreSystemStructureProvider;
import com.inet.config.structure.provider.ConfigStructureProvider;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.error.ErrorCode;
import com.inet.error.HasErrorCode;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonSubTypeResolver;
import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.CoreLoggers;
import com.inet.logging.LogLevel;
import com.inet.logging.LogLevelsDefaults;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.pdfc.LicenseModel;
import com.inet.pdfc.PDFC;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.PDFCLicenseChecker;
import com.inet.pdfc.PDFCRecoveryConfiguration;
import com.inet.pdfc.PDFCVersion;
import com.inet.pdfc.commandline.a;
import com.inet.pdfc.commandline.b;
import com.inet.pdfc.commandline.c;
import com.inet.pdfc.config.DefaultProfile;
import com.inet.pdfc.config.LanguageValues;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.config.PDFCPropertyUpdater;
import com.inet.pdfc.generator.analysis.FeatureKey;
import com.inet.pdfc.generator.continuous.ContinuousComparatorFactory;
import com.inet.pdfc.generator.filter.FilterFactory;
import com.inet.pdfc.generator.filter.IFilterFactory;
import com.inet.pdfc.generator.filter.ISortFilterFactory;
import com.inet.pdfc.generator.filter.SortFilterFactoryBase;
import com.inet.pdfc.generator.filter.bidi.BidiSortFilter;
import com.inet.pdfc.generator.message.HighlightData;
import com.inet.pdfc.generator.rendercache.PdfcRenderCache;
import com.inet.pdfc.generator.resultfilter.IResultFilterFactory;
import com.inet.pdfc.generator.resultfilter.LocationMixUpFilter;
import com.inet.pdfc.generator.resultfilter.ResultFilterFactoryBase;
import com.inet.pdfc.generator.strict.StrictComparerFactory;
import com.inet.pdfc.i18n.I18nMessageToBundleProvider;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.images.PDFCLogoProvider;
import com.inet.pdfc.ocr.OcrFactory;
import com.inet.pdfc.ocr.OcrUsage;
import com.inet.pdfc.pagegraphics.PageGraphicsConverter;
import com.inet.pdfc.persistence.UserSettingsImpl;
import com.inet.pdfc.plugin.CommandLineParameter;
import com.inet.pdfc.plugin.PluginManager;
import com.inet.pdfc.plugin.configurations.PreInstalledProfile;
import com.inet.pdfc.plugin.interfaces.ComparatorFactory;
import com.inet.pdfc.plugin.interfaces.CompareRunnerFactory;
import com.inet.pdfc.plugin.interfaces.DocumentFactory;
import com.inet.pdfc.plugin.interfaces.DocumentFontListener;
import com.inet.pdfc.plugin.interfaces.PaintComparatorFactory;
import com.inet.pdfc.plugin.interfaces.PaintConverterFactory;
import com.inet.pdfc.plugin.pdfparser.PDFDocumentFactory;
import com.inet.pdfc.plugin.pdfparser.PDFParserProperties;
import com.inet.pdfc.plugin.pdfparser.PatternPaintComparatorFactory;
import com.inet.pdfc.plugin.pdfparser.PatternPaintConverterFactory;
import com.inet.pdfc.plugin.persistence.ProfilePersistence;
import com.inet.pdfc.plugin.persistence.ProfilePersistenceManager;
import com.inet.pdfc.plugin.persistence.ProfilePersistenceManagerImpl;
import com.inet.pdfc.plugin.pool.PoolCompareRunnerFactory;
import com.inet.pdfc.presenter.Preview;
import com.inet.pdfc.presenter.PrintToPDFFactory;
import com.inet.pdfc.presenter.ReportPDFPresenterFactory;
import com.inet.pdfc.presenter.impl.PrintToPDFFactoryImpl;
import com.inet.pdfc.presenter.impl.ReportPDFPresenterFactoryImpl;
import com.inet.pdfc.presenter.impl.ReportPluginPermissionChecker;
import com.inet.pdfc.presenter.impl.ReportPreviewImpl;
import com.inet.pdfc.presenter.impl.datasource.ComparisonResultDataFactory;
import com.inet.pdfc.reporting.FontGenerationCtrl;
import com.inet.pdfc.results.filter.PerModificationResultFilter;
import com.inet.pdfc.results.filter.ResultFilterFactory;
import com.inet.pdfc.structure.PdfcStructureProvider;
import com.inet.pdfc.thread.PdfcSession;
import com.inet.pdfc.util.LogLevelTranslate;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.font.FontFactory;
import com.inet.permissions.Permission;
import com.inet.permissions.url.PluginPermissionChecker;
import com.inet.persistence.Persistence;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.CoreServerPlugin;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.Executable;
import com.inet.plugin.HelpProviderContainer;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.RemoteGuiInformation;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.ServerPluginManagerListener;
import com.inet.plugin.help.ConfigHelpProvider;
import com.inet.plugin.help.HelpProvider;
import com.inet.plugin.help.HelpProviderImpl;
import com.inet.plugin.image.ProductLogoProvider;
import com.inet.plugin.website.WellKnownWebsites;
import com.inet.report.database.DataFactory;
import com.inet.shared.utils.Version;
import com.inet.thread.BaseRunnableSession;
import com.inet.thread.RunnableSession;
import com.inet.thread.ThreadPool;
import com.inet.usersandgroups.api.UserField;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PluginInfo(id="pdfc", dependencies="", optionalDependencies="reporting;parser.pdf", packages="com.inet.pdfc", group="system;comparisons", version="25.10.259", internal="icu4j.jar", flags="core;designer", icon="com/inet/pdfc/structure/pdfcerver_48.png")
@InternalApi
public class PDFCCorePlugin
implements CoreServerPlugin,
ServerPlugin {
    public static final String PLUGIN_ID = "pdfc";
    public static final String PLUGIN_ID_GUI = "pdfc.gui";
    public static final String PLUGIN_ID_STANDALONE = "pdfc.standalone";
    public static final I18nMessages MSG;
    public static final String APP_NAME = "i-net PDFC";
    private static ThreadLocal<String> ag;
    private static ThreadLocal<Boolean> ah;
    private static boolean ai;
    private static Persistence aj;
    private static PDFCLogoProvider ak;
    public static final FeatureKey FEATURE_LANGUAGE_DETECTION;
    private ProfilePersistenceManagerImpl al;

    public static void configureLogging(DefaultProfile configuration, boolean defaultToConsolse) {
        String string;
        String string2;
        Configuration configuration2 = ConfigurationManager.getInstance().getCurrent();
        String string3 = configuration2.get(ConfigKey.LOG_FILE.getKey());
        if (configuration.getProperties().containsKey(PDFCProperty.LOG_FILE.name())) {
            string2 = configuration.getString(PDFCProperty.LOG_FILE);
        } else if (StringFunctions.isEmpty((String)string3)) {
            if (defaultToConsolse) {
                string2 = null;
            } else {
                if (aj == null) {
                    aj = Persistence.getInstance();
                }
                string2 = Persistence.isFilePersistence() ? aj.resolve("log.txt").getPath() : null;
            }
        } else {
            string2 = string3;
        }
        if (!StringFunctions.isEmpty((String)string2)) {
            LogManager.getConfigLogger().info((Object)Msg.getMsg("Config.logToFile", string2));
        }
        if (StringFunctions.isEmpty((String)string3) ? !StringFunctions.isEmpty((String)string2) : !string3.equals(string2)) {
            configuration2 = PDFCCorePlugin.a(configuration2);
            configuration2.put(ConfigKey.LOG_FILE.getKey(), string2);
        }
        if (configuration.getProperties().containsKey(PDFCProperty.LOG_LEVEL.name()) && (string = configuration.getString(PDFCProperty.LOG_LEVEL)) != null) {
            LogLevel logLevel = LogLevelTranslate.getLogLevel(string);
            PDFCCorePlugin.setLogLevel(logLevel, PDFCCorePlugin.a(configuration2));
        }
    }

    public static void configureLogging(File logfilename) {
        if (logfilename != null) {
            if (!logfilename.exists()) {
                try {
                    logfilename.createNewFile();
                }
                catch (IOException iOException) {
                    PDFCCore.LOGGER_CORE.error((Object)Msg.getMsg("Config.error.createLogFile", logfilename.getAbsolutePath()));
                }
            }
            PDFCCore.LOGGER_CORE.debug((Object)Msg.getMsg("Config.logToFile", logfilename.getAbsolutePath()));
            try {
                LogManager.setLogStream((PrintStream)new PrintStream(new FileOutputStream(logfilename, true)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                PDFCCore.LOGGER_CORE.error((Object)Msg.getMsg("Config.error.locationLogFile", logfilename.getAbsolutePath()));
            }
        } else {
            LogManager.setLogStream((PrintStream)System.out);
        }
    }

    private static Configuration a(Configuration configuration) {
        if (configuration instanceof TempConfiguration) {
            return configuration;
        }
        aj = Persistence.getInstance();
        return ConfigurationManager.getInstance().setTemporaryProperties(configuration.getProperties());
    }

    public static void setLogLevel(LogLevel level) {
        for (String string : CoreLoggers.CORE_LOGGERS) {
            LogManager.getLogger((String)string).setLogLevel(level.getValue());
        }
    }

    public static void setLogLevel(LogLevel level, Configuration config) {
        String string = config.get(ConfigKey.LOG_LEVELS.getKey());
        LogLevelsDefaults logLevelsDefaults = string != null ? (LogLevelsDefaults)new Json().fromJson(string, LogLevelsDefaults.class) : new LogLevelsDefaults();
        Integer n = level.getValue();
        for (String string2 : CoreLoggers.CORE_LOGGERS) {
            logLevelsDefaults.put((Object)string2, (Object)n);
        }
        string = new Json().toJson((Object)logLevelsDefaults);
        config.put(ConfigKey.LOG_LEVELS.getKey(), string);
    }

    public void init(ServerPluginManager manager) {
        CoreSystemStructureProvider.addFilterPropertyLicense((String)PLUGIN_ID);
        for (ProfilePersistence profilePersistence : PreInstalledProfile.getAllPreInstalledProfiles()) {
            DynamicExtensionManager.getInstance().register(ProfilePersistence.class, (Object)profilePersistence);
        }
        ForkJoinPool.commonPool().execute(() -> {
            LogManager.getApplicationLogger().debug((Object)"Initializing pdfc core plugin");
            this.al.initIndex();
            if (ConfigurationManager.getInstance().getCurrent().getScope() != 4) {
                aj = Persistence.getInstance();
            }
            ThreadPool.DEFAULT.startSubThread(() -> this.p(), (RunnableSession)new BaseRunnableSession());
            this.q();
            PDFCCorePlugin.findInstalledOCRLanguages();
            this.o();
        });
    }

    void o() {
        Object object;
        HashMap<ClassLoader, String> hashMap = new HashMap<ClassLoader, String>();
        ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
        for (String object2 : serverPluginManager.getLoadedPlugins()) {
            object = serverPluginManager.getPluginDescription(object2);
            hashMap.put(object.getClassLoader(), object2);
        }
        List list = serverPluginManager.get(Msg.ResourceBundleProvider.class);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Msg.ResourceBundleProvider resourceBundleProvider = (Msg.ResourceBundleProvider)iterator.next();
            if (resourceBundleProvider instanceof I18nMessageToBundleProvider) {
                String string = ((I18nMessageToBundleProvider)resourceBundleProvider).getPluginID();
                Msg.addPluginBundle(string, resourceBundleProvider);
                continue;
            }
            ClassLoader classLoader = resourceBundleProvider.getClass().getClassLoader();
            object = (String)hashMap.get(classLoader);
            if (object == null || classLoader == this.getClass().getClassLoader()) {
                PDFCCore.LOGGER_CORE.error((Object)("Cannot determine the source plugin for translation provider '" + resourceBundleProvider.getClass().getName() + "'."));
                continue;
            }
            Msg.addPluginBundle((String)object, resourceBundleProvider);
        }
    }

    void p() {
        LicenseModel licenseModel = PDFCLicenseChecker.getCurrentLicenseModel();
        PDFCCore.LOGGER_CORE.info((Object)("i-net PDFC version: " + PDFC.getVersion(true, true)));
        StringBuilder stringBuilder = new StringBuilder();
        if (licenseModel != null) {
            stringBuilder.append(licenseModel.getLicenseInfoText());
        } else {
            stringBuilder.append("none");
        }
        PDFCCore.LOGGER_CORE.info((Object)("i-net PDFC license: " + String.valueOf(stringBuilder)));
    }

    void q() {
        Set<@Nonnull String> set = new HashSet<String>(FilterFactory.getAvailableInputFilterKeys());
        set.addAll(FilterFactory.getAvailableResultFilterKeys());
        set = set.stream().map(String::toLowerCase).collect(Collectors.toSet());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : PDFCProperty.FILTERS.getDefaultValue().split(",|;")) {
            if (!set.contains(string.toLowerCase())) continue;
            arrayList.add(string);
        }
        PDFCPropertyUpdater.modifyDefault(PDFCProperty.FILTERS, String.join((CharSequence)",", arrayList));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void findInstalledOCRLanguages() {
        @Nonnull List list = DynamicExtensionManager.getInstance().get(OcrFactory.class);
        LanguageValues.DEFAULT_INSTANCE.reset();
        for (OcrFactory ocrFactory : list) {
            try {
                OcrUsage ocrUsage = ocrFactory.createInstance();
                for (String string : ocrUsage.getInstalledLanguageFiles()) {
                    LanguageValues.DEFAULT_INSTANCE.addLanguage(string, () -> PDFCCorePlugin.d(string));
                }
            }
            catch (Throwable throwable) {
                if (throwable instanceof HasErrorCode) continue;
                PDFCCore.LOGGER_CORE.error(throwable);
            }
        }
    }

    private static String d(String string) {
        String string2;
        Object object;
        Locale locale = ClientLocale.getThreadLocale();
        String string3 = "";
        if (string.indexOf(95) > 0) {
            int n = string.indexOf(95);
            string3 = string.substring(n + 1, string.length());
            string = string.substring(0, n);
        }
        if (((String)(object = Locale.forLanguageTag(string).getDisplayName(locale))).equals(string) && (string2 = LanguageValues.TESS_MAP.get(object)) != null) {
            string = string2;
            object = Locale.forLanguageTag(string2).getDisplayName(locale);
        }
        if (string3.length() > 0) {
            object = (String)object + " (" + string3 + ")";
        }
        return object;
    }

    public void registerExtension(final ServerPluginManager manager) {
        LogManager.getApplicationLogger().debug((Object)"Registering pdfc core plugin extensions");
        Json.registerTypeResolver(HighlightData.Highlight.class, (JsonSubTypeResolver)new com.inet.pdfc.generator.message.a());
        if (PLUGIN_ID.equals(manager.getCorePluginId()) || PLUGIN_ID_GUI.equals(manager.getCorePluginId())) {
            manager.register(ApplicationDescription.class, (Object)this.getApplicationDescription());
        }
        manager.register(ComparatorFactory.class, (Object)new ContinuousComparatorFactory());
        manager.register(ComparatorFactory.class, (Object)new StrictComparerFactory());
        manager.register(CompareRunnerFactory.class, (Object)new PoolCompareRunnerFactory());
        manager.register(ISortFilterFactory.class, new SortFilterFactoryBase<com.inet.pdfc.generator.filter.b>("type", com.inet.pdfc.generator.filter.b.class, Arrays.asList(IFilterFactory.FLAG.internal), new PDFCProperty[0]));
        manager.register(ISortFilterFactory.class, new SortFilterFactoryBase<BidiSortFilter>("BIDI", BidiSortFilter.class, Arrays.asList(IFilterFactory.FLAG.internal, IFilterFactory.FLAG.executeAlways), new PDFCProperty[0]));
        manager.register(IResultFilterFactory.class, new ResultFilterFactoryBase<LocationMixUpFilter>("SOLVEFALSEREPLACE", LocationMixUpFilter.class, Arrays.asList(IFilterFactory.FLAG.internal, IFilterFactory.FLAG.executeAlways)));
        manager.register(ResultFilterFactory.class, new ResultFilterFactory<PerModificationResultFilter>(PerModificationResultFilter.class, "PerModificationFilter"));
        manager.register(ConfigStructureProvider.class, (Object)new PdfcStructureProvider());
        this.al = new ProfilePersistenceManagerImpl();
        manager.register(ProfilePersistenceManager.class, (Object)this.al);
        manager.register(PageGraphicsConverter.class, (Object)new com.inet.pdfc.pagegraphics.a());
        manager.register(UserField.class, UserSettingsImpl.SETTINGS);
        manager.register(CommandLineParameter.class, (Object)c.a.aA);
        manager.register(CommandLineParameter.class, (Object)c.a.aC);
        manager.register(CommandLineParameter.class, (Object)c.a.aB);
        manager.register(CommandLineParameter.class, (Object)new b());
        manager.register(CommandLineParameter.class, (Object)new a());
        manager.register(ProductLogoProvider.class, (Object)ak);
        if (manager.isPluginLoaded("reporting") || this.getClass().getResource("/com/inet/report/Engine.class") != null) {
            new Runnable(){

                @Override
                public void run() {
                    manager.register(PluginPermissionChecker.class, (Object)new ReportPluginPermissionChecker());
                    manager.register(ReportPDFPresenterFactory.class, (Object)new ReportPDFPresenterFactoryImpl());
                    manager.register(Preview.class, (Object)new ReportPreviewImpl());
                    manager.register(PrintToPDFFactory.class, (Object)new PrintToPDFFactoryImpl());
                    manager.register(DocumentFontListener.class, (Object)new FontGenerationCtrl());
                    manager.register(DataFactory.class, (Object)new ComparisonResultDataFactory());
                    Configuration configuration = ConfigurationManager.getInstance().getCurrent();
                    configuration.put(ConfigKey.USE_NATIVE_FONTS, "true");
                }
            }.run();
        }
        manager.runIfPluginLoaded("parser.pdf", () -> new Executable(){

            public void execute() {
                new PDFParserProperties();
                Logger logger = PDFParser.LOGGER;
                manager.register(DocumentFactory.class, (Object)new PDFDocumentFactory());
                manager.register(PaintConverterFactory.class, (Object)new PatternPaintConverterFactory());
                manager.register(PaintComparatorFactory.class, (Object)new PatternPaintComparatorFactory());
                manager.register(FontFactory.class, byArray -> new SerializableGeneralFont(byArray, PdfcSession.getSession().getStoreMap().nextKey(PdfcRenderCache.CONTENT_TYPE.font)));
            }
        });
    }

    public void registerHelp(final HelpProviderContainer container) {
        container.add((HelpProvider)new HelpProviderImpl(PLUGIN_ID, 2101, new Permission[]{null}){}, new String[0]);
        container.add((HelpProvider)new ConfigHelpProvider("configuration", 2102, new Permission[]{Permission.CONFIGURATION}){}, new String[0]);
        ServerPluginManager.getInstance().runIfPluginLoaded("parser.pdf", () -> new Executable(){

            public void execute() {
                container.add((HelpProvider)new HelpProviderImpl("parser", 2250, new Permission[]{null}){}, new String[0]);
            }
        });
    }

    public void reset() {
    }

    public void restart() {
    }

    static void e(String string) {
        ag.set(string);
    }

    static void r() {
        ah.set(Boolean.TRUE);
    }

    static void s() {
        ai = true;
    }

    @Nonnull
    public RecoveryLauncher getRecoveryLauncher() {
        return new PDFCRecoveryConfiguration();
    }

    public ApplicationDescription getApplicationDescription() {
        return new PDFCApplicationDescription();
    }

    public boolean startWithProcessStarter() {
        String[] stringArray = CoreServerPlugin.Start.getArgs();
        return stringArray.length == 0 || !"cmd".equals(stringArray[0]);
    }

    public void preInit(ServerPluginDescription spd) {
        com.inet.pdfc.a.n();
        final String[] stringArray = CoreServerPlugin.Start.getArgs();
        if (stringArray.length > 0 && "cmd".equals(stringArray[0])) {
            ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
            PluginManager.setPluginFilterForAPI(serverPluginManager);
            serverPluginManager.register(ServerPluginManagerListener.class, (Object)new ServerPluginManagerListener(){

                public void initFinished() {
                    try {
                        String[] stringArray2 = Arrays.copyOfRange(stringArray, 1, stringArray.length);
                        LicenseModel licenseModel = PDFCLicenseChecker.getCurrentLicenseModel();
                        if (licenseModel == null || !licenseModel.isValid()) {
                            ForkJoinPool.commonPool().awaitQuiescence(10L, TimeUnit.SECONDS);
                        }
                        PDFC.main(stringArray2);
                        System.exit(0);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace(System.err);
                        System.exit(1);
                    }
                }
            });
        }
    }

    static {
        ConfigurationManager.NAME_DEFAULT = APP_NAME;
        MSG = new I18nMessages("com.inet.pdfc.i18n.LanguageResources", PDFCVersion.class);
        ag = new ThreadLocal();
        ah = new ThreadLocal();
        ai = false;
        ak = new PDFCLogoProvider();
        FEATURE_LANGUAGE_DETECTION = new FeatureKey("language.detect");
    }

    @InternalApi
    public static class PDFCApplicationDescription
    implements ApplicationDescription {
        @Nonnull
        private final Version ar = new Version(PDFCVersion.c(true));

        @Nonnull
        public Version getVersion() {
            return this.ar;
        }

        @Nonnull
        public String getApplicationName() {
            return PDFCCorePlugin.APP_NAME;
        }

        public LicenseInfo getActiveLicenseInfo(@Nonnull List<LicenseInfo> licenses) {
            LicenseInfo licenseInfo = null;
            for (LicenseInfo licenseInfo2 : licenses) {
                if (!PDFCApplicationDescription.a(licenseInfo, licenseInfo2)) continue;
                licenseInfo = licenseInfo2;
            }
            return licenseInfo;
        }

        private static boolean a(LicenseInfo licenseInfo, LicenseInfo licenseInfo2) {
            ApplicationDescription applicationDescription = PluginManager.getSingleInstance(ApplicationDescription.class);
            if (licenseInfo2 == null || !applicationDescription.getApplicationName().equals(licenseInfo2.getAttributes().get("app"))) {
                return false;
            }
            if (licenseInfo == null) {
                return true;
            }
            if (!licenseInfo2.isValid()) {
                return false;
            }
            if (!licenseInfo.isValid() && licenseInfo2.isValid()) {
                return true;
            }
            int n = com.inet.pdfc.util.b.c(licenseInfo.getAttributes());
            int n2 = com.inet.pdfc.util.b.c(licenseInfo2.getAttributes());
            if (n2 > n && !com.inet.pdfc.util.b.d(licenseInfo.getAttributes())) {
                return true;
            }
            LicenseModel licenseModel = new LicenseModel(licenseInfo);
            LicenseModel licenseModel2 = new LicenseModel(licenseInfo2);
            ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
            boolean bl = PDFCCorePlugin.PLUGIN_ID_GUI.equals(serverPluginManager.getCorePluginId());
            if (!bl) {
                if (!licenseModel.isCommandLine() && licenseModel2.isCommandLine()) {
                    return true;
                }
                if (!licenseModel.isAPI() && licenseModel2.isAPI()) {
                    return true;
                }
            }
            return serverPluginManager.isPluginLoaded("webserver") && !licenseModel.isServer() && licenseModel2.isServer();
        }

        public static Supplier<String> validateBetaExpiration(Map<String, String> licenseProperties) {
            Supplier<String> supplier = (Supplier<String>)((Object)licenseProperties.get("error"));
            Date date = Version.getTechnicalBuildExpirationDate();
            if (date != null && !PDFCVersion.aw.before(date)) {
                supplier = () -> Msg.getMsg("License.BetaExpired");
            }
            return supplier;
        }

        public static Supplier<String> validateHardwareCheck(Map<String, String> licenseProperties) {
            String string = licenseProperties.get("hwid");
            if (string != null && !PDFCLicenseChecker.testForCorrectHardwareHash(string)) {
                return () -> Msg.getMsg("License.Invalid");
            }
            return null;
        }

        public static boolean isTrial(Map<String, String> licenseProperties) {
            return com.inet.pdfc.util.b.isTrial(licenseProperties);
        }

        @Nonnull
        public LicenseInfo validate(Map<String, String> licenseProperties) {
            String string = licenseProperties.get("displayname");
            String string2 = licenseProperties.get("licensee");
            Supplier<String> supplier = (Supplier<String>)((Object)licenseProperties.get("error"));
            boolean bl = PDFCApplicationDescription.isTrial(licenseProperties);
            if (supplier == null && this.getApplicationName().equals(licenseProperties.get("app"))) {
                boolean bl2;
                supplier = PDFCApplicationDescription.validateBetaExpiration(licenseProperties);
                ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
                boolean bl3 = serverPluginManager.isPluginLoaded("webserver");
                boolean bl4 = PDFCCorePlugin.PLUGIN_ID_GUI.equals(serverPluginManager.getCorePluginId());
                if (supplier == null && bl3 && !"true".equals(licenseProperties.get("server"))) {
                    supplier = () -> Msg.getMsg("License.NotServer");
                }
                if (supplier == null && bl4 && !"true".equals(licenseProperties.get("gui"))) {
                    supplier = () -> Msg.getMsg("License.NotGUI");
                }
                if (supplier == null && ai && !"true".equals(licenseProperties.get("commandline"))) {
                    supplier = () -> Msg.getMsg("License.NotCommandline");
                }
                boolean bl5 = bl2 = !ai && !bl3 && !bl4;
                if (supplier == null && bl2 && !"true".equals(licenseProperties.get("api"))) {
                    supplier = () -> Msg.getMsg("License.NotAPI");
                }
                if (supplier == null) {
                    supplier = PDFCApplicationDescription.validateHardwareCheck(licenseProperties);
                }
            }
            return new LicenseInfo(() -> string, string2, (Supplier)supplier, bl, licenseProperties);
        }

        public void appendTrialLicenseParameters(@Nonnull StringBuilder licenseURL, @Nonnull ConfigStructureSettings settings) {
            String string = settings.getValue("license.generateTrial.select");
            if (string == null) {
                string = "";
            }
            switch (string) {
                case "license.generateTrial.server": {
                    String string2 = settings.getValue("license.generateTrial.machine.id");
                    if (string2 == null) {
                        string2 = PDFCLicenseChecker.getHashedHardwareKey();
                    }
                    licenseURL.append("&hwid=").append(EncodingFunctions.encodeUrlParameter((String)string2));
                    break;
                }
                case "license.generateTrial.domain": {
                    String string3 = settings.getValue("license.generateTrial.domain.name");
                    if (string3 == null) break;
                    licenseURL.append("&domain=").append(EncodingFunctions.encodeUrlParameter((String)string3));
                    break;
                }
                case "license.generateTrial.cloud": {
                    licenseURL.append("&fqdn=").append(EncodingFunctions.encodeUrlParameter((String)settings.getValue("license.generateTrial.fqdn")));
                    break;
                }
                case "license.generateTrial.privatecloud": {
                    try {
                        URL uRL = new URL(settings.getValue(ConfigKey.SERVER_URL));
                        licenseURL.append("&cloudhost=").append(EncodingFunctions.encodeUrlParameter((String)uRL.getHost()));
                    }
                    catch (MalformedURLException malformedURLException) {
                        ErrorCode.throwAny((Throwable)malformedURLException);
                    }
                    break;
                }
                default: {
                    licenseURL.append("&hwid=").append(EncodingFunctions.encodeUrlParameter((String)PDFCLicenseChecker.getHashedHardwareKey()));
                }
            }
            if (Boolean.TRUE.equals(ah.get())) {
                licenseURL.append("&force=true");
                ah.set(Boolean.FALSE);
            }
            licenseURL.append("&actkey=");
            try {
                Object object = ag.get();
                int n = CoreSystemStructureProvider.isDocker() ? 1 : 0;
                object = object == null || ((String)object).equals("TRIAL_ACTIVATION") ? (n != 0 ? "SITE_TR" : "TR") + "IAL_ACTIVATION" : object;
                licenseURL.append(EncodingFunctions.encodeUrlParameter((String)object));
            }
            catch (Exception exception) {
                LogManager.getConfigLogger().error((Throwable)exception);
            }
        }

        public String getTrialLicenseBrowserURL() {
            return WellKnownWebsites.LICENSE_TOOL_BASE_URL + "?product=pdfc&uid=" + EncodingFunctions.encodeUrlParameter((String)PDFCLicenseChecker.getHashedHardwareKey()) + "&version=" + this.ar.getMajor();
        }

        @Nonnull
        public String getDefaultSupportAddress() {
            return "pdfc@inetsoftware.de";
        }

        public int getDefaultPort() {
            return 9900;
        }

        @Nonnull
        public RemoteGuiInformation getRemoteGuiInformation() {
            ModulePriority modulePriority = new ModulePriority();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("/comparison");
            arrayList.add("/store");
            arrayList.add("/configmanager");
            ArrayList arrayList2 = new ArrayList();
            modulePriority.setPriorityModules(arrayList);
            modulePriority.setOtherModules(arrayList2);
            RemoteGuiInformation remoteGuiInformation = new RemoteGuiInformation(modulePriority);
            remoteGuiInformation.setLogoURL(this.getLogoURL(96));
            remoteGuiInformation.setAuthenticationIconURL(this.getClass().getResource("/com/inet/pdfc/images/PDFC_icon_authentication.png"));
            remoteGuiInformation.setFaviconURL(this.getClass().getResource("/com/inet/pdfc/images/favicon.ico"));
            return remoteGuiInformation;
        }

        public URL getLogoURL(int size) {
            return this.getClass().getResource(size >= 64 ? "/com/inet/pdfc/images/PDFC_icon_96.png" : "/com/inet/pdfc/images/PDFC_icon_32.png");
        }

        public int getDefaultNumberOfJobs() {
            int n = Runtime.getRuntime().availableProcessors() / 2;
            int n2 = 512;
            n = (int)Math.min((long)n, Runtime.getRuntime().maxMemory() / 1024L / 1024L / (long)n2);
            return n;
        }

        @Nullable
        public URL getHelpPrintReport() {
            return PDFCApplicationDescription.class.getResource("print/help.rpt");
        }
    }
}

