/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.textselection;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.generator.continuous.structure.StructureElement;
import com.inet.pdfc.generator.model.text.WordElement;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.textselection.TextInfoImpl;
import com.inet.pdfc.util.LocationUtils;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

@InternalApi
public class TextInfoFactory {
    public static TextInfoImpl createTextInfo(WordElement word, boolean left) {
        Object object;
        Object object2;
        TextInfoImpl textInfoImpl = new TextInfoImpl(word.getLabel().replace(Character.toString('\uefff'), ""), left, (short)word.getPageIndex(), word.getElementID());
        textInfoImpl.setX((float)word.getStartPointX().getX());
        textInfoImpl.setY((float)word.getStartPointX().getY());
        textInfoImpl.setHeight((float)word.getBounds().getHeight());
        if (word.getRotation() != 0.0) {
            object2 = AffineTransform.getRotateInstance(-word.getRotation());
            object = LocationUtils.getBounds(word);
            ((Rectangle)object).x = 0;
            ((Rectangle)object).y = 0;
            Rectangle rectangle = ((AffineTransform)object2).createTransformedShape((Shape)object).getBounds();
            textInfoImpl.setHeight((float)rectangle.getHeight());
            if (Math.abs(word.getRotation() + 1.5707963267948966) < 0.01) {
                textInfoImpl.setY((double)((float)word.getStartPointX().getY()) - rectangle.getWidth());
            }
        }
        textInfoImpl.setWswidth((short)(word.getStyle().getWsWidthScaled() * 20.0));
        textInfoImpl.setRotation((float)word.getRotation());
        object2 = word.getLabel();
        object = new float[((String)object2).length()];
        for (int i = 0; i < ((String)object2).length(); ++i) {
            object[i] = (float)word.getCharWidths()[i];
        }
        textInfoImpl.setCharWidth((float[])object);
        if (textInfoImpl.getHeight() < 0.0) {
            textInfoImpl.setY(textInfoImpl.getY() + textInfoImpl.getHeight());
            textInfoImpl.setHeight((float)(-textInfoImpl.getHeight()));
        }
        if (word.getFillPaint() instanceof Color) {
            textInfoImpl.setColor((Color)word.getFillPaint());
        } else {
            textInfoImpl.setColor(Color.BLACK);
        }
        textInfoImpl.setFontname(word.getStyle().getFont().getFontName());
        textInfoImpl.setFontSize(word.getStyle().getFontSize());
        textInfoImpl.setFontStyle(word.getStyle().getFont().getStyle());
        return textInfoImpl;
    }

    public static List<TextInfoImpl> getTextInfos(List<DrawableElement> elements, int pageNr, boolean isFirst) {
        ArrayList<@Nonnull DrawableElement> arrayList = new ArrayList<DrawableElement>();
        new StructureElement(ElementType.Text, null, elements, pageNr, ElementID.DUMMY).serialize(arrayList);
        ArrayList<TextInfoImpl> arrayList2 = new ArrayList<TextInfoImpl>();
        for (DrawableElement drawableElement : arrayList) {
            if (!(drawableElement instanceof WordElement)) continue;
            TextInfoImpl textInfoImpl = TextInfoFactory.createTextInfo((WordElement)drawableElement, isFirst);
            arrayList2.add(textInfoImpl);
        }
        return arrayList2;
    }

    public static TextInfoImpl mergeTextInfos(final TextInfoImpl previous, final TextInfoImpl current, final boolean hasWhitespace) {
        final String string = previous.getText() + (hasWhitespace ? " " : "") + current.getText();
        double d2 = previous.getBounds().getX();
        double d3 = previous.getBounds().getY();
        final double d4 = current.getBounds().getMaxX() - previous.getBounds().getX();
        double d5 = Math.max(previous.getBounds().getHeight(), current.getBounds().getHeight());
        final Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d3, d4, d5);
        TextInfoImpl textInfoImpl = new TextInfoImpl(previous){
            private float[] sW;
            {
                super(textInfoImpl);
                this.sW = null;
            }

            @Override
            public Rectangle2D getBounds() {
                return double_;
            }

            @Override
            public String getText() {
                return string;
            }

            @Override
            public String getLabel() {
                return string;
            }

            @Override
            public float[] getCharWidth() {
                if (this.sW == null) {
                    this.sW = new float[previous.getCharWidth().length + current.getCharWidth().length + (hasWhitespace ? 1 : 0)];
                    System.arraycopy(previous.getCharWidth(), 0, this.sW, 0, previous.getCharWidth().length);
                    System.arraycopy(current.getCharWidth(), 0, this.sW, previous.getCharWidth().length + (hasWhitespace ? 1 : 0), current.getCharWidth().length);
                    double d2 = 0.0;
                    for (float f2 : this.sW) {
                        d2 += (double)f2;
                    }
                    if (hasWhitespace) {
                        float f3 = (float)(d4 - d2);
                        if (f3 < 0.0f) {
                            f3 = 0.0f;
                        }
                        this.sW[previous.getCharWidth().length] = f3;
                    } else {
                        this.sW[previous.getCharWidth().length - 1] = (float)((double)this.sW[previous.getCharWidth().length - 1] + (d4 - d2));
                    }
                }
                return this.sW;
            }
        };
        return textInfoImpl;
    }

    public static TextInfoImpl mergeTextInfos(final TextInfoImpl textInfo, final double additionalWidth, final String aditionalText) {
        final String string = textInfo.getText() + aditionalText;
        double d2 = textInfo.getBounds().getX();
        double d3 = textInfo.getBounds().getY();
        double d4 = textInfo.getBounds().getWidth() + additionalWidth;
        double d5 = textInfo.getBounds().getHeight();
        final Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d3, d4, d5);
        TextInfoImpl textInfoImpl = new TextInfoImpl(textInfo){
            private float[] sW;
            {
                super(textInfoImpl);
                this.sW = null;
            }

            @Override
            public Rectangle2D getBounds() {
                return double_;
            }

            @Override
            public String getText() {
                return string;
            }

            @Override
            public String getLabel() {
                return string;
            }

            @Override
            public float[] getCharWidth() {
                if (this.sW == null) {
                    this.sW = new float[textInfo.getCharWidth().length + aditionalText.length()];
                    System.arraycopy(textInfo.getCharWidth(), 0, this.sW, 0, textInfo.getCharWidth().length);
                    double d2 = additionalWidth / (double)aditionalText.length();
                    for (int i = textInfo.getCharWidth().length; i < this.sW.length; ++i) {
                        this.sW[i] = (float)d2;
                    }
                }
                return this.sW;
            }
        };
        return textInfoImpl;
    }
}

