/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.filter;

import com.inet.annotations.InternalApi;
import com.inet.classloader.I18nMessages;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.generator.filter.IFilterFactory;
import com.inet.pdfc.generator.filter.ISortFilter;
import com.inet.pdfc.generator.filter.ISortFilterFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;

@InternalApi
public class SortFilterFactoryBase<T extends ISortFilter>
implements ISortFilterFactory {
    private static final Map<String, Integer> eU = new HashMap<String, Integer>();
    private String aH;
    private Class<T> eV;
    private List<PDFCProperty<?>> eW;
    private I18nMessages eX;
    private I18nMessages eY;
    private String eZ = "pdfc.filter.";
    private int fa;
    private int fb;
    private HashMap<PDFCProperty<?>, String> fc = new HashMap();
    private List<IFilterFactory.FLAG> fd;

    public SortFilterFactoryBase(String name, Class<T> filterClass, int priority, PDFCProperty<?> ... properties) {
        this(name, filterClass, priority, (List<IFilterFactory.FLAG>)null, properties);
    }

    public SortFilterFactoryBase(String name, Class<T> filterClass, List<IFilterFactory.FLAG> flags, PDFCProperty<?> ... properties) {
        this(name, filterClass, SortFilterFactoryBase.getPrioFromName(name), flags, properties);
    }

    public SortFilterFactoryBase(String name, Class<T> filterClass, int priority, List<IFilterFactory.FLAG> flags, PDFCProperty<?> ... properties) {
        this.aH = name;
        this.eV = filterClass;
        this.fa = priority;
        this.fb = priority;
        this.fd = flags;
        this.eW = properties != null ? Arrays.asList(properties) : new ArrayList();
        this.eX = new I18nMessages(filterClass.getPackage().getName() + ".structure.i18n.ConfigStructure", filterClass);
        this.eY = new I18nMessages(filterClass.getPackage().getName() + ".structure.i18n.LanguageResources", filterClass);
        try {
            this.eX.getBundle();
        }
        catch (MissingResourceException missingResourceException) {
            this.eX = null;
        }
        try {
            this.eY.getBundle();
        }
        catch (MissingResourceException missingResourceException) {
            this.eY = null;
        }
        if (this.eX == null && this.eY == null) {
            PDFCCore.LOGGER_CORE.debug((Object)("No translations found for filter '" + name + "', implementation class " + filterClass.getName()));
        }
    }

    public SortFilterFactoryBase(String name, Class<T> filterClass, PDFCProperty<?> ... properties) {
        this(name, filterClass, SortFilterFactoryBase.getPrioFromName(name), properties);
    }

    public static int getPrioFromName(String name) {
        Integer n = eU.get(name);
        if (n != null) {
            return n;
        }
        if (name.length() == 0) {
            return 0;
        }
        if (name.length() == 1) {
            return name.charAt(0);
        }
        char c2 = name.charAt(0);
        char c3 = name.charAt(1);
        return (c2 - 32) * 100 + (c3 - 32);
    }

    public String getExtensionName() {
        return this.aH;
    }

    @Override
    public T createInstance(IProfile configuration) {
        try {
            ISortFilter iSortFilter = (ISortFilter)this.eV.getConstructor(new Class[0]).newInstance(new Object[0]);
            iSortFilter.setProfile(configuration);
            return (T)iSortFilter;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            throw new IllegalStateException("The filter '" + this.getExtensionName() + "' is invalid an cannot be used.");
        }
    }

    @Override
    public List<PDFCProperty<?>> getFilterProperties() {
        return this.eW;
    }

    @Override
    public String getFilterName() {
        return this.n(this.eZ + this.aH);
    }

    @Override
    public String getFilterTooltip() {
        return this.n(this.eZ + this.aH + ".tooltip");
    }

    @Override
    public String getPropertyName(PDFCProperty<?> p) {
        return this.n(this.eZ + p.name());
    }

    @Override
    public String getPropertyTooltip(PDFCProperty<?> p) {
        return this.n(this.eZ + p.name() + ".tooltip");
    }

    @Override
    public int getFilterPriority() {
        return this.fa;
    }

    @Override
    public int getFilterAnalyzePriority() {
        return this.fb;
    }

    public SortFilterFactoryBase<T> setFilterAnalyzePriority(int prio) {
        this.fb = prio;
        return this;
    }

    private String n(String string) {
        Object object = "$" + string + "$";
        if (this.eX != null && this.eX.getBundle().containsKey(string)) {
            object = this.eX.getMsg(string, new Object[0]);
        }
        if (this.eY != null && this.eY.getBundle().containsKey(string)) {
            object = this.eY.getMsg(string, new Object[0]);
        }
        if (((String)object).contains("$")) {
            PDFCCore.LOGGER_CORE.debug((Object)("Class " + String.valueOf(this.eV) + " doesn't found translate for key => " + string));
        }
        return object;
    }

    public void addPlaceholder(PDFCProperty<?> property, String placeholder) {
        this.fc.put(property, placeholder);
    }

    @Override
    public String getPlaceholderForProperty(PDFCProperty<?> property) {
        return this.fc.get(property);
    }

    @Override
    public boolean hasFlag(IFilterFactory.FLAG flag) {
        return this.fd != null ? this.fd.contains((Object)flag) : false;
    }

    static {
        eU.put("CMAPPATCH", 1000);
        eU.put("PAGERANGE", 2000);
        eU.put("OCR", 3000);
        eU.put("HEADERFOOTER", 4000);
        eU.put("MARGIN", 5000);
        eU.put("HIDEROTATEDTEXT", 6000);
        eU.put("TEXTTRANSFORM", 7000);
        eU.put("BASELINETABLE", 8000);
        eU.put("MULTICOLUMN", 9000);
        eU.put("BIDI", 10000);
        eU.put("REGEXP", 11000);
        eU.put("INVISIBLEELEMENTS", 12000);
    }
}

