/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator;

import com.inet.annotations.InternalApi;
import com.inet.config.LicenseInfo;
import com.inet.logging.Logger;
import com.inet.pdfc.LicenseModel;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.PDFCCorePlugin;
import com.inet.pdfc.PDFCLicenseChecker;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.error.ExceptionData;
import com.inet.pdfc.generator.AbstractComparator;
import com.inet.pdfc.generator.ComparatorProperties;
import com.inet.pdfc.generator.InvalidLicenseException;
import com.inet.pdfc.generator.e;
import com.inet.pdfc.generator.f;
import com.inet.pdfc.generator.message.Chunk;
import com.inet.pdfc.generator.message.ErrorData;
import com.inet.pdfc.generator.message.PageDataImpl;
import com.inet.pdfc.generator.rendercache.PdfcRenderCache;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.model.Document;
import com.inet.pdfc.model.EnumerationProgress;
import com.inet.pdfc.model.Page;
import com.inet.pdfc.model.a;
import com.inet.pdfc.plugin.persistence.QuotaExceededException;
import com.inet.pdfc.util.FilterUtils;
import com.inet.thread.NamedTask;
import com.inet.thread.job.StoppableCallable;
import com.inet.thread.job.TerminatedByPausing;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.Callable;

@InternalApi
public class PDFParserTask
extends StoppableCallable<Void>
implements NamedTask,
Serializable,
Callable<Void> {
    private static final Logger LOGGER = PDFCCore.LOGGER_CORE;
    private static final Object cy = new Object();
    private transient e cz;
    private transient com.inet.pdfc.generator.a cA;
    private transient PdfcRenderCache bt;
    private transient ComparatorProperties bj;
    private boolean cB;
    private String cC;
    private int pageNr = 0;
    private transient EnumerationProgress cD;
    private boolean cE;
    private boolean cF = false;
    private int cG;
    private IProfile profile;

    PDFParserTask(Document pdfFile, String fileName, PdfcRenderCache storeMap, f generatorListener, com.inet.pdfc.generator.a pipeline, boolean isFirst, ComparatorProperties properties, int pageLimit, IProfile profile) {
        this.bt = storeMap;
        this.cz = generatorListener;
        this.bj = properties;
        this.cC = fileName;
        this.cA = pipeline;
        this.cB = isFirst;
        this.cG = pageLimit;
        this.profile = profile;
        this.cD = com.inet.pdfc.model.a.a(pdfFile, FilterUtils.getPageRange(profile, isFirst));
        generatorListener.a(this.cD, isFirst);
    }

    void a(Document document, PdfcRenderCache pdfcRenderCache, f f2, com.inet.pdfc.generator.a a2, ComparatorProperties comparatorProperties) throws ClassNotFoundException, IOException {
        this.bt = pdfcRenderCache;
        this.cz = f2;
        this.bj = comparatorProperties;
        this.cA = a2;
        this.cD = com.inet.pdfc.model.a.a(document, FilterUtils.getPageRange(this.profile, this.cB));
        f2.a(this.cD, this.cB);
    }

    protected Void call0() throws Exception {
        if (this.cF) {
            return null;
        }
        try {
            while (this.cD.hasMoreElements()) {
                int n;
                Serializable serializable;
                if (this.stopRequested()) {
                    throw new TerminatedByPausing();
                }
                this.ah();
                Page page = this.cD.nextElement();
                if (page == null) continue;
                if (page.getRecentError() != null) {
                    serializable = page.getRecentError();
                    if (serializable instanceof a.c) {
                        n = this.cB ? 1 : 2;
                        String string = PDFCCorePlugin.MSG.getMsg("error.nopages." + (this.cB ? "first" : "second"), new Object[0]);
                        this.cz.addData(new ErrorData(new ExceptionData(-1, null, string, ""), n, false));
                    } else {
                        throw serializable;
                    }
                }
                this.ah();
                if (this.bj.isCreateImages()) {
                    this.bt.putPage(page, this.cB);
                }
                serializable = new PageDataImpl(page.getPageIndex(), this.cB, page.getWidth(), page.getHeight());
                ++this.pageNr;
                if (page.getPageIndex() == 0) {
                    n = (int)Math.round(1.0 / this.cD.getProgress());
                    if (this.cB) {
                        this.cA.a(n, -1);
                    } else {
                        this.cA.a(-1, n);
                    }
                }
                this.cz.addData((Chunk)serializable);
                this.cA.a(page, this.cB);
                this.ah();
                this.cz.k(this.cB);
                this.ah();
                if (this.pageNr < this.cG) continue;
                this.cA.b((Throwable)((Object)new QuotaExceededException(Msg.getMsg("Server.quotaexceeded.pages", Integer.toString(this.cG)))));
                break;
            }
            this.cA.d(this.cB);
            this.cF = true;
        }
        catch (InterruptedException interruptedException) {
            AbstractComparator.LOGGER.debug((Object)"Parser thread ended by interruption");
            AbstractComparator.LOGGER.debug((Object)interruptedException);
            throw interruptedException;
        }
        catch (a a2) {
            return null;
        }
        catch (Throwable throwable) {
            this.cA.c(throwable);
            this.cA.sendStopSignal();
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw (Exception)throwable;
        }
        return null;
    }

    protected void sendStopSignal() {
        this.cE = true;
    }

    void ah() throws a {
        if (this.cE || this.cA.Y()) {
            if (this.cE) {
                this.cE = false;
            }
            throw new a();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkLicense(boolean checkFalse, boolean requireAPI, boolean requireCommandLine, boolean requireServer) {
        Object object = cy;
        synchronized (object) {
            PDFParserTask.j(checkFalse);
            PDFParserTask.checkLicense(PDFCLicenseChecker.getCurrentLicenseModel(), requireAPI, requireCommandLine, requireServer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void j(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        LicenseModel licenseModel = new LicenseModel(new LicenseInfo(() -> "Server license", "i-net Software GmbH", () -> "error", hashMap));
        long l = System.currentTimeMillis() % 10L;
        hashMap.put("gui", Long.toString(l));
        boolean bl2 = false;
        int n = LOGGER.getLogLevel();
        LOGGER.setLogLevel(0);
        try {
            PDFParserTask.checkLicense(licenseModel, true, true, false);
            bl2 = bl;
        }
        catch (InvalidLicenseException invalidLicenseException) {
            if (l < 0L) {
                throw new InvalidLicenseException(Msg.getMsg("License.Invalid"));
            }
        }
        finally {
            LOGGER.setLogLevel(n);
        }
        if (bl2) {
            throw new InvalidLicenseException(Msg.getMsg("License.Invalid"));
        }
    }

    public static void checkLicense(LicenseModel model, boolean requireAPI, boolean requireCommandLine, boolean requireServer) {
        if (!model.isValid()) {
            LOGGER.info((Object)model.getLicenseInfoText());
            throw new InvalidLicenseException(model.getLicenseInfoText());
        }
        if (requireAPI && !model.isAPI()) {
            LOGGER.info((Object)Msg.getMsg("License.NotAPI"));
            throw new InvalidLicenseException(Msg.getMsg("License.NotAPI"));
        }
        if (requireCommandLine && !model.isCommandLine()) {
            LOGGER.info((Object)Msg.getMsg("License.NotCommandline"));
            throw new InvalidLicenseException(Msg.getMsg("License.NotCommandline"));
        }
        if (requireServer && !model.isServer()) {
            LOGGER.info((Object)Msg.getMsg("License.NotServer"));
            throw new InvalidLicenseException(Msg.getMsg("License.NotServer"));
        }
        if (model.isTrial()) {
            LOGGER.info((Object)Msg.getMsg("License.IsTrial", model.getExpirationDate().toString()));
        }
    }

    public String getTaskName() {
        return "PDF Reader " + (this.cC != null ? this.cC : (this.cB ? "#first" : "#second"));
    }

    private static class a
    extends Exception {
        private a() {
        }
    }
}

