/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.util;

import com.inet.annotations.InternalApi;
import com.inet.logging.LogManager;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.util.Pair;
import com.inet.plugin.ServerPluginManager;
import java.util.ArrayList;
import java.util.List;

@InternalApi
public class FilterUtils {
    public static final String FILTER_PAGERANGE = "PAGERANGE";
    public static final String FILTER_PAGERANGE_END = "PAGERANGE_END";
    public static final String FILTER_AREA = "AREAFILTER";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getErrorMessage(String propertyName, String value) {
        if (FILTER_PAGERANGE.equals(propertyName)) {
            String[] stringArray;
            if (value == null || value.isEmpty()) {
                return null;
            }
            if (!value.matches("[\\d-,]*")) return Msg.getMsg("Filter.message.error.invalidsign", "'0-9', '-', ','");
            for (String string : stringArray = value.split(",")) {
                if (string.contains("-")) {
                    int n;
                    if (!string.matches("\\d+-\\d+")) return Msg.getMsg("Filter.message.error.pagerange.format", string);
                    String[] stringArray2 = string.split("-");
                    if (stringArray2[0].length() >= 6) {
                        return Msg.getMsg("Filter.message.error.value.oversize", stringArray2[0]);
                    }
                    if (stringArray2[1].length() >= 6) {
                        return Msg.getMsg("Filter.message.error.value.oversize", stringArray2[1]);
                    }
                    int n2 = Integer.parseInt(stringArray2[0]);
                    if (n2 <= (n = Integer.parseInt(stringArray2[1]))) continue;
                    return Msg.getMsg("Filter.message.error.pagerange.order", string);
                }
                if (string.length() < 6) continue;
                return Msg.getMsg("Filter.message.error.value.oversize", string);
            }
            return null;
        } else if (FILTER_AREA.equals(propertyName)) {
            if (value == null || value.isEmpty()) {
                return null;
            }
            if (!value.matches("[\\d,;SF]*")) {
                return Msg.getMsg("Filter.message.error.invalidsign", "'0-9', ',', ';', 'F' , 'S'");
            }
            for (String string : value.split(";")) {
                int n = 0;
                for (String string2 : string.split(",")) {
                    ++n;
                    if (string2.length() >= 6) {
                        return Msg.getMsg("Filter.message.error.value.oversize", value);
                    }
                    if ((string2.contains("S") || string2.contains("F")) && string2.length() > 1) {
                        return Msg.getMsg("Filter.message.error.value.areaMixedParameter", value);
                    }
                    if (!string2.contains("S") && !string2.contains("F") || n >= 4) continue;
                    return Msg.getMsg("Filter.message.error.value.areaNoOptional", value);
                }
            }
            return null;
        } else {
            if (!FILTER_PAGERANGE_END.equals(propertyName)) return null;
            if (value == null || value.isEmpty()) {
                return null;
            }
            if (!value.matches("[\\d]*")) {
                return Msg.getMsg("Filter.message.error.pagerangeend.format", value);
            }
            if (value.length() < 6) return null;
            return Msg.getMsg("Filter.message.error.pagerangeend.exceeded", value);
        }
    }

    public static List<Pair<Integer>> getPageRange(IProfile profile, boolean firstDocument) {
        boolean bl;
        if (profile != null && ServerPluginManager.getInstance().isPluginLoaded("filter.pagerange") && (bl = profile.getString(PDFCProperty.FILTERS).contains(FILTER_PAGERANGE))) {
            String string = profile.getString("PAGERANGE_DOCUMENT" + (firstDocument ? "1" : "2"));
            return FilterUtils.getPageRange(string);
        }
        ArrayList<Pair<Integer>> arrayList = new ArrayList<Pair<Integer>>();
        arrayList.add(new Pair<Integer>(0, -1));
        return arrayList;
    }

    public static List<Pair<Integer>> getPageRange(String value) {
        ArrayList<Pair<Integer>> arrayList = new ArrayList<Pair<Integer>>();
        if (value.isEmpty()) {
            arrayList.add(new Pair<Integer>(0, -1));
            return arrayList;
        }
        if (FilterUtils.getErrorMessage(FILTER_PAGERANGE, value) == null) {
            String[] stringArray;
            for (String string : stringArray = value.split(",")) {
                if (string.trim().isEmpty()) continue;
                if (string.contains("-")) {
                    int n;
                    if (!string.matches("\\d+-\\d+")) continue;
                    String[] stringArray2 = string.split("-");
                    int n2 = Integer.parseInt(stringArray2[0]);
                    if (n2 > (n = Integer.parseInt(stringArray2[1]))) {
                        LogManager.getLogger((String)"ComparisonFilter").warn((Object)("Page range filter has invalid value startpage was " + n2 + " and engpage was " + n));
                        continue;
                    }
                    arrayList.add(new Pair<Integer>(n2, n));
                    continue;
                }
                int n = Integer.parseInt(string);
                arrayList.add(new Pair<Integer>(n, n));
            }
        }
        if (arrayList.isEmpty()) {
            arrayList.add(new Pair<Integer>(0, -1));
        }
        arrayList.sort((pair, pair2) -> {
            if (((Integer)pair.get(true)).equals(pair2.get(true))) {
                return Integer.compare((Integer)pair.get(false), (Integer)pair2.get(false));
            }
            return Integer.compare((Integer)pair.get(true), (Integer)pair2.get(true));
        });
        return arrayList;
    }
}

