/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.presenter;

import com.inet.annotations.PublicApi;
import com.inet.error.ErrorCode;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.error.PdfcErrorCode;
import com.inet.pdfc.error.PdfcException;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.plugin.PluginManager;
import com.inet.pdfc.presenter.BasePresenter;
import com.inet.pdfc.presenter.ExportFilePresenter;
import com.inet.pdfc.presenter.PrintToPDFFactory;
import com.inet.pdfc.print.PrintPainter;
import com.inet.pdfc.print.PrintToX;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

@PublicApi
public class DifferencesPDFPresenter
extends ExportFilePresenter {
    private int oQ = 792;
    private int oR = 1121;
    private int oS = 10;
    private int oT = 10;
    private int oU = 10;
    private int oV = 10;
    private PrintToPDFFactory oW;
    private OutputStream oX = null;
    private String password = null;
    private boolean pf = false;

    public String getExtensionName() {
        return "Presenter_PDF";
    }

    public DifferencesPDFPresenter(File rootFolder) {
        this(rootFolder, true);
    }

    public DifferencesPDFPresenter(File target, boolean isFolder) {
        this();
        if (isFolder) {
            this.s = target;
        } else {
            this.s = target.getAbsoluteFile().getParentFile();
            this.pn = target;
        }
    }

    public DifferencesPDFPresenter(OutputStream customStream) {
        this();
        this.oX = customStream;
    }

    protected DifferencesPDFPresenter() throws IllegalStateException {
        try {
            this.oW = PluginManager.getSingleInstance(PrintToPDFFactory.class);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException("Using the DifferencesPDFPresenter requires an activated 'reporting' plugin.");
        }
        this.setBackgroundColor(Color.white);
    }

    @Override
    public BasePresenter spawn(boolean spawnWithParent) {
        DifferencesPDFPresenter differencesPDFPresenter = (DifferencesPDFPresenter)super.spawn(spawnWithParent);
        differencesPDFPresenter.s = this.s;
        differencesPDFPresenter.oV = this.oV;
        differencesPDFPresenter.oS = this.oS;
        differencesPDFPresenter.oU = this.oU;
        differencesPDFPresenter.oT = this.oT;
        differencesPDFPresenter.oR = this.oR;
        differencesPDFPresenter.oQ = this.oQ;
        differencesPDFPresenter.oX = this.oX;
        differencesPDFPresenter.password = this.password;
        return differencesPDFPresenter;
    }

    @Override
    protected OutputStream getExportStream() throws IOException {
        return this.oX != null ? this.oX : super.getExportStream();
    }

    @Override
    public void onComparisonDone() throws Exception {
        if (this.getModel().getDifferencesCount(true) == 0 && this.getModel().getSettings().isEnabled(Settings.EXPORT.ONLY_ON_DIFFERENCES)) {
            LOGGER.info((Object)Msg.getMsg("Export.doNothingNoDiffs", this.getModel().getComparisonParameters().getFirstFile().getName(), this.getModel().getComparisonParameters().getSecondFile().getName()));
            return;
        }
        PrintPainter printPainter = this.createAndSetupPrintPainter();
        PrintToX printToX = this.oW.createPrinter(this.oQ, this.oR, this.oS, this.oT, this.oU, this.oV, printPainter, () -> this.getExportStream(), this.password, this.pf);
        if (printToX instanceof ExportFilePresenter.HasPrintRange) {
            this.applyPrintRange((ExportFilePresenter.HasPrintRange)((Object)printToX));
        }
        try {
            printToX.export();
        }
        catch (Exception exception) {
            throw PdfcException.create((ErrorCode)PdfcErrorCode.errorWhilePresenting, exception, new Object[0]);
        }
        if (this.pn != null) {
            LOGGER.info((Object)Msg.getMsg("Export.pdfTarget", this.pn.getAbsoluteFile()));
        }
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    protected String getExtension() {
        return ".pdf";
    }

    public void setReplaceSystemFonts(boolean replace) {
        this.pf = replace;
    }

    public void setPagelayout(int pageWidth, int pageHeight, int marginLeft, int marginTop, int marginRight, int marginBottom) {
        this.oQ = pageWidth;
        this.oR = pageHeight;
        this.oS = marginLeft;
        this.oT = marginTop;
        this.oU = marginRight;
        this.oV = marginBottom;
    }
}

