/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.postcompare;

import com.inet.annotations.JsonData;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.config.CompareType;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.config.TextStyleType;
import com.inet.pdfc.generator.filter.FilterFactory;
import com.inet.pdfc.generator.filter.ISortFilter;
import com.inet.pdfc.generator.filter.ISortFilterFactory;
import com.inet.pdfc.generator.filter.TypeFilterPostComparerFactory;
import com.inet.pdfc.generator.model.CompareDiffGroup;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.generator.model.MinifiedDrawableElement;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.generator.model.diff.AttributeDifference;
import com.inet.pdfc.generator.model.forms.GeomShape;
import com.inet.pdfc.generator.model.text.TextStyle;
import com.inet.pdfc.generator.model.text.WordElement;
import com.inet.pdfc.generator.postcompare.AnnotationComparator;
import com.inet.pdfc.generator.postcompare.IPostComparator;
import com.inet.pdfc.generator.postcompare.ImageComparator;
import com.inet.pdfc.generator.postcompare.TagComparator;
import com.inet.pdfc.generator.postcompare.b;
import com.inet.pdfc.generator.postcompare.e;
import com.inet.pdfc.generator.postcompare.g;
import com.inet.pdfc.model.AdditionalBoundsInfo;
import com.inet.pdfc.model.AnnotationElement;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.ImageElement;
import com.inet.pdfc.model.PagedElement;
import com.inet.pdfc.model.TagElement;
import com.inet.pdfc.model.controls.ControlElement;
import com.inet.pdfc.util.CollectionUtils;
import com.inet.pdfc.util.EnumParser;
import com.inet.pdfc.util.Pair;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class PostComparer
implements Serializable {
    private Set<ElementType> hn;
    private Set<ElementType> ho = new HashSet<ElementType>();
    private transient g di;
    private transient e dj;
    private transient ImageComparator df;
    private transient b dk;
    private transient AnnotationComparator hp;
    private transient TagComparator hq;
    private transient HashMap<ElementType, List<TypeFilterPostComparerFactory.TypeFilterAcceptor<?>>> hr;
    private List<CompareDiffGroup> hs;
    private List<Modification> ht = new ArrayList<Modification>();
    private List<AttributeDifference<?>> hu;
    private List<PagedElement> hv = new ArrayList<PagedElement>();
    private List<PagedElement> hw = new ArrayList<PagedElement>();
    private DiffGroup.GroupType hx;
    private PagedElement hy;
    private PagedElement hz;
    private int hA = -1;
    private int hB = -1;
    private PagedElement hC;
    private PagedElement hD;
    private WordElement hE;
    private WordElement hF;
    private boolean hG;
    private double hH = PDFCProperty.TEXT_ALIGN_RATIO.getDefaultValue();

    public PostComparer(@Nonnull IProfile config) {
        this(config, EnumParser.getConfiguredValues(config, PDFCProperty.COMPARE_TYPES, CompareType.class));
    }

    public PostComparer(IProfile config, List<CompareType> diffTypes) {
        boolean bl = diffTypes.contains((Object)CompareType.TEXT);
        if (config.getString(PDFCProperty.COMPARE_TEXT_STYLES).isEmpty()) {
            diffTypes.remove((Object)CompareType.TEXT);
        } else {
            this.hG = config.getString(PDFCProperty.COMPARE_TEXT_STYLES).toLowerCase().contains(TextStyleType.SPACING.name().toLowerCase());
        }
        if (!config.getBool(PDFCProperty.COMPARE_LINE_STYLES)) {
            diffTypes.remove((Object)CompareType.LINE);
        }
        this.hH = config.getDouble(PDFCProperty.TEXT_ALIGN_RATIO);
        this.hn = CompareType.getElementTypesForCompareTypes(diffTypes);
        if (bl) {
            this.hn.add(ElementType.ControlText);
            this.hn.add(ElementType.ControlCheckBox);
            this.hn.add(ElementType.ControlSignature);
        }
        if (config.getBool(PDFCProperty.COMPARE_TAGS)) {
            this.hn.add(ElementType.Tag);
        }
        this.init(config);
    }

    public void init(IProfile config) {
        this.di = new g(config);
        this.dj = new e(config);
        this.df = new ImageComparator(config);
        this.dk = new b();
        this.hp = new AnnotationComparator(config);
        this.hq = new TagComparator(config);
        this.hr = new HashMap();
        List<ISortFilter> list = FilterFactory.getFilters(config);
        Set set = list.stream().map(iSortFilter -> iSortFilter.getExtensionName()).collect(Collectors.toSet());
        List list2 = DynamicExtensionManager.getInstance().get(TypeFilterPostComparerFactory.class);
        for (TypeFilterPostComparerFactory typeFilterPostComparerFactory : list2) {
            if (!set.contains(typeFilterPostComparerFactory.getExtensionName())) {
                try {
                    ServerPluginManager.getInstance().getSingleInstanceByName(ISortFilterFactory.class, typeFilterPostComparerFactory.getExtensionName(), false);
                    continue;
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            for (TypeFilterPostComparerFactory.TypeFilterAcceptor<?> typeFilterAcceptor : typeFilterPostComparerFactory.getAcceptorList()) {
                for (ElementType elementType : typeFilterAcceptor.getAcceptedTypes()) {
                    List<TypeFilterPostComparerFactory.TypeFilterAcceptor<?>> list3 = this.hr.get(elementType);
                    if (list3 == null) {
                        list3 = new ArrayList();
                        this.hn.add(elementType);
                        this.hr.put(elementType, list3);
                    }
                    list3.add(typeFilterAcceptor);
                }
            }
        }
    }

    public void a(PagedElement pagedElement, PagedElement pagedElement2, List<CompareDiffGroup> list) {
        this.hC = pagedElement;
        this.hD = pagedElement2;
        this.hA = pagedElement != null ? pagedElement.getPageIndex() : -1;
        this.hB = pagedElement2 != null ? pagedElement2.getPageIndex() : -1;
        this.hs = list;
    }

    public void b(PagedElement pagedElement, PagedElement pagedElement2) {
        if (this.hu != null) {
            this.bg();
        }
        if (this.hx != null) {
            this.f(pagedElement, pagedElement2);
        }
        this.hs = null;
        this.hE = null;
        this.hF = null;
    }

    private a a(WordElement wordElement, WordElement wordElement2) {
        TextStyle textStyle;
        double d2;
        Point2D point2D = wordElement.getEndPoint();
        Point2D point2D2 = wordElement2.getStartPoint();
        if (point2D.getY() != point2D2.getY() && !this.b(wordElement, wordElement2)) {
            return a.hK;
        }
        TextStyle textStyle2 = wordElement.getStyle();
        double d3 = textStyle2.getWsWidthScaled();
        if (d3 <= 0.0) {
            d3 = Math.abs(wordElement.getBounds().getHeight());
        }
        if ((d2 = (textStyle = wordElement2.getStyle()).getWsWidthScaled()) <= 0.0) {
            d2 = Math.abs(wordElement2.getBounds().getHeight());
        }
        if (d3 != d2 && textStyle2.getFont().hasWhiteSpace() != textStyle.getFont().hasWhiteSpace()) {
            if (textStyle2.getFont().hasWhiteSpace()) {
                d2 = d3;
            } else {
                d3 = d2;
            }
        }
        double d4 = Math.max(d3, d2) * 0.8;
        double d5 = this.c(wordElement, wordElement2);
        return d5 > d4 ? a.hJ : a.hI;
    }

    private boolean b(WordElement wordElement, WordElement wordElement2) {
        if (Math.abs(wordElement.getRotation() - wordElement2.getRotation()) > 0.05) {
            return false;
        }
        double d2 = this.hH * Math.min(wordElement.getStyle().getTextHeight(), wordElement2.getStyle().getTextHeight());
        Point2D point2D = wordElement.getStartPointX();
        Point2D point2D2 = wordElement2.getStartPointX();
        if (wordElement.getRotation() == 0.0) {
            return Math.abs(point2D.getY() - point2D2.getY()) < d2;
        }
        double d3 = wordElement.getRotation();
        double d4 = Math.abs(Math.sin(d3 = Math.atan(d3)) * (point2D2.getX() - point2D.getX()) + Math.cos(d3) * (point2D.getY() - point2D2.getY()));
        return d4 < d2;
    }

    private double c(WordElement wordElement, WordElement wordElement2) {
        if (wordElement.getRotation() == 0.0) {
            double d2 = wordElement.getEndPoint().getX();
            double d3 = wordElement2.getStartPoint().getX();
            if (d3 >= d2) {
                return d3 - d2;
            }
            if (wordElement2.getEndPoint().getX() < wordElement.getStartPoint().getX()) {
                return this.c(wordElement2, wordElement);
            }
            return 0.0;
        }
        if (wordElement.getStartPointX().distance(wordElement2.getStartPointX()) < Arrays.stream(wordElement.getCharWidths()).sum()) {
            return 0.0;
        }
        return wordElement.getEndPoint().distance(wordElement2.getStartPointX());
    }

    private WordElement d(WordElement wordElement, WordElement wordElement2) {
        Point2D point2D = wordElement.getEndPoint();
        Point2D point2D2 = wordElement2.getStartPoint();
        double d2 = wordElement.getStyle().getTextHeight();
        if (point2D.getY() != point2D2.getY()) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(point2D.getX(), point2D.getY(), 5.0, -d2);
            Rectangle2D.Double double_2 = new Rectangle2D.Double(point2D2.getX() - 5.0, point2D2.getY(), 5.0, -d2);
            WordElement wordElement3 = new WordElement("  ", double_, new double[]{double_2.getWidth(), 5.0}, wordElement.getPageIndex(), wordElement.getStyle(), wordElement.getElementID().getDescendant());
            wordElement3.setAdditionalBounds(new AdditionalBoundsInfo(double_2, 1));
            return wordElement3;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(point2D.getX(), point2D.getY(), point2D2.getX() - point2D.getX(), -d2);
        WordElement wordElement4 = new WordElement(" ", double_, new double[]{double_.getWidth()}, wordElement.getPageIndex(), wordElement.getStyle(), wordElement.getElementID().getDescendant());
        return wordElement4;
    }

    public void c(PagedElement pagedElement, PagedElement pagedElement2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (this.hs == null) {
            throw new IllegalStateException("Cannot compared matched elements! Comparator is not in a matched region!");
        }
        if (pagedElement.getType() != pagedElement2.getType()) {
            PDFCCore.LOGGER_COMPARE.error((Object)("compareElements called for inconsistent elements: " + String.valueOf(pagedElement) + " <-> " + String.valueOf(pagedElement2)));
            return;
        }
        if (!this.hn.contains(pagedElement.getType())) {
            this.d(pagedElement, pagedElement2);
            this.hC = pagedElement;
            this.hD = pagedElement2;
            this.hA = pagedElement.getPageIndex();
            this.hB = pagedElement2.getPageIndex();
            if (pagedElement instanceof WordElement) {
                this.hE = (WordElement)pagedElement;
                this.hF = (WordElement)pagedElement2;
            }
            return;
        }
        if (pagedElement.getType() == ElementType.TextWord && (object4 = this.di.e((WordElement)pagedElement, (WordElement)pagedElement2)) != null) {
            Iterator<Object> iterator = object4.iterator();
            while (iterator.hasNext()) {
                Pair pair = (Pair)iterator.next();
                this.c((PagedElement)pair.get(true), (PagedElement)pair.get(false));
            }
            return;
        }
        if (this.hG && this.hE != null && this.hE.getAdditionalBounds() == null && this.hF != null && this.hF.getAdditionalBounds() == null && pagedElement instanceof WordElement) {
            object4 = (WordElement)pagedElement;
            object3 = (WordElement)pagedElement2;
            if (((WordElement)object4).getAdditionalBounds() == null && ((WordElement)object3).getAdditionalBounds() == null) {
                object2 = this.a(this.hE, (WordElement)object4);
                object = this.a(this.hF, (WordElement)object3);
                if (((a)((Object)object2)).hL != ((a)((Object)object)).hL) {
                    ArrayList<PagedElement> arrayList = new ArrayList<PagedElement>();
                    ArrayList<PagedElement> arrayList2 = new ArrayList<PagedElement>();
                    ArrayList arrayList3 = new ArrayList();
                    if (((a)((Object)object2)).hL) {
                        arrayList.add(this.d(this.hE, (WordElement)object4));
                        arrayList3.add(SpacingDiff.createSpacingDiff(false, (a)((Object)object2)));
                    } else {
                        arrayList2.add(this.d(this.hF, (WordElement)object3));
                        arrayList3.add(SpacingDiff.createSpacingDiff(true, (a)((Object)object)));
                    }
                    Modification modification = new Modification(DiffGroup.GroupType.Modified, arrayList, arrayList2, arrayList3);
                    CompareDiffGroup compareDiffGroup = new CompareDiffGroup(CollectionUtils.toList(modification), this.hE, this.hF, (PagedElement)object4, (PagedElement)object3, DiffGroup.GroupType.Modified);
                    this.hs.add(compareDiffGroup);
                }
            }
        }
        object4 = new ArrayList();
        switch (pagedElement.getType()) {
            case TextWord: {
                object4.add((Object)this.di.b((WordElement)pagedElement, (WordElement)pagedElement2, false));
                break;
            }
            case Line: 
            case LineHorizontal: 
            case LineVertical: 
            case Curve: {
                object4.add((Object)this.dj.a((GeomShape)pagedElement, (GeomShape)pagedElement2, false));
                break;
            }
            case Image: {
                object4.add((Object)this.df.compareElements((ImageElement)pagedElement, (ImageElement)pagedElement2, false));
                break;
            }
            case ControlCheckBox: 
            case ControlSignature: 
            case ControlText: {
                object4.add((Object)this.dk.a((ControlElement)pagedElement, (ControlElement)pagedElement2, false));
                break;
            }
            case Annotation: {
                object4.add((Object)this.hp.a((AnnotationElement)pagedElement, (AnnotationElement)pagedElement2, false));
                break;
            }
            case Tag: {
                object4.add((Object)this.hq.a((TagElement)pagedElement, (TagElement)pagedElement2, false));
                break;
            }
            default: {
                if (this.hr.containsKey(pagedElement.getType())) break;
                if (!this.ho.contains(pagedElement.getType())) {
                    PDFCCore.LOGGER_COMPARE.warn((Object)("Missing PostComparator for " + String.valueOf(pagedElement.getType())));
                    this.ho.add(pagedElement.getType());
                }
                return;
            }
        }
        object4.addAll(this.a(this.hr.get(pagedElement.getType()), pagedElement, pagedElement2));
        object4.removeAll(Collections.singleton(null));
        if (object4.size() > 0) {
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (IPostComparator.PostCompareResult)object3.next();
                if (((IPostComparator.PostCompareResult)object2).hasInstantDiffs() && (object = ((IPostComparator.PostCompareResult)object2).getInstantDiffs()) != null) {
                    this.hs.addAll((Collection<CompareDiffGroup>)object);
                }
                if ((object = ((IPostComparator.PostCompareResult)object2).getChanges()) == null || object.isEmpty()) continue;
                Collections.sort(object);
                if (this.hx != null && this.hx != ((IPostComparator.PostCompareResult)object2).getType()) {
                    this.bg();
                    this.f(pagedElement, pagedElement2);
                }
                if (this.hu != null && !this.hu.equals(object)) {
                    this.bg();
                }
                this.hu = object;
                if (this.hu != null && this.hu.isEmpty()) {
                    this.hu = null;
                }
                if (this.hx == null) {
                    this.hy = this.hC;
                    this.hz = this.hD;
                    this.hx = ((IPostComparator.PostCompareResult)object2).getType();
                }
                this.hv.add(pagedElement);
                this.hw.add(pagedElement2);
            }
        } else {
            this.bg();
            this.f(pagedElement, pagedElement2);
        }
        this.d(pagedElement, pagedElement2);
        this.hC = pagedElement;
        this.hD = pagedElement2;
        this.hA = pagedElement.getPageIndex();
        this.hB = pagedElement2.getPageIndex();
        if (pagedElement instanceof WordElement) {
            this.hE = (WordElement)pagedElement;
            this.hF = (WordElement)pagedElement2;
        }
    }

    @Nonnull
    private List<IPostComparator.PostCompareResult> a(List<TypeFilterPostComparerFactory.TypeFilterAcceptor<?>> list, PagedElement pagedElement, PagedElement pagedElement2) throws IllegalArgumentException {
        ArrayList<IPostComparator.PostCompareResult> arrayList = new ArrayList<IPostComparator.PostCompareResult>();
        if (list != null) {
            for (TypeFilterPostComparerFactory.TypeFilterAcceptor<?> typeFilterAcceptor : list) {
                if (!typeFilterAcceptor.getAcceptedTypes().contains(pagedElement.getType())) {
                    throw new IllegalArgumentException("The type of the filter '" + typeFilterAcceptor.getClass().getName() + "' does not match the type of the element.");
                }
                IPostComparator.PostCompareResult postCompareResult = typeFilterAcceptor.compareElements(pagedElement, pagedElement2, false);
                if (postCompareResult == null) continue;
                arrayList.add(postCompareResult);
            }
        }
        return arrayList;
    }

    private void d(PagedElement pagedElement, PagedElement pagedElement2) {
        if (this.hA > -1 && (this.hA != pagedElement.getPageIndex() || this.hB != pagedElement2.getPageIndex()) && this.hC != null && this.hD != null) {
            CompareDiffGroup compareDiffGroup;
            if (this.hs.size() > 0 && this.hC.getPageIndex() < pagedElement.getPageIndex() && this.hD.getPageIndex() != pagedElement2.getPageIndex() && ((compareDiffGroup = this.hs.get(this.hs.size() - 1)).getType() == DiffGroup.GroupType.AddedOrRemoved || compareDiffGroup.getType() == DiffGroup.GroupType.Replaced) && compareDiffGroup.getAfterFirst() == pagedElement && compareDiffGroup.getAfterSecond() == pagedElement2) {
                PagedElement pagedElement3;
                List<PagedElement> list = compareDiffGroup.getRemovedElements();
                List<PagedElement> list2 = compareDiffGroup.getAddedElements();
                PagedElement pagedElement4 = compareDiffGroup.getBeforeFirst();
                PagedElement pagedElement5 = compareDiffGroup.getBeforeSecond();
                PagedElement pagedElement6 = this.a(pagedElement4, list);
                PagedElement pagedElement7 = this.e(pagedElement6, pagedElement3 = this.a(pagedElement5, list2));
                if (pagedElement7 != null) {
                    Rectangle2D rectangle2D = pagedElement7.getBounds();
                    Rectangle2D.Float float_ = new Rectangle2D.Float((float)(rectangle2D.getX() + rectangle2D.getWidth() + 1.0), (float)rectangle2D.getY(), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
                    this.hC = new MinifiedDrawableElement(float_, pagedElement7.getType(), pagedElement4 != null ? pagedElement4.getPageIndex() : this.hA, pagedElement instanceof DrawableElement ? ((DrawableElement)pagedElement).getElementID().getDescendant() : ElementID.DUMMY);
                    this.hD = new MinifiedDrawableElement(float_, pagedElement7.getType(), pagedElement5 != null ? pagedElement5.getPageIndex() : this.hB, pagedElement2 instanceof DrawableElement ? ((DrawableElement)pagedElement2).getElementID().getDescendant() : ElementID.DUMMY);
                    int n = this.hs.size() - 1;
                    while (n >= 0) {
                        CompareDiffGroup compareDiffGroup2 = this.hs.get(n--);
                        PagedElement pagedElement8 = compareDiffGroup2.getAfterFirst();
                        PagedElement pagedElement9 = compareDiffGroup2.getAfterSecond();
                        boolean bl = true;
                        if (pagedElement8 == pagedElement) {
                            pagedElement8 = this.hC;
                            bl = false;
                        }
                        if (pagedElement9 == pagedElement2) {
                            pagedElement9 = this.hD;
                            bl = false;
                        }
                        if (bl) break;
                        compareDiffGroup2.setElementsAfterGroup(pagedElement8, pagedElement9);
                    }
                }
            }
            this.hs.add(new CompareDiffGroup(new ArrayList<PagedElement>(), new ArrayList<PagedElement>(), this.hC, this.hD, pagedElement, pagedElement2, DiffGroup.GroupType.Sync));
        }
    }

    private PagedElement a(PagedElement pagedElement, List<PagedElement> list) {
        if (list == null || list.size() == 0) {
            return pagedElement;
        }
        if (pagedElement == null) {
            return list.get(0);
        }
        int n = pagedElement.getPageIndex();
        PagedElement pagedElement2 = list.get(list.size() - 1);
        for (int i = list.size() - 1; i >= 0; --i) {
            if (pagedElement2.getPageIndex() != n) continue;
            return this.e(pagedElement, pagedElement2);
        }
        return pagedElement;
    }

    private PagedElement e(PagedElement pagedElement, PagedElement pagedElement2) {
        if (pagedElement2 == null) {
            return pagedElement;
        }
        if (pagedElement == null) {
            return pagedElement;
        }
        return pagedElement.getBounds().getY() < pagedElement2.getBounds().getY() ? pagedElement2 : pagedElement;
    }

    private void f(PagedElement pagedElement, PagedElement pagedElement2) {
        if (this.hx != null) {
            ArrayList<Modification> arrayList = new ArrayList<Modification>();
            for (Modification modification : this.ht) {
                Serializable serializable2;
                boolean bl = false;
                for (Serializable serializable2 : modification.getAttributeDifferences()) {
                    if (serializable2.getInstanceType() != AttributeDifference.TYPE.IMG_PARTCONTENT) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                ImageElement imageElement = (ImageElement)modification.getAffectedElements(true).get(0);
                serializable2 = (ImageElement)modification.getAffectedElements(false).get(0);
                IPostComparator.PostCompareResult postCompareResult = this.df.compareElements(imageElement, (ImageElement)serializable2, false);
                postCompareResult.createDiffGroups(this.hs, imageElement, (PagedElement)((Object)serializable2));
                arrayList.add(modification);
            }
            this.ht.removeAll(arrayList);
            if (!this.ht.isEmpty()) {
                CompareDiffGroup compareDiffGroup = new CompareDiffGroup(this.ht, this.hy, this.hz, pagedElement, pagedElement2, this.hx);
                this.hs.add(compareDiffGroup);
            }
            this.ht = new ArrayList<Modification>();
            this.hx = null;
        }
    }

    private void bg() {
        if (this.hu == null || this.hu.isEmpty()) {
            return;
        }
        if (this.hx == DiffGroup.GroupType.AddedOrRemoved && !this.hu.isEmpty()) {
            this.ht.add(new Modification(DiffGroup.GroupType.Replaced, this.hv, this.hw, this.hu));
        } else {
            this.ht.add(new Modification(this.hx, this.hv, this.hw, this.hu));
        }
        this.hv = new ArrayList<PagedElement>();
        this.hw = new ArrayList<PagedElement>();
        this.hu = null;
    }

    private static final class a
    extends Enum<a> {
        public static final /* enum */ a hI = new a(false, false);
        public static final /* enum */ a hJ = new a(true, false);
        public static final /* enum */ a hK = new a(true, true);
        private boolean hL;
        private boolean hM;
        private static final /* synthetic */ a[] hN;

        public static a[] values() {
            return (a[])hN.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private a(boolean bl, boolean bl2) {
            this.hL = bl;
            this.hM = bl2;
        }

        private static /* synthetic */ a[] bh() {
            return new a[]{hI, hJ, hK};
        }

        static {
            hN = a.bh();
        }
    }

    @JsonData
    private static class SpacingDiff
    extends AttributeDifference<String> {
        private static SpacingDiff createSpacingDiff(boolean added, a type) {
            return new SpacingDiff("PostDiff." + (type.hM ? "linebreak" : "space") + "." + (added ? "added" : "removed"));
        }

        private SpacingDiff(String messageKey) {
            super(AttributeDifference.TYPE.SPACING, null, null, messageKey);
        }
    }
}

