/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.presenter;

import com.inet.annotations.PublicApi;
import com.inet.error.ErrorCodeObject;
import com.inet.logging.LogLevel;
import com.inet.logging.Logger;
import com.inet.logging.StaticLogger;
import com.inet.pdfc.config.PdfSource;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.error.ExceptionData;
import com.inet.pdfc.error.PdfcErrorCode;
import com.inet.pdfc.generator.message.InfoData;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.presenter.BasePresenter;
import com.inet.pdfc.results.ResultModel;
import com.inet.pdfc.util.BatchSummaryCreator;
import java.io.Closeable;
import java.io.PrintWriter;
import java.util.Date;

@PublicApi
public class ConsolePresenter
extends BasePresenter {
    private int oK = 100;
    private Logger ma = LOGGER;
    private BatchSummaryCreator oL = new BatchSummaryCreator(50);

    public String getExtensionName() {
        return "Presenter_Console";
    }

    public void setLogWriter(final PrintWriter writer) {
        this.ma = writer == null ? LOGGER : new StaticLogger("ConsolePresenter"){

            protected void log(LogLevel level, String prefix, Object message) {
                writer.println(level.name() + " (" + String.valueOf(new Date()) + ")\t" + String.valueOf(message));
                writer.flush();
            }
        };
        try (a a2 = new a(this.ma);){
            this.oL.setLogger(this.ma);
        }
    }

    @Override
    public void onInit() throws Exception {
        InfoData infoData = this.getModel().getComparisonParameters();
        PdfSource pdfSource = infoData.getFirstFile();
        String string = pdfSource.getPath() == null || pdfSource.getPath().isBlank() ? pdfSource.getName() : pdfSource.getPath();
        PdfSource pdfSource2 = infoData.getSecondFile();
        String string2 = pdfSource2.getPath() == null || pdfSource2.getPath().isBlank() ? pdfSource2.getName() : pdfSource2.getPath();
        try (a a2 = new a(this.ma);){
            this.ma.info((Object)Msg.getMsg("Status.ComparingFiles", string, string2));
        }
    }

    public void setMaxErrors(int maxErrors) {
        if (this.getModel() != null) {
            this.getModel().getSettings().setSetting(maxErrors, Settings.MAX_ERRORS_PER_FILE.name());
        }
        this.oK = maxErrors;
    }

    @Override
    public void onComparisonDone() throws Exception {
        ResultModel resultModel = this.getModel();
        String string = resultModel.getComparisonParameters().getFirstFile().getName();
        Object object = this.getModel().getSettings().getSetting(Settings.MAX_ERRORS_PER_FILE.name());
        int n = object instanceof Integer ? (Integer)object : this.oK;
        int n2 = 0;
        try (a a2 = new a(this.ma);){
            if (resultModel.getDifferencesCount(false) > 0) {
                for (DiffGroup diffGroup : resultModel.getDifferences(false)) {
                    if (diffGroup.getType() == DiffGroup.GroupType.Sync || diffGroup.getModifications().size() == 0) continue;
                    for (Modification modification : diffGroup.getModifications()) {
                        if (n < 0 || n2 < n) {
                            this.ma.info((Object)Msg.getMsg("Status.DifferencesFound", string, Integer.toString(this.c(modification)), modification.getMessage()));
                        }
                        ++n2;
                    }
                }
                if (n > 0 && n2 >= n) {
                    this.ma.info((Object)Msg.getMsg("Status.MoreDifferences", Math.abs(n2 - n)));
                }
                this.ma.info((Object)Msg.getMsg("Status.TotalDifferences", Math.abs(n2)));
            } else {
                this.ma.info((Object)Msg.getMsg("Status.NoDifferencesFound", string));
            }
        }
        this.oL.storeResultForSummary(resultModel.getComparisonParameters().getFirstFile().getName(), resultModel.getComparisonParameters().getSecondFile().getName(), resultModel.getDifferencesCount(false));
    }

    @Override
    public void onFinish() {
        if (this.getParent() != null) {
            return;
        }
        try (a a2 = new a(this.ma);){
            this.oL.printResultAndClear();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onError(ExceptionData error, boolean interrupted, BasePresenter.ERROR_SOURCE source) {
        InfoData infoData = this.getModel().getComparisonParameters();
        String string = infoData.getFirstFile() != null ? infoData.getFirstFile().getName() : null;
        String string2 = infoData.getSecondFile() != null ? infoData.getSecondFile().getName() : null;
        try (a a2 = new a(this.ma);){
            switch (source) {
                case FIRST_PDF: {
                    this.ma.error((Object)new ErrorCodeObject(PdfcErrorCode.cannotReadDocument.getErrorCodeNumber(), (Object)Msg.getMsg("Error.ReadingFile", string)));
                    this.ma.error((Object)error);
                    return;
                }
                case SECOND_PDF: {
                    LOGGER.error((Object)new ErrorCodeObject(PdfcErrorCode.cannotReadDocument.getErrorCodeNumber(), (Object)Msg.getMsg("Error.ReadingFile", string2)));
                    this.ma.error((Object)error);
                    return;
                }
                case COMPARE: {
                    this.ma.error((Object)new ErrorCodeObject(PdfcErrorCode.errorWhileComparing.getErrorCodeNumber(), (Object)Msg.getMsg("Error.ComparingFiles", string, string2)));
                    this.ma.error((Object)error);
                }
                default: {
                    if (string != null && string2 != null) {
                        this.ma.error((Object)error);
                        return;
                    } else {
                        if (string == null && string2 != null) {
                            this.oL.storeAdded(string2);
                        }
                        if (string != null && string2 == null) {
                            this.oL.storeRemoved(string);
                        }
                        if (error.getMessage() == null) return;
                        this.ma.error((Object)new ErrorCodeObject(error.getErrorCode(), (Object)error.getMessage()));
                    }
                    return;
                }
            }
        }
    }

    @Override
    protected boolean canInformUserOnErrors() {
        return true;
    }

    @Override
    public ConsolePresenter spawn(boolean spawnWithParent) {
        ConsolePresenter consolePresenter = new ConsolePresenter();
        consolePresenter.setParent(this);
        consolePresenter.oL = this.oL;
        if (this.ma != LOGGER) {
            consolePresenter.ma = this.ma;
        }
        return consolePresenter;
    }

    private static class a
    implements Closeable {
        private int oP = -1;
        private Logger ma;

        public a(Logger logger) {
            this.ma = logger;
            if (logger.getLogLevel() < LogLevel.INFO.ordinal()) {
                this.oP = logger.getLogLevel();
                logger.setLogLevel(LogLevel.INFO.ordinal());
            }
        }

        @Override
        public void close() {
            if (this.oP >= 0) {
                this.ma.setLogLevel(this.oP);
            }
        }
    }
}

