/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.plugin;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigurationManager;
import com.inet.encoder.pdf.PDFParserPlugin;
import com.inet.font.truetype.SessionFontFactoryCache;
import com.inet.lib.json.Json;
import com.inet.logging.LogManager;
import com.inet.pdfc.PDFCCorePlugin;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.plugins.ReportingServerPlugin;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class PluginManager {
    public static final String DEFAULT_CONFIG_NAME = "i-net PDFC";

    public static boolean isPluginLoaded(String id) {
        return PluginManager.bF().isPluginLoaded(id);
    }

    @Nonnull
    public static <T> T getSingleInstance(Class<T> interfaceClass) throws IllegalStateException {
        return (T)PluginManager.bF().getSingleInstance(interfaceClass);
    }

    @Nullable
    public static <T> T getOptional(@Nonnull Class<T> interfaceClass) {
        List list;
        Object object = PluginManager.bF().getOptionalInstance(interfaceClass);
        if (object == null && !(list = DynamicExtensionManager.getInstance().get(interfaceClass)).isEmpty()) {
            LogManager.getConfigLogger().debug((Object)("Load DynamicExtensionInstance for " + String.valueOf(interfaceClass)));
            object = list.get(0);
        }
        return (T)object;
    }

    @Nonnull
    public static <T> List<T> get(@Nonnull Class<T> interfaceClass) {
        return PluginManager.bF().get(interfaceClass);
    }

    public static void initConditionally() {
        PluginManager.bF();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ServerPluginManager bF() {
        final ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
        if (serverPluginManager.getState() == ServerPluginManager.ServerPluginManagerState.INIT) return serverPluginManager;
        String string = "[PDFC PLUGIN INFO] ";
        synchronized ("[PDFC PLUGIN INFO] ") {
            ServerPluginDescription serverPluginDescription;
            if (serverPluginManager.getState() == ServerPluginManager.ServerPluginManagerState.INIT) return serverPluginManager;
            try {
                serverPluginDescription = ServerPluginDescription.create((ServerPlugin)new PDFCCorePlugin(), null);
            }
            catch (Exception exception) {
                throw new IllegalStateException("Could not create core plugin", exception);
            }
            try {
                new Runnable(){

                    @Override
                    public void run() {
                        serverPluginManager.addExtractedPlugin(ReportingServerPlugin.class.getName());
                    }
                }.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                new Runnable(){

                    @Override
                    public void run() {
                        serverPluginManager.addExtractedPlugin(PDFParserPlugin.class.getName());
                    }
                }.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            serverPluginManager.init(new ServerPluginDescription[]{serverPluginDescription});
            ForkJoinPool.commonPool().awaitQuiescence(5L, TimeUnit.SECONDS);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return serverPluginManager;
        }
    }

    public static void activatePlugin(String pluginID, boolean activate) {
        Boolean bl;
        String string = ConfigurationManager.getInstance().getCurrent().get(ConfigKey.PLUGINS_ACTIVATED.getKey());
        Map<String, Boolean> map = new HashMap();
        if (string != null) {
            map = (Map)new Json().fromJson(string, Map.class);
        }
        if ((bl = (Boolean)map.get(pluginID)) == null || activate != bl) {
            map.put(pluginID, activate);
            ConfigurationManager.getInstance().getCurrent().put(ConfigKey.PLUGINS_ACTIVATED.getKey(), new Json().toJson(map));
        }
    }

    public static void setPluginFilterForAPI() {
        ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
        if (serverPluginManager.getState() == ServerPluginManager.ServerPluginManagerState.PRE_INIT || serverPluginManager.getState() == ServerPluginManager.ServerPluginManagerState.RESET) {
            PluginManager.setPluginFilterForAPI(serverPluginManager);
        }
    }

    public static void setPluginFilterForAPI(ServerPluginManager spm) {
        spm.setPluginFilter(serverPluginDescription -> !serverPluginDescription.getId().matches("(?i)remotegui|webserver|authentication.*|.*setupwizard.*|theme|help|webapi\\.core|drive|oauth.*"));
    }

    static {
        new SessionFontFactoryCache();
    }
}

