/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.ocr;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.generator.filter.ISortFilter;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.ocr.Language;
import com.inet.pdfc.ocr.LanguageManager;
import com.inet.pdfc.ocr.OcrFactory;
import com.inet.pdfc.ocr.OcrUsage;
import com.inet.pdfc.plugin.PluginManager;
import com.inet.pdfc.thread.PdfcSession;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.annotation.SuppressFBWarnings;
import javax.imageio.ImageIO;

@InternalApi
public abstract class OcrAnalyseFilterBase
implements ISortFilter {
    protected IProfile profile;
    protected boolean active = false;
    protected double alignmentRatio;
    private OcrUsage lH;
    private Language lI;
    private boolean lJ = false;

    @Override
    public ISortFilter setProfile(IProfile profile) {
        this.active = profile.getString(PDFCProperty.FILTERS).toLowerCase().contains(this.getExtensionName().toLowerCase());
        Properties properties = PdfcSession.getSession().getSessionProperties();
        if (this.active) {
            properties.put("ocr.active", Boolean.toString(this.active));
        }
        this.alignmentRatio = profile.getDouble(PDFCProperty.TEXT_ALIGN_RATIO);
        this.profile = profile;
        return this;
    }

    protected OcrUsage getOcrUsage() {
        if (this.lH == null && !this.lJ) {
            OcrFactory ocrFactory = PluginManager.getOptional(OcrFactory.class);
            if (ocrFactory == null) {
                PDFCCore.LOGGER_CORE.debug((Object)Msg.getMsg("pdfc.filter.missingocr"));
                this.lJ = true;
            } else {
                this.lI = LanguageManager.getInstance().getLanguage(this.profile.getString(PDFCProperty.DOCUMENT_LANGUAGE).toLowerCase());
                if (this.lI == null) {
                    this.lI = LanguageManager.getInstance().getLanguage(true);
                }
                this.lH = ocrFactory.createInstance();
                this.lH.setLanguage(this.lI);
            }
        }
        return this.lH;
    }

    protected boolean isActive() {
        if (this.active && this.getOcrUsage() != null) {
            try {
                return this.getOcrUsage().tryTesseract();
            }
            catch (Throwable throwable) {
                throw new RuntimeException(Msg.getMsg("pdfc.filter.failConfigurate", throwable));
            }
        }
        return false;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Read file is always from PdfcSession")
    protected BufferedImage readImage(boolean first, int pageNr) throws IOException {
        String string = this.c(first, pageNr);
        String string2 = PdfcSession.getSession().getSessionProperties().getProperty(string);
        if (string2 == null) {
            return null;
        }
        File file = new File(string2);
        if (file.exists()) {
            BufferedImage bufferedImage = ImageIO.read(file);
            file.delete();
            return bufferedImage;
        }
        return null;
    }

    private String c(boolean bl, int n) {
        return this.getExtensionName() + "_" + bl + "_" + n;
    }
}

