/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.model.forms.image;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.util.Pair;
import com.inet.pdfc.util.a;
import java.awt.Color;
import java.awt.Point;
import java.awt.image.BufferedImage;

@InternalApi
public class HSBImageComparator {
    private double gf;
    private boolean gg;

    public HSBImageComparator(double delta, boolean useAverageValue) {
        this.gf = delta;
        this.gg = useAverageValue;
    }

    public boolean equals(BufferedImage image1, BufferedImage image2) {
        if (image1 == null || image2 == null) {
            return image1 == image2;
        }
        int n = image1.getWidth(null);
        int n2 = image1.getHeight(null);
        int n3 = image2.getWidth(null);
        int n4 = image2.getHeight(null);
        return this.equals(image1, image2, 0, 0, Math.max(n, n3), Math.max(n2, n4));
    }

    public boolean equals(BufferedImage image1, BufferedImage image2, int startX, int startY, int width, int height) {
        return this.getFirstDifferentPoint(image1, image2, startX, startY, width, height) == null;
    }

    public Point getFirstDifferentPoint(BufferedImage image1, BufferedImage image2, int startX, int startY, int width, int height) {
        if (image1 == null || image2 == null) {
            return image1 == image2 ? null : new Point(startX, startY);
        }
        Pair<BufferedImage> pair = a.a(image1, image2);
        if (pair == null) {
            return new Point(startX, startY);
        }
        BufferedImage bufferedImage = pair.get(true);
        BufferedImage bufferedImage2 = pair.get(false);
        float[] fArray = null;
        float[] fArray2 = null;
        height = Math.min(height, bufferedImage2.getHeight() - startY);
        width = Math.min(width, bufferedImage2.getWidth() - startX);
        for (int i = startY; i < startY + height; ++i) {
            for (int j = startX; j < startX + width; ++j) {
                int n;
                int n2 = bufferedImage2.getRGB(j, i);
                if (n2 == (n = bufferedImage.getRGB(j, i))) continue;
                int n3 = bufferedImage2.getType();
                int n4 = bufferedImage.getType();
                if (n3 == 10 && n4 == 1 || n3 == 1 && n4 == 10) {
                    if (n3 == 10) {
                        n2 = this.a(bufferedImage2, j, i);
                    }
                    if (n4 == 10) {
                        n = this.a(bufferedImage, j, i);
                    }
                    if (n2 == n) continue;
                }
                if (this.gf > 0.0) {
                    int n5 = n2 >> 24 & 0xFF;
                    int n6 = n >> 24 & 0xFF;
                    if (n6 == 0 && n5 == 0 || this.a(n, n2, this.gf)) continue;
                    fArray = HSBImageComparator.a(n2, fArray);
                    fArray2 = HSBImageComparator.a(n, fArray2);
                    boolean bl = HSBImageComparator.a((double)n5 / 255.0, (double)n6 / 255.0, this.gf);
                    boolean bl2 = HSBImageComparator.a(fArray, fArray2, this.gf);
                    if (bl2 && bl) continue;
                    if (this.gg) {
                        HSBImageComparator.a(bufferedImage2, j, i, fArray);
                        HSBImageComparator.a(bufferedImage, j, i, fArray2);
                        if (HSBImageComparator.a(fArray, fArray2, this.gf)) continue;
                        return new Point(j, i);
                    }
                    return new Point(j, i);
                }
                if (HSBImageComparator.d(n2, n)) continue;
                return new Point(j, i);
            }
        }
        return null;
    }

    private int a(BufferedImage bufferedImage, int n, int n2) {
        int n3 = bufferedImage.getRaster().getSample(n, n2, 0) & 0xFF;
        return -16777216 + (n3 << 16) + (n3 << 8) + n3;
    }

    private static boolean a(float[] fArray, float[] fArray2, double d2) {
        if (!HSBImageComparator.a(fArray[2], fArray2[2], d2)) {
            return false;
        }
        if (!(fArray[2] + fArray2[2] > 0.0f)) {
            return true;
        }
        if (!HSBImageComparator.a(fArray[1], fArray2[1], d2 /= (double)((fArray[2] + fArray2[2]) / 2.0f))) {
            return false;
        }
        if (!(fArray[1] + fArray2[1] > 0.0f)) {
            return true;
        }
        if (!HSBImageComparator.a(fArray[0], fArray2[0], d2 /= (double)((fArray[1] + fArray2[1]) / 2.0f))) {
            float f2;
            float f3 = f2 = fArray2[0] < fArray[0] ? fArray2[0] + 1.0f : fArray2[0] - 1.0f;
            if (!HSBImageComparator.a(fArray[0], f2, d2)) {
                return false;
            }
        }
        return true;
    }

    private boolean a(int n, int n2, double d2) {
        int n3 = n >> 24 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 8 & 0xFF;
        int n6 = n & 0xFF;
        int n7 = n2 >> 24 & 0xFF;
        int n8 = n2 >> 16 & 0xFF;
        int n9 = n2 >> 8 & 0xFF;
        int n10 = n2 & 0xFF;
        int n11 = (int)Math.ceil(256.0 * d2);
        if (Math.abs(n3 - n7) > n11) {
            return false;
        }
        if (Math.abs(n4 - n8) > n11) {
            return false;
        }
        if (Math.abs(n5 - n9) > n11) {
            return false;
        }
        return Math.abs(n6 - n10) <= n11;
    }

    private static float[] a(BufferedImage bufferedImage, int n, int n2, float[] fArray) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = Math.max(n - 1, 0);
        int n8 = Math.min(n + 1, bufferedImage.getWidth() - 1);
        int n9 = Math.max(0, n2 - 1);
        int n10 = Math.min(n2 + 1, bufferedImage.getHeight() - 1);
        for (int i = n7; i <= n8; ++i) {
            for (int j = n9; j <= n10; ++j) {
                int n11 = bufferedImage.getRGB(i, j);
                n3 += n11 >> 16 & 0xFF;
                n4 += n11 >> 8 & 0xFF;
                n5 += n11 >> 0 & 0xFF;
                ++n6;
            }
        }
        return Color.RGBtoHSB(n3 / n6, n4 / n6, n5 / n6, fArray);
    }

    private static float[] a(int n, float[] fArray) {
        return Color.RGBtoHSB(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF, fArray);
    }

    private static boolean d(int n, int n2) {
        return n2 == n;
    }

    private static boolean a(double d2, double d3, double d4) {
        return Math.abs(d3 - d2) <= d4;
    }
}

