/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.model.forms;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.generator.model.forms.LineShape;
import com.inet.pdfc.generator.model.forms.TwoSidedPaint;
import com.inet.pdfc.generator.postcompare.PaintComparator;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.model.ShapeElement;
import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

@JsonData
@InternalApi
public class LineShapeSegmented
extends LineShape {
    private static final double MIN_LINE_SIZE = 0.02;
    public static final double MIN_SEGMENT_SIZE = 0.5;
    public static final double TOLERANCE_LATERAL = 0.5;
    @Nonnull
    private @Nonnull List<@Nonnull Segment> segments = new ArrayList<Segment>();

    public LineShapeSegmented(Line2D line, Paint strokeColor, Paint fillColor, BasicStroke stroke, int pageIndex, @Nonnull ShapeElement sourceElement, @Nonnull ElementID id) {
        super(line, strokeColor, fillColor, stroke, pageIndex, sourceElement, id);
        this.segments.add(new Segment(this, 0.0, true));
    }

    private Point2D getPoint(double distFromP1) {
        double d2 = this.getLineLength();
        Line2D line2D = this.getLine();
        double d3 = line2D.getX1() + (line2D.getX2() - line2D.getX1()) / d2 * distFromP1;
        double d4 = line2D.getY1() + (line2D.getY2() - line2D.getY1()) / d2 * distFromP1;
        return new Point2D.Double(d3, d4);
    }

    private void extendLine(double distFromP1) {
        double d2 = this.getLineLength();
        if (distFromP1 >= 0.0 && distFromP1 <= d2) {
            return;
        }
        Line2D line2D = this.getLine();
        double d3 = line2D.getX1() + (line2D.getX2() - line2D.getX1()) / d2 * distFromP1;
        double d4 = line2D.getY1() + (line2D.getY2() - line2D.getY1()) / d2 * distFromP1;
        line2D = distFromP1 < 0.0 ? new Line2D.Double(d3, d4, line2D.getX2(), line2D.getY2()) : new Line2D.Double(line2D.getX1(), line2D.getY1(), d3, d4);
        this.setLine(line2D);
    }

    @Override
    protected void checkOriginalLineModification(Line2D line) {
    }

    public void add(LineShape line) {
        if (line instanceof LineShapeSegmented) {
            for (LineShape lineShape : ((LineShapeSegmented)line).toLines()) {
                this.addLineToSegments(lineShape);
            }
            this.optimizeSegments();
            return;
        }
        this.addLineToSegments(line);
        this.optimizeSegments();
    }

    private void addLineToSegments(LineShape line) {
        Segment segment2;
        double d2 = this.getLineLength();
        double d3 = this.getDistanceToP1(line.getX1(), line.getY1());
        double d4 = this.getDistanceToP1(line.getX2(), line.getY2());
        boolean bl = true;
        if (d3 > d4) {
            double d5 = d3;
            d3 = d4;
            d4 = d5;
            bl = false;
        }
        int n = 0;
        int n2 = this.segments.size();
        if (d4 > d2) {
            this.extendLine(d4);
            if (!this.isSamepoint(d4, d2)) {
                this.segments.add(new Segment(line, d2, bl));
            }
        }
        if (d3 < 0.0) {
            if (this.isSamepoint(d3, 0.0)) {
                this.extendLine(d3);
            } else {
                for (Segment segment2 : this.segments) {
                    segment2.ga -= d3;
                }
                this.segments.add(0, new Segment(line, 0.0, bl));
                this.extendLine(d3);
                ++n;
                ++n2;
            }
            d2 -= d3;
            d4 -= d3;
            d3 = 0.0;
        }
        if (d3 > 0.01) {
            for (int i = 0; i < this.segments.size(); ++i) {
                segment2 = this.segments.get(i);
                if (this.isSamepoint(segment2.ga, d3)) {
                    if (line.getElementID().compareTo(segment2.fZ) >= 0 && i > 0) {
                        segment2.ga = d3;
                    }
                    n = i;
                    break;
                }
                if (segment2.ga > d3) {
                    n = i;
                    ++n2;
                    this.segments.add(i, new Segment(this.segments.get(i - 1), d3));
                    break;
                }
                if (i != this.segments.size() - 1) continue;
                n = i + 1;
                ++n2;
                this.segments.add(new Segment(segment2, d3));
                break;
            }
        }
        if (d4 < d2 && d2 - d4 > 0.01) {
            for (int i = this.segments.size() - 1; i >= 0; --i) {
                segment2 = this.segments.get(i);
                if (this.isSamepoint(segment2.ga, d4)) {
                    if (i > 0 && line.getElementID().compareTo(segment2.fZ) >= 0) {
                        segment2.ga = d4;
                    }
                    n2 = i;
                    break;
                }
                if (!(segment2.ga < d4)) continue;
                n2 = i + 1;
                this.segments.add(i + 1, new Segment(segment2, d4));
                break;
            }
        }
        for (int i = n; i < n2; ++i) {
            segment2 = this.segments.get(i);
            segment2.combineProperties(line, bl, false);
        }
    }

    private void optimizeSegments() {
        Iterator<@Nonnull Segment> iterator = this.segments.iterator();
        Segment segment = null;
        while (iterator.hasNext()) {
            Segment segment2 = iterator.next();
            if (segment != null && segment.canMerge(segment2, 0.5)) {
                iterator.remove();
                continue;
            }
            segment = segment2;
        }
    }

    @Override
    public String getReadableForm() {
        return super.getReadableForm() + " SEG";
    }

    private boolean isSamepoint(double segmentOffset1, double segmentOffset2) {
        return Math.abs(segmentOffset2 - segmentOffset1) < 0.5;
    }

    @Nonnull
    public @Nonnull List<@Nonnull Segment> getSegments() {
        return this.segments;
    }

    public List<@Nonnull LineShape> toLines() {
        Object object;
        boolean bl = false;
        for (Segment object22 : this.segments) {
            TwoSidedPaint i;
            if (object22.stroke == null || object22.strokePaint == null || !((object = object22.fillPaint) instanceof TwoSidedPaint) || !PaintComparator.DEFAULT.isEqual((i = (TwoSidedPaint)object).getPaint(true), i.getPaint(false))) continue;
            object22.fillPaint = null;
            bl = true;
        }
        if (bl) {
            this.optimizeSegments();
        }
        ArrayList arrayList = new ArrayList(this.segments.size());
        HashMap<ElementID, ElementID> hashMap = new HashMap<ElementID, ElementID>();
        for (int i = 0; i < this.segments.size(); ++i) {
            Point2D point2D;
            object = this.segments.get(i);
            Point2D point2D2 = i > 0 ? this.getPoint(((Segment)object).ga) : this.getLine().getP1();
            Point2D point2D3 = point2D = i < this.segments.size() - 1 ? this.getPoint(this.segments.get((int)(i + 1)).ga) : this.getLine().getP2();
            if (point2D2.distance(point2D) < 0.02) continue;
            Line2D.Double double_ = new Line2D.Double(point2D2, point2D);
            ElementID elementID = ((Segment)object).fZ;
            ElementID elementID2 = (ElementID)hashMap.get(elementID);
            ElementID elementID3 = elementID2 == null ? elementID.getDescendant() : elementID2.getDescendant();
            hashMap.put(elementID, elementID3);
            Paint paint = ((Segment)object).fillPaint;
            arrayList.add(new LineShape(double_, ((Segment)object).strokePaint, paint, ((Segment)object).stroke, this.getPageIndex(), ((Segment)object).source, elementID3));
        }
        return arrayList;
    }

    @InternalApi
    public static class Segment {
        private Paint strokePaint;
        private Paint fillPaint;
        private BasicStroke stroke;
        @Nonnull
        private ElementID fZ;
        private double ga;
        @Nonnull
        private ShapeElement source;

        public Segment(LineShape source, double start, boolean sameDirection) {
            this(source.getStrokePaint(), !sameDirection && source.getFillPaint() instanceof TwoSidedPaint ? ((TwoSidedPaint)source.getFillPaint()).copyInverse() : source.getFillPaint(), source.getStroke(), source.getSource(), source.getElementID(), start);
        }

        public Segment(Segment source, double start) {
            this(source.strokePaint, source.fillPaint, source.stroke, source.source, source.fZ, start);
        }

        public Segment(Paint strokePaint, Paint fillPaint, BasicStroke stroke, @Nonnull ShapeElement source, @Nonnull ElementID id, double start) {
            this.strokePaint = strokePaint;
            this.fillPaint = fillPaint;
            this.stroke = stroke;
            this.source = source;
            this.fZ = id;
            this.ga = start;
        }

        public void combineProperties(LineShape other, boolean sameDirection, boolean optimizeFill) {
            Paint paint;
            TwoSidedPaint twoSidedPaint;
            boolean bl;
            BasicStroke basicStroke = other.getStroke();
            Paint paint2 = other.getStrokePaint();
            Paint paint3 = other.getFillPaint();
            if (this.stroke == null) {
                this.stroke = basicStroke;
                this.strokePaint = paint2;
                this.source = other.getSource();
                this.fZ = other.getElementID();
            } else if (basicStroke != null && paint2 != null && basicStroke.getDashArray() == null && (other.getElementID().compareTo(this.fZ) > 0 || this.stroke.getDashArray() != null)) {
                this.stroke = basicStroke;
                this.strokePaint = paint2;
                this.source = other.getSource();
                this.fZ = other.getElementID();
            }
            boolean bl2 = bl = paint3 != null && PaintComparator.DEFAULT.isEqual(paint3, this.fillPaint);
            if (!sameDirection && bl && paint3 instanceof TwoSidedPaint) {
                twoSidedPaint = new TwoSidedPaint(((TwoSidedPaint)paint3).getPaint(false), this.fZ, ((TwoSidedPaint)paint3).getPaint(true), this.fZ);
                bl = PaintComparator.DEFAULT.isEqual(twoSidedPaint, this.fillPaint);
            }
            if (!(paint3 == null || this.fillPaint != null && bl)) {
                if (this.fillPaint == null) {
                    if (paint3 instanceof TwoSidedPaint) {
                        twoSidedPaint = (TwoSidedPaint)paint3;
                        paint3 = new TwoSidedPaint(twoSidedPaint.getPaint(sameDirection), this.fZ, ((TwoSidedPaint)paint3).getPaint(!sameDirection), this.fZ);
                    }
                    this.fillPaint = paint3;
                } else if (this.fillPaint instanceof TwoSidedPaint) {
                    twoSidedPaint = (TwoSidedPaint)this.fillPaint;
                    twoSidedPaint = twoSidedPaint.copy();
                    if (paint3 instanceof TwoSidedPaint) {
                        twoSidedPaint.setTwoSided((TwoSidedPaint)paint3, sameDirection);
                    } else if (sameDirection) {
                        twoSidedPaint.setSameSide(paint3, other.getElementID());
                    } else {
                        twoSidedPaint.setOtherSide(paint3, other.getElementID());
                    }
                    this.fillPaint = twoSidedPaint;
                } else if (paint3 instanceof TwoSidedPaint) {
                    twoSidedPaint = (TwoSidedPaint)paint3;
                    twoSidedPaint = twoSidedPaint.copy();
                    if (sameDirection) {
                        twoSidedPaint.setSameSide(this.fillPaint, null);
                    } else {
                        twoSidedPaint.setOtherSide(this.fillPaint, null);
                    }
                    this.fillPaint = paint3;
                } else if (sameDirection) {
                    this.fillPaint = paint3;
                } else {
                    twoSidedPaint = new TwoSidedPaint(this.fillPaint, this.fZ, true);
                    twoSidedPaint.setOtherSide(paint3, other.getElementID());
                    this.fillPaint = twoSidedPaint;
                }
            }
            if (optimizeFill && this.stroke != null && this.strokePaint != null && (paint = this.fillPaint) instanceof TwoSidedPaint && PaintComparator.DEFAULT.isEqual((twoSidedPaint = (TwoSidedPaint)paint).getPaint(true), twoSidedPaint.getPaint(false))) {
                this.fillPaint = null;
            }
        }

        public boolean canMerge(Segment other, double toleranceLateral) {
            if (!PaintComparator.DEFAULT.isEqual(this.fillPaint, other.fillPaint)) {
                return false;
            }
            if (!PaintComparator.DEFAULT.isEqual(this.strokePaint, other.strokePaint)) {
                return false;
            }
            if (this.strokePaint == null != (other.strokePaint == null)) {
                return false;
            }
            if (this.strokePaint == null && other.strokePaint == null) {
                return true;
            }
            if (this.strokePaint != null && this.stroke != null) {
                BasicStroke basicStroke = this.stroke;
                BasicStroke basicStroke2 = other.stroke;
                if ((double)Math.abs(basicStroke.getLineWidth() - basicStroke2.getLineWidth()) > toleranceLateral) {
                    return false;
                }
                if (basicStroke.getLineJoin() != basicStroke2.getLineJoin()) {
                    return false;
                }
                if (basicStroke.getEndCap() != basicStroke2.getEndCap()) {
                    return false;
                }
                if (basicStroke.getMiterLimit() != basicStroke2.getMiterLimit()) {
                    return false;
                }
                if (basicStroke.getDashArray() != null ? !Arrays.equals(basicStroke.getDashArray(), basicStroke2.getDashArray()) : basicStroke2.getDashArray() != null) {
                    return false;
                }
            }
            return true;
        }

        public Paint getFillPaint() {
            return this.fillPaint;
        }

        public BasicStroke getStroke() {
            return this.stroke;
        }

        public Paint getStrokePaint() {
            return this.strokePaint;
        }

        @Nonnull
        public ShapeElement getSource() {
            return this.source;
        }

        public String toString() {
            return "Start: " + this.ga + (String)(this.strokePaint != null ? ", Stroke: " + String.valueOf(this.strokePaint) + " / " + String.valueOf(this.stroke) : "") + (String)(this.fillPaint != null ? ", Fill: " + String.valueOf(this.fillPaint) : "");
        }
    }
}

