/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.util;

import com.inet.annotations.InternalApi;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

@InternalApi
public class Sample<T>
extends Number {
    public static final Comparator<Sample<?>> SORT_BY_VALUE = (sample, sample2) -> Double.compare(sample.uo, sample2.uo);
    public static final Comparator<Sample<?>> SORT_BY_OCCURENCES = (sample, sample2) -> {
        if (sample.getOccurrences() == sample2.getOccurrences()) {
            return Double.compare(sample.uo, sample2.uo);
        }
        return sample.getOccurrences().size() - sample2.getOccurrences().size();
    };
    private double uo;
    private double up = Double.MAX_VALUE;
    private double uq = Double.MIN_VALUE;
    private double ur = 0.0;
    private List<T> us = new ArrayList<T>();

    public Sample(List<T> samples, ValueFunction<T> assignment) {
        double d2 = 0.0;
        for (T t : samples) {
            d2 += assignment.getValue(t);
        }
        this.uo = d2 / (double)samples.size();
        for (T t : samples) {
            double d3 = assignment.getValue(t);
            this.ur += Math.pow(this.uo - d3, 2.0);
            if (d3 < this.up) {
                this.up = d3;
            }
            if (!(d3 > this.uq)) continue;
            this.uq = d3;
        }
        this.ur /= (double)samples.size();
        this.us = samples;
    }

    public void addOccurrence(T value) {
        this.us.add(value);
    }

    public List<T> getOccurrences() {
        return this.us;
    }

    public int getCount() {
        return this.us.size();
    }

    public double getMin() {
        return this.up;
    }

    public double getMax() {
        return this.uq;
    }

    public double getVariance() {
        return this.ur;
    }

    @Override
    public int intValue() {
        return (int)Math.round(this.uo);
    }

    @Override
    public long longValue() {
        return Math.round(this.uo);
    }

    @Override
    public float floatValue() {
        return (float)this.uo;
    }

    @Override
    public double doubleValue() {
        return this.uo;
    }

    @FunctionalInterface
    @InternalApi
    public static interface ValueFunction<T> {
        public double getValue(T var1);
    }
}

