/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.print;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigurationManager;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.config.PdfSource;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.print.MasterAlphaGraphics;
import com.inet.pdfc.results.CollapsePagesModelData;
import com.inet.pdfc.results.ResultModel;
import com.inet.pdfc.results.ResultPage;
import com.inet.pdfc.results.painter.DifferenceImageCache;
import com.inet.pdfc.results.painter.IViewInfoProvider;
import com.inet.pdfc.results.painter.MarkerManager;
import com.inet.pdfc.results.painter.Painter;
import com.inet.pdfc.results.painter.ScrollController;
import com.inet.pdfc.structure.PdfcStructureProvider;
import com.inet.pdfc.util.Pair;
import com.inet.pdfc.util.VersionData;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class PrintPainter {
    public static final byte PAINT_LEFT = 1;
    public static final byte PAINT_RIGHT = 2;
    public static final byte PAINT_BOTH = 3;
    private Painter qu;
    @Nonnull
    private ScrollController qv;
    private b qw;
    private DifferenceImageCache qx;
    @Nonnull
    private ResultModel model;
    private double qy = -1.0;
    private double qz;
    private double nu;
    private boolean qA = true;
    private int oR;
    private int oQ;
    private int qB;
    private double qC;
    public static final int GAP_BETWEEN_PAGES = 30;
    private boolean qD = true;
    private boolean qE = true;
    private boolean qF = false;
    private boolean qG = false;
    private Color ns = Color.white;
    private byte qH = (byte)3;
    private boolean pp = false;
    private float po = 0.0f;
    private int nd;
    private List<a> qI;
    private String qJ;
    private FontRenderContext qK;
    private Font qL = new Font("Serif", 0, 10);
    private int qM = 0;

    public PrintPainter(@Nonnull MarkerManager markerManager, @Nonnull ScrollController layerManager, @Nonnull ResultModel model, DifferenceImageCache differenceImageCache) {
        this.qv = layerManager;
        this.model = model;
        this.qx = differenceImageCache;
        this.qw = new b();
        this.qu = new Painter(this.qw, model, this.qx, markerManager, this.ns);
        this.setSettings(model.getSettings());
        this.qJ = ConfigurationManager.getInstance().getCurrent().get(PdfcStructureProvider.KEY_EXPORT_FOOTER);
        if (this.qJ != null && !this.qJ.isBlank()) {
            this.qM = -1;
        }
    }

    private int a(int n, Font font, String string) {
        int n2;
        if (this.qJ == null || this.qJ.isBlank()) {
            return 0;
        }
        AttributedString attributedString = new AttributedString(string);
        attributedString.addAttribute(TextAttribute.FONT, font);
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), this.qK);
        int n3 = 0;
        lineBreakMeasurer.setPosition(0);
        while (lineBreakMeasurer.getPosition() < string.length()) {
            n2 = lineBreakMeasurer.nextOffset(n);
            lineBreakMeasurer.setPosition(n2);
            ++n3;
        }
        n2 = (int)Math.ceil(font.getLineMetrics(string, this.qK).getHeight());
        int n4 = n3 * n2;
        return n4;
    }

    public void setSettings(Settings settings) {
        this.qu.setSettings(settings);
        this.qD = settings.isEnabled(Settings.EXPORT.HEADER);
        this.qE = settings.isEnabled(Settings.EXPORT.FOOTER);
        this.qF = settings.isEnabled(Settings.EXPORT.SCALETOPAGEHEIGHT);
        this.qG = settings.isEnabled(Settings.EXPORT.AUTOPAGESSIZE);
        if (this.qG) {
            this.qF = true;
        }
    }

    public void setScale(double scale) {
        if (!this.qG) {
            PDFCCore.LOGGER_PRESENTER.debug((Object)"WARNING: setScale() was called on an export instance while no 'scale to fit' was set. This call is invalid and will be ignored.");
            return;
        }
        if (this.qy < 0.0) {
            this.qw.cR();
            this.cP();
        }
        this.nu = scale;
    }

    public void print(@Nonnull Graphics2D g2, int pageNr) {
        boolean bl;
        boolean bl2 = bl = !this.qA && this.model.isEmpty();
        if (this.qy == -1.0 && !bl || this.qM < 0) {
            throw new IllegalStateException("You must call calculatePages(int, int, FontRenderContext) before you can print!");
        }
        this.qu.setPaintSides(this.qH);
        if (this.model.isEmpty()) {
            Rectangle rectangle = new Rectangle(0, this.oR * pageNr, this.oQ, this.oR);
            this.qu.paintContent(g2, rectangle, true, false);
            return;
        }
        this.nd = pageNr;
        if (!this.model.isEmpty()) {
            this.a(g2);
            this.a(g2, pageNr);
            if (this.qD) {
                g2.translate(0, 25);
            }
        }
        if (!this.pp && this.qH != 3 && this.qF) {
            this.a(g2, pageNr, this.nu);
        } else if (this.pp) {
            this.a(g2, pageNr, this.nu, false);
        } else {
            this.b(g2, pageNr, this.nu, false);
        }
        if (this.qD || this.qE) {
            g2.translate(0.0, -25.0 / this.nu);
        }
    }

    public Pair<ResultPage> getPages(int printPageNr) {
        if (this.qI == null) {
            if (this.qG && this.qH != 3) {
                boolean bl = this.qH == 1;
                ResultPage resultPage = this.model.getPage(printPageNr, bl);
                if (resultPage.getHeight() == 0) {
                    return null;
                }
                return new Pair<ResultPage>(bl ? resultPage : null, bl ? null : resultPage);
            }
            return null;
        }
        a a2 = this.qI.get(printPageNr);
        return a2 != null ? new Pair<ResultPage>(a2.qN, a2.qO) : null;
    }

    private List<a> cO() {
        if (!this.qF || this.qH != 3) {
            return null;
        }
        ArrayList<a> arrayList = new ArrayList<a>();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (true) {
            int n8;
            int n9 = n + this.qw.getPageGap(n3, true);
            int n10 = n2 + this.qw.getPageGap(n4, false);
            ResultPage resultPage = this.model.getPage(n3, true);
            ResultPage resultPage2 = this.model.getPage(n4, false);
            if (resultPage == null && resultPage2 == null) break;
            int n11 = resultPage != null ? resultPage.getHeight() : 0;
            int n12 = n8 = resultPage2 != null ? resultPage2.getHeight() : 0;
            if (n11 == 0 && n8 == 0) {
                if (resultPage != null) {
                    ++n3;
                }
                if (resultPage2 == null) continue;
                ++n4;
                continue;
            }
            n5 = resultPage != null ? resultPage.getWidth() : (n5 > 0 ? n5 : (resultPage2 != null ? resultPage2.getWidth() : 0));
            int n13 = n9 + n11;
            int n14 = n10 + n8;
            int n15 = Math.max(n11, n8);
            if (n13 <= n10 && resultPage != null || resultPage2 == null) {
                n6 = n9;
                arrayList.add(new a(resultPage, null, n6, n7, n15));
                n += n11;
                ++n3;
            } else if (n14 <= n9 || resultPage == null) {
                n7 = n10;
                arrayList.add(new a(null, resultPage2, n6, n7, n15));
                n2 += n8;
                ++n4;
            } else {
                n6 = n9;
                n7 = n10;
                arrayList.add(new a(resultPage, resultPage2, n6, n7, n15));
                n2 += n8;
                n += n11;
                ++n3;
                ++n4;
            }
            n6 += n15;
            n7 += n15;
        }
        return arrayList;
    }

    private void a(Graphics2D graphics2D, int n, double d2, boolean bl) {
        Rectangle rectangle = new Rectangle(0, this.oR * n, this.oQ, this.oR);
        graphics2D.translate(0, -rectangle.y);
        Rectangle rectangle2 = graphics2D.getClipBounds();
        rectangle2 = rectangle2 == null ? rectangle : rectangle2.intersection(rectangle);
        graphics2D.setClip(rectangle2);
        this.qu.paintBackground(graphics2D, rectangle);
        MasterAlphaGraphics masterAlphaGraphics = new MasterAlphaGraphics(graphics2D);
        boolean bl2 = this.cQ();
        if ((double)this.po < 0.5) {
            if (this.qA) {
                masterAlphaGraphics.setMasterAlpha(this.po);
                graphics2D.setComposite(AlphaComposite.getInstance(3, this.po));
                if ((double)this.po < 0.1) {
                    this.qu.setPaintSides(1);
                }
            }
            this.qu.paintContent((Graphics2D)((Object)masterAlphaGraphics), rectangle, false, false, this.qA, bl2);
            masterAlphaGraphics.setMasterAlpha(1.0f - this.po);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f - this.po));
            this.qu.paintContent((Graphics2D)((Object)masterAlphaGraphics), rectangle, true, false, this.qA, bl2);
        } else {
            if (this.qA) {
                masterAlphaGraphics.setMasterAlpha(1.0f - this.po);
                graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f - this.po));
                if ((double)this.po > 0.9) {
                    this.qu.setPaintSides(2);
                }
            }
            this.qu.paintContent((Graphics2D)((Object)masterAlphaGraphics), rectangle, true, false, this.qA, bl2);
            masterAlphaGraphics.setMasterAlpha(this.po);
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.po));
            this.qu.paintContent((Graphics2D)((Object)masterAlphaGraphics), rectangle, false, false, this.qA, bl2);
        }
        graphics2D.translate(0, rectangle.y);
    }

    private void b(Graphics2D graphics2D, int n, double d2, boolean bl) {
        boolean[] blArray = this.qH == 1 ? new boolean[]{true} : (this.qH == 3 ? new boolean[]{true, false} : new boolean[]{false});
        AffineTransform affineTransform = graphics2D.getTransform();
        for (boolean bl2 : blArray) {
            Rectangle rectangle;
            IViewInfoProvider.ViewInfo viewInfo = this.qw.computeCurrentViewPosition(bl2);
            graphics2D.translate(0, -viewInfo.y);
            double d3 = 30.0 * d2;
            viewInfo.width = viewInfo.width + (int)(bl2 ? d3 / 2.0 : Math.ceil(d3 / 2.0));
            boolean bl3 = bl2 || this.qH == 2;
            Rectangle rectangle2 = new Rectangle(viewInfo.x - (bl3 ? 2 : 0), viewInfo.y - 2, viewInfo.width + (bl3 ? 3 : 1), viewInfo.height + 3);
            if (bl3) {
                graphics2D.translate(1, 0);
            }
            if ((rectangle = graphics2D.getClipBounds()) != null) {
                Rectangle rectangle3 = rectangle2.intersection(rectangle);
                graphics2D.setClip(rectangle3);
            } else {
                graphics2D.setClip(rectangle2);
            }
            this.qu.paintBackground(graphics2D, viewInfo);
            this.qu.paintContent(graphics2D, viewInfo, bl2, this.qH == 3, this.qA, true);
            graphics2D.setClip(rectangle);
            graphics2D.translate(0, viewInfo.y);
            graphics2D.translate(viewInfo.width, 0);
        }
        graphics2D.setTransform(affineTransform);
    }

    private void a(Graphics2D graphics2D, int n, double d2) {
        boolean bl = this.qH == 1;
        AffineTransform affineTransform = graphics2D.getTransform();
        IViewInfoProvider.ViewInfo viewInfo = this.qw.computeCurrentViewPosition(bl);
        graphics2D.translate(0, -viewInfo.y);
        Rectangle rectangle = new Rectangle(viewInfo.x, viewInfo.y, viewInfo.width, viewInfo.height);
        Rectangle rectangle2 = graphics2D.getClipBounds();
        if (rectangle2 != null) {
            Rectangle rectangle3 = rectangle.intersection(rectangle2);
            graphics2D.setClip(rectangle3);
        } else {
            graphics2D.setClip(rectangle);
        }
        this.qu.paintBackground(graphics2D, viewInfo);
        this.qu.paintContent(graphics2D, viewInfo, bl, false, this.qA, this.cQ());
        graphics2D.setClip(rectangle2);
        graphics2D.setTransform(affineTransform);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Path is only resolved to be printed to the output document in well formed form")
    private void a(Graphics2D graphics2D) {
        if (this.qD) {
            int n;
            graphics2D.setColor(Color.black);
            graphics2D.setFont(new Font("Arial", 0, 10));
            graphics2D.setStroke(new BasicStroke(0.2f));
            PdfSource pdfSource = this.model.getComparisonParameters().getFirstFile();
            PdfSource pdfSource2 = this.model.getComparisonParameters().getSecondFile();
            String[] stringArray = null;
            stringArray = pdfSource.getPath() != null && pdfSource2.getPath() != null ? PrintPainter.a(new File(pdfSource.getPath()), new File(pdfSource2.getPath())) : new String[]{pdfSource.getName(), pdfSource2.getName()};
            String string = Msg.getMsg("Export.file.header.right", stringArray[0], stringArray[1]);
            String string2 = this.model.getComparisonParameters().getProfile().getString("PROFIL_NAME");
            String string3 = string2 == null || string2.isEmpty() ? Msg.getMsg("Export.file.header.left.default") : Msg.getMsg("Export.file.header.left", string2);
            int n2 = n = 2;
            int n3 = (int)graphics2D.getFontMetrics().getStringBounds(string3, graphics2D).getHeight();
            graphics2D.drawString(string3, n2, n3);
            string = this.a(string, graphics2D, n, graphics2D.getFontMetrics().stringWidth(string3));
            int n4 = graphics2D.getFontMetrics().stringWidth(string);
            double d2 = graphics2D.getFontMetrics().getStringBounds(string, graphics2D).getHeight();
            int n5 = (int)d2;
            graphics2D.drawString(string, this.oQ - n - n4, n5);
            graphics2D.drawLine(0, n5 + 5, this.oQ, n5 + 5);
        }
    }

    private String a(String string, Graphics2D graphics2D, int n, int n2) {
        int n3 = this.oQ - 2 * n - n2 - 5;
        while (graphics2D.getFontMetrics().stringWidth(string) > n3) {
            if (string.isEmpty()) {
                return "";
            }
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private static String[] a(File file, File file2) {
        if (!file.getName().equals(file2.getName())) {
            return new String[]{file.getName(), file2.getName()};
        }
        int n = 0;
        File file3 = file.getParentFile();
        File file4 = file2.getParentFile();
        while (file3 != null && file4 != null && file3.getName().equals(file4.getName())) {
            file3 = file3.getParentFile();
            file4 = file4.getParentFile();
            ++n;
        }
        if (file3 == null || file4 == null) {
            return new String[]{file.getName(), file2.getName()};
        }
        Object object = File.separator;
        if (n > 0) {
            object = (String)object + "..." + (String)object;
        }
        return new String[]{file3.getName() + (String)object + file.getName(), file4.getName() + (String)object + file2.getName()};
    }

    private void a(Graphics2D graphics2D, int n) {
        if (this.qE) {
            Object object;
            graphics2D.setColor(Color.black);
            graphics2D.setFont(this.qL);
            graphics2D.setStroke(new BasicStroke(0.2f));
            int n2 = this.oR + (this.qD ? 30 : 5);
            graphics2D.drawLine(0, n2, this.oQ, n2);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            n2 += fontMetrics.getDescent();
            if (this.qM > 0) {
                object = new AttributedString(this.qJ);
                ((AttributedString)object).addAttribute(TextAttribute.FONT, this.qL);
                LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(((AttributedString)object).getIterator(), graphics2D.getFontRenderContext());
                lineBreakMeasurer.setPosition(0);
                int n3 = 0;
                while (lineBreakMeasurer.getPosition() < this.qJ.length()) {
                    int n4 = lineBreakMeasurer.nextOffset(this.oQ - 4);
                    graphics2D.drawString(this.qJ.substring(n3, n4), 2, n2 += fontMetrics.getAscent());
                    n2 += fontMetrics.getDescent() + fontMetrics.getLeading();
                    lineBreakMeasurer.setPosition(n4);
                    n3 = n4;
                }
            }
            object = Msg.getMsg("Export.file.footer.right", n + 1, this.qB);
            int n5 = fontMetrics.stringWidth((String)object);
            graphics2D.drawString((String)object, this.oQ - 2 - n5, n2 += fontMetrics.getAscent());
            String string = VersionData.getProductName() + " " + Msg.getMsg("Export.file.footer.left", this.getPrintDate());
            graphics2D.drawString(string, 2, n2);
        }
    }

    protected Date getPrintDate() {
        return new Date();
    }

    public int calculatePages(int pageWidth, int pageHeight, @Nonnull FontRenderContext frc) {
        int n;
        double d2;
        boolean bl;
        if (this.model.isEmpty()) {
            return 0;
        }
        this.qK = frc;
        this.qM = this.qJ != null && !this.qJ.isBlank() ? this.a(pageWidth - 4, this.qL, this.qJ) : 0;
        this.qw.cR();
        this.cP();
        pageHeight = this.setPageSize(pageWidth, pageHeight);
        boolean bl2 = this.cQ();
        boolean bl3 = bl = bl2 && frc.getFractionalMetricsHint() != RenderingHints.VALUE_FRACTIONALMETRICS_ON;
        double d3 = bl ? (double)(this.qH != 3 ? 2 : 1) : (d2 = bl2 ? 0.8 : 0.0);
        if (this.qF) {
            float f2 = 0.0f;
            if (this.qH != 3 && !this.pp) {
                for (n = 0; n < this.model.getPageCount(this.qH == 1); n += 1) {
                    f2 = Math.max(f2, (float)this.model.getPage(n, this.qH == 1).getHeight());
                }
            } else {
                for (n = 0; n < this.model.getPageCount(true); n += 1) {
                    f2 = Math.max(f2, (float)this.model.getPage(n, true).getHeight());
                }
                for (n = 0; n < this.model.getPageCount(false); n += 1) {
                    f2 = Math.max(f2, (float)this.model.getPage(n, false).getHeight());
                }
            }
            this.nu = ((double)pageHeight - d2) / (double)f2;
            if (this.nu * this.qz + d2 > (double)pageWidth) {
                this.nu = ((double)pageWidth - d2) / this.qz;
            }
        } else {
            this.nu = ((double)pageWidth - d2) / this.qz;
        }
        if (!bl2) {
            int n2;
            this.qI = null;
            int n3 = 0;
            n = this.qH != 3 ? (this.qH == 1 ? 1 : 0) : ((double)this.po < 0.5 ? 1 : 0);
            for (int i = n2 = Math.max(this.getModel().getPageCount(true), this.getModel().getPageCount(false)); i >= 0; --i) {
                ResultPage resultPage = this.model.getPage(i, n != 0);
                if (resultPage == null || resultPage.getHeight() <= 0) continue;
                ++n3;
            }
            this.qB = n3;
            return this.qB;
        }
        this.qI = this.cO();
        this.qB = this.qF ? (int)Math.ceil(this.qy / this.qC) : (int)Math.ceil(this.nu * this.qy / (double)pageHeight);
        return this.qB;
    }

    public int setPageSize(int pageWidth, int pageHeight) {
        if (this.qD) {
            boolean bl = this.qD = pageHeight >= 25;
        }
        if (this.qE) {
            this.qM = this.a(pageWidth - 4, this.qL, this.qJ);
            this.qE = pageHeight >= 25 + this.qM;
        }
        pageHeight -= this.qD ? 25 : 0;
        this.oR = pageHeight -= this.qE ? 25 + this.qM : 0;
        this.oQ = pageWidth;
        return pageHeight;
    }

    private void cP() {
        int n;
        int n2 = this.qH;
        if (this.pp) {
            n2 = 3;
        }
        if (this.model.isEmpty()) {
            return;
        }
        int n3 = this.model.getComparisonParameters().getFirstPageCount() - 1;
        int n4 = this.model.getComparisonParameters().getSecondPageCount() - 1;
        n3 = n3 == -2 ? 0 : n3;
        n4 = n4 == -2 ? 0 : n4;
        int n5 = this.qv.getTotalDrawHeight(ScrollController.Column.first);
        int n6 = this.qv.getTotalDrawHeight(ScrollController.Column.second);
        int n7 = this.qw.getPageGap(n3, true);
        this.qy = n5 + n7 > n6 + (n = this.qw.getPageGap(n4, false)) && n2 == 3 || n2 == 1 ? (double)(n5 + n7 + (this.qF ? -1 : 0)) : (double)(n6 + n + (this.qF ? -1 : 0));
        double d2 = 0.0;
        if ((n2 & 1) > 0) {
            for (int i = 0; i < this.model.getComparisonParameters().getFirstPageCount(); ++i) {
                float f2;
                ResultPage resultPage = this.model.getPage(i, true);
                if (resultPage == null || resultPage.getHeight() <= 0 || !((double)(f2 = (float)resultPage.getWidth()) > d2)) continue;
                d2 = f2;
            }
        }
        double d3 = 0.0;
        if ((n2 & 2) > 0) {
            for (int i = 0; i < this.model.getComparisonParameters().getSecondPageCount(); ++i) {
                float f3;
                ResultPage resultPage = this.model.getPage(i, false);
                if (resultPage == null || resultPage.getHeight() <= 0 || !((double)(f3 = (float)resultPage.getWidth()) > d3)) continue;
                d3 = f3;
            }
        }
        if (this.pp) {
            this.qz = Math.max(d2, d3);
        } else {
            this.qz = d2 + d3;
            if (n2 == 3) {
                this.qz += 30.0;
            }
        }
    }

    public void setScaleToFitPageHeight(boolean flag) {
        if (this.qF != flag) {
            this.qy = -1.0;
        }
        this.qF = flag;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.ns = backgroundColor;
        this.qu.setPageAreaBG(backgroundColor);
    }

    public Color getBackgroundColor() {
        return this.ns;
    }

    public void setPaintSides(byte sides) {
        if (this.qH != sides) {
            this.qH = sides;
        }
        this.qy = -1.0;
    }

    public void setPaintOverlap(boolean paintOverlap) {
        if (this.pp != paintOverlap) {
            this.pp = paintOverlap;
        }
        this.qy = -1.0;
    }

    public boolean isDataChanged() {
        return this.qy < 0.0;
    }

    public boolean isAutoSize() {
        return this.qG;
    }

    public boolean isScaleToFitPageHeight() {
        return this.qF;
    }

    public Painter getPainter() {
        return this.qu;
    }

    public void setOverlapAlpha(float overlapAlpha) {
        if ((double)overlapAlpha > 1.0 || (double)overlapAlpha < 0.0) {
            throw new IllegalArgumentException("OverlapAlpha must be between 0.0 and 1.0 but was " + overlapAlpha);
        }
        this.po = overlapAlpha;
    }

    public boolean isOneSideExport() {
        return this.pp || this.qH != 3;
    }

    public int getHeaderAndFooterSize(int pageWidth) {
        if (this.qE && this.qJ != null && !this.qJ.isBlank()) {
            this.qM = this.a(pageWidth - 4, this.qL, this.qJ);
        }
        return (this.qD ? 25 : 0) + (this.qE ? 25 + this.qM : 0);
    }

    private boolean cQ() {
        return this.pp && (double)this.po >= 0.1 && (double)this.po <= 0.9 || this.qH == 3 || !this.qF;
    }

    @Nonnull
    public ResultModel getModel() {
        return this.model;
    }

    public void setExport(boolean isExport) {
        this.qA = isExport;
    }

    private class b
    implements IViewInfoProvider {
        private Pair<int[]> qs;
        private int[] qS;
        private int[] qT;
        private int qU = 0;
        private int qV = 0;

        private b() {
        }

        @Override
        public double getViewScale() {
            return PrintPainter.this.nu;
        }

        @Override
        public IViewInfoProvider.ViewInfo computeCurrentViewPosition(boolean left) {
            int n;
            int n2 = PrintPainter.this.qH == 3 ? (int)((double)(left ? this.qU : this.qV) * PrintPainter.this.nu) : (n = PrintPainter.this.oQ);
            if (PrintPainter.this.qF) {
                int n3;
                int n4;
                if (PrintPainter.this.qG && PrintPainter.this.qI != null) {
                    ResultPage resultPage;
                    a a2 = PrintPainter.this.qI.get(PrintPainter.this.nd);
                    int n5 = left ? a2.qP : a2.qQ;
                    ResultPage resultPage2 = resultPage = left ? a2.qN : a2.qO;
                    if (resultPage == null && left) {
                        resultPage = a2.qO;
                    }
                    if (resultPage != null) {
                        n = (int)Math.round((double)resultPage.getWidth() * PrintPainter.this.nu);
                    }
                    return new IViewInfoProvider.ViewInfo(0, (int)((double)n5 * PrintPainter.this.nu), n, (int)Math.round((double)a2.qR * PrintPainter.this.nu), 0);
                }
                if (PrintPainter.this.qG) {
                    n4 = left ? this.qS[PrintPainter.this.nd * 2] : this.qT[PrintPainter.this.nd * 2];
                    n3 = left ? this.qS[PrintPainter.this.nd * 2 + 1] : this.qT[PrintPainter.this.nd * 2 + 1];
                } else {
                    n4 = (int)Math.round(PrintPainter.this.qC * (double)PrintPainter.this.nd);
                    n3 = (int)Math.round(PrintPainter.this.qC * (double)(1 + PrintPainter.this.nd));
                }
                int n6 = this.d(n4, left);
                int n7 = (int)Math.round((double)(n4 - n6) * PrintPainter.this.nu);
                return new IViewInfoProvider.ViewInfo(0, (int)Math.round((double)n4 * PrintPainter.this.nu), n, (int)Math.round((double)(n3 - n4) * PrintPainter.this.nu), n7);
            }
            return new IViewInfoProvider.ViewInfo(0, PrintPainter.this.oR * PrintPainter.this.nd, n, PrintPainter.this.oR, 0);
        }

        @Override
        public Rectangle computeCurrentDocumentPosition(boolean left) {
            IViewInfoProvider.ViewInfo viewInfo = this.computeCurrentViewPosition(left);
            viewInfo.y = (int)((double)viewInfo.y / PrintPainter.this.nu);
            viewInfo.height = (int)((double)viewInfo.height / PrintPainter.this.nu);
            int n = this.c(viewInfo.y, left);
            int n2 = this.c(viewInfo.y + viewInfo.height, left);
            return new Rectangle(0, n, 0, n2 - n);
        }

        private int c(int n, boolean bl) {
            int[] nArray = bl ? this.qS : this.qT;
            int n2 = Arrays.binarySearch(nArray, n);
            int n3 = 0;
            boolean bl2 = false;
            if (n2 < 0) {
                if ((n2 = -(n2 + 1)) % 2 == 1) {
                    n3 = n - nArray[n2 - 1];
                } else {
                    if (n2 >= nArray.length) {
                        bl2 = true;
                    }
                    ++n2;
                }
            } else if (n2 % 2 == 1) {
                bl2 = true;
            }
            int n4 = Math.min(n2 / 2, PrintPainter.this.model.getPageCount(bl) - 1);
            ResultPage resultPage = PrintPainter.this.model.getPage(n4, bl);
            int n5 = resultPage.getPageOffset() + (bl2 ? resultPage.getHeight() : 0) + n3;
            return n5;
        }

        private int d(int n, boolean bl) {
            ResultPage resultPage;
            boolean bl2;
            int n2;
            if (PrintPainter.this.qH != 3 && !PrintPainter.this.pp) {
                return n;
            }
            int[] nArray = bl ? this.qS : this.qT;
            int n3 = n2 = Arrays.binarySearch(nArray, n);
            if (n2 <= 0) {
                if (n2 >= -1) {
                    return 0;
                }
                n3 = -(n2 + 1);
            }
            int n4 = Math.min(n3 / 2, this.qs.get(bl).length - 1);
            boolean bl3 = bl2 = n3 % 2 == 0 && n2 < 0;
            if (bl2 && !PrintPainter.this.qF && (resultPage = PrintPainter.this.model.getPage(n4 = Math.min(n4 - 1, nArray.length / 2 - 1), bl)) != null) {
                return resultPage.getPageOffset() + resultPage.getHeight() + this.qs.get(bl)[n4 + 1];
            }
            return n;
        }

        @Override
        public int getPageGap(int pageIndex, boolean left) {
            int[] nArray = this.qs.get(left);
            return pageIndex < nArray.length ? nArray[pageIndex] : 0;
        }

        private void cR() {
            ResultPage resultPage;
            int n;
            int n2;
            int n3;
            int n4;
            Pair<int[]> pair;
            ResultPage resultPage2;
            int n5;
            int n6 = Math.max(PrintPainter.this.model.getPageCount(true), PrintPainter.this.model.getPageCount(false));
            this.qs = new Pair<int[]>(new int[n6], new int[n6]);
            PrintPainter.this.qC = -1.0;
            this.qU = 0;
            this.qV = 0;
            for (n5 = 0; n5 < PrintPainter.this.model.getPageCount(true); ++n5) {
                resultPage2 = PrintPainter.this.model.getPage(n5, true);
                PrintPainter.this.qC = Math.max(PrintPainter.this.qC, (double)resultPage2.getHeight());
                if (!CollapsePagesModelData.isRealPage(resultPage2)) continue;
                this.qU = Math.max(this.qU, resultPage2.getWidth());
            }
            for (n5 = 0; n5 < PrintPainter.this.model.getPageCount(false); ++n5) {
                resultPage2 = PrintPainter.this.model.getPage(n5, false);
                PrintPainter.this.qC = Math.max(PrintPainter.this.qC, (double)resultPage2.getHeight());
                if (!CollapsePagesModelData.isRealPage(resultPage2)) continue;
                this.qV = Math.max(this.qV, resultPage2.getWidth());
            }
            n5 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            if (PrintPainter.this.qH == 3) {
                pair = new com.inet.pdfc.print.a(PrintPainter.this.model).cK();
                n4 = 0;
                n3 = 0;
                while (n5 < PrintPainter.this.model.getPageCount(true) && n7 < PrintPainter.this.model.getPageCount(false)) {
                    int n10;
                    n2 = pair.get(true)[n5];
                    int n11 = pair.get(false)[n7];
                    boolean bl = false;
                    n = 0;
                    ResultPage resultPage3 = PrintPainter.this.model.getPage(n5, true);
                    resultPage = PrintPainter.this.model.getPage(n7, false);
                    int n12 = CollapsePagesModelData.isRealPage(resultPage3) && resultPage3.getHeight() > 0 ? resultPage3.getHeight() : 0;
                    int n13 = n10 = CollapsePagesModelData.isRealPage(resultPage) && resultPage.getHeight() > 0 ? resultPage.getHeight() : 0;
                    if (n4 < n3 + n11 && n3 < n4 + n2) {
                        if (n2 > 0 && n2 >= n11) {
                            n2 -= n11;
                            n11 = 0;
                            n = 1;
                        } else if (n11 > 0 && n11 >= n2) {
                            n11 -= n2;
                            n2 = 0;
                            bl = true;
                        } else {
                            bl = true;
                            n = 1;
                        }
                    } else if (n4 == n3) {
                        bl = true;
                        n = 1;
                    } else if (n4 < n3) {
                        bl = true;
                    } else {
                        n = 1;
                    }
                    pair.get((boolean)true)[n5] = n2;
                    pair.get((boolean)false)[n7] = n11;
                    if (bl) {
                        n4 += n12 + n2;
                        ++n5;
                    }
                    if (n == 0) continue;
                    n3 += n10 + n11;
                    ++n7;
                }
                if (PrintPainter.this.qF) {
                    this.qS = new int[n6 * 2];
                    this.qT = new int[n6 * 2];
                    for (n2 = 0; n2 < n6; ++n2) {
                        ResultPage resultPage4 = PrintPainter.this.model.getPage(n2, true);
                        ResultPage resultPage5 = PrintPainter.this.model.getPage(n2, false);
                        if (resultPage4 != null) {
                            this.qS[n2 * 2] = n8 += pair.get(true)[n2];
                            this.qS[n2 * 2 + 1] = n8 += Math.max(0, resultPage4.getHeight());
                        }
                        if (resultPage5 == null) continue;
                        this.qT[n2 * 2] = n9 += pair.get(false)[n2];
                        this.qT[n2 * 2 + 1] = n9 += Math.max(0, resultPage5.getHeight());
                    }
                    n5 = 0;
                    n7 = 0;
                    pair = new Pair<int[]>(new int[n6], new int[n6]);
                    n2 = Math.min(PrintPainter.this.model.getPageCount(true), PrintPainter.this.model.getPageCount(false));
                    while (n5 < n2 && n7 < n2) {
                        int n14 = this.qS[n5 * 2];
                        int n15 = this.qS[n5 * 2 + 1];
                        n = this.qT[n7 * 2];
                        int n16 = this.qT[n7 * 2 + 1];
                        resultPage = PrintPainter.this.model.getPage(n5, true);
                        ResultPage resultPage6 = PrintPainter.this.model.getPage(n7, false);
                        float f2 = 1.75f;
                        if (n >= n14 && (float)(n16 - n14) <= f2 * (float)(n15 - n14) || n14 >= n && (float)(n15 - n) <= f2 * (float)(n16 - n) || this.a(resultPage) && this.a(resultPage6)) {
                            if (this.a(resultPage) && this.a(PrintPainter.this.model.getPage(n7 + 1, false))) {
                                int[] nArray = pair.get(true);
                                int n17 = n5;
                                nArray[n17] = (int)((double)nArray[n17] + PrintPainter.this.qC);
                                while ((resultPage6 = PrintPainter.this.model.getPage(++n7, false)) != null && resultPage6.getHeight() == 0) {
                                }
                                continue;
                            }
                            if (this.a(resultPage6) && this.a(PrintPainter.this.model.getPage(n5 + 1, true))) {
                                int[] nArray = pair.get(false);
                                int n18 = n7;
                                nArray[n18] = (int)((double)nArray[n18] + PrintPainter.this.qC);
                                while ((resultPage = PrintPainter.this.model.getPage(++n5, true)) != null && resultPage.getHeight() == 0) {
                                }
                                continue;
                            }
                            while ((resultPage = PrintPainter.this.model.getPage(++n5, true)) != null && resultPage.getHeight() == 0) {
                            }
                            while ((resultPage6 = PrintPainter.this.model.getPage(++n7, false)) != null && resultPage6.getHeight() == 0) {
                            }
                            continue;
                        }
                        if (n > n14) {
                            int[] nArray = pair.get(false);
                            int n19 = n7;
                            nArray[n19] = (int)((double)nArray[n19] + PrintPainter.this.qC);
                            while ((resultPage = PrintPainter.this.model.getPage(++n5, true)) != null && resultPage.getHeight() == 0) {
                            }
                            continue;
                        }
                        int[] nArray = pair.get(true);
                        int n20 = n5;
                        nArray[n20] = (int)((double)nArray[n20] + PrintPainter.this.qC);
                        while ((resultPage6 = PrintPainter.this.model.getPage(++n7, false)) != null && resultPage6.getHeight() == 0) {
                        }
                    }
                }
            } else {
                int[] nArray = new int[n6 * 2];
                int[] nArray2 = new int[n6 * 2];
                pair = new Pair<int[]>(nArray, nArray2);
            }
            n4 = 0;
            n3 = 0;
            n8 = 0;
            n9 = 0;
            this.qS = new int[n6 * 2];
            this.qT = new int[n6 * 2];
            for (n2 = 0; n2 < n6; ++n2) {
                ResultPage resultPage7;
                int n21 = pair.get(true)[n2];
                int n22 = pair.get(false)[n2];
                n = 0;
                int n23 = 0;
                if (PrintPainter.this.qF && (!PrintPainter.this.qG || PrintPainter.this.qH == 3)) {
                    int n24;
                    resultPage = PrintPainter.this.model.getPage(n2, true);
                    resultPage7 = PrintPainter.this.model.getPage(n2, false);
                    int n25 = resultPage != null ? resultPage.getHeight() : 0;
                    int n26 = n24 = resultPage7 != null ? resultPage7.getHeight() : 0;
                    if (n25 > 0) {
                        n = (int)Math.ceil(PrintPainter.this.qC - (double)n25);
                        if (pair.get(true).length > n2 + 1) {
                            int[] nArray = pair.get(true);
                            int n27 = n2 + 1;
                            nArray[n27] = nArray[n27] + n;
                        }
                    }
                    if (n24 > 0) {
                        n23 = (int)Math.ceil(PrintPainter.this.qC - (double)n24);
                        if (pair.get(false).length > n2 + 1) {
                            int[] nArray = pair.get(false);
                            int n28 = n2 + 1;
                            nArray[n28] = nArray[n28] + n23;
                        }
                    }
                }
                this.qs.get((boolean)true)[n2] = (n4 += n21) + (PrintPainter.this.cQ() ? 1 : 0);
                this.qs.get((boolean)false)[n2] = (n3 += n22) + (PrintPainter.this.cQ() ? 1 : 0);
                resultPage = PrintPainter.this.model.getPage(n2, true);
                this.qS[n2 * 2] = (n8 += n21) + n;
                this.qS[n2 * 2 + 1] = (n8 += Math.max(0, resultPage != null ? resultPage.getHeight() : 0)) + n;
                resultPage7 = PrintPainter.this.model.getPage(n2, false);
                this.qT[n2 * 2] = (n9 += n22) + n23;
                this.qT[n2 * 2 + 1] = (n9 += Math.max(0, resultPage7 != null ? resultPage7.getHeight() : 0)) + n23;
            }
        }

        protected boolean a(ResultPage resultPage) {
            return resultPage != null && !CollapsePagesModelData.isRealPage(resultPage) && resultPage.getHeight() > 0;
        }

        @Override
        public Rectangle updateMarkerRect(Rectangle markerRect, boolean left) {
            if (markerRect == null) {
                return null;
            }
            markerRect = markerRect.getBounds();
            int n = markerRect.y;
            int n2 = markerRect.y + markerRect.height;
            int n3 = PrintPainter.this.model.getPageAt(new Point(1, n), left).getPageIndex();
            int n4 = markerRect.height > 0 ? PrintPainter.this.model.getPageAt(new Point(1, n2), left).getPageIndex() : n3;
            int n5 = this.getPageGap(n3, left);
            int n6 = n4 != n3 ? this.getPageGap(n4, left) : n5;
            markerRect.y += n5;
            markerRect.height += n6 - n5;
            if (PrintPainter.this.nu != 1.0) {
                markerRect.x = (int)Math.round((double)markerRect.x * PrintPainter.this.nu);
                markerRect.y = (int)Math.round((double)markerRect.y * PrintPainter.this.nu);
                markerRect.width = (int)Math.round((double)markerRect.width * PrintPainter.this.nu);
                markerRect.height = (int)Math.round((double)markerRect.height * PrintPainter.this.nu);
            }
            return markerRect;
        }

        @Override
        public int getCenterOffset(int pageIndex, boolean left, boolean vertical) {
            if (vertical || pageIndex < 0) {
                return 0;
            }
            if (PrintPainter.this.qH != 3 && !PrintPainter.this.pp) {
                return 0;
            }
            if (PrintPainter.this.qF && PrintPainter.this.qG) {
                return left ? 0 : 15;
            }
            ResultPage resultPage = PrintPainter.this.model.getPage(pageIndex, left);
            double d2 = resultPage.getWidth();
            double d3 = left ? ((double)this.qU - d2) * PrintPainter.this.nu / 2.0 : ((double)this.qV - d2 + 30.0) * PrintPainter.this.nu / 2.0;
            return Math.max(0, (int)d3);
        }
    }

    public static class a {
        private ResultPage qN;
        private ResultPage qO;
        private int qP;
        private int qQ;
        private int qR;

        public a(ResultPage resultPage, ResultPage resultPage2, int n, int n2, int n3) {
            this.qN = resultPage;
            this.qO = resultPage2;
            this.qP = n;
            this.qQ = n2;
            this.qR = n3;
        }

        public String toString() {
            return (String)(this.qN != null ? "Page " + this.qN.getPageIndex() : "<none>") + " : " + (String)(this.qO != null ? "Page " + this.qO.getPageIndex() : "<none>") + " @ " + this.qP + " : " + this.qQ;
        }
    }
}

