/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.print;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.PDFCCore;
import com.inet.shared.utils.BlendComposite;
import com.inet.shared.utils.LayerGraphics2D;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.LinkedList;
import java.util.Map;

@InternalApi
public class MasterAlphaGraphics
extends LayerGraphics2D {
    private Graphics2D qn;
    private float qo = 1.0f;
    private LinkedList<AffineTransform> qp = new LinkedList();

    public MasterAlphaGraphics(Graphics2D destination) {
        this.qn = destination;
    }

    public MasterAlphaGraphics create() {
        return new a((Graphics2D)this.getDestination().create());
    }

    public MasterAlphaGraphics create(int x, int y, int width, int height) {
        return new a((Graphics2D)this.getDestination().create(x, y, width, height));
    }

    public int hashCode() {
        return this.getDestination().hashCode();
    }

    public boolean equals(Object obj) {
        return this.getDestination().equals(obj);
    }

    public void setInitialInformation(Rectangle2D imgBound, AffineTransform initialTransformation) throws UnsupportedOperationException {
        if (this.getDestination() instanceof LayerGraphics2D) {
            ((LayerGraphics2D)this.getDestination()).setInitialInformation(imgBound, initialTransformation);
        } else {
            PDFCCore.LOGGER_CORE.error((Object)"InitialInformation not implemented");
        }
    }

    public void addLayer(boolean knockout, boolean isolate, BlendComposite composite) throws UnsupportedOperationException {
        Graphics2D graphics2D = this.getDestination();
        if (graphics2D instanceof LayerGraphics2D) {
            this.qp.add(graphics2D.getTransform());
            ((LayerGraphics2D)graphics2D).addLayer(knockout, isolate, composite);
        } else {
            PDFCCore.LOGGER_CORE.error((Object)"Add Layer not implemented");
        }
    }

    public void paintLastLayer() throws IllegalStateException, UnsupportedOperationException {
        Graphics2D graphics2D = this.getDestination();
        if (graphics2D instanceof LayerGraphics2D) {
            ((LayerGraphics2D)graphics2D).paintLastLayer();
            this.qp.removeLast();
        } else {
            PDFCCore.LOGGER_CORE.error((Object)"Paint Layer not implemented");
        }
    }

    public Color getColor() {
        return this.getDestination().getColor();
    }

    public void setColor(Color c2) {
        this.getDestination().setColor(c2);
    }

    public void setPaintMode() {
        this.getDestination().setPaintMode();
    }

    public void setXORMode(Color c1) {
        this.getDestination().setXORMode(c1);
    }

    public Font getFont() {
        return this.getDestination().getFont();
    }

    public void setFont(Font font) {
        this.getDestination().setFont(font);
    }

    public FontMetrics getFontMetrics() {
        return this.getDestination().getFontMetrics();
    }

    public FontMetrics getFontMetrics(Font f2) {
        return this.getDestination().getFontMetrics(f2);
    }

    public Rectangle getClipBounds() {
        return this.getDestination().getClipBounds();
    }

    public void clipRect(int x, int y, int width, int height) {
        this.getDestination().clipRect(x, y, width, height);
    }

    public void setClip(int x, int y, int width, int height) {
        this.getDestination().setClip(x, y, width, height);
    }

    public Shape getClip() {
        return this.getDestination().getClip();
    }

    public void setClip(Shape clip) {
        this.getDestination().setClip(clip);
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.getDestination().copyArea(x, y, width, height, dx, dy);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.getDestination().drawLine(x1, y1, x2, y2);
    }

    public void fillRect(int x, int y, int width, int height) {
        this.getDestination().fillRect(x, y, width, height);
    }

    public void drawRect(int x, int y, int width, int height) {
        this.getDestination().drawRect(x, y, width, height);
    }

    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        this.getDestination().draw3DRect(x, y, width, height, raised);
    }

    public void clearRect(int x, int y, int width, int height) {
        this.getDestination().clearRect(x, y, width, height);
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.getDestination().drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        this.getDestination().fill3DRect(x, y, width, height, raised);
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.getDestination().fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    public void draw(Shape s) {
        this.getDestination().draw(s);
    }

    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return this.getDestination().drawImage(img, xform, obs);
    }

    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        this.getDestination().drawImage(img, op, x, y);
    }

    public void drawOval(int x, int y, int width, int height) {
        this.getDestination().drawOval(x, y, width, height);
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        this.getDestination().drawRenderedImage(img, xform);
    }

    public void fillOval(int x, int y, int width, int height) {
        this.getDestination().fillOval(x, y, width, height);
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.getDestination().drawArc(x, y, width, height, startAngle, arcAngle);
    }

    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.getDestination().drawRenderableImage(img, xform);
    }

    public void drawString(String str, int x, int y) {
        this.getDestination().drawString(str, x, y);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.getDestination().fillArc(x, y, width, height, startAngle, arcAngle);
    }

    public void drawString(String str, float x, float y) {
        this.getDestination().drawString(str, x, y);
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.getDestination().drawPolyline(xPoints, yPoints, nPoints);
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.getDestination().drawString(iterator, x, y);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.getDestination().drawPolygon(xPoints, yPoints, nPoints);
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.getDestination().drawString(iterator, x, y);
    }

    public void drawPolygon(Polygon p) {
        this.getDestination().drawPolygon(p);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.getDestination().fillPolygon(xPoints, yPoints, nPoints);
    }

    public void drawGlyphVector(GlyphVector g2, float x, float y) {
        this.getDestination().drawGlyphVector(g2, x, y);
    }

    public void fillPolygon(Polygon p) {
        this.getDestination().fillPolygon(p);
    }

    public void fill(Shape s) {
        try {
            this.getDestination().fill(s);
        }
        catch (Exception exception) {
            PDFCCore.LOGGER_PRESENTER.error((Object)("Exception filling shape " + String.valueOf(s) + " " + exception.getMessage()));
        }
    }

    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return this.getDestination().hit(rect, s, onStroke);
    }

    public void drawChars(char[] data, int offset, int length, int x, int y) {
        this.getDestination().drawChars(data, offset, length, x, y);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.getDestination().getDeviceConfiguration();
    }

    public void setComposite(Composite comp) {
        if (comp instanceof AlphaComposite && this.getMasterAlpha() != 1.0f) {
            comp = AlphaComposite.getInstance(((AlphaComposite)comp).getRule(), ((AlphaComposite)comp).getAlpha() * this.getMasterAlpha());
        }
        this.getDestination().setComposite(comp);
    }

    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        this.getDestination().drawBytes(data, offset, length, x, y);
    }

    public void setPaint(Paint paint) {
        this.getDestination().setPaint(paint);
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.getDestination().drawImage(img, x, y, observer);
    }

    public void setStroke(Stroke s) {
        this.getDestination().setStroke(s);
    }

    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.getDestination().setRenderingHint(hintKey, hintValue);
    }

    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.getDestination().getRenderingHint(hintKey);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.getDestination().drawImage(img, x, y, width, height, observer);
    }

    public void setRenderingHints(Map<?, ?> hints) {
        this.getDestination().setRenderingHints(hints);
    }

    public void addRenderingHints(Map<?, ?> hints) {
        this.getDestination().addRenderingHints(hints);
    }

    public RenderingHints getRenderingHints() {
        return this.getDestination().getRenderingHints();
    }

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.getDestination().drawImage(img, x, y, bgcolor, observer);
    }

    public void translate(int x, int y) {
        this.getDestination().translate(x, y);
    }

    public void translate(double tx, double ty) {
        this.getDestination().translate(tx, ty);
    }

    public void rotate(double theta) {
        this.getDestination().rotate(theta);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.getDestination().drawImage(img, x, y, width, height, bgcolor, observer);
    }

    public void rotate(double theta, double x, double y) {
        this.getDestination().rotate(theta, x, y);
    }

    public void scale(double sx, double sy) {
        this.getDestination().scale(sx, sy);
    }

    public void shear(double shx, double shy) {
        this.getDestination().shear(shx, shy);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.getDestination().drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    public void transform(AffineTransform Tx) {
        this.getDestination().transform(Tx);
    }

    public AffineTransform getTransform() {
        return this.getDestination().getTransform();
    }

    public void setTransform(AffineTransform Tx) {
        if (this.qp.isEmpty() || this.getDestination() instanceof MasterAlphaGraphics) {
            this.getDestination().setTransform(Tx);
        } else {
            AffineTransform affineTransform = this.qp.peekLast();
            try {
                affineTransform = affineTransform.createInverse();
                affineTransform.concatenate(Tx);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                PDFCCore.LOGGER_CORE.error((Throwable)noninvertibleTransformException);
            }
            this.getDestination().setTransform(affineTransform);
        }
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return this.getDestination().drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    public Paint getPaint() {
        return this.getDestination().getPaint();
    }

    public Composite getComposite() {
        return this.getDestination().getComposite();
    }

    public void setBackground(Color color) {
        this.getDestination().setBackground(color);
    }

    public Color getBackground() {
        return this.getDestination().getBackground();
    }

    public Stroke getStroke() {
        return this.getDestination().getStroke();
    }

    public void clip(Shape s) {
        this.getDestination().clip(s);
    }

    public FontRenderContext getFontRenderContext() {
        return this.getDestination().getFontRenderContext();
    }

    public void dispose() {
        this.getDestination().dispose();
    }

    public Rectangle getClipRect() {
        return this.getDestination().getClipRect();
    }

    public boolean hitClip(int x, int y, int width, int height) {
        return this.getDestination().hitClip(x, y, width, height);
    }

    public Rectangle getClipBounds(Rectangle r) {
        return this.getDestination().getClipBounds(r);
    }

    public float getMasterAlpha() {
        return this.qo;
    }

    public void setMasterAlpha(float masterAlpha) {
        this.qo = masterAlpha;
    }

    public Graphics2D getDestination() {
        return this.qn;
    }

    private class a
    extends MasterAlphaGraphics {
        public a(Graphics2D graphics2D) {
            super(graphics2D);
        }

        @Override
        public float getMasterAlpha() {
            return MasterAlphaGraphics.this.getMasterAlpha();
        }

        @Override
        public void setMasterAlpha(float masterAlpha) {
            throw new IllegalStateException("The master alpha can only be set in the root-graphics!");
        }
    }
}

