/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.plugin.interfaces;

import com.inet.annotations.InternalApi;
import com.inet.error.ErrorCode;
import com.inet.pdfc.error.PdfcErrorCode;
import com.inet.pdfc.error.PdfcException;
import com.inet.pdfc.model.Document;
import com.inet.persistence.RandomAccessRead;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Set;

@InternalApi
public interface DocumentFactory {
    public String getDocumentTypeName(Locale var1);

    public Set<String> getSupportedFileExtensions();

    default public boolean canRead(String userFileName, byte[] content) {
        return this.canRead(userFileName, RandomAccessRead.wrap((byte[])content));
    }

    default public boolean canRead(String userFileName, File file) {
        boolean bl;
        block8: {
            RandomAccessRead randomAccessRead = RandomAccessRead.wrap((File)file);
            try {
                bl = this.canRead(userFileName, randomAccessRead);
                if (randomAccessRead == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (randomAccessRead != null) {
                        try {
                            randomAccessRead.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | IllegalStateException exception) {
                    return false;
                }
            }
            randomAccessRead.close();
        }
        return bl;
    }

    public boolean canRead(String var1, RandomAccessRead var2);

    default public Document readDocument(byte[] data, String userFileName, String password) throws PasswordException, PdfcException {
        return this.readDocumentReduced(data, userFileName, password, (FEATURE[])null);
    }

    default public Document readDocument(String userFileName, File file, String password) throws PasswordException, PdfcException {
        return this.readDocumentReduced(userFileName, file, password, (FEATURE[])null);
    }

    default public Document readDocumentReduced(byte[] data, String userFileName, String password, FEATURE ... requiredFeatures) throws PasswordException, PdfcException {
        return this.readDocumentReduced(userFileName, RandomAccessRead.wrap((byte[])data), password, requiredFeatures);
    }

    default public Document readDocumentReduced(String userFileName, File file, String password, FEATURE ... requiredFeatures) throws PasswordException, PdfcException {
        try {
            return this.readDocumentReduced(userFileName, RandomAccessRead.wrap((File)file), password, requiredFeatures);
        }
        catch (IllegalStateException illegalStateException) {
            throw PdfcException.create(illegalStateException.getCause());
        }
    }

    public Document readDocumentReduced(String var1, RandomAccessRead var2, String var3, FEATURE ... var4) throws PasswordException, PdfcException;

    @InternalApi
    public static final class FEATURE
    extends Enum<FEATURE> {
        public static final /* enum */ FEATURE text = new FEATURE();
        public static final /* enum */ FEATURE textNoCharMapping = new FEATURE();
        public static final /* enum */ FEATURE images = new FEATURE();
        public static final /* enum */ FEATURE shapes = new FEATURE();
        public static final /* enum */ FEATURE structure = new FEATURE();
        public static final /* enum */ FEATURE meta = new FEATURE();
        public static final /* enum */ FEATURE page = new FEATURE();
        private static final /* synthetic */ FEATURE[] ml;

        public static FEATURE[] values() {
            return (FEATURE[])ml.clone();
        }

        public static FEATURE valueOf(String name) {
            return Enum.valueOf(FEATURE.class, name);
        }

        private static /* synthetic */ FEATURE[] bI() {
            return new FEATURE[]{text, textNoCharMapping, images, shapes, structure, meta, page};
        }

        static {
            ml = FEATURE.bI();
        }
    }

    @InternalApi
    public static final class PasswordException
    extends PdfcException {
        private String mm;
        private boolean mn;

        public PasswordException(Throwable cause, String filename, boolean wasUsingPassword) {
            super((ErrorCode)(wasUsingPassword ? PdfcErrorCode.incorrectPassword : PdfcErrorCode.requiresPassword), cause, filename != null ? filename + " " : "");
            this.mm = filename;
            this.mn = wasUsingPassword;
        }

        public String getFilename() {
            return this.mm;
        }

        public boolean wasUsingPassword() {
            return this.mn;
        }
    }
}

