/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.model;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.graphics.BasicStrokeStyle;
import com.inet.pdfc.model.DrawableElementXY;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.Visitable;
import com.inet.pdfc.model.Visitor;
import com.inet.pdfc.model.i18n.a;
import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@JsonData
@InternalApi
public class ShapeElement
extends DrawableElementXY
implements Visitable {
    public static final int SEGMENT_LIMIT = 500;
    static final long serialVersionUID = -4288921972079575311L;
    private boolean isClip;
    private double xOffset = Double.NaN;
    private double yOffset = Double.NaN;
    private Shape shape;
    private BasicStroke stroke;
    private Paint strokePaint;
    private Paint fillPaint;
    private transient float lineWidth;
    private transient List<Shape> segments;
    private static final double ALMOST_ZERO = 1.0E-5;
    private static final Comparator<Shape> SHAPE_SORTER = (a2, b2) -> Double.compare(ShapeElement.getShapeDiameter(b2), ShapeElement.getShapeDiameter(a2));

    public ShapeElement(boolean isClip, int pageIndex, Point2D offset, Shape shape, BasicStroke stroke, Paint strokePaint, Paint fillPaint, ElementID id) {
        super(pageIndex, id);
        this.isClip = isClip;
        this.shape = shape;
        this.stroke = stroke;
        this.strokePaint = strokePaint;
        this.fillPaint = fillPaint;
        if (offset != null) {
            this.setX(offset.getX());
            this.setY(offset.getY());
        }
        if (stroke != null) {
            this.lineWidth = this.stroke.getLineWidth();
        }
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
        if (shape != null) {
            Rectangle2D rectangle2D = shape.getBounds2D();
            super.setX(rectangle2D.getX());
            super.setY(rectangle2D.getY());
            this.segments = null;
        }
    }

    public BasicStroke getStroke() {
        return this.stroke;
    }

    public void setStroke(BasicStroke bs) {
        this.stroke = bs;
        if (this.stroke != null) {
            this.lineWidth = this.stroke.getLineWidth();
        }
    }

    public boolean getIsClip() {
        return this.isClip;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public int getLineStyle() {
        return BasicStrokeStyle.getLineStyleFromStroke((BasicStroke)this.stroke);
    }

    public int createShapeSegments() {
        if (this.getShape() == null) {
            return 0;
        }
        this.segments = new ArrayList<Shape>();
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        double d2 = Double.isNaN(this.xOffset) ? 0.0 : this.xOffset;
        double d3 = Double.isNaN(this.yOffset) ? 0.0 : this.yOffset;
        PathIterator pathIterator = this.getShape().getPathIterator(AffineTransform.getTranslateInstance(d2, d3));
        while (!pathIterator.isDone()) {
            float[] fArray = new float[6];
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    f2 = fArray[0];
                    f3 = fArray[1];
                    f4 = f2;
                    f5 = f3;
                    break;
                }
                case 1: {
                    if (f2 == fArray[0] && f3 == fArray[1]) break;
                    this.segments.add(new Line2D.Float(f2, f3, fArray[0], fArray[1]));
                    f2 = fArray[0];
                    f3 = fArray[1];
                    break;
                }
                case 3: {
                    this.segments.add(new CubicCurve2D.Float(f2, f3, fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]));
                    f2 = fArray[4];
                    f3 = fArray[5];
                    break;
                }
                case 2: {
                    this.segments.add(new QuadCurve2D.Float(f2, f3, fArray[0], fArray[1], fArray[2], fArray[3]));
                    f2 = fArray[2];
                    f3 = fArray[3];
                    break;
                }
                case 4: {
                    if (f2 != f4 || f3 != f5) {
                        this.segments.add(new Line2D.Float(f2, f3, f4, f5));
                    }
                    f2 = f4;
                    f3 = f5;
                }
            }
            pathIterator.next();
        }
        if (this.segments.size() > 500) {
            Collections.sort(this.segments, SHAPE_SORTER);
            this.segments = new ArrayList<Shape>(this.segments.subList(0, 500));
        }
        return this.segments.size();
    }

    private static double getShapeDiameter(Shape a2) {
        Rectangle2D rectangle2D = a2.getBounds2D();
        double d2 = rectangle2D.getWidth() * rectangle2D.getWidth() + rectangle2D.getHeight() * rectangle2D.getHeight();
        return d2;
    }

    public List<Shape> getShapeSegments() {
        if (this.segments == null && this.shape != null) {
            this.createShapeSegments();
        }
        return this.segments;
    }

    @Override
    public void setX(double x) {
        this.xOffset = !Double.isNaN(this.xOffset) ? (this.xOffset += x - this.getX()) : 0.0;
        this.segments = null;
        super.setX(x);
    }

    @Override
    public void setY(double y) {
        this.yOffset = !Double.isNaN(this.yOffset) ? (this.yOffset += y - this.getY()) : 0.0;
        this.segments = null;
        super.setY(y);
    }

    public boolean isEmpty() {
        return this.shape == null;
    }

    void setSegments(List<Shape> segments) {
        this.segments = segments;
    }

    @Override
    public Rectangle2D getBounds() {
        if (this.shape == null) {
            if (this.segments == null || this.segments.size() == 0) {
                return null;
            }
            this.shape = new Polygon();
            Path2D.Double double_ = new Path2D.Double();
            for (Shape shape : this.segments) {
                double_.append(shape, true);
            }
            this.shape = double_;
        }
        double d2 = Double.isNaN(this.xOffset) ? 0.0 : this.xOffset;
        double d3 = Double.isNaN(this.yOffset) ? 0.0 : this.yOffset;
        Rectangle2D rectangle2D = this.shape.getBounds2D();
        rectangle2D.setRect(rectangle2D.getX() + d2, rectangle2D.getY() + d3, rectangle2D.getWidth(), rectangle2D.getHeight());
        return rectangle2D;
    }

    @Override
    public int getCompareHash() {
        return 4;
    }

    @Override
    public ElementType getType() {
        return ElementType.Shape;
    }

    public void setStrokePaint(Paint paint) {
        this.strokePaint = paint;
    }

    public void setFillPaint(Paint paint) {
        this.fillPaint = paint;
    }

    @Override
    public Paint getStrokePaint() {
        return this.strokePaint;
    }

    @Override
    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public String toString() {
        String string;
        DecimalFormat decimalFormat = new DecimalFormat("0.###");
        Rectangle2D rectangle2D = this.getBounds();
        Rectangle rectangle = rectangle2D != null ? rectangle2D.getBounds() : null;
        String string2 = string = rectangle != null ? "(" + decimalFormat.format(rectangle2D.getMinX()) + ":" + decimalFormat.format(rectangle2D.getMinY()) + " -> " + decimalFormat.format(rectangle2D.getMaxX()) + ":" + decimalFormat.format(rectangle2D.getMaxY()) + ")" : "";
        if (this.isClip) {
            return this.getElementID().toString() + ": Clip-Shape " + string;
        }
        return this.getElementID().toString() + ": " + string;
    }

    @Override
    public String getLabel() {
        Rectangle2D rectangle2D = this.getBounds();
        String string = rectangle2D != null ? Long.toString(Math.round(rectangle2D.getWidth())) : "null";
        String string2 = rectangle2D != null ? Long.toString(Math.round(rectangle2D.getHeight())) : "null";
        return a.getMsg("ElementType." + String.valueOf(this.getType()), string, string2);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

