/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.model.diff;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.pdfc.i18n.Msg;
import java.io.Serializable;

@JsonData
@PublicApi
public abstract class AttributeDifference<T>
implements Serializable,
Comparable<AttributeDifference<?>> {
    private transient T oldValue;
    private transient T newValue;
    private TYPE instanceType;
    private String messageKey;
    private String oldValueDescriptor;
    private String newValueDescriptor;

    private AttributeDifference() {
    }

    private AttributeDifference(T oldValue, T newValue) {
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.oldValueDescriptor = this.formatValue(oldValue);
        this.newValueDescriptor = this.formatValue(newValue);
    }

    public AttributeDifference(TYPE instanceType, T oldValue, T newValue, String messageKey) {
        this(oldValue, newValue);
        this.instanceType = instanceType;
        this.messageKey = messageKey;
    }

    String formatValue(T value) {
        return String.valueOf(value);
    }

    String getMessageKey() {
        return this.messageKey;
    }

    public String getMessage() {
        if (this.getOldValue() == null && this.getNewValue() == null) {
            return Msg.getMsg(this.getMessageKey(), this.getOldValueDescriptor(), this.getNewValueDescriptor());
        }
        return Msg.getMsg(this.getMessageKey(), this.getOldValue(), this.getNewValue());
    }

    public boolean equals(Object obj) {
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeDifference attributeDifference = (AttributeDifference)obj;
        return this.isEqual(attributeDifference.getOldValue(), this.getOldValue()) && this.isEqual(attributeDifference.getNewValue(), this.getNewValue());
    }

    private boolean isEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    @Override
    public int compareTo(AttributeDifference<?> o) {
        if (this.getClass() != o.getClass()) {
            return this.getClass().getName().compareTo(o.getClass().getName());
        }
        return 0;
    }

    public T getOldValue() {
        return this.oldValue;
    }

    public T getNewValue() {
        return this.newValue;
    }

    public TYPE getInstanceType() {
        return this.instanceType;
    }

    public String getOldValueDescriptor() {
        return this.oldValueDescriptor;
    }

    public String getNewValueDescriptor() {
        return this.newValueDescriptor;
    }

    @PublicApi
    public static final class TYPE
    extends Enum<TYPE> {
        public static final /* enum */ TYPE ABSTRACT_COLOR = new TYPE();
        public static final /* enum */ TYPE SHAPEFILL = new TYPE();
        public static final /* enum */ TYPE CHECKED = new TYPE();
        public static final /* enum */ TYPE CURVE_POINT = new TYPE();
        public static final /* enum */ TYPE CURVE_TYPE = new TYPE();
        public static final /* enum */ TYPE FONT_FAMILY = new TYPE();
        public static final /* enum */ TYPE FONT_STYLE = new TYPE();
        public static final /* enum */ TYPE FONT_SIZE = new TYPE();
        public static final /* enum */ TYPE FONT_COLOR = new TYPE();
        public static final /* enum */ TYPE IMG_CONTENT = new TYPE();
        public static final /* enum */ TYPE IMG_META = new TYPE();
        public static final /* enum */ TYPE IMG_PARTCONTENT = new TYPE();
        public static final /* enum */ TYPE IMG_SIZE = new TYPE();
        public static final /* enum */ TYPE LINE_SIZE = new TYPE();
        public static final /* enum */ TYPE LINE_STYLE = new TYPE();
        public static final /* enum */ TYPE LINE_THICKNESS = new TYPE();
        public static final /* enum */ TYPE LINE_COLOR = new TYPE();
        public static final /* enum */ TYPE MINIFIED = new TYPE();
        public static final /* enum */ TYPE ASPECT_RATIO = new TYPE();
        public static final /* enum */ TYPE PAGE_BOX_BOUNDS = new TYPE();
        public static final /* enum */ TYPE PAGE_BOX_SIZE = new TYPE();
        public static final /* enum */ TYPE PAGE_BOX_LOC = new TYPE();
        public static final /* enum */ TYPE PAGE_MARGIN = new TYPE();
        public static final /* enum */ TYPE PAGE_ROTATION = new TYPE();
        public static final /* enum */ TYPE TEXT_CONTROL = new TYPE();
        public static final /* enum */ TYPE TEXT_LOC = new TYPE();
        public static final /* enum */ TYPE TEXT_ROTATION = new TYPE();
        public static final /* enum */ TYPE UNDERLINE = new TYPE();
        public static final /* enum */ TYPE UNDERLINE_LENGTH = new TYPE();
        public static final /* enum */ TYPE LANG_UNSUPPORTED = new TYPE();
        public static final /* enum */ TYPE LANG_DIFFERENT = new TYPE();
        public static final /* enum */ TYPE MISC = new TYPE();
        public static final /* enum */ TYPE SPACING = new TYPE();
        public static final /* enum */ TYPE IMAGE_LOC = new TYPE();
        public static final /* enum */ TYPE TAG = new TYPE();
        private static final /* synthetic */ TYPE[] fX;

        public static TYPE[] values() {
            return (TYPE[])fX.clone();
        }

        public static TYPE valueOf(String name) {
            return Enum.valueOf(TYPE.class, name);
        }

        private static /* synthetic */ TYPE[] aX() {
            return new TYPE[]{ABSTRACT_COLOR, SHAPEFILL, CHECKED, CURVE_POINT, CURVE_TYPE, FONT_FAMILY, FONT_STYLE, FONT_SIZE, FONT_COLOR, IMG_CONTENT, IMG_META, IMG_PARTCONTENT, IMG_SIZE, LINE_SIZE, LINE_STYLE, LINE_THICKNESS, LINE_COLOR, MINIFIED, ASPECT_RATIO, PAGE_BOX_BOUNDS, PAGE_BOX_SIZE, PAGE_BOX_LOC, PAGE_MARGIN, PAGE_ROTATION, TEXT_CONTROL, TEXT_LOC, TEXT_ROTATION, UNDERLINE, UNDERLINE_LENGTH, LANG_UNSUPPORTED, LANG_DIFFERENT, MISC, SPACING, IMAGE_LOC, TAG};
        }

        static {
            fX = TYPE.aX();
        }
    }
}

