/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc;

import com.inet.annotations.PublicApi;
import com.inet.authentication.LoginProcessor;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigurationManager;
import com.inet.config.structure.core.license.LicenseEntry;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.lib.util.NetworkFunctions;
import com.inet.logging.LogManager;
import com.inet.pdfc.LicenseModel;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.PDFCCorePlugin;
import com.inet.pdfc.PDFCLicenseChecker;
import com.inet.pdfc.PDFCVersion;
import com.inet.pdfc.PDFComparer;
import com.inet.pdfc.config.DefaultProfile;
import com.inet.pdfc.config.DefaultSetting;
import com.inet.pdfc.config.FilePdfSource;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.config.PdfSource;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.config.XMLProfile;
import com.inet.pdfc.generator.ComparatorProperty;
import com.inet.pdfc.generator.InvalidLicenseException;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.permissions.PdfcLoginProcessor;
import com.inet.pdfc.plugin.CommandLineParameter;
import com.inet.pdfc.plugin.PluginManager;
import com.inet.pdfc.plugin.interfaces.CompareRunner;
import com.inet.pdfc.plugin.interfaces.DocumentFactory;
import com.inet.pdfc.presenter.BasePresenter;
import com.inet.pdfc.presenter.ConsolePresenter;
import com.inet.pdfc.presenter.DifferencesImagePresenter;
import com.inet.pdfc.presenter.DifferencesPDFPresenter;
import com.inet.pdfc.presenter.DifferencesPNGPresenter;
import com.inet.pdfc.presenter.DifferencesPrintPresenter;
import com.inet.pdfc.presenter.ExportPresenter;
import com.inet.pdfc.presenter.ReportPDFPresenter;
import com.inet.pdfc.results.painter.DiffConstants;
import com.inet.pdfc.results.painter.Painter;
import com.inet.pdfc.util.FileNameUtil;
import com.inet.plugin.ServerPluginManager;
import com.inet.shared.utils.Version;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.security.AccessController;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.regex.Pattern;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JOptionPane;

@PublicApi
public class PDFC {
    private static final Pattern d = Pattern.compile("-(\\?|h|help|-help )", 2);
    private File e;
    private File f;
    private Map<CommandLineParameter, String> g;
    private PDFComparer i;
    private a j;

    protected PDFC(File original, File toCompare, Map<b, String> props) {
        this.e = original;
        this.f = toCompare;
        this.g = new LinkedHashMap<CommandLineParameter, String>();
        if (props != null) {
            this.g.putAll(props);
        }
    }

    public static void main(String[] args) throws InvalidPropertiesFormatException {
        System.setProperty("java.awt.headless", "true");
        PDFC.e();
        PDFCCorePlugin.s();
        if (args == null || args.length == 0) {
            PDFC.f();
            return;
        }
        args = PDFC.a(args);
        PDFC.g();
        PdfcLoginProcessor pdfcLoginProcessor = new PdfcLoginProcessor();
        LoginProcessor.setCurrentForAllThreads((LoginProcessor)pdfcLoginProcessor);
        LinkedHashMap<CommandLineParameter, String> linkedHashMap = new LinkedHashMap<CommandLineParameter, String>();
        a a2 = new a();
        File file = null;
        File file2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            int n;
            String string = args[i];
            if (string.startsWith("-D")) {
                n = string.indexOf(61);
                if (n == -1) {
                    System.setProperty(string.substring(2), "");
                } else {
                    System.setProperty(string.substring(2, n), string.substring(n + 1));
                }
            }
            if (string.startsWith("-parameters")) {
                String string2;
                if (string.indexOf("=") < 0) {
                    if (i > args.length - 1) {
                        System.out.println(Msg.getMsg("ConsoleTool.ParamError", "-parameters"));
                        return;
                    }
                    string2 = args[++i];
                } else {
                    string2 = string.substring(string.indexOf("=") + 1);
                }
                if (string2.isEmpty()) {
                    System.out.println(Msg.getMsg("ConsoleTool.ParamError", "-parameters"));
                    return;
                }
                File file3 = FileNameUtil.getUserFile(string2);
                if (arrayList.contains(file3.getAbsolutePath())) continue;
                args = PDFC.a(args, file3);
                arrayList.add(file3.getAbsolutePath());
                continue;
            }
            n = PDFC.a(args, i, linkedHashMap, a2);
            if (n >= 0) {
                i += n;
                continue;
            }
            if (n == -2) {
                return;
            }
            if (file != null && file2 == null && string.startsWith("-")) {
                System.out.println(Msg.getMsg("ConsoleTool.MissingSecondPDFfile", file));
                return;
            }
            if (d.matcher(string).matches()) {
                PDFC.f();
                return;
            }
            if (file == null) {
                file = FileNameUtil.getUserFile(string);
                continue;
            }
            if (file2 == null) {
                file2 = FileNameUtil.getUserFile(string);
                continue;
            }
            System.out.println(Msg.getMsg("ConsoleTool.ParamError", string));
            System.out.println();
            PDFC.f();
            return;
        }
        if ((file == null || file2 == null) && linkedHashMap.get(b.u) == null && linkedHashMap.get(b.v) == null && linkedHashMap.get(b.z) == null) {
            PDFC.f();
            return;
        }
        if (PluginManager.get(DocumentFactory.class).size() == 0) {
            String string = Msg.getMsg("Error.MissingParserPlugin");
            PDFCCore.LOGGER_CORE.fatal((Object)string);
            System.exit(1);
        }
        PDFC pDFC = new PDFC(file, file2, linkedHashMap);
        pDFC.a(a2);
        pDFC.b();
    }

    private static String[] a(String[] stringArray, File file) {
        String[] stringArray2;
        if (!file.exists()) {
            System.err.println(Msg.getMsg("ConsoleTool.MissingParametersFile", file.getAbsolutePath()));
            return stringArray;
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            stringArray2 = new Scanner(file);
            while (stringArray2.hasNextLine()) {
                stringBuilder.append(stringArray2.nextLine().replace("\n", " "));
                stringBuilder.append(" ");
            }
            stringArray2.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(fileNotFoundException);
        }
        stringArray2 = PDFC.a(stringBuilder.toString().split(" "));
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    private static String[] a(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        for (String string2 : stringArray) {
            if (string2.isEmpty()) continue;
            if ((string2.startsWith("\"") && string2.endsWith("\"") || string2.startsWith("'") && string2.endsWith("'")) && string2.length() > 2 && string == null) {
                arrayList.add(string2.length() > 2 ? string2.substring(1, string2.length() - 1) : string2);
                continue;
            }
            if (string2.startsWith("\"") || string2.startsWith("'") && string == null) {
                string = string2;
                continue;
            }
            if (string2.endsWith("\"") || string2.endsWith("'") && string != null) {
                string = string + " " + string2;
                arrayList.add(string.replaceAll("[\"']", ""));
                string = null;
                continue;
            }
            if (string == null) {
                arrayList.add(string2);
                continue;
            }
            string = string + " " + string2;
        }
        return arrayList.toArray(new String[0]);
    }

    private void a(a a2) {
        this.j = a2;
    }

    protected void b() throws InvalidPropertiesFormatException {
        block17: {
            Object object;
            PDFComparer pDFComparer = this.a(this.g.containsKey(b.T));
            if (this.e == null || this.f == null) {
                return;
            }
            if (!PDFCLicenseChecker.getCurrentLicenseModel().isValid()) {
                object = Msg.getMsg("ConsoleTool.NeedLicense");
                PDFCCore.LOGGER_CORE.fatal(object);
                if (LogManager.getLogStream() != System.out) {
                    System.out.println((String)object);
                }
                System.exit(2);
            }
            try {
                if (!this.e.exists()) {
                    System.err.println(Msg.getMsg("Error.DoesNotExist", this.e.getPath()));
                    return;
                }
                if (!this.f.exists()) {
                    System.err.println(Msg.getMsg("Error.DoesNotExist", this.f.getPath()));
                    return;
                }
                if (this.e.isDirectory() && this.f.isDirectory()) {
                    if (this.g.get(b.Z) != null || this.g.get(b.aa) != null) {
                        PDFCCore.LOGGER_CORE.warn((Object)Msg.getMsg("Error.Password.NotForBatch"));
                    }
                    pDFComparer.batchCompare(this.e, this.f);
                } else if (this.e.isFile() && this.f.isFile()) {
                    object = new FilePdfSource(this.e);
                    if (this.g.get(b.Z) != null) {
                        ((PdfSource)object).setPassword(this.g.get(b.Z));
                    }
                    FilePdfSource filePdfSource = new FilePdfSource(this.f);
                    if (this.g.get(b.aa) != null) {
                        filePdfSource.setPassword(this.g.get(b.aa));
                    }
                    pDFComparer.compare((PdfSource)object, filePdfSource);
                } else {
                    System.err.println(Msg.getMsg("Error.ParametersMustBeEqualTypes", this.e, this.f));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println(illegalArgumentException.getMessage());
            }
            catch (InvalidLicenseException invalidLicenseException) {
                System.err.println(invalidLicenseException.getMessage());
            }
            catch (DocumentFactory.PasswordException passwordException) {
                String string = Msg.getMsg(passwordException.wasUsingPassword() ? "Error.Password.Incorrect" : "Error.Password.Missing", passwordException.getFilename());
                System.err.println(string);
                PDFCCore.LOGGER_CORE.debug((Object)passwordException);
            }
            catch (Exception exception) {
                PDFCCore.LOGGER_CORE.error((Throwable)exception);
                String string = ConfigurationManager.getInstance().getCurrent().get(ConfigKey.LOG_FILE.getKey());
                if (string == null || string.isEmpty()) break block17;
                exception.printStackTrace();
            }
        }
    }

    protected PDFComparer a(boolean bl) throws IllegalArgumentException, InvalidPropertiesFormatException {
        ComparisonParameters comparisonParameters = new ComparisonParameters(new XMLProfile(null), new File("differences"));
        comparisonParameters.getSettings().setEnabled(true, Settings.EXPORT.ONLY_ON_DIFFERENCES);
        comparisonParameters.addPresenter(new ConsolePresenter());
        for (CommandLineParameter commandLineParameter : this.j.l()) {
            if (!this.g.containsKey(commandLineParameter)) continue;
            commandLineParameter.execute(comparisonParameters, this.g.get(commandLineParameter));
        }
        if (this.e == null || this.f == null) {
            return null;
        }
        comparisonParameters.a(this.b(bl));
        return this.b(bl);
    }

    private PDFComparer b(final boolean bl) {
        if (this.i == null) {
            this.i = new PDFComparer(){

                @Override
                protected boolean isCreateTextSelectionData() {
                    return false;
                }

                @Override
                CompareRunner k() {
                    CompareRunner compareRunner = super.k();
                    if (bl) {
                        compareRunner.setComparerProperty(ComparatorProperty.retryOnLowMemory, "true");
                    }
                    return compareRunner;
                }
            };
        }
        return this.i;
    }

    private static DifferencesPrintPresenter c() {
        PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        hashPrintRequestAttributeSet.add(MediaSizeName.ISO_A4);
        hashPrintRequestAttributeSet.add(OrientationRequested.LANDSCAPE);
        return new DifferencesPrintPresenter(printService, hashPrintRequestAttributeSet);
    }

    private static int a(String[] stringArray, int n, Map<CommandLineParameter, String> map, a a2) {
        int n2;
        String string = stringArray[n];
        int n3 = 0;
        if (!string.startsWith("-")) {
            return -1;
        }
        string = string.substring(1);
        String string2 = null;
        int n4 = string.indexOf(61);
        if (n4 > 0) {
            string2 = string.substring(n4 + 1);
            string = string.substring(0, n4).toLowerCase();
        } else {
            string = string.toLowerCase();
        }
        CommandLineParameter commandLineParameter = a2.c(string);
        if (commandLineParameter == null && string.length() == 1) {
            commandLineParameter = a2.a(string.charAt(0));
        }
        if (commandLineParameter != null) {
            if (commandLineParameter.hasValue()) {
                if (string2 == null) {
                    if (n + 1 == stringArray.length) {
                        PDFC.a(commandLineParameter);
                        return -2;
                    }
                    string2 = stringArray[n + 1];
                    n3 = 1;
                }
                if (string2.startsWith("-")) {
                    try {
                        Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        PDFC.a(commandLineParameter);
                        return -2;
                    }
                }
                map.put(commandLineParameter, string2);
            } else {
                map.put(commandLineParameter, "true");
            }
            return n3;
        }
        for (n2 = 0; n2 < string.length(); ++n2) {
            if (a2.a(string.charAt(n2)) != null) continue;
            System.out.println(Msg.getMsg("ConsoleTool.ParamError", string));
            return -2;
        }
        for (n2 = 0; n2 < string.length(); ++n2) {
            char c2 = string.charAt(n2);
            commandLineParameter = a2.a(c2);
            if (commandLineParameter.hasValue()) {
                if (string2 == null) {
                    System.out.println(Msg.getMsg("ConsoleTool.NeedParam", string));
                    return -2;
                }
                map.put(commandLineParameter, string2);
                continue;
            }
            map.put(commandLineParameter, "true");
        }
        return 0;
    }

    private static void a(CommandLineParameter commandLineParameter) {
        System.out.println(Msg.getMsg(commandLineParameter.getMissingArgMsg() != null ? commandLineParameter.getMissingArgMsg() : "ConsoleTool.NeedParam"));
    }

    private static void d() {
        Date date;
        System.out.println("Version: " + PDFC.getVersion(true, true));
        LicenseModel licenseModel = PDFCLicenseChecker.getCurrentLicenseModel();
        System.out.println(Msg.getMsg("License.UID", PDFCLicenseChecker.getHashedHardwareKey(), NetworkFunctions.getLocalHostName()));
        String string = "'" + licenseModel.getLicenseTypeString() + "'";
        string = licenseModel.isPerpetual() ? string + " for major version " + licenseModel.getLicenseVersion() : string + " valid until " + DateFormat.getDateInstance(3).format(licenseModel.getExpirationDate());
        System.out.println("License: " + string);
        List<LicenseEntry> list = PDFCLicenseChecker.getLicenseList();
        Optional<LicenseEntry> optional = list.stream().filter(licenseEntry -> licenseEntry.isActive()).findFirst();
        if (optional.isPresent()) {
            date = optional.get();
            for (LocalizedKey localizedKey : date.getDetails()) {
                System.out.println(localizedKey.getKey() + " = " + localizedKey.getDisplayName());
            }
            if (date.getError() != null) {
                System.out.println("License error = " + date.getError());
            }
        }
        if ((date = Version.getTechnicalBuildExpirationDate()) != null && date.getTime() < new Date().getTime()) {
            System.out.println(Msg.getMsg("License.BetaExpired"));
        }
    }

    private static void a(String string) {
        String string2 = null;
        if (string.length() > 100) {
            string2 = string;
        } else {
            try {
                string2 = PDFCLicenseChecker.requestLicenseKeyAndWait(string);
            }
            catch (ConnectException connectException) {
                System.out.println(Msg.getMsg("License.NoConnConsole"));
                System.out.println(Msg.getMsg("License.UID", PDFCLicenseChecker.getHashedHardwareKey(), NetworkFunctions.getLocalHostName()));
                System.out.println(Msg.getMsg("License.ActivationKey", string));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string2 == null) {
                System.out.println(Msg.getMsg("License.ActivationKeyInvalid", string));
            }
        }
        LicenseModel licenseModel = PDFCLicenseChecker.createModelFromEncryptedLicenseKey(string2);
        if (licenseModel.isValid()) {
            String string3 = licenseModel.getAdditionalInfo() != null && licenseModel.getAdditionalInfo().length() > 0 ? " (" + licenseModel.getAdditionalInfo() + ")" : "";
            System.out.println(Msg.getMsg("License.Activated", licenseModel.getLicensee() + string3));
            if (!PDFCLicenseChecker.storeLicense(string2)) {
                System.out.println(Msg.getMsg("License.WrongScope.Body"));
            }
        } else {
            System.out.println(licenseModel.getLicenseInfoText());
        }
    }

    private static void e() {
        String string = System.getProperty("file.encoding.actual");
        if (string != null) {
            try {
                System.setOut(new PrintStream((OutputStream)new FileOutputStream(FileDescriptor.out), true, string));
                System.setErr(new PrintStream((OutputStream)new FileOutputStream(FileDescriptor.err), true, string));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                PDFCCore.LOGGER_CORE.error((Throwable)unsupportedEncodingException);
            }
        }
    }

    public static String getVersion(boolean appendBeta, boolean appendValidTime) {
        return PDFCVersion.c(appendBeta);
    }

    private static void f() {
        StringBuilder stringBuilder = new StringBuilder();
        List list = ServerPluginManager.getInstance().get(CommandLineParameter.class);
        for (CommandLineParameter commandLineParameter : list) {
            String string = commandLineParameter.getHelpMessage();
            if (string == null) continue;
            stringBuilder.append('\n').append(string);
        }
        String string = Msg.getMsg("ConsoleTool.Help", Msg.getMsg("ConsoleTool.Help.Command"), stringBuilder.toString());
        System.out.println(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void activateLicense(String activationOrLicenseKey) throws IOException {
        String string = activationOrLicenseKey;
        String string2 = null;
        if (string == null || string.length() < 8) {
            throw new InvalidLicenseException(Msg.getMsg("License.ActivationKeyInvalid", string));
        }
        if (string.length() > 100) {
            string2 = string;
        } else {
            try {
                string2 = PDFCLicenseChecker.requestLicenseKeyAndWait(string);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string2 == null) {
                throw new InvalidLicenseException(Msg.getMsg("License.ActivationKeyInvalid", string));
            }
        }
        Object object = string2;
        synchronized (object) {
            for (int i = 0; i < 100000; ++i) {
                try {
                    string2.wait(500L);
                    break;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
        }
        try {
            object = PDFCLicenseChecker.createModelFromEncryptedLicenseKey(string2.substring(1));
        }
        catch (Exception exception) {
            throw new InvalidLicenseException(Msg.getMsg("License.ActivationKeyInvalid", string));
        }
        if (((LicenseModel)object).isValid()) {
            throw new InvalidLicenseException(Msg.getMsg("License.ActivationKeyInvalid", string));
        }
        try {
            object = PDFCLicenseChecker.createModelFromEncryptedLicenseKey(string2);
        }
        catch (Exception exception) {
            throw new InvalidLicenseException(Msg.getMsg("License.ActivationKeyInvalid", string));
        }
        if (!((LicenseModel)object).isValid()) {
            String string3 = ((LicenseModel)object).getLicenseInfoText();
            if (((LicenseModel)object).isNoLicense()) {
                string3 = Msg.getMsg("License.ActivationKeyInvalid", string);
            }
            if (string3.length() == 0) {
                string3 = Msg.getMsg("License.ActivationKeyInvalid", string);
            }
            throw new InvalidLicenseException(string3);
        }
        PDFCLicenseChecker.storeLicense(string2);
    }

    private static void g() {
        PluginManager.setPluginFilterForAPI();
    }

    static {
        PluginManager.setPluginFilterForAPI();
        PluginManager.initConditionally();
        try {
            AccessController.doPrivileged(() -> {
                String string = System.getProperty("java.vm.specification.version");
                double d2 = Double.parseDouble(string);
                String string2 = d2 < 17.0 ? "Your Java version " + string + " is too old. Please try a newer version of Java. The minimum version is " + 17 + "\nCurrent Java installation directory: " + System.getProperty("java.home") : (d2 >= 26.0 ? "Your Java version " + string + " is too new and has never been tested with this software. Please update to the latest version of the product or switch to Java version " + 25 + "\nCurrent Java installation directory: " + System.getProperty("java.home") : null);
                if (string2 != null) {
                    if (GraphicsEnvironment.isHeadless()) {
                        System.err.println(string2);
                    } else {
                        JOptionPane.showMessageDialog(null, string2, "Setup Error", 0);
                    }
                }
                return null;
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
    }

    private static class a {
        private Map<Character, CommandLineParameter> o = new HashMap<Character, CommandLineParameter>();
        private Map<String, CommandLineParameter> p = new HashMap<String, CommandLineParameter>();
        private List<CommandLineParameter> q = new ArrayList<CommandLineParameter>();

        public a() {
            Object object;
            for (b b2 : b.values()) {
                char c2;
                object = b2.getKey();
                if (object != null) {
                    this.p.put(((String)object).toLowerCase(), b2);
                }
                if ((c2 = b2.getShortcut()) != '\u0000') {
                    this.o.put(Character.valueOf(c2), b2);
                }
                this.q.add(b2);
            }
            for (CommandLineParameter commandLineParameter : ServerPluginManager.getInstance().get(CommandLineParameter.class)) {
                char c3;
                String string = commandLineParameter.getKey();
                if (string != null) {
                    this.p.put(string.toLowerCase(), commandLineParameter);
                }
                if ((c3 = commandLineParameter.getShortcut()) != '\u0000') {
                    object = Character.valueOf(c3);
                    if (this.o.get(object) != null) {
                        System.out.println("ERROR: Shortcut parameter '" + c3 + "' has multiple mappings and is thus ambiguous!");
                    }
                    this.o.put((Character)object, commandLineParameter);
                }
                this.q.add(commandLineParameter);
            }
        }

        public CommandLineParameter c(String string) {
            return this.p.get(string.toLowerCase());
        }

        public CommandLineParameter a(char c2) {
            return this.o.get(Character.valueOf(c2));
        }

        public List<CommandLineParameter> l() {
            return this.q;
        }
    }

    protected static final class b
    extends Enum<b>
    implements CommandLineParameter {
        public static final /* enum */ b u = new b("activate", '\u0000', "ConsoleTool.MissingActivationKey");
        public static final /* enum */ b v = new b("generateinfo", '\u0000', false);
        public static final /* enum */ b z = new b("triallicense", 'a', false);
        public static final /* enum */ b A = new b("config", 'c', "ConsoleTool.MissingConfigName");
        public static final /* enum */ b B = new b("root", 'r', "ConsoleTool.MissingFolder");
        public static final /* enum */ b C = new b("export", '\u0000', true);
        public static final /* enum */ b D = new b('p');
        public static final /* enum */ b E = new b('e');
        public static final /* enum */ b F = new b("format", '\u0000', true);
        public static final /* enum */ b G = new b("exportpw", '\u0000', true);
        public static final /* enum */ b H = new b("fontembedding", '\u0000', true);
        public static final /* enum */ b I = new b("minimize", 'm', false);
        public static final /* enum */ b J = new b("types");
        public static final /* enum */ b K = new b("highlights");
        public static final /* enum */ b N = new b("sides");
        public static final /* enum */ b O = new b("header");
        public static final /* enum */ b P = new b("scaletofit");
        public static final /* enum */ b Q = new b("overlap");
        public static final /* enum */ b R = new b("exportAlways", '\u0000', false);
        public static final /* enum */ b T = new b("retryFailed", '\u0000', false);
        public static final /* enum */ b U = new b('x');
        public static final /* enum */ b V = new b('o');
        public static final /* enum */ b W = new b('f');
        public static final /* enum */ b X = new b('s');
        public static final /* enum */ b Y = new b('i');
        public static final /* enum */ b Z = new b("p1", '\u0000', true);
        public static final /* enum */ b aa = new b("p2", '\u0000', true);
        private String ab;
        private char ac;
        private boolean ad;
        private String ae;
        private static final /* synthetic */ b[] af;

        public static b[] values() {
            return (b[])af.clone();
        }

        public static b valueOf(String name) {
            return Enum.valueOf(b.class, name);
        }

        private b(String string2, char c2, boolean bl) {
            this.ab = string2;
            this.ac = c2;
            this.ad = bl;
        }

        private b(char c2) {
            this(null, c2, false);
        }

        private b(String string2) {
            this(string2, '\u0000', true);
        }

        @Override
        public String getKey() {
            return this.ab;
        }

        @Override
        public char getShortcut() {
            return this.ac;
        }

        @Override
        public boolean hasValue() {
            return this.ad;
        }

        @Override
        public String getMissingArgMsg() {
            return this.ae;
        }

        @Override
        public void execute(ComparisonParameters parameters, String optionalParameter) {
            switch (this) {
                case u: {
                    PDFC.a(optionalParameter);
                    break;
                }
                case A: {
                    try {
                        XMLProfile xMLProfile = new XMLProfile(FileNameUtil.getUserFile(optionalParameter));
                        parameters.getProfile().putValues(xMLProfile.getProperties());
                    }
                    catch (IllegalArgumentException | InvalidPropertiesFormatException exception) {
                        PDFCCore.LOGGER_CORE.error((Throwable)exception);
                    }
                    break;
                }
                case B: {
                    parameters.setRootFolder(FileNameUtil.getUserFile(optionalParameter));
                    break;
                }
                case v: {
                    PDFC.d();
                    break;
                }
                case C: {
                    String[] stringArray;
                    String[] stringArray2 = stringArray = optionalParameter.toLowerCase().split("\\s*[,;]\\s*");
                    int n = stringArray2.length;
                    block88: for (int i = 0; i < n; ++i) {
                        String string;
                        switch (string = stringArray2[i]) {
                            case "printpdf": {
                                DifferencesPDFPresenter differencesPDFPresenter = new DifferencesPDFPresenter(parameters.getRootFolder());
                                parameters.addPresenter(differencesPDFPresenter);
                                differencesPDFPresenter.setPassword((String)parameters.t.get(G.name()));
                                String string2 = (String)parameters.t.get(H.name());
                                if (string2 == null) continue block88;
                                differencesPDFPresenter.setReplaceSystemFonts(Boolean.parseBoolean(string2));
                                continue block88;
                            }
                            case "printpng": {
                                parameters.addPresenter(new DifferencesPNGPresenter(parameters.getRootFolder()));
                                continue block88;
                            }
                            case "print": {
                                parameters.addPresenter(PDFC.c());
                                continue block88;
                            }
                            case "report": {
                                ReportPDFPresenter reportPDFPresenter = new ReportPDFPresenter(true, true, parameters.getRootFolder());
                                String string3 = (String)parameters.t.get(F.name());
                                if (string3 != null) {
                                    reportPDFPresenter.setExportFormat(string3);
                                }
                                reportPDFPresenter.setPassword((String)parameters.t.get(G.name()));
                                parameters.addPresenter(reportPDFPresenter);
                                continue block88;
                            }
                            case "image": {
                                parameters.addPresenter(new DifferencesImagePresenter(parameters.getRootFolder()));
                                continue block88;
                            }
                            default: {
                                System.err.println(Msg.getMsg("ConsoleTool.UnknownPresenter", string));
                            }
                        }
                    }
                    break;
                }
                case F: {
                    parameters.t.put(F.name(), optionalParameter);
                    ReportPDFPresenter reportPDFPresenter = parameters.getPresenter(ReportPDFPresenter.class);
                    if (reportPDFPresenter == null) break;
                    reportPDFPresenter.setExportFormat(optionalParameter);
                    break;
                }
                case G: {
                    DifferencesPDFPresenter differencesPDFPresenter;
                    parameters.t.put(G.name(), optionalParameter);
                    ReportPDFPresenter reportPDFPresenter = parameters.getPresenter(ReportPDFPresenter.class);
                    if (reportPDFPresenter != null) {
                        reportPDFPresenter.setPassword(optionalParameter);
                    }
                    if ((differencesPDFPresenter = parameters.getPresenter(DifferencesPDFPresenter.class)) == null) break;
                    differencesPDFPresenter.setPassword(optionalParameter);
                    break;
                }
                case Y: {
                    parameters.addPresenter(new DifferencesImagePresenter(parameters.getRootFolder()));
                    parameters.getSettings().setEnabled(true, Settings.EXPORT.CREATE_DIFFIMAGES_FIRST);
                    parameters.getSettings().setEnabled(true, Settings.EXPORT.CREATE_DIFFIMAGES_SECOND);
                    ((DefaultProfile)parameters.getProfile()).getProperties().remove(PDFCProperty.CREATE_DIFFIMAGES.name());
                    break;
                }
                case W: {
                    parameters.addPresenter(new DifferencesImagePresenter(parameters.getRootFolder()));
                    parameters.getSettings().setEnabled(Boolean.valueOf(optionalParameter), Settings.EXPORT.CREATE_DIFFIMAGES_FIRST);
                    ((DefaultProfile)parameters.getProfile()).getProperties().remove(PDFCProperty.CREATE_DIFFIMAGES.name());
                    break;
                }
                case X: {
                    parameters.addPresenter(new DifferencesImagePresenter(parameters.getRootFolder()));
                    parameters.getSettings().setEnabled(Boolean.valueOf(optionalParameter), Settings.EXPORT.CREATE_DIFFIMAGES_SECOND);
                    ((DefaultProfile)parameters.getProfile()).getProperties().remove(PDFCProperty.CREATE_DIFFIMAGES.name());
                    break;
                }
                case E: {
                    ReportPDFPresenter reportPDFPresenter = new ReportPDFPresenter(true, true, parameters.getRootFolder());
                    String string = (String)parameters.t.get(F.name());
                    if (string != null) {
                        reportPDFPresenter.setExportFormat(string);
                    }
                    parameters.addPresenter(reportPDFPresenter);
                    break;
                }
                case D: {
                    parameters.addPresenter(new DifferencesPDFPresenter(parameters.getRootFolder()));
                    break;
                }
                case V: {
                    parameters.addPresenter(new DifferencesImagePresenter(parameters.getRootFolder()));
                    parameters.getSettings().setEnabled(Boolean.valueOf(optionalParameter), Settings.EXPORT.CREATE_ORIGIMAGES);
                    ((DefaultProfile)parameters.getProfile()).getProperties().remove(PDFCProperty.CREATE_ORIGIMAGES.name());
                    break;
                }
                case U: {
                    parameters.addPresenter(new DifferencesImagePresenter(parameters.getRootFolder()));
                    parameters.getSettings().setEnabled(Boolean.valueOf(optionalParameter), Settings.EXPORT.CREATE_XORIMAGES);
                    ((DefaultProfile)parameters.getProfile()).getProperties().remove(PDFCProperty.CREATE_XORIMAGES.name());
                    break;
                }
                case O: {
                    parameters.getSettings().setEnabled(Boolean.valueOf(optionalParameter), Settings.EXPORT.FOOTER, Settings.EXPORT.HEADER);
                    break;
                }
                case P: {
                    parameters.getSettings().setEnabled(Boolean.valueOf(optionalParameter), Settings.EXPORT.SCALETOPAGEHEIGHT);
                    break;
                }
                case N: {
                    byte by = 3;
                    switch (optionalParameter.toLowerCase()) {
                        case "left": {
                            by = 1;
                            break;
                        }
                        case "right": {
                            by = 2;
                            break;
                        }
                        case "both": {
                            break;
                        }
                        default: {
                            System.err.println("Unkown side to print '" + optionalParameter + "'");
                        }
                    }
                    for (BasePresenter basePresenter : parameters.getPresenters()) {
                        if (!(basePresenter instanceof ExportPresenter)) continue;
                        ((ExportPresenter)basePresenter).setPaintSides(by);
                    }
                    break;
                }
                case Q: {
                    float f2;
                    try {
                        f2 = Float.parseFloat(optionalParameter);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("Option 'overlap' requires a transparency ratio instead of '" + optionalParameter + "'");
                        return;
                    }
                    for (BasePresenter basePresenter : parameters.getPresenters()) {
                        if (!(basePresenter instanceof ExportPresenter)) continue;
                        ExportPresenter exportPresenter = (ExportPresenter)basePresenter;
                        exportPresenter.setPaintOverlap(true);
                        exportPresenter.setOverlapAlpha(f2);
                    }
                    break;
                }
                case R: {
                    parameters.getSettings().setEnabled(false, Settings.EXPORT.ONLY_ON_DIFFERENCES);
                    ((DefaultProfile)parameters.getProfile()).getProperties().remove(PDFCProperty.EXPORT_PDF_ALWAYS.name());
                    break;
                }
                case J: {
                    String[] stringArray;
                    ArrayList<Modification.ModificationType> arrayList = new ArrayList<Modification.ModificationType>();
                    String[] stringArray3 = stringArray = optionalParameter.toLowerCase().split("\\s*[,;]\\s*");
                    int n = stringArray3.length;
                    block91: for (int i = 0; i < n; ++i) {
                        String string;
                        switch (string = stringArray3[i]) {
                            case "added": {
                                arrayList.add(Modification.ModificationType.add);
                                continue block91;
                            }
                            case "removed": {
                                arrayList.add(Modification.ModificationType.remove);
                                continue block91;
                            }
                            case "addremove": {
                                arrayList.addAll(Arrays.stream(DiffConstants.getModificationType(DiffGroup.GroupType.AddedOrRemoved)).toList());
                                continue block91;
                            }
                            case "replaced": {
                                arrayList.add(Modification.ModificationType.replace);
                                continue block91;
                            }
                            case "modified": {
                                arrayList.add(Modification.ModificationType.attributeDifference);
                                continue block91;
                            }
                            case "validationError": {
                                arrayList.add(Modification.ModificationType.validationError);
                                continue block91;
                            }
                            case "meta": {
                                arrayList.add(Modification.ModificationType.metadataChanged);
                                continue block91;
                            }
                            default: {
                                System.err.println("Unknown difference type '" + string + "'");
                            }
                        }
                    }
                    if (arrayList.isEmpty()) {
                        System.err.println("Warning: All difference types are hidden by parameter '-types'");
                    }
                    parameters.getSettings().setEnabled(false, Modification.ModificationType.values());
                    parameters.getSettings().setEnabled(true, arrayList.toArray(new Modification.ModificationType[0]));
                    break;
                }
                case K: {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    String[] stringArray = optionalParameter.toLowerCase().split("\\s*[,;]\\s*");
                    String[] stringArray4 = stringArray;
                    int n = stringArray4.length;
                    block92: for (int i = 0; i < n; ++i) {
                        String string;
                        switch (string = stringArray4[i]) {
                            case "annotation": {
                                arrayList.add("ANNOTATION");
                                continue block92;
                            }
                            case "headerfooter": {
                                arrayList.add("HEADERFOOTER");
                                continue block92;
                            }
                            case "invisible": {
                                arrayList.add("INVISIBLEELEMENTS");
                                continue block92;
                            }
                            case "multicolumn": {
                                arrayList.add("MULTICOLUMN");
                                continue block92;
                            }
                            case "regexp": {
                                arrayList.add("REGEXP");
                                continue block92;
                            }
                            case "unicode": {
                                arrayList.add("TEXTTRANSFORM");
                                continue block92;
                            }
                            default: {
                                System.err.println("Unknown filter type '" + string + "'");
                            }
                        }
                    }
                    if (arrayList.size() == 0) {
                        System.err.println("Warning: All difference types are hidden by parameter '-highlights'");
                    }
                    for (String string : arrayList) {
                        parameters.getSettings().setEnabled(true, new Painter.HighlightColorSetting(string));
                    }
                    break;
                }
                case I: {
                    parameters.getSettings().setEnabled(true, Settings.OPTION.ONLYPAGESWITHDIFFS);
                    break;
                }
                case Z: 
                case aa: {
                    break;
                }
                case z: {
                    com.inet.pdfc.util.b.a("ConsoleTool.ActivateLicenseFine", false, true, false);
                    if (PDFCLicenseChecker.getCurrentLicenseModel().isValid()) break;
                    String string = Msg.getMsg("ConsoleTool.NeedLicense");
                    System.out.println(string);
                    System.exit(2);
                }
            }
        }

        private b(String string2, char c2, String string3) {
            this(string2, c2, true);
            this.ae = string3;
        }

        @Override
        public String getHelpMessage() {
            return null;
        }

        private static /* synthetic */ b[] m() {
            return new b[]{u, v, z, A, B, C, D, E, F, G, H, I, J, K, N, O, P, Q, R, T, U, V, W, X, Y, Z, aa};
        }

        static {
            af = b.m();
        }
    }

    @PublicApi
    public class ComparisonParameters {
        private List<BasePresenter> r = new ArrayList<BasePresenter>();
        private File s;
        private IProfile profile;
        private Settings settings;
        private Map<String, String> t = new HashMap<String, String>();

        private ComparisonParameters(IProfile initialProfile, File rootFolder) {
            this.profile = initialProfile != null ? initialProfile : new DefaultProfile();
            this.settings = new DefaultSetting();
            this.s = rootFolder != null ? rootFolder : new File("differences");
        }

        public IProfile getProfile() {
            return this.profile;
        }

        public Settings getSettings() {
            return this.settings;
        }

        public void addPresenter(BasePresenter p) {
            for (BasePresenter basePresenter : this.r) {
                if (basePresenter.getClass() != p.getClass()) continue;
                this.r.remove(basePresenter);
                break;
            }
            this.r.add(p);
        }

        public <T extends BasePresenter> T getPresenter(Class<T> pClass) {
            for (BasePresenter basePresenter : this.r) {
                if (pClass != basePresenter.getClass()) continue;
                return (T)basePresenter;
            }
            return null;
        }

        public List<BasePresenter> getPresenters() {
            return Collections.unmodifiableList(this.r);
        }

        public File getRootFolder() {
            return this.s;
        }

        public void setRootFolder(File rootFolder) {
            this.s = rootFolder;
        }

        private void a(PDFComparer pDFComparer) {
            pDFComparer.setProfile(this.profile);
            pDFComparer.setSettings(this.settings);
            for (BasePresenter basePresenter : this.r) {
                pDFComparer.addPresenter(basePresenter);
            }
        }
    }
}

