/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.util;

import com.inet.annotations.InternalApi;
import com.inet.graphics.buffered.BufferedGraphicsCommand;
import com.inet.graphics.buffered.GraphicsFilter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

@InternalApi
public class OCRGraphicsFilter
implements GraphicsFilter {
    private int width;
    private int height;
    private final int tR = 10;
    private Set<BufferedGraphicsCommand.MethodNames> tZ = new HashSet<BufferedGraphicsCommand.MethodNames>();
    private boolean ua;
    private boolean ub;
    private static final Set<BufferedGraphicsCommand.MethodNames> uc = Set.of(BufferedGraphicsCommand.MethodNames.DRAW_IMAGE_WITH_BG, BufferedGraphicsCommand.MethodNames.DRAW_IMAGE_WITH_BUFF_IMG, BufferedGraphicsCommand.MethodNames.DRAW_IMAGE_WITH_CORNER, BufferedGraphicsCommand.MethodNames.DRAW_IMAGE_WITH_CORNER_AND_BG, BufferedGraphicsCommand.MethodNames.DRAW_IMAGE_WITH_OBS, BufferedGraphicsCommand.MethodNames.DRAW_IMAGE_WITH_SIZE, BufferedGraphicsCommand.MethodNames.DRAW_IMAGE_WITH_SIZE_AND_BG, BufferedGraphicsCommand.MethodNames.DRAW_IMAGE_WITH_XFORM);
    private static final Set<BufferedGraphicsCommand.MethodNames> ud = Set.of(BufferedGraphicsCommand.MethodNames.FILL, BufferedGraphicsCommand.MethodNames.FILL_ARC, BufferedGraphicsCommand.MethodNames.FILL_OVAL, BufferedGraphicsCommand.MethodNames.FILL_POLYGON, BufferedGraphicsCommand.MethodNames.FILL_RECT, BufferedGraphicsCommand.MethodNames.FILL_ROUND_RECT);
    private static final Set<BufferedGraphicsCommand.MethodNames> ue = Set.of(BufferedGraphicsCommand.MethodNames.DRAW, BufferedGraphicsCommand.MethodNames.DRAW_ARC, BufferedGraphicsCommand.MethodNames.DRAW_LINE, BufferedGraphicsCommand.MethodNames.DRAW_OVAL, BufferedGraphicsCommand.MethodNames.DRAW_POLYGON, BufferedGraphicsCommand.MethodNames.DRAW_POLYLINE, BufferedGraphicsCommand.MethodNames.DRAW_ROUND_RECT);
    private static final Set<BufferedGraphicsCommand.MethodNames> uf = Set.of(BufferedGraphicsCommand.MethodNames.DRAW_GLYPH_VECTOR, BufferedGraphicsCommand.MethodNames.DRAW_STRING_WITH_INT, BufferedGraphicsCommand.MethodNames.DRAW_STRING_WITH_FLOAT, BufferedGraphicsCommand.MethodNames.DRAW_STRING_WITH_ACI_AND_INT, BufferedGraphicsCommand.MethodNames.DRAW_STRING_WITH_ACI_AND_FLOAT, BufferedGraphicsCommand.MethodNames.GET_FONT, BufferedGraphicsCommand.MethodNames.GET_FONT_METRICS);

    public void setImageSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public OCRGraphicsFilter blockText() {
        this.tZ.addAll(uf);
        return this;
    }

    public OCRGraphicsFilter blockFilledShapes() {
        this.tZ.addAll(ud);
        return this;
    }

    public OCRGraphicsFilter blockImages() {
        this.tZ.addAll(uc);
        return this;
    }

    public OCRGraphicsFilter blockBackground() {
        this.ua = true;
        return this;
    }

    public OCRGraphicsFilter blockAnythingButText() {
        this.tZ.addAll(ud);
        this.tZ.addAll(ue);
        this.tZ.addAll(uc);
        this.ua = true;
        this.ub = true;
        return this;
    }

    public boolean canDraw(BufferedGraphicsCommand command, @Nonnull Graphics2D graphics) {
        if (this.tZ.contains(command.getName())) {
            return false;
        }
        if (this.ub && uf.contains(command.getName())) {
            graphics.setColor(Color.BLACK);
        }
        if (this.ua) {
            Rectangle rectangle;
            Object[] objectArray = command.getParameters();
            switch (command.getName()) {
                case DRAW_IMAGE_WITH_XFORM: {
                    Image image = (Image)objectArray[0];
                    AffineTransform affineTransform = (AffineTransform)objectArray[1];
                    rectangle = new Rectangle(image.getWidth(null), image.getHeight(null));
                    rectangle = affineTransform.createTransformedShape(rectangle).getBounds();
                    break;
                }
                case DRAW_IMAGE_WITH_BUFF_IMG: 
                case DRAW_IMAGE_WITH_OBS: 
                case DRAW_IMAGE_WITH_BG: {
                    Image image = (Image)objectArray[0];
                    this.width = image.getWidth(null);
                    this.height = image.getHeight(null);
                    rectangle = new Rectangle((Integer)objectArray[1], (Integer)objectArray[2], image.getWidth(null), image.getHeight(null));
                    break;
                }
                case DRAW_IMAGE_WITH_SIZE: 
                case DRAW_IMAGE_WITH_SIZE_AND_BG: {
                    rectangle = new Rectangle((Integer)objectArray[1], (Integer)objectArray[2], (Integer)objectArray[3], (Integer)objectArray[4]);
                    break;
                }
                case DRAW_IMAGE_WITH_CORNER: 
                case DRAW_IMAGE_WITH_CORNER_AND_BG: {
                    int n = (Integer)objectArray[1];
                    int n2 = (Integer)objectArray[2];
                    int n3 = (Integer)objectArray[3];
                    int n4 = (Integer)objectArray[4];
                    rectangle = new Rectangle(n, n2, Math.abs(n - n3), Math.abs(n2 - n4));
                    break;
                }
                case FILL_ARC: 
                case FILL_OVAL: 
                case FILL_RECT: 
                case FILL_ROUND_RECT: {
                    rectangle = new Rectangle((Integer)objectArray[0], (Integer)objectArray[1], (Integer)objectArray[2], (Integer)objectArray[3]);
                    break;
                }
                case FILL: {
                    rectangle = ((Shape)objectArray[0]).getBounds();
                    break;
                }
                case FILL_POLYGON: {
                    Polygon polygon = new Polygon((int[])objectArray[0], (int[])objectArray[1], (Integer)objectArray[2]);
                    rectangle = polygon.getBounds();
                    break;
                }
                default: {
                    return true;
                }
            }
            return !this.a(rectangle.x, rectangle.y, rectangle.width, rectangle.height, graphics.getTransform());
        }
        return true;
    }

    private boolean a(int n, int n2, int n3, int n4, AffineTransform affineTransform) {
        Point2D point2D = new Point(n, n2);
        Point2D point2D2 = new Point(n + n3, n2 + n4);
        point2D = affineTransform.transform(point2D, point2D);
        point2D2 = affineTransform.transform(point2D2, point2D2);
        Rectangle2D.Double double_ = new Rectangle2D.Double(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
        return Math.abs(double_.getMinX()) < 10.0 && Math.abs(double_.getMinY()) < 10.0 && Math.abs(double_.getMaxX() - (double)this.width) < 10.0 && Math.abs(double_.getMaxY() - (double)this.height) < 10.0;
    }
}

