/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.util;

import com.inet.annotations.InternalApi;
import com.inet.error.ErrorCode;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.error.PdfcErrorCode;
import com.inet.pdfc.error.PdfcException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;

@InternalApi
public class EnumParser {
    @Nonnull
    public static <T extends Enum<T>> List<T> getConfiguredValues(@Nonnull IProfile config, @Nonnull PDFCProperty<?> key, @Nonnull Class<T> enumtype) {
        ArrayList<T> arrayList = new ArrayList<T>();
        String string = config.getString(key);
        if (string == null || string.length() == 0) {
            return arrayList;
        }
        for (String string2 : EnumParser.splitEnumValues(string)) {
            if (string2.length() == 0) continue;
            try {
                arrayList.add(Enum.valueOf(enumtype, string2.trim()));
            }
            catch (Throwable throwable) {
                String string3 = "Config parameter '" + string2 + "' for " + String.valueOf(key);
                PDFCCore.LOGGER_CORE.error((Throwable)((Object)PdfcException.create((ErrorCode)PdfcErrorCode.savedValueNoLongerExists, throwable, string3)));
            }
        }
        return arrayList;
    }

    @Nonnull
    public static String[] splitEnumValues(String value) {
        return value != null ? value.split("\\s*[,;]\\s*") : new String[]{};
    }

    public static <T extends Enum<T>> boolean isValidValue(@Nonnull String singleEnumValue, @Nonnull Class<T> enumtype) {
        try {
            Enum.valueOf(enumtype, singleEnumValue.trim());
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    public static boolean isInList(String value, String list) {
        if (list == null) {
            return false;
        }
        return Arrays.asList(list.trim().split(",")).contains(value);
    }

    public static boolean modifyListProperty(PDFCProperty<?> key, String value, boolean mustBeSet, IProfile profile) {
        return EnumParser.modifyListProperty(key.name(), value, mustBeSet, profile);
    }

    public static boolean modifyListProperty(String key, String value, boolean mustBeSet, IProfile profile) {
        String string = profile.getString(key);
        List<String> list = Arrays.asList(string.trim().split(","));
        boolean bl = false;
        if (mustBeSet) {
            if (!list.contains(value)) {
                list = new ArrayList<String>(list);
                list.add(value);
                bl = true;
            }
        } else if (list.contains(value)) {
            list = new ArrayList<String>(list);
            list.remove(value);
            bl = true;
        }
        if (bl) {
            list.remove("");
            profile.putValue(key, String.join((CharSequence)",", list.toArray(new String[list.size()])));
        }
        return bl;
    }
}

