/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.util;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.generator.continuous.structure.StructureElement;
import com.inet.pdfc.generator.model.forms.GeomShape;
import com.inet.pdfc.generator.model.text.TextModuleUtils;
import com.inet.pdfc.generator.model.text.WordElement;
import com.inet.pdfc.model.AnnotationElement;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.ShapeElement;
import com.inet.pdfc.model.TextElement;
import com.inet.pdfc.textselection.TextInfo;
import com.inet.pdfc.util.LocationUtils;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

@InternalApi
public class ElementSorter {
    public static final Comparator<DrawableElement> Y_COMPARATOR = new Comparator<DrawableElement>(){

        public int f(DrawableElement drawableElement, DrawableElement drawableElement2) {
            return Double.compare(Math.round(drawableElement.getY() * 100.0) / 100L, Math.round(drawableElement2.getY() * 100.0) / 100L);
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.f((DrawableElement)object, (DrawableElement)object2);
        }
    };
    public static final Comparator<DrawableElement> X_COMPARATOR = new Comparator<DrawableElement>(){

        public int f(DrawableElement drawableElement, DrawableElement drawableElement2) {
            return Double.compare(Math.round(drawableElement.getX() * 100.0) / 100L, Math.round(drawableElement2.getX() * 100.0) / 100L);
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.f((DrawableElement)object, (DrawableElement)object2);
        }
    };
    public static final Comparator<DrawableElement> YX_COMPARATOR_RASTERED = new Comparator<DrawableElement>(){

        public int f(DrawableElement drawableElement, DrawableElement drawableElement2) {
            if (drawableElement.getPageIndex() != drawableElement2.getPageIndex()) {
                return drawableElement.getPageIndex() - drawableElement2.getPageIndex();
            }
            double d2 = Math.round(drawableElement.getX() * 1000.0) / 1000L;
            double d3 = Math.round(drawableElement.getY() * 1000.0) / 1000L;
            double d4 = Math.round(drawableElement2.getX() * 1000.0) / 1000L;
            double d5 = Math.round(drawableElement2.getY() * 1000.0) / 1000L;
            if (Double.compare(d3, d5) == 0) {
                if (Double.compare(d2, d4) == 0) {
                    double d6;
                    int n = drawableElement.getElementID().compareTo(drawableElement2.getElementID());
                    if (n != 0) {
                        return n;
                    }
                    double d7 = drawableElement.getBounds().getHeight();
                    if (d7 == (d6 = drawableElement2.getBounds().getHeight())) {
                        return Double.compare(drawableElement2.getBounds().getWidth(), drawableElement.getBounds().getWidth());
                    }
                    return Double.compare(d6, d7);
                }
                return Double.compare(d2, d4);
            }
            return Double.compare(d3, d5);
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.f((DrawableElement)object, (DrawableElement)object2);
        }
    };
    public static final Comparator<DrawableElement> YX_COMPARATOR = new Comparator<DrawableElement>(){

        public int f(DrawableElement drawableElement, DrawableElement drawableElement2) {
            DrawableElement drawableElement3;
            DrawableElement drawableElement4;
            int n = Double.compare(drawableElement.getY(), drawableElement2.getY());
            if (n != 0) {
                return n;
            }
            n = Double.compare(drawableElement.getX(), drawableElement2.getX());
            if (n != 0) {
                return n;
            }
            Rectangle2D rectangle2D = drawableElement2.getBounds();
            Rectangle2D rectangle2D2 = drawableElement.getBounds();
            n = drawableElement.getElementID().compareTo(drawableElement2.getElementID());
            if (n != 0) {
                return n;
            }
            if (drawableElement instanceof ShapeElement) {
                drawableElement4 = (ShapeElement)drawableElement;
                drawableElement3 = (ShapeElement)drawableElement2;
                n = ElementSorter.b(((ShapeElement)drawableElement4).getFillPaint(), ((ShapeElement)drawableElement3).getFillPaint());
                if (n != 0) {
                    return n;
                }
                n = ElementSorter.b(((ShapeElement)drawableElement4).getStrokePaint(), ((ShapeElement)drawableElement3).getStrokePaint());
                if (n != 0) {
                    return n;
                }
                if (rectangle2D2 != null && rectangle2D != null && (n = ((ShapeElement)drawableElement4).getShapeSegments().size() - ((ShapeElement)drawableElement3).getShapeSegments().size()) != 0) {
                    return n;
                }
            }
            if (drawableElement instanceof GeomShape) {
                drawableElement4 = (GeomShape)drawableElement;
                drawableElement3 = (GeomShape)drawableElement2;
                n = ElementSorter.b(((GeomShape)drawableElement4).getFillPaint(), ((GeomShape)drawableElement3).getFillPaint());
                if (n != 0) {
                    return n;
                }
                n = ElementSorter.b(((GeomShape)drawableElement4).getStrokePaint(), ((GeomShape)drawableElement3).getStrokePaint());
                if (n != 0) {
                    return n;
                }
            }
            return 0;
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.f((DrawableElement)object, (DrawableElement)object2);
        }
    };
    public static final Comparator<DrawableElement> YX_COMPARATOR_PAGED = new Comparator<DrawableElement>(){

        public int f(DrawableElement drawableElement, DrawableElement drawableElement2) {
            if (drawableElement.getPageIndex() != drawableElement2.getPageIndex()) {
                return drawableElement.getPageIndex() - drawableElement2.getPageIndex();
            }
            return YX_COMPARATOR.compare(drawableElement, drawableElement2);
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.f((DrawableElement)object, (DrawableElement)object2);
        }
    };
    private static final Comparator<b> tz = new Comparator<b>(){

        public int a(b b2, b b3) {
            return Double.compare(b2.tG, b3.tG);
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((b)object, (b)object2);
        }
    };

    private static int b(Paint paint, Paint paint2) {
        if (paint == null != (paint2 == null)) {
            return paint == null ? -1 : 1;
        }
        if (paint == null || paint2 == null) {
            return 0;
        }
        if (paint.getClass() != paint2.getClass()) {
            return paint.getClass().hashCode() - paint2.getClass().hashCode();
        }
        if (paint instanceof Color) {
            return Integer.compare(((Color)paint).getRGB(), ((Color)paint2).getRGB());
        }
        return 0;
    }

    public static <T extends DrawableElement> void alignAndSort(List<T> list, double toleranceRatio, boolean textOnly) {
        ElementSorter.alignAndSort(list, toleranceRatio, textOnly, false);
    }

    public static <T extends DrawableElement> void alignAndSort(List<T> list, double toleranceRatio, boolean textOnly, boolean ignoreRotation) {
        ElementSorter.alignAndSort(list, toleranceRatio, textOnly, ignoreRotation, false);
    }

    public static <T extends DrawableElement> void alignAndSort(List<T> list, double toleranceRatio, boolean textOnly, boolean ignoreRotation, boolean restoreCoordinates) {
        ArrayList<c> arrayList;
        block17: {
            b b2;
            Object object2;
            if (list == null || list.size() <= 1) {
                return;
            }
            arrayList = null;
            if (restoreCoordinates) {
                arrayList = new ArrayList<c>(list.size());
                for (Object object2 : list) {
                    arrayList.add(new c((DrawableElement)object2));
                }
            }
            Collections.sort(list, YX_COMPARATOR_PAGED);
            ArrayList arrayList2 = new ArrayList();
            object2 = null;
            double d2 = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < list.size(); ++i) {
                DrawableElement drawableElement = (DrawableElement)list.get(i);
                if (textOnly && drawableElement.getType() != ElementType.TextWord && drawableElement.getType() != ElementType.Text && drawableElement.getType() != ElementType.TextInfo || textOnly && !ignoreRotation && Math.abs(drawableElement.getRotation()) > 0.01) continue;
                if (object2 == null) {
                    object2 = new b(drawableElement, toleranceRatio, ignoreRotation);
                    d2 = drawableElement.getY();
                    continue;
                }
                if (drawableElement.getY() == d2) {
                    ((b)object2).addElement(drawableElement);
                    continue;
                }
                b2 = new b(drawableElement, toleranceRatio, ignoreRotation);
                d2 = drawableElement.getY();
                ((b)object2).c(b2);
                b2.a((b)object2);
                arrayList2.add(object2);
                object2 = b2;
            }
            if (object2 != null) {
                b b3;
                arrayList2.add(object2);
                TreeSet<b> treeSet = new TreeSet<b>();
                treeSet.addAll(arrayList2);
                boolean bl = false;
                b2 = (b)treeSet.first();
                while (b2.di() < toleranceRatio) {
                    b3 = b2.dj();
                    ElementSorter.a(b2, b3, treeSet);
                    b2 = (b)treeSet.first();
                    bl = true;
                }
                arrayList2.clear();
                arrayList2.addAll(treeSet);
                Collections.sort(arrayList2, tz);
                b2 = (b)arrayList2.get(0);
                while (b2 != null) {
                    if (b2.dn() || b2.do()) {
                        ElementSorter.a(b2, b2.dj(), treeSet);
                        bl = true;
                        continue;
                    }
                    for (b3 = b2.dj(); b3 != null && b3.tG - b3.tH < b2.tG; b3 = b3.dj()) {
                        if (!b2.d(b3)) continue;
                        ElementSorter.a(b2, b3, treeSet);
                    }
                    b2 = b2.dj();
                }
                if (treeSet.size() != arrayList2.size()) {
                    arrayList2.clear();
                    arrayList2.addAll(treeSet);
                    Collections.sort(arrayList2, tz);
                }
                if (bl) {
                    for (b3 = (b)arrayList2.get(0); b3 != null; b3 = b3.dj()) {
                        b3.v(textOnly);
                    }
                }
            }
            try {
                Collections.sort(list, YX_COMPARATOR);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                PDFCCore.LOGGER_COMPARE.error((Object)"Element sorting failed most likely because of the tolerance in X/Y space.");
                PDFCCore.LOGGER_COMPARE.debug((Object)illegalArgumentException);
                if (!"true".equals(System.getProperty("checkcomparator"))) break block17;
                ElementSorter.x(list);
                throw illegalArgumentException;
            }
        }
        if (arrayList != null) {
            arrayList.forEach(c::reset);
        }
    }

    private static void a(b b2, b b3, SortedSet<b> sortedSet) {
        sortedSet.remove(b2);
        sortedSet.remove(b3);
        b2.b(b3);
        if (b3.tK != null) {
            b3.tK.c(b3.tJ);
        }
        if (b3.tJ != null) {
            b3.tJ.a(b3.tK);
        }
        ElementSorter.a(b2, sortedSet);
        if (b3.tK != b2) {
            ElementSorter.a(b3.tK, sortedSet);
        }
        sortedSet.add(b2);
    }

    private static void a(b b2, SortedSet<b> sortedSet) {
        if (b2.tK != null && b2.tN && b2.tK.tN) {
            sortedSet.remove(b2.tK);
            b2.tK.dh();
            sortedSet.add(b2.tK);
        }
    }

    private static <T extends DrawableElement> void x(List<T> list) {
        int n;
        int n2;
        int n3;
        DrawableElement drawableElement;
        DrawableElement drawableElement2;
        DrawableElement drawableElement3;
        int n4;
        int n5;
        for (n5 = 0; n5 < list.size(); ++n5) {
            for (n4 = 0; n4 < list.size(); ++n4) {
                DrawableElement drawableElement4 = (DrawableElement)list.get(n5);
                if (YX_COMPARATOR.compare(drawableElement4, drawableElement3 = (DrawableElement)list.get(n4)) == -YX_COMPARATOR.compare(drawableElement3, drawableElement4) || !PDFCCore.LOGGER_COMPARE.isDebug()) continue;
                PDFCCore.LOGGER_COMPARE.debug((Object)("Rule#1 failed for " + String.valueOf(drawableElement4) + " and " + String.valueOf(drawableElement3)));
            }
        }
        for (n5 = 0; n5 < list.size(); ++n5) {
            for (n4 = 0; n4 < list.size(); ++n4) {
                for (int i = 0; i < list.size(); ++i) {
                    drawableElement3 = (DrawableElement)list.get(n5);
                    drawableElement2 = (DrawableElement)list.get(n4);
                    drawableElement = (DrawableElement)list.get(i);
                    n3 = (int)Math.signum(YX_COMPARATOR.compare(drawableElement3, drawableElement2));
                    n2 = (int)Math.signum(YX_COMPARATOR.compare(drawableElement2, drawableElement));
                    n = (int)Math.signum(YX_COMPARATOR.compare(drawableElement3, drawableElement));
                    if (n3 <= 0 || n2 <= 0 || n > 0 || !PDFCCore.LOGGER_COMPARE.isDebug()) continue;
                    PDFCCore.LOGGER_COMPARE.debug((Object)("Rule#2 failed for " + String.valueOf(drawableElement3) + ", " + String.valueOf(drawableElement2) + " and " + String.valueOf(drawableElement)));
                }
            }
        }
        for (n5 = 0; n5 < list.size(); ++n5) {
            for (n4 = 0; n4 < list.size(); ++n4) {
                for (int i = 0; i < list.size(); ++i) {
                    drawableElement3 = (DrawableElement)list.get(n5);
                    drawableElement2 = (DrawableElement)list.get(n4);
                    drawableElement = (DrawableElement)list.get(i);
                    n3 = (int)Math.signum(YX_COMPARATOR.compare(drawableElement3, drawableElement2));
                    n2 = (int)Math.signum(YX_COMPARATOR.compare(drawableElement2, drawableElement));
                    n = (int)Math.signum(YX_COMPARATOR.compare(drawableElement3, drawableElement));
                    if (n3 != 0 || n2 == n || !PDFCCore.LOGGER_COMPARE.isDebug()) continue;
                    PDFCCore.LOGGER_COMPARE.debug((Object)("Rule#3 failed for " + String.valueOf(drawableElement3) + ", " + String.valueOf(drawableElement2) + " and " + String.valueOf(drawableElement)));
                }
            }
        }
    }

    private static double v(DrawableElement drawableElement) {
        if (drawableElement.getType() == ElementType.Text) {
            return ((TextElement)drawableElement).getStyle().getWsWidthScaled();
        }
        if (drawableElement.getType() == ElementType.TextWord) {
            return (int)((WordElement)drawableElement).getStyle().getWsWidthScaled();
        }
        return 0.0;
    }

    private static class c {
        private DrawableElement element;
        private double y;

        public c(DrawableElement drawableElement) {
            this.element = drawableElement;
            this.y = drawableElement.getY();
        }

        public void reset() {
            this.element.setY(this.y);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class b
    implements Comparable<b> {
        private List<DrawableElement> fo = new ArrayList<DrawableElement>();
        private double tG;
        private double tH;
        private double tI;
        private b tJ;
        private b tK;
        private double tL = 2.147483647E9;
        private boolean tM;
        private boolean tN;
        private double tO;
        private boolean tP;
        private double tQ;

        private b(DrawableElement drawableElement, double d2, boolean bl) {
            this.tO = d2;
            this.tP = bl;
            this.fo.add(drawableElement);
            this.tN = this.x(drawableElement);
            this.tG = drawableElement.getY();
            this.tH = this.w(drawableElement);
            this.tI = drawableElement.getBounds().getWidth();
            this.tQ = LocationUtils.getNormedBounds(drawableElement).getMinY();
        }

        public void a(b b2) {
            this.tK = b2;
        }

        public void dh() {
            this.tL = this.dl();
        }

        private double w(DrawableElement drawableElement) {
            List<DrawableElement> list;
            switch (drawableElement.getType()) {
                case Text: {
                    if (drawableElement.getLabel().isBlank()) {
                        return 1.0;
                    }
                    if (!this.tP && Math.abs(((TextElement)drawableElement).getRotation()) > 1.0) {
                        return Math.abs(drawableElement.getBounds().getWidth());
                    }
                    return Math.abs(drawableElement.getBounds().getHeight());
                }
                case TextWord: {
                    if (drawableElement.getLabel().isBlank()) {
                        return 1.0;
                    }
                    if (!this.tP && Math.abs(((WordElement)drawableElement).getStyle().getRotation()) > 1.0) {
                        return Math.abs(drawableElement.getBounds().getWidth());
                    }
                    return Math.abs(drawableElement.getBounds().getHeight());
                }
                case TextInfo: {
                    if (!this.tP && Math.abs(((TextInfo)((Object)drawableElement)).getRotation()) > 1.0) {
                        return Math.abs(drawableElement.getBounds().getWidth());
                    }
                    return Math.abs(drawableElement.getBounds().getHeight());
                }
                case Line: 
                case LineHorizontal: 
                case LineVertical: 
                case Curve: {
                    GeomShape geomShape = (GeomShape)drawableElement;
                    if (geomShape.getStroke() == null || geomShape.getStrokePaint() == null) break;
                    Rectangle2D rectangle2D = geomShape.getBounds();
                    double d2 = Math.sqrt(rectangle2D.getWidth() * rectangle2D.getWidth() + rectangle2D.getHeight() * rectangle2D.getHeight());
                    double d3 = Math.max(1.0, Math.sqrt((double)geomShape.getStroke().getLineWidth() * d2 / 100.0));
                    return d3;
                }
            }
            if (drawableElement.getType().isStructuralType() && (list = ((StructureElement)drawableElement).getChildren()) != null && list.size() > 0) {
                double d4 = 0.0;
                for (DrawableElement drawableElement2 : list) {
                    d4 = Math.max(d4, this.w(drawableElement2));
                }
                return d4;
            }
            return 1.0;
        }

        public double di() {
            return this.tL;
        }

        public void addElement(DrawableElement e2) {
            this.tN |= this.x(e2);
            this.tH = Math.max(this.tH, this.w(e2));
            this.tI += e2.getBounds().getWidth();
            this.fo.add(e2);
        }

        public b dj() {
            return this.tJ;
        }

        public void v(boolean bl) {
            boolean bl2 = false;
            boolean bl3 = false;
            for (DrawableElement object : this.fo) {
                if (!this.x(object)) continue;
                bl2 = !bl;
                bl3 = true;
                break;
            }
            if (!bl3) {
                return;
            }
            if (bl2 || bl) {
                Iterator<DrawableElement> iterator = new ArrayList();
                for (DrawableElement drawableElement : this.fo) {
                    if (!this.x(drawableElement)) continue;
                    iterator.add(drawableElement);
                }
                Collections.sort(iterator, X_COMPARATOR);
                double d2 = this.dk();
                double d3 = 0.15 * d2;
                boolean bl4 = false;
                RectangularShape rectangularShape = null;
                for (int i = 0; i < iterator.size(); ++i) {
                    DrawableElement drawableElement = (DrawableElement)iterator.get(i);
                    if (drawableElement.getLabel().isBlank()) continue;
                    Rectangle2D rectangle2D = LocationUtils.getNormedBounds(drawableElement);
                    double d4 = rectangularShape != null ? rectangle2D.getX() - rectangularShape.getMaxX() : Double.MAX_VALUE;
                    double d5 = -ElementSorter.v(drawableElement) / 4.0;
                    if (d4 < this.tH && d4 > d5) {
                        if (bl4 || Math.abs(rectangularShape.getMinY() - rectangle2D.getMinY()) > d3 || Math.abs(rectangularShape.getMaxY() - rectangle2D.getMaxY()) > d3) {
                            DrawableElement drawableElement2;
                            bl4 = this.a(d2, d3, drawableElement, rectangle2D);
                            if (i == 1 && (!(drawableElement2 = (DrawableElement)iterator.get(0)).getLabel().isBlank() && drawableElement2.getLabel().length() > 1 || d4 < this.tH / 2.0)) {
                                this.a(d2, d3, drawableElement2, (Rectangle2D)rectangularShape);
                            }
                        }
                    } else {
                        bl4 = false;
                    }
                    rectangularShape = rectangle2D;
                }
            }
            if (!this.tM) {
                return;
            }
            for (DrawableElement drawableElement : this.fo) {
                if (this.x(drawableElement) || drawableElement.getType() == ElementType.Annotation && ((AnnotationElement)drawableElement).isLinkedToText()) {
                    drawableElement.setY(this.tG);
                    continue;
                }
                if (bl) continue;
                if (bl2) {
                    drawableElement.setY(this.tG + (drawableElement.getY() < this.tG ? -0.05 : 0.05));
                    continue;
                }
                drawableElement.setY(this.tG);
            }
        }

        private boolean a(double d2, double d3, DrawableElement drawableElement, Rectangle2D rectangle2D) {
            boolean bl = true;
            if (drawableElement.getBounds().getHeight() < 0.0) {
                if (this.tG - drawableElement.getY() > d3) {
                    this.y(drawableElement);
                } else if (rectangle2D.getMinY() - (this.tG - d2) > d3) {
                    this.z(drawableElement);
                } else {
                    bl = false;
                }
            } else if (this.tG + d2 - rectangle2D.getMaxX() > d3) {
                this.y(drawableElement);
            } else if (rectangle2D.getMinY() - this.tG > d3) {
                this.z(drawableElement);
            } else {
                bl = false;
            }
            return bl;
        }

        private double dk() {
            double d2 = 0.0;
            int n = 0;
            for (DrawableElement drawableElement : this.fo) {
                if (!this.x(drawableElement)) continue;
                n += drawableElement.getLabel().length();
                d2 += Math.abs(drawableElement.getBounds().getHeight()) * (double)drawableElement.getLabel().length();
            }
            return d2 / (double)n;
        }

        private boolean x(DrawableElement drawableElement) {
            return drawableElement.getType() == ElementType.TextWord || drawableElement.getType() == ElementType.Text || drawableElement.getType() == ElementType.TextInfo;
        }

        private void y(DrawableElement drawableElement) {
            if (drawableElement instanceof TextElement) {
                ((TextElement)drawableElement).getStyle().setSuperscript();
            }
            if (drawableElement instanceof WordElement) {
                ((WordElement)drawableElement).getStyle().setSuperscript();
            }
        }

        private void z(DrawableElement drawableElement) {
            if (drawableElement instanceof TextElement) {
                ((TextElement)drawableElement).getStyle().setSubscript();
            }
            if (drawableElement instanceof WordElement) {
                ((WordElement)drawableElement).getStyle().setSubscript();
            }
        }

        public void b(b b2) {
            if (b2 == null) {
                return;
            }
            double d2 = this.y(this.fo);
            double d3 = this.y(this.tJ.fo);
            this.tG = (this.tG * d2 + b2.tG * d3) / (d2 + d3);
            this.fo.addAll(b2.fo);
            this.tI = this.fo.stream().mapToDouble(drawableElement -> drawableElement.getBounds().getWidth()).sum();
            this.tN |= b2.tN;
            this.tH = Math.max(this.tH, this.tJ.tH);
            this.tJ = b2.tJ;
            this.tL = this.dl();
            this.tM = true;
        }

        private double y(List<DrawableElement> list) {
            double d2 = 0.0;
            block3: for (DrawableElement drawableElement : list) {
                switch (drawableElement.getType()) {
                    case Text: 
                    case TextWord: {
                        double d3 = Math.abs(drawableElement.getBounds().getHeight());
                        d2 += (double)drawableElement.getLabel().length() * d3;
                        continue block3;
                    }
                }
                if (drawableElement.getType().isStructuralType() && drawableElement instanceof StructureElement) {
                    d2 += this.y(((StructureElement)drawableElement).getChildren());
                    continue;
                }
                d2 += 1.0;
            }
            return d2;
        }

        private void c(b b2) {
            this.tJ = b2;
            this.tL = this.dl();
        }

        private double dl() {
            if (this.tJ == null) {
                return 2.147483647E9;
            }
            double d2 = this.tH == 1.0 ? Math.max(0.1, this.tJ.tH) : (this.tJ.tH == 1.0 ? Math.max(0.1, this.tH) : (this.fo.size() < this.tJ.fo.size() ? this.tJ.tH : (this.fo.size() > this.tJ.fo.size() ? this.tH : (this.tH + this.tJ.tH) / 2.0)));
            double d3 = Math.abs((this.tG - this.tJ.tG) / d2);
            if (d3 > this.tO && this.d(this.tJ)) {
                return 0.0;
            }
            return d3;
        }

        public boolean d(b b2) {
            if (b2 != null && this.tN && b2.tN) {
                Rectangle2D rectangle2D = this.dm();
                Rectangle2D rectangle2D2 = b2.dm();
                if (rectangle2D != null && rectangle2D2 != null && rectangle2D.intersects(rectangle2D2)) {
                    ArrayList<a> arrayList = new ArrayList<a>();
                    for (DrawableElement object : this.fo) {
                        if (!this.x(object)) continue;
                        arrayList.add(new a(object, 1));
                    }
                    for (DrawableElement drawableElement : b2.fo) {
                        if (!this.x(drawableElement)) continue;
                        arrayList.add(new a(drawableElement, 2));
                    }
                    Collections.sort(arrayList);
                    for (int i = 0; i < arrayList.size() - 1; ++i) {
                        a a2;
                        a a3 = (a)arrayList.get(i);
                        for (int j = i + 1; j < arrayList.size() && a3.b(a2 = (a)arrayList.get(j)); ++j) {
                            if (!a3.a(a2)) continue;
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        private Rectangle2D dm() {
            Rectangle2D rectangle2D = null;
            for (DrawableElement drawableElement : this.fo) {
                if (drawableElement.getType() != ElementType.Text && drawableElement.getType() != ElementType.TextWord) continue;
                if (rectangle2D == null) {
                    rectangle2D = this.getBounds(drawableElement);
                    continue;
                }
                Rectangle2D.union(rectangle2D, this.getBounds(drawableElement), rectangle2D);
            }
            return rectangle2D;
        }

        private Rectangle2D getBounds(DrawableElement e2) {
            Rectangle2D rectangle2D = e2.getBounds();
            double d2 = ElementSorter.v(e2);
            if (rectangle2D.getMaxY() < rectangle2D.getMinY()) {
                return new Rectangle2D.Double(rectangle2D.getMinX() - d2, rectangle2D.getMaxY(), rectangle2D.getWidth() + d2 * 2.0, rectangle2D.getMinY() - rectangle2D.getMaxY());
            }
            return new Rectangle2D.Double(rectangle2D.getX() - d2, rectangle2D.getY(), rectangle2D.getWidth() + d2 * 2.0, rectangle2D.getHeight());
        }

        private static boolean b(b b2, b b3) {
            b b4;
            b b5 = b4 = b2.tG < b3.tG ? b2 : b3;
            if (b4.tL > 0.85 || b3.fo.size() / b2.fo.size() < 1 || b3.tI / b2.tI < 2.0 || b2.tM || b3.tH < b2.tH || b4.tQ + b4.tH < b4.tJ.tQ || !b2.tN) {
                return false;
            }
            double d2 = b3.tH / 3.0;
            boolean bl = false;
            for (DrawableElement drawableElement : b2.fo) {
                TextElement textElement;
                if (drawableElement.getType() != ElementType.Text || (textElement = (TextElement)drawableElement).getText().trim().length() == 0) continue;
                Rectangle2D rectangle2D = drawableElement.getBounds();
                double d3 = rectangle2D.getMinX();
                double d4 = rectangle2D.getMaxX();
                boolean bl2 = false;
                for (DrawableElement drawableElement2 : b3.fo) {
                    Rectangle2D rectangle2D2;
                    TextElement textElement2;
                    if (drawableElement2.getType() != ElementType.Text || (textElement2 = (TextElement)drawableElement2).getFontSize() <= textElement.getFontSize() || !(d4 + d2 > (rectangle2D2 = drawableElement2.getBounds()).getMinX()) || !(d3 < rectangle2D2.getMaxX() + d2) || textElement2.getText().trim().length() <= 0) continue;
                    bl2 = true;
                    bl = true;
                    break;
                }
                if (bl2) continue;
                return false;
            }
            return bl;
        }

        private boolean dn() {
            if (this.tJ == null) {
                return false;
            }
            boolean bl = b.b(this.tJ, this);
            if (bl) {
                this.tJ.dp();
            }
            return bl;
        }

        private boolean do() {
            if (this.tJ == null) {
                return false;
            }
            boolean bl = b.b(this, this.tJ);
            if (bl) {
                this.dp();
            }
            return bl;
        }

        private void dp() {
            for (DrawableElement drawableElement : this.fo) {
                if (!(drawableElement instanceof TextElement)) continue;
                ((TextElement)drawableElement).setIndex(true);
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (DrawableElement drawableElement : this.fo) {
                if (drawableElement.getType() == ElementType.Text || drawableElement.getType() == ElementType.TextWord) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(drawableElement.getType() == ElementType.Text ? ((TextElement)drawableElement).getText() : ((WordElement)drawableElement).getLabel());
                    continue;
                }
                stringBuilder.append('[').append(drawableElement.getType().name()).append("] ");
            }
            if (stringBuilder.length() == 0) {
                stringBuilder.append(this.fo.get(0).toString());
            }
            return "Line @" + new DecimalFormat("0.##").format(this.tG) + " = " + stringBuilder.toString() + " (ratio=" + this.tL + ")";
        }

        public int e(b b2) {
            int n = Double.compare(this.tL, b2.tL);
            if (n == 0) {
                int n2 = Double.compare(this.tG, b2.tG);
                if (n2 != 0) {
                    return n2;
                }
                DrawableElement drawableElement = this.fo.get(0);
                DrawableElement drawableElement2 = b2.fo.get(0);
                return drawableElement.getElementID().compareTo(drawableElement2.getElementID());
            }
            return n;
        }

        @Override
        public /* synthetic */ int compareTo(Object object) {
            return this.e((b)object);
        }
    }

    private static class a
    implements Comparable<a> {
        private DrawableElement tA;
        private int tB;
        private double wsWidth;
        private double tC;
        private double tD;
        private double tE;
        private double tF;

        public a(DrawableElement drawableElement, int n) {
            this.tA = drawableElement;
            this.tB = n;
            this.wsWidth = ElementSorter.v(drawableElement);
            Rectangle2D rectangle2D = drawableElement.getBounds();
            this.tD = rectangle2D.getMaxX();
            this.tC = drawableElement.getX();
            this.tE = LocationUtils.getMinY(rectangle2D);
            this.tF = LocationUtils.getMaxY(rectangle2D);
        }

        public boolean a(a a2) {
            if (a2.tB == this.tB) {
                return false;
            }
            Point2D.Double double_ = new Point2D.Double(this.tD, 0.0);
            Point2D.Double double_2 = new Point2D.Double(a2.tC, 0.0);
            if (TextModuleUtils.canJoinOnOneWord(Math.min(this.wsWidth, a2.wsWidth), double_, double_2)) {
                double d2 = Math.min(this.tF, a2.tF) - Math.max(this.tE, a2.tE);
                return !(d2 < (this.tF - this.tE) / 2.0) || !(d2 < (a2.tF - a2.tE) / 2.0);
            }
            return false;
        }

        public boolean b(a a2) {
            return a2.tC < this.tD + 2.0 * this.wsWidth;
        }

        public int c(a a2) {
            return Double.compare(this.tA.getX(), a2.tA.getX());
        }

        public String toString() {
            return this.tA.getLabel() + "#" + this.tB;
        }

        @Override
        public /* synthetic */ int compareTo(Object object) {
            return this.c((a)object);
        }
    }
}

