/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.util;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.generator.model.forms.GeomShape;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.HasBounds;
import com.inet.pdfc.model.ShapeElement;
import com.inet.pdfc.util.ElementSorter;
import com.inet.pdfc.util.LocationUtils;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

@InternalApi
public class ElementSearch<T extends DrawableElement> {
    public static final double SEARCH_AREA_TOLERANCE = 0.5;
    private int tr;
    private boolean ts;
    private a<T> tt;
    private List<T> tu = new ArrayList<T>();
    private double tv = 0.5;

    public ElementSearch(@Nonnull Rectangle2D pageArea) {
        this(pageArea, 25);
    }

    public ElementSearch(@Nonnull Rectangle2D pageArea, int nodeSize) {
        this.tr = nodeSize;
        this.tt = new a(pageArea.getX() - 0.25, pageArea.getY() - 0.25, pageArea.getWidth() + 0.5, pageArea.getHeight() + 0.5, 0);
    }

    public ElementSearch<T> setSkipBogusElements() {
        this.ts = true;
        return this;
    }

    public void setSearchAreaTolerance(double tolerance) {
        this.tv = tolerance;
    }

    public void add(@Nonnull T element) {
        this.tu.add(element);
    }

    public ElementSearch<T> addAll(@Nonnull @Nonnull List<@Nonnull T> elements) {
        this.tu.addAll(elements);
        return this;
    }

    private void df() {
        if (this.tu.isEmpty()) {
            return;
        }
        for (DrawableElement drawableElement : this.tu) {
            this.tt.add(drawableElement);
        }
        this.tu = new ArrayList<T>();
    }

    private Rectangle2D a(HasBounds hasBounds) {
        Rectangle2D rectangle2D = LocationUtils.getNormedBounds(hasBounds);
        return rectangle2D != null ? this.c(rectangle2D) : null;
    }

    private Rectangle2D c(Rectangle2D rectangle2D) {
        if (rectangle2D.getWidth() != 0.0 && rectangle2D.getHeight() != 0.0) {
            return rectangle2D;
        }
        return new Rectangle2D.Double(rectangle2D.getX() - 0.25, rectangle2D.getY() - 0.25, rectangle2D.getWidth() + 0.5, rectangle2D.getHeight() + 0.5);
    }

    @Nonnull
    public @Nonnull Collection<@Nonnull T> getElementsInArea(Rectangle2D requestArea) {
        return this.getElementsInArea(requestArea, false);
    }

    @Nonnull
    public @Nonnull Collection<@Nonnull T> getElementsInArea(Rectangle2D requestArea, boolean containedOnly) {
        this.df();
        double d2 = this.tv;
        Rectangle2D.Double double_ = new Rectangle2D.Double(requestArea.getX() - d2, requestArea.getY() - d2, requestArea.getWidth() + d2 * 2.0, requestArea.getHeight() + d2 * 2.0);
        LinkedHashSet<@Nonnull E> linkedHashSet = new LinkedHashSet();
        HashSet<@Nonnull E> hashSet = new HashSet();
        this.tt.a(double_, linkedHashSet, hashSet, containedOnly);
        return linkedHashSet;
    }

    @Nonnull
    public @Nonnull List<@Nonnull T> getElementsInAreaAsList(Rectangle2D requestArea, boolean sort) {
        ArrayList<@Nonnull T> arrayList = new ArrayList<T>(this.getElementsInArea(requestArea));
        if (sort) {
            Collections.sort(arrayList, ElementSorter.YX_COMPARATOR);
        }
        return arrayList;
    }

    @Nonnull
    public @Nonnull List<@Nonnull T> getElementsInAreaAsList(double x, double y, double width, double height, boolean sort) {
        return this.getElementsInAreaAsList(x, y, width, height, sort, false);
    }

    @Nonnull
    public @Nonnull List<@Nonnull T> getElementsInAreaAsList(double x, double y, double width, double height, boolean sort, boolean containedOnly) {
        @Nonnull ArrayList<@Nonnull T> arrayList = new ArrayList<T>(this.getElementsInArea(new Rectangle2D.Double(x, y, width, height), containedOnly));
        if (sort) {
            Collections.sort(arrayList, ElementSorter.YX_COMPARATOR);
        }
        return arrayList;
    }

    public void remove(T e2) {
        if (!this.tu.isEmpty() && this.tu.remove(e2)) {
            return;
        }
        this.tt.remove(e2);
    }

    protected boolean isBogusElement(DrawableElement e2) {
        switch (e2.getType()) {
            case Shape: {
                Paint paint;
                ShapeElement shapeElement = (ShapeElement)e2;
                if (shapeElement.getIsClip()) {
                    return true;
                }
                if (shapeElement.getStroke() != null && shapeElement.getStrokePaint() != null || !Color.WHITE.equals(paint = shapeElement.getFillPaint()) && (!(paint instanceof Color) || ((Color)paint).getAlpha() >= 5)) break;
                return true;
            }
            case TextWord: 
            case Text: {
                return e2.getLabel() == null || e2.getLabel().trim().length() == 0;
            }
        }
        return false;
    }

    private class a<E extends DrawableElement>
    extends Rectangle2D.Double {
        private List<E> fo;
        private int tw;
        private int tx;
        private List<a<E>> children;

        public a(double d2, double d3, double d4, double d5, int n) {
            super(d2, d3, d4, d5);
            this.fo = null;
            this.tw = 0;
            this.tx = 1;
            this.children = null;
            this.tx = n + 1;
        }

        public void a(Rectangle2D rectangle2D, Set<E> set, Set<E> set2, boolean bl) {
            block6: {
                block5: {
                    if (!this.intersects(rectangle2D)) {
                        return;
                    }
                    if (this.fo == null) break block5;
                    for (DrawableElement drawableElement : this.fo) {
                        if (set.contains(drawableElement) || set2.contains(drawableElement)) continue;
                        if (!bl && this.a(drawableElement, ElementSearch.this.a(drawableElement), rectangle2D)) {
                            set.add(drawableElement);
                            continue;
                        }
                        if (bl && this.b(drawableElement, ElementSearch.this.a(drawableElement), rectangle2D)) {
                            set.add(drawableElement);
                            continue;
                        }
                        set2.add(drawableElement);
                    }
                    break block6;
                }
                if (this.children == null) break block6;
                for (a<DrawableElement> a2 : this.children) {
                    a2.a(rectangle2D, set, set2, bl);
                }
            }
        }

        public void add(E e2) {
            if (ElementSearch.this.ts && ElementSearch.this.isBogusElement((DrawableElement)e2)) {
                return;
            }
            Rectangle2D rectangle2D = ElementSearch.this.a((HasBounds)e2);
            if (rectangle2D != null) {
                this.c(e2, rectangle2D);
            }
        }

        public void remove(E e2) {
            this.b(e2, ElementSearch.this.a((HasBounds)e2));
        }

        private boolean b(E e2, Rectangle2D rectangle2D) {
            if (!this.d((DrawableElement)e2, rectangle2D)) {
                return this.fo == null || this.fo.isEmpty();
            }
            if (this.children != null) {
                boolean bl = true;
                for (a<E> a2 : this.children) {
                    bl &= a2.b(e2, rectangle2D);
                }
                if (bl) {
                    this.children = null;
                }
                return bl;
            }
            if (this.fo != null) {
                this.fo.remove(e2);
                if (rectangle2D.contains(this)) {
                    --this.tw;
                }
                if (this.fo.isEmpty()) {
                    this.fo = null;
                    return true;
                }
                return false;
            }
            return true;
        }

        private void c(E e2, Rectangle2D rectangle2D) {
            if (this.children != null) {
                this.e(e2, rectangle2D);
                return;
            }
            if (this.fo == null) {
                this.fo = new ArrayList();
            }
            if (rectangle2D.contains(this)) {
                ++this.tw;
            }
            this.fo.add(e2);
            if (this.fo.size() > ElementSearch.this.tr && this.tw < this.fo.size()) {
                this.dg();
            }
        }

        public boolean d(DrawableElement drawableElement, Rectangle2D rectangle2D) {
            if (rectangle2D == null) {
                rectangle2D = ElementSearch.this.a(drawableElement);
            }
            return this.a(drawableElement, rectangle2D, this);
        }

        private boolean a(DrawableElement drawableElement, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
            if (!rectangle2D2.intersects(rectangle2D)) {
                return false;
            }
            if (drawableElement instanceof GeomShape) {
                GeomShape geomShape = (GeomShape)drawableElement;
                Shape shape = geomShape.getShape();
                return shape.intersects(rectangle2D2);
            }
            return true;
        }

        private boolean b(DrawableElement drawableElement, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
            return rectangle2D2.contains(rectangle2D);
        }

        public void dg() {
            if (this.tx >= 6) {
                return;
            }
            this.children = new ArrayList<a<E>>();
            double d2 = this.width / 2.0;
            double d3 = this.height / 2.0;
            this.children.add(new a<E>(this.x, this.y, d2, d3, this.tx));
            this.children.add(new a<E>(this.x + d2, this.y, d2, d3, this.tx));
            this.children.add(new a<E>(this.x, this.y + d3, d2, d3, this.tx));
            this.children.add(new a<E>(this.x + d2, this.y + d3, d2, d3, this.tx));
            for (DrawableElement drawableElement : this.fo) {
                this.e(drawableElement, ElementSearch.this.a(drawableElement));
            }
            this.fo = null;
        }

        protected void e(E e2, Rectangle2D rectangle2D) {
            for (a<E> a2 : this.children) {
                if (!a2.d((DrawableElement)e2, rectangle2D)) continue;
                a2.c(e2, rectangle2D);
            }
        }
    }
}

