/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.print;

import com.inet.annotations.InternalApi;
import com.inet.logging.Logger;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.presenter.ExportFilePresenter;
import com.inet.pdfc.print.PrintPainter;
import com.inet.pdfc.print.PrintToX;
import com.inet.pdfc.results.ResultModel;
import com.inet.pdfc.results.ResultPage;
import com.inet.pdfc.util.Pair;
import com.inet.pdfc.util.a;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;

@InternalApi
public abstract class PrintToPng
extends PrintToX
implements ExportFilePresenter.HasPrintRange {
    private static final Logger LOGGER = PDFCCore.LOGGER_PRESENTER;
    @Nonnull
    public static final FontRenderContext IMAGE_CONTEXT;
    private int oQ = 1000;
    private int oR = 1500;
    private int pk = -1;
    private int pl = -1;
    private boolean qX = false;
    private int qY = 0;
    private int qZ = 0;

    public PrintToPng(PrintPainter painter) {
        super(painter);
        ResultModel resultModel = painter.getModel();
        Pair<Integer> pair = a.b(resultModel);
        this.qY = pair.get(true);
        this.qZ = pair.get(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export() throws IOException {
        this.qX = false;
        PrintPainter printPainter = this.getPainter();
        boolean bl = printPainter.isAutoSize();
        int n = printPainter.calculatePages(this.oQ, this.oR, IMAGE_CONTEXT);
        if (this.pl >= n || this.pk > this.pl) {
            throw new IllegalStateException("Invalid page range. From=" + this.pk + " To=" + this.pl + " but page count is " + n);
        }
        int n2 = this.pk == -1 ? 0 : this.pk;
        int n3 = n;
        if (this.pl != -1) {
            n3 = this.pl + 1;
        }
        int n4 = n3 - n2;
        try (ZipOutputStream zipOutputStream = null;){
            Object object = null;
            Object object2 = null;
            int n5 = 0;
            while (n2 < n3) {
                Object object3;
                Object object4;
                Pair<ResultPage> pair;
                int n6 = this.oQ;
                int n7 = this.oR;
                if (bl) {
                    pair = printPainter.getPages(n2);
                    if (pair != null) {
                        if (printPainter.isOneSideExport()) {
                            object4 = pair.get(true) != null ? pair.get(true) : pair.get(false);
                            n6 = ((ResultPage)object4).getWidth();
                            n7 = ((ResultPage)object4).getHeight() + printPainter.getHeaderAndFooterSize(n6);
                        } else {
                            object4 = pair.get(true);
                            object3 = pair.get(false);
                            if (object4 == null) {
                                Object object5 = object4 = object != null ? object : object3;
                            }
                            if (object3 == null) {
                                object3 = object2 != null ? object2 : object4;
                            }
                            int n8 = Math.max(((ResultPage)object4).getHeight(), ((ResultPage)object3).getHeight());
                            n6 = ((ResultPage)object4).getWidth() + ((ResultPage)object3).getWidth() + 30 + 4;
                            n7 = n8 + printPainter.getHeaderAndFooterSize(n6) + 2;
                            object = object4;
                            object2 = object3;
                        }
                        printPainter.setPageSize(n6, n7);
                        printPainter.setScale(1.0);
                    }
                } else {
                    printPainter.setPageSize(n6, n7);
                }
                this.fireNextPage(n5, n4, n2, n);
                pair = new BufferedImage(n6, n7, 2);
                object4 = ((BufferedImage)((Object)pair)).createGraphics();
                object3 = printPainter.getBackgroundColor();
                if (object3 != null) {
                    ((Graphics)object4).setColor((Color)object3);
                    ((Graphics)object4).fillRect(0, 0, ((BufferedImage)((Object)pair)).getWidth(), ((BufferedImage)((Object)pair)).getHeight());
                }
                printPainter.print((Graphics2D)object4, n2);
                if (this.qX) {
                    return;
                }
                if (n4 == 1) {
                    OutputStream outputStream = this.getOutputStream();
                    ImageIO.write((RenderedImage)((Object)pair), "PNG", outputStream);
                    outputStream.close();
                } else {
                    zipOutputStream = this.a((BufferedImage)((Object)pair), n5, zipOutputStream);
                }
                ++n2;
                ++n5;
            }
        }
        this.fireFinish();
    }

    private ZipOutputStream a(BufferedImage bufferedImage, int n, ZipOutputStream zipOutputStream) throws IOException {
        if (zipOutputStream == null) {
            zipOutputStream = new ZipOutputStream(this.getOutputStream());
        }
        Object object = this.getResultDocumentName();
        if (n > 0) {
            object = (String)object + "_" + n;
        }
        object = (String)object + ".png";
        zipOutputStream.putNextEntry(new ZipEntry((String)object));
        ImageIO.write((RenderedImage)bufferedImage, "PNG", zipOutputStream);
        zipOutputStream.closeEntry();
        return zipOutputStream;
    }

    @Override
    public boolean cancel() {
        this.qX = true;
        return true;
    }

    public void setSize(int width, int height) {
        if (width > this.qY || height > this.qZ) {
            LOGGER.warn((Object)Msg.getMsg("Export.reachMaxSize", this.qY, this.qZ));
        }
        this.oQ = width > this.qY ? this.qY : width;
        this.oR = height > this.qZ ? this.qZ : height;
    }

    @Override
    public void setPrintRange(int from, int to) {
        this.pk = from;
        this.pl = to;
    }

    protected abstract OutputStream getOutputStream() throws IOException;

    static {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        IMAGE_CONTEXT = graphics2D.getFontRenderContext();
        graphics2D.dispose();
    }
}

