/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.presenter.impl.datasource;

import com.inet.annotations.InternalApi;
import com.inet.id.GUID;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.plugin.persistence.ComparePersistence;
import com.inet.pdfc.plugin.persistence.PersistenceFactory;
import com.inet.pdfc.results.ResultModel;
import com.inet.pdfc.util.FileNameUtil;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.ServerPluginManager;
import com.inet.thread.SessionLocal;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class ReportDataProvider {
    private static final SessionLocal<Map<String, ComparisonDataProvider>> qg = new SessionLocal();

    static Map<String, ComparisonDataProvider> cJ() {
        return (Map)qg.get();
    }

    static void a(Map<String, ComparisonDataProvider> map) {
        qg.set(map);
    }

    public static void setResultProviderForSession(Map<String, ComparisonDataProvider> resultProvider) {
        qg.set(resultProvider);
    }

    public static void addResultProviderForSession(String id, ComparisonDataProvider resultProvider) {
        Map map = (Map)qg.get();
        HashMap<String, ComparisonDataProvider> hashMap = map != null ? new HashMap<String, ComparisonDataProvider>(map) : new HashMap();
        hashMap.put(id, resultProvider);
        qg.set(hashMap);
    }

    public static boolean hasResultProvider() {
        return qg.get() != null;
    }

    @InternalApi
    public static interface ComparisonDataProvider {
        @Nullable
        public String getTitle();

        public int getDifferencesCount();

        @Nonnull
        public ResultModel getResult();
    }

    @InternalApi
    public static class ResultModelDataProvider
    implements ComparisonDataProvider {
        @Nullable
        private String qh;
        @Nonnull
        private ResultModel oz;

        public ResultModelDataProvider(@Nullable String title, @Nonnull ResultModel result) {
            this.qh = title;
            this.oz = result;
        }

        @Override
        public String getTitle() {
            return this.qh;
        }

        @Override
        public int getDifferencesCount() {
            return this.oz.getDifferencesCount(false);
        }

        @Override
        @Nonnull
        public ResultModel getResult() {
            return this.oz;
        }
    }

    @InternalApi
    public static class ComparePersistenceDataProvider
    implements ComparisonDataProvider {
        private GUID comparisonID;

        public ComparePersistenceDataProvider(GUID comparisonID) {
            this.comparisonID = comparisonID;
        }

        @Override
        @Nullable
        public String getTitle() {
            try {
                ComparePersistence comparePersistence = ((PersistenceFactory)ServerPluginManager.getInstance().getSingleInstance(PersistenceFactory.class)).getPersistence(this.comparisonID);
                if (comparePersistence != null) {
                    String string = comparePersistence.getMetaProperty("title");
                    if (!(string != null && !string.isBlank() || (string = comparePersistence.getMetaProperty("first.name")) != null && string.equals(comparePersistence.getMetaProperty("second.name")))) {
                        string = FileNameUtil.createExportFilename("report", comparePersistence.getMetaProperty("first.name"), comparePersistence.getMetaProperty("second.name"));
                    }
                    return string;
                }
            }
            catch (AccessDeniedException | IOException | IllegalStateException throwable) {
                PDFCCore.LOGGER_PRESENTER.error(throwable);
            }
            return null;
        }

        @Override
        public int getDifferencesCount() {
            try {
                ComparePersistence comparePersistence = ((PersistenceFactory)ServerPluginManager.getInstance().getSingleInstance(PersistenceFactory.class)).getPersistence(this.comparisonID);
                if (comparePersistence != null) {
                    return Integer.parseInt(comparePersistence.getMetaProperty("differences.count"));
                }
            }
            catch (Exception exception) {
                PDFCCore.LOGGER_PRESENTER.error((Throwable)exception);
            }
            return 0;
        }

        @Override
        @Nonnull
        public ResultModel getResult() {
            try {
                ResultModel resultModel;
                ComparePersistence comparePersistence = ((PersistenceFactory)ServerPluginManager.getInstance().getSingleInstance(PersistenceFactory.class)).getPersistence(this.comparisonID);
                if (comparePersistence != null && (resultModel = comparePersistence.getResult()) != null) {
                    return resultModel;
                }
            }
            catch (Exception exception) {
                PDFCCore.LOGGER_PRESENTER.error((Throwable)exception);
            }
            return new ResultModel();
        }
    }
}

