/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.presenter;

import com.inet.annotations.PublicApi;
import com.inet.pdfc.presenter.BasePresenter;
import com.inet.pdfc.print.PrintPainter;
import com.inet.pdfc.results.painter.DifferenceImageCache;
import com.inet.pdfc.results.painter.LayerManager;
import com.inet.pdfc.results.painter.MarkerManager;
import java.awt.Color;

@PublicApi
public abstract class ExportPresenter
extends BasePresenter
implements Cloneable {
    public static final byte PAINT_LEFT = 1;
    public static final byte PAINT_RIGHT = 2;
    public static final byte PAINT_BOTH = 3;
    private Color ns;
    private float po = 0.5f;
    private boolean pp;
    private byte pq = (byte)3;

    protected PrintPainter createAndSetupPrintPainter() {
        MarkerManager markerManager = new MarkerManager(this.getModel());
        markerManager.update();
        LayerManager layerManager = new LayerManager(this.getModel());
        layerManager.updateLayers(false, true);
        DifferenceImageCache differenceImageCache = new DifferenceImageCache(this.getModel());
        PrintPainter printPainter = new PrintPainter(markerManager, layerManager, this.getModel(), differenceImageCache);
        printPainter.setBackgroundColor(this.ns);
        printPainter.setOverlapAlpha(this.po);
        printPainter.setPaintOverlap(this.pp);
        printPainter.setPaintSides(this.pq);
        return printPainter;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.ns = backgroundColor;
    }

    public void setPaintSides(byte sides) {
        this.pq = sides;
    }

    public void setPaintOverlap(boolean paintOverlap) {
        this.pp = paintOverlap;
    }

    public void setOverlapAlpha(float overlapAlpha) {
        if ((double)overlapAlpha > 1.0 || (double)overlapAlpha < 0.0) {
            throw new IllegalArgumentException("OverlapAlpha must be between 0.0 and 1.0 but was " + overlapAlpha);
        }
        this.po = overlapAlpha;
    }
}

