/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.presenter;

import com.inet.annotations.PublicApi;
import com.inet.error.ErrorCode;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.error.PdfcErrorCode;
import com.inet.pdfc.error.PdfcException;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.PagedElement;
import com.inet.pdfc.presenter.BasePresenter;
import com.inet.pdfc.results.ResultPage;
import com.inet.pdfc.results.painter.DiffConstants;
import com.inet.pdfc.util.LocationUtils;
import com.inet.pdfc.util.PdfcImageIO;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.SuppressFBWarnings;

@PublicApi
@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="No files are being read")
public class DifferencesImagePresenter
extends BasePresenter {
    private Boolean oY = null;
    private Boolean oZ = null;
    private Boolean pa = null;
    private Boolean pb = null;
    private Double pc = null;
    private File s;
    private File pd;

    public String getExtensionName() {
        return "Presenter_Image";
    }

    public DifferencesImagePresenter() {
        this.s = new File("differences");
    }

    public DifferencesImagePresenter(File rootFolder) {
        this.s = rootFolder;
    }

    @Override
    public BasePresenter spawn(boolean spawnWithParent) {
        DifferencesImagePresenter differencesImagePresenter = (DifferencesImagePresenter)super.spawn(spawnWithParent);
        differencesImagePresenter.s = this.s;
        differencesImagePresenter.oY = this.oY;
        differencesImagePresenter.oZ = this.oZ;
        differencesImagePresenter.pb = this.pb;
        differencesImagePresenter.pa = this.pa;
        differencesImagePresenter.pc = this.pc;
        return differencesImagePresenter;
    }

    private boolean cu() {
        return this.oY == null ? this.getModel().getSettings().isEnabled(Settings.EXPORT.CREATE_DIFFIMAGES_FIRST) : !Boolean.FALSE.equals(this.oY);
    }

    private boolean cv() {
        return this.oZ == null ? this.getModel().getSettings().isEnabled(Settings.EXPORT.CREATE_DIFFIMAGES_SECOND) : !Boolean.FALSE.equals(this.oZ);
    }

    private boolean cw() {
        return this.pa == null ? this.getModel().getSettings().isEnabled(Settings.EXPORT.CREATE_XORIMAGES) : Boolean.TRUE.equals(this.pa);
    }

    private boolean cx() {
        return this.pb == null ? this.getModel().getSettings().isEnabled(Settings.EXPORT.CREATE_ORIGIMAGES) : Boolean.TRUE.equals(this.pb);
    }

    public void setImageScaleFactor(double scale) {
        if (scale <= 0.0) {
            throw new IllegalArgumentException("An image scale factor or " + scale + " is not allowed. The value has to be > 0");
        }
        this.pc = scale;
    }

    private double getScale() {
        Object object;
        if (this.getModel() != null && (object = this.getModel().getSettings().getSetting(Settings.IMAGE_SCALE_FACTOR.name())) != null) {
            return (Double)object;
        }
        return Math.max(this.pc != null ? this.pc : 1.0, (double)0.01f);
    }

    @Override
    public void onInit() throws Exception {
        if (!(this.cu() || this.cv() || this.cw() || this.cx())) {
            return;
        }
        this.pd = new File(this.s, this.getModel().getComparisonParameters().getFirstFile().getName());
        if (!this.pd.exists()) {
            if (!this.pd.mkdirs() && !this.pd.isDirectory()) {
                throw new IOException(Msg.getMsg("diffimage.error.createtargetdir", this.pd.getAbsolutePath()));
            }
            this.pd.delete();
        }
    }

    @Override
    public void onComparisonDone() throws Exception {
        LOGGER.info((Object)Msg.getMsg("Export.imageTarget", this.s.getAbsoluteFile()));
        if (!(this.cu() || this.cv() || this.cw() || this.cx())) {
            return;
        }
        if (this.getModel().getPageCount(true) > 0 && this.getModel().getPageCount(false) > 0) {
            this.cz();
        }
    }

    private Map<Integer, List<Modification>> cy() {
        HashMap<Integer, List<Modification>> hashMap = new HashMap<Integer, List<Modification>>();
        for (DiffGroup diffGroup : this.getModel().getDifferences(false)) {
            List<Modification> list;
            if (diffGroup.getType() == DiffGroup.GroupType.Sync || (list = diffGroup.getModifications()) == null) continue;
            for (Modification modification : list) {
                this.a(hashMap, modification);
            }
        }
        return hashMap;
    }

    private void a(Map<Integer, List<Modification>> map, Modification modification) {
        List<PagedElement> list = modification.getAffectedElements(true);
        List<PagedElement> list2 = modification.getAffectedElements(false);
        if (list.size() == 0 && list2.size() == 0) {
            return;
        }
        if (list2.size() == 0) {
            int n = list.get(0).getPageIndex();
            int n2 = list.get(list.size() - 1).getPageIndex();
            for (int i = n; i <= n2; ++i) {
                this.a(map, i).add(modification);
            }
            return;
        }
        if (list.size() == 0) {
            int n = list2.get(0).getPageIndex();
            int n3 = list2.get(list2.size() - 1).getPageIndex();
            for (int i = n; i <= n3; ++i) {
                this.a(map, i).add(modification);
            }
            return;
        }
        int n = list.get(0).getPageIndex();
        int n4 = list.get(list.size() - 1).getPageIndex();
        int n5 = list2.get(0).getPageIndex();
        int n6 = list2.get(list2.size() - 1).getPageIndex();
        if (n4 < n5 || n6 < n) {
            int n7;
            for (n7 = n; n7 <= n4; ++n7) {
                this.a(map, n7).add(modification);
            }
            for (n7 = n5; n7 <= n6; ++n7) {
                this.a(map, n7).add(modification);
            }
        } else {
            int n8 = Math.min(n, n5);
            int n9 = Math.max(n4, n6);
            for (int i = n8; i <= n9; ++i) {
                this.a(map, i).add(modification);
            }
        }
    }

    private List<Modification> a(Map<Integer, List<Modification>> map, int n) {
        Integer n2 = n;
        List<Modification> list = map.get(n2);
        if (list == null) {
            list = new ArrayList<Modification>();
            map.put(n2, list);
        }
        return list;
    }

    private void cz() {
        Map<Integer, List<Modification>> map = this.cy();
        int n = Math.max(this.getModel().getPageCount(true), this.getModel().getPageCount(false));
        for (int i = 0; i < n; ++i) {
            List<Modification> list;
            a a2 = this.a(i, true, this.getScale());
            a a3 = this.a(i, false, this.getScale());
            if (a2 == null && a3 == null) continue;
            if (this.cx()) {
                if (a2 != null) {
                    this.a(i, a2.getWidth(), a2.getHeight(), a2.getImage(), true);
                }
                if (a3 != null) {
                    this.a(i, a3.getWidth(), a3.getHeight(), a3.getImage(), false);
                }
            }
            if ((list = map.get(i)) == null || list.size() <= 0) continue;
            this.a(list, i, a2, a3);
        }
    }

    private a a(int n, boolean bl, double d2) {
        ResultPage resultPage = this.getModel().getPage(n, bl);
        if (resultPage == null) {
            return null;
        }
        BufferedImage bufferedImage = resultPage.getPageImage(d2);
        if (bufferedImage == null) {
            return null;
        }
        return new a(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage);
    }

    private void a(List<Modification> list, int n, a a2, a a3) {
        Object object;
        boolean bl;
        int n2;
        if (a3 == null) {
            a3 = new a(a2.getWidth(), a2.getHeight(), null);
        }
        if (a2 == null) {
            a2 = new a(a3.getWidth(), a3.getHeight(), null);
        }
        int n3 = n2 = this.cu() ? a2.getWidth() : 0;
        int n4 = Math.max(a3.getWidth(), a2.getHeight());
        boolean bl2 = bl = this.cw() && a2.getImage() != null && a3.getImage() != null;
        if (!(this.cu() || this.cv() || bl)) {
            return;
        }
        if (bl) {
            object = this.a(a2, a3);
            n3 += ((Rectangle)object).width;
            n4 = Math.max(n4, ((Rectangle)object).height);
        }
        object = new BufferedImage(n3 + (this.cv() ? a3.getWidth() : 0), n4, 6);
        Graphics2D graphics2D = (Graphics2D)((BufferedImage)object).getGraphics();
        boolean bl3 = false;
        if (this.cu()) {
            bl3 |= this.a(graphics2D, a2, 0, true);
        }
        if (this.cv()) {
            bl3 |= this.a(graphics2D, a3, n3, true);
        }
        if (bl) {
            this.a(a2, a3, (BufferedImage)object);
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawLine(n3, 0, n3, n4);
            bl3 = true;
        }
        if (this.cv()) {
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawLine(n2, 0, n2, n4);
        }
        long l = 0L;
        if (this.cu()) {
            l += this.a(list, n, graphics2D, true, 0);
        }
        if (this.cv()) {
            l += this.a(list, n, graphics2D, false, (int)Math.round((double)n3 / this.getScale()));
        }
        if (!bl3 && l == 0L) {
            return;
        }
        LOGGER.debug((Object)Msg.getMsg("diffimage.debug.creatingdiffimage", l, this.getModel().getComparisonParameters().getFirstFile().getName()));
        this.writeDifferencesImage(n, (BufferedImage)object);
    }

    protected void writeDifferencesImage(int pageIndex, BufferedImage targetImg) {
        try {
            if (!this.pd.exists() && !this.pd.mkdirs()) {
                LOGGER.error((Throwable)((Object)PdfcException.create((ErrorCode)PdfcErrorCode.cannotCreateFileOrFolder, this.pd.getAbsolutePath())));
                return;
            }
            File file = new File(this.pd, this.getDefaultExportName("diffpage" + (pageIndex + 1)) + ".png");
            int n = (int)Math.round(72.0 * this.getScale());
            PdfcImageIO.writeImage(targetImg, n, "png", file);
        }
        catch (Throwable throwable) {
            LOGGER.debug((Object)Msg.getMsg("diffimage.error.exceptionexport"));
            LOGGER.debug((Object)throwable);
        }
    }

    private long a(List<Modification> list, int n, Graphics2D graphics2D, boolean bl, int n2) {
        long l = 0L;
        for (Modification modification : list) {
            List<PagedElement> list2 = modification.getAffectedElements(bl);
            Rectangle rectangle = null;
            for (PagedElement pagedElement : list2) {
                if (pagedElement.getPageIndex() == n) {
                    Rectangle rectangle2;
                    if (pagedElement.getType() == ElementType.Page) {
                        ResultPage resultPage = this.getModel().getPage(n, bl);
                        rectangle2 = new Rectangle(resultPage.getWidth(), resultPage.getHeight());
                    } else {
                        rectangle2 = LocationUtils.getBounds(pagedElement);
                    }
                    if (rectangle == null) {
                        rectangle = rectangle2;
                        continue;
                    }
                    if (rectangle.y + rectangle.height == rectangle2.y + rectangle2.height) {
                        rectangle = rectangle.union(rectangle2);
                        continue;
                    }
                    rectangle.translate(n2, 0);
                    this.a(rectangle, modification.getModificationType(), graphics2D, false);
                    rectangle = rectangle2;
                    continue;
                }
                if (pagedElement.getPageIndex() <= n) continue;
                break;
            }
            if (rectangle == null) continue;
            rectangle.translate(n2, 0);
            this.a(rectangle, modification.getModificationType(), graphics2D, false);
            if (modification.getSourceType() != DiffGroup.GroupType.AddedOrRemoved && !bl) continue;
            ++l;
        }
        return l;
    }

    private void a(a a2, a a3, BufferedImage bufferedImage) {
        Rectangle rectangle = this.a(a2, a3);
        int n = this.cu() ? a2.getWidth() : 0;
        bufferedImage.getGraphics().drawImage(a2.getImage(), n, 0, null);
        bufferedImage.getGraphics().drawImage(a3.getImage(), n, 0, null);
        Rectangle rectangle2 = this.b(a2, a3);
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        for (int i = 0; i < rectangle2.height; ++i) {
            for (int j = 0; j < rectangle2.width; ++j) {
                a2.getImage().getRaster().getPixel(j, i, nArray);
                a3.getImage().getRaster().getPixel(j, i, nArray2);
                nArray2[0] = 255 - nArray[0] ^ nArray2[0];
                nArray2[1] = 255 - nArray[1] ^ nArray2[1];
                nArray2[2] = 255 - nArray[2] ^ nArray2[2];
                nArray2[3] = 255;
                int n2 = j + n + rectangle2.x - rectangle.x;
                int n3 = i + rectangle2.y - rectangle.y;
                bufferedImage.getRaster().setPixel(n2, n3, nArray2);
            }
        }
    }

    private Rectangle a(a a2, a a3) {
        Rectangle rectangle = new Rectangle(a2.getWidth(), a2.getHeight());
        Rectangle rectangle2 = new Rectangle(a3.getWidth(), a3.getHeight());
        return rectangle.union(rectangle2);
    }

    private Rectangle b(a a2, a a3) {
        Rectangle rectangle = new Rectangle(a2.getWidth(), a2.getHeight());
        Rectangle rectangle2 = new Rectangle(a3.getWidth(), a3.getHeight());
        return rectangle.intersection(rectangle2);
    }

    private boolean a(Graphics2D graphics2D, a a2, int n, boolean bl) {
        if (a2.getImage() != null) {
            graphics2D.drawImage((Image)a2.getImage(), n, 0, null);
            if (bl) {
                graphics2D.setColor(new Color(255, 255, 255, 63));
                graphics2D.fillRect(n, 0, a2.getWidth(), a2.getHeight());
            }
            return true;
        }
        return false;
    }

    private void a(Rectangle rectangle, Modification.ModificationType modificationType, Graphics2D graphics2D, boolean bl) {
        Color color;
        switch (modificationType) {
            case remove: 
            case add: {
                color = DiffConstants.getOutlineColor(modificationType);
                color = bl ? color.brighter().brighter() : color;
                break;
            }
            case replace: 
            case attributeDifference: 
            case validationError: {
                color = DiffConstants.getOutlineColor(modificationType);
                break;
            }
            default: {
                return;
            }
        }
        color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 255);
        graphics2D.setColor(color);
        double d2 = this.getScale();
        if (d2 != 1.0) {
            rectangle.x = (int)Math.round((double)rectangle.x * d2);
            rectangle.y = (int)Math.round((double)rectangle.y * d2);
            rectangle.width = (int)Math.round((double)rectangle.width * d2);
            rectangle.height = (int)Math.round((double)rectangle.height * d2);
        }
        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private void a(int n, int n2, int n3, Image image, boolean bl) {
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 6);
        bufferedImage.getGraphics().drawImage(image, 0, 0, null);
        this.writePageImage(n, bl, bufferedImage);
    }

    protected void writePageImage(int pageIndex, boolean isFirstPDF, BufferedImage pageImage) {
        try {
            if (!this.pd.exists() && !this.pd.mkdirs()) {
                LOGGER.error((Throwable)((Object)PdfcException.create((ErrorCode)PdfcErrorCode.cannotCreateFileOrFolder, this.pd.getAbsolutePath())));
                return;
            }
            File file = new File(this.pd, (isFirstPDF ? "orig_" : "new_") + "page" + (pageIndex + 1) + ".png");
            int n = (int)Math.round(72.0 * this.getScale());
            PdfcImageIO.writeImage(pageImage, n, "png", file);
        }
        catch (Throwable throwable) {
            LOGGER.warn((Object)Msg.getMsg("diffimage.error.exceptionexport"));
            LOGGER.warn((Object)throwable);
        }
    }

    private static class a {
        private int width;
        private int height;
        private BufferedImage pe;

        public a(int n, int n2, BufferedImage bufferedImage) {
            this.width = n;
            this.height = n2;
            this.pe = bufferedImage;
        }

        public BufferedImage getImage() {
            return this.pe;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

