/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.plugin.pool;

import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.config.ArrayPdfSource;
import com.inet.pdfc.config.DirectoryPdfSource;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PdfSource;
import com.inet.pdfc.error.ExceptionDataFactory;
import com.inet.pdfc.generator.ComparatorProperty;
import com.inet.pdfc.generator.DataGeneratorListener;
import com.inet.pdfc.generator.message.ErrorData;
import com.inet.pdfc.generator.message.InfoData;
import com.inet.pdfc.generator.message.ProgressState;
import com.inet.pdfc.generator.message.State;
import com.inet.pdfc.plugin.defaultrunner.BaseCompareRunner;
import com.inet.pdfc.plugin.pool.a;
import com.inet.pdfc.plugin.pool.b;
import com.inet.pdfc.presenter.BasePresenter;
import com.inet.pdfc.presenter.PresenterManager;
import com.inet.pdfc.results.ResultModel;
import com.inet.pdfc.results.ResultModelUpdater;
import com.inet.pdfc.util.Pair;
import com.inet.thread.job.Job;
import com.inet.thread.job.JobInfo;
import com.inet.thread.job.manager.JobManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class c
extends BaseCompareRunner {
    private Map<a, CompletableFuture<ResultModel>> oC = new ConcurrentHashMap<a, CompletableFuture<ResultModel>>();
    private JobManager oD = JobManager.instance();

    @Override
    public CompletableFuture<ResultModel> compare(PdfSource pdf1, PdfSource pdf2) {
        b b2;
        List<BasePresenter> list = this.getPresenters();
        DataGeneratorListener dataGeneratorListener = this.getOverrideListener();
        if (dataGeneratorListener != null) {
            b2 = new b(pdf1, pdf2, this.getProfile(), dataGeneratorListener);
        } else {
            b2 = new b(pdf1, pdf2, this.getProfile(), false, list.toArray(new BasePresenter[list.size()]));
            b2.getResult().setSetting(this.settings);
        }
        b2.setProperties(this.getProperties());
        try {
            a a2 = new a(b2);
            CompletableFuture completableFuture = this.oD.submitJob((Job)a2);
            this.oC.put(a2, completableFuture);
            return completableFuture;
        }
        catch (Throwable throwable) {
            PDFCCore.LOGGER_CORE.error(throwable);
            CompletableFuture<ResultModel> completableFuture = new CompletableFuture<ResultModel>();
            completableFuture.completeExceptionally(throwable);
            return completableFuture;
        }
    }

    @Override
    public void batchCompare(DirectoryPdfSource directory1, DirectoryPdfSource directory2) {
        List<BasePresenter> list = this.getPresenters();
        if (list.size() == 0) {
            PDFCCore.LOGGER_CORE.error((Object)"There is no presenter registered for batchCompare. The operation will be interrupted.");
            return;
        }
        if (this.getOverrideListener() != null) {
            throw new IllegalStateException("A data listener cannot be used for a batch compare");
        }
        IProfile iProfile = this.getProfile();
        BasePresenter[] basePresenterArray = list.toArray(new BasePresenter[list.size()]);
        ResultModel resultModel = new ResultModel();
        InfoData infoData = new InfoData(new ArrayPdfSource(directory1.getName(), 0L, new byte[0]), new ArrayPdfSource(directory2.getName(), 0L, new byte[0]), iProfile);
        new ResultModelUpdater(resultModel).addData(infoData);
        for (BasePresenter object : basePresenterArray) {
            object.setModel(resultModel);
        }
        ArrayList arrayList = new ArrayList();
        for (PdfSource pdfSource : directory1.getPdfSources()) {
            PdfSource pdfSource2 = directory2.getPdfSource(pdfSource.getName());
            if (pdfSource2 != null) {
                arrayList.add(new Pair<PdfSource>(pdfSource, pdfSource2));
                continue;
            }
            this.notifySecondFileMissing(pdfSource, directory2);
        }
        for (PdfSource pdfSource : directory2.getPdfSources()) {
            if (directory1.getPdfSource(pdfSource.getName()) != null) continue;
            this.notifyFirstFileMissing(pdfSource, directory1);
        }
        PDFCCore.LOGGER_CORE.info((Object)("Found " + arrayList.size() + " documents to compare as batch"));
        List<Pair<PdfSource>> list2 = this.b(iProfile, basePresenterArray, arrayList);
        if (Boolean.valueOf(this.getProperties().getProperty(ComparatorProperty.retryOnLowMemory)).booleanValue() && list2.size() > 0) {
            PDFCCore.LOGGER_CORE.info((Object)("Retry for " + list2.size() + " comparisons which failed due to low memory"));
            this.a(iProfile, basePresenterArray, list2);
        }
        for (BasePresenter basePresenter : list) {
            PresenterManager.finish(basePresenter);
        }
    }

    private void a(IProfile iProfile, BasePresenter[] basePresenterArray, List<Pair<PdfSource>> list) {
        for (Pair<PdfSource> pair : list) {
            b b2 = new b(pair.get(true), pair.get(false), iProfile, true, basePresenterArray);
            b2.getResult().setSetting(this.settings);
            b2.setProperties(this.getProperties());
            a a2 = new a(b2);
            b2.cq().addData(new ProgressState(State.QUEUED, this.oC.size()));
            JobManager.JobSubmitData jobSubmitData = this.oD.submitManagedJob((Job)a2);
            try {
                ResultModel resultModel = (ResultModel)jobSubmitData.getFuture().join();
                a2.getSession().setThreadLocal();
                resultModel.close();
                a2.getSession().resetThreadLocal();
            }
            catch (Throwable throwable) {
                ResultModel resultModel = new ResultModel();
                ResultModelUpdater resultModelUpdater = new ResultModelUpdater(resultModel);
                resultModelUpdater.addData(new InfoData(pair.get(true), pair.get(false), iProfile));
                resultModelUpdater.addData(new ErrorData(ExceptionDataFactory.createExceptionData(throwable), 3, true));
                for (BasePresenter basePresenter : b2.cp()) {
                    try {
                        basePresenter.executeImmediately(resultModel);
                    }
                    catch (Exception exception) {
                        PDFCCore.LOGGER_CORE.error((Throwable)exception);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Pair<PdfSource>> b(IProfile iProfile, BasePresenter[] basePresenterArray, List<Pair<PdfSource>> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ConcurrentLinkedQueue<Pair<PdfSource>> concurrentLinkedQueue = new ConcurrentLinkedQueue<Pair<PdfSource>>(list);
        ConcurrentLinkedQueue<Pair<PdfSource>> concurrentLinkedQueue2 = new ConcurrentLinkedQueue<Pair<PdfSource>>();
        int n = (Integer)JobManager.THREAD_POOL_MAX_SIZE.get() + 1;
        ConcurrentHashMap<String, JobManager.JobSubmitData<ResultModel>> concurrentHashMap = new ConcurrentHashMap<String, JobManager.JobSubmitData<ResultModel>>();
        while (!concurrentLinkedQueue.isEmpty() && concurrentHashMap.size() < n) {
            this.a(iProfile, basePresenterArray, arrayList, concurrentLinkedQueue, concurrentHashMap, concurrentLinkedQueue2);
        }
        while (concurrentHashMap.size() > 0 || !concurrentLinkedQueue.isEmpty()) {
            ArrayList arrayList2;
            ArrayList<String> arrayList3 = arrayList;
            synchronized (arrayList3) {
                try {
                    arrayList.wait(60000L);
                }
                catch (InterruptedException interruptedException) {
                    return new ArrayList<Pair<PdfSource>>(concurrentLinkedQueue2);
                }
            }
            if (concurrentHashMap.size() <= 0 && concurrentLinkedQueue.isEmpty()) continue;
            arrayList3 = new ArrayList<String>();
            ArrayList<String> arrayList4 = arrayList;
            synchronized (arrayList4) {
                arrayList2 = new ArrayList(concurrentHashMap.values());
            }
            for (JobManager.JobSubmitData jobSubmitData : arrayList2) {
                try {
                    JobInfo jobInfo = jobSubmitData.getJobInfo();
                    if (jobInfo != null) continue;
                    PDFCCore.LOGGER_CORE.warn((Object)("Batch-Compare: Job " + jobSubmitData.getUuid() + " was removed in background without notification."));
                    arrayList3.add(jobSubmitData.getUuid());
                }
                catch (Exception exception) {
                    arrayList3.add(jobSubmitData.getUuid());
                }
            }
            arrayList3.forEach(string -> concurrentHashMap.remove(string));
        }
        return new ArrayList<Pair<PdfSource>>(concurrentLinkedQueue2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(IProfile iProfile, BasePresenter[] basePresenterArray, Object object, Queue<Pair<PdfSource>> queue, Map<String, JobManager.JobSubmitData<ResultModel>> map, Queue<Pair<PdfSource>> queue2) {
        Pair<PdfSource> pair = queue.poll();
        if (pair == null) {
            Object object2 = object;
            synchronized (object2) {
                object.notifyAll();
            }
            return;
        }
        b b2 = new b(pair.get(true), pair.get(false), iProfile, true, basePresenterArray);
        b2.getResult().setSetting(this.settings);
        b2.setProperties(this.getProperties());
        a a2 = new a(b2);
        b2.cq().addData(new ProgressState(State.QUEUED, this.oC.size()));
        JobManager.JobSubmitData jobSubmitData = this.oD.submitManagedJob((Job)a2);
        Object object3 = object;
        synchronized (object3) {
            map.put(jobSubmitData.getUuid(), (JobManager.JobSubmitData<ResultModel>)jobSubmitData);
        }
        jobSubmitData.getFuture().whenComplete((resultModel, throwable) -> {
            if (resultModel != null) {
                a2.getSession().setThreadLocal();
                resultModel.close();
                a2.getSession().resetThreadLocal();
            }
            if (throwable != null && this.d((Throwable)throwable) instanceof OutOfMemoryError) {
                queue2.add(pair);
            }
            Object object2 = object;
            synchronized (object2) {
                map.remove(jobSubmitData.getUuid());
                object.notify();
            }
            this.oC.remove((Object)a2);
            this.a(iProfile, basePresenterArray, object, queue, map, queue2);
        });
        this.oC.put(a2, jobSubmitData.getFuture());
    }

    private Throwable d(Throwable throwable) {
        Throwable throwable2 = throwable.getCause();
        while (throwable2 != null && throwable2 != throwable) {
            throwable = throwable2;
            throwable2 = throwable.getCause();
        }
        return throwable;
    }

    @Override
    public void cancel() {
        this.oC.forEach((a2, completableFuture) -> completableFuture.cancel(true));
        this.oC.clear();
    }
}

