/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.plugin.persistence;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.pdfc.config.VisibilitySetting;
import com.inet.pdfc.generator.message.ErrorData;
import com.inet.pdfc.generator.message.HighlightData;
import com.inet.pdfc.generator.message.InfoData;
import com.inet.pdfc.generator.message.PageDataImpl;
import com.inet.pdfc.generator.message.PageFilterDone;
import com.inet.pdfc.generator.message.PageReadDone;
import com.inet.pdfc.generator.message.PartialDiffs;
import com.inet.pdfc.generator.message.ProgressState;
import com.inet.pdfc.plugin.persistence.ComparePersistence;
import com.inet.pdfc.plugin.persistence.UserSession;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@InternalApi
public interface PersistenceObserver {
    public boolean isValid();

    default public boolean canTimeout() {
        return true;
    }

    public <T> void changed(EventType<T> var1, T var2, boolean var3);

    @JsonData
    public static class VisiblityUpdate {
        private int groupIndex;
        private int modificationIndex;
        private boolean visible;

        public VisiblityUpdate(int groupIndex, int modificationIndex, boolean visible) {
            this.groupIndex = groupIndex;
            this.modificationIndex = modificationIndex;
            this.visible = visible;
        }

        public int getGroupIndex() {
            return this.groupIndex;
        }

        public int getModificationIndex() {
            return this.modificationIndex;
        }

        public boolean isVisible() {
            return this.visible;
        }
    }

    @JsonData
    public static class PreviewData {
        private boolean first;
        private ComparePersistence.PREVIEW_SIZE size;

        public PreviewData(boolean first, ComparePersistence.PREVIEW_SIZE size) {
            this.first = first;
            this.size = size;
        }

        public boolean isFirst() {
            return this.first;
        }

        public ComparePersistence.PREVIEW_SIZE getSize() {
            return this.size;
        }
    }

    @InternalApi
    public static class EventType<T> {
        private static final Map<String, EventType<?>> nB = new HashMap();
        public static final EventType<ErrorData> ERROR = new EventType("ERROR", false, null);
        public static final EventType<InfoData> COMPARISON_INFO = new EventType("COMPARISON_INFO", true, null);
        public static final EventType<PageDataImpl> PAGE_PARSED = new EventType("PAGE_PARSED", true, null);
        public static final EventType<PageDataImpl> TEXTINFO_UPDATE = new EventType("TEXTINFO_UPDATE", true, null);
        public static final EventType<PageReadDone> PAGE_ANALYZED = new EventType("PAGE_ANALYZED", true, null);
        public static final EventType<PageFilterDone> PAGE_FILTERED = new EventType("PAGE_FILTERED", true, null);
        public static final EventType<PartialDiffs> PARTIAL_DIFFS = new EventType("PARTIAL_DIFFS", true, null);
        public static final EventType<ProgressState> PROGRESS = new EventType<ProgressState>("PROGRESS", true, ProgressState.class);
        public static final EventType<HighlightData> HIGHLIGHT = new EventType("HIGHLIGHT", true, null);
        public static final EventType<Boolean> COMPARISON_RESET = new EventType<Boolean>("COMPARISON_RESET", false, Boolean.class);
        public static final EventType<Boolean> COMPARISON_SERIALIZED = new EventType<Boolean>("COMPARISON_SERIALIZED", false, Boolean.class);
        public static final EventType<List<UserSession>> VIEWERS_CHANGED = new EventType("VIEWERS_CHANGED", false, null);
        public static final EventType<Map> META_CHANGED = new EventType<Map>("META_CHANGED", false, Map.class);
        public static final EventType<Boolean> DOCUMENT_CHANGED = new EventType<Boolean>("DOCUMENT_CHANGED", false, Boolean.class);
        public static final EventType<ComparePersistence.PUBLICATION_MODE> PUBLISHING_CHANGED = new EventType<ComparePersistence.PUBLICATION_MODE>("PUBLISHING_CHANGED", false, ComparePersistence.PUBLICATION_MODE.class);
        public static final EventType<PreviewData> PREVIEW_GENERATED = new EventType<PreviewData>("PREVIEW_GENERATED", false, PreviewData.class);
        public static final EventType<GUID> REMOVED = new EventType("REMOVED", false, null);
        public static final EventType<GUID> CREATED = new EventType("CREATED", false, null);
        public static final EventType<Long> TOTAL_SIZE_CHANGED = new EventType<Long>("TOTAL_SIZE_CHANGED", false, Long.class);
        public static final EventType<Map<String, VisibilitySetting>> SETTINGS_CHANGED = new EventType("SETTINGS_CHANGED", false, null);
        public static final EventType<List<VisiblityUpdate>> VISIBILITY_CHANGED = new EventType("VISIBILITY_CHANGED", false, null);
        private String nC;
        private Class<T> nD;
        private boolean nE;

        private EventType(String jsonKey, boolean runtimeEvent, Class<T> deserializer) {
            this.nC = jsonKey;
            this.nE = runtimeEvent;
            this.nD = deserializer;
            nB.put(jsonKey, this);
        }

        public String getJSONKey() {
            return this.nC;
        }

        public String toJson(T eventData) {
            return this.nD != null ? new Json().toJson(eventData) : null;
        }

        public T fromJSON(String json) {
            if (json == null || json.isEmpty() || this.nD == null) {
                return null;
            }
            return (T)new Json().fromJson(json, this.nD);
        }

        public static EventType<?> getTypeForKey(String jsonKey) {
            return nB.get(jsonKey);
        }

        public boolean isRuntimeEvent() {
            return this.nE;
        }
    }
}

