/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.model;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.generator.model.text.TextStyle;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.FontInfo;
import com.inet.pdfc.model.Visitable;
import com.inet.pdfc.model.Visitor;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.annotation.Nonnull;

@JsonData
@InternalApi
public class TextElement
extends DrawableElement
implements Visitable {
    static final long serialVersionUID = 999238012010077L;
    private final double TWIPS = 20.0;
    private String text;
    private static double[] DEFAULT_ROTATION = new double[2];
    private double[] m = null;
    private double[] charWidths;
    private double[] kerning;
    private Rectangle2D clip;
    private double textWidth = -1.0;
    private Rectangle2D.Double bounds;
    private boolean hasUnicodeMapping = true;
    private int border = 0;
    private boolean isIndex = false;
    private boolean wsWidthArtificial;
    private final int CHECKTEXTHEIGHT = 100;
    private TextStyle style;

    private TextElement(int pageNr, ElementID id) {
        super(pageNr, id);
    }

    public TextElement(FontInfo fontInfo, float fontSize, AffineTransform transform, String text, Paint fillPaint, Paint strokePaint, double[] charWidths, double[] kerning, boolean replaceZeroChar, ElementID id) {
        this(fontInfo, fontSize, transform, text, fillPaint, strokePaint, charWidths, kerning, replaceZeroChar, true, id);
    }

    public TextElement(FontInfo fontInfo, float fontSize, AffineTransform transform, String text, Paint fillPaint, Paint strokePaint, double[] charWidths, double[] kerning, boolean replaceZeroChar, boolean hasUnicodeMapping, ElementID id) {
        super(0, id);
        double d2;
        double d3;
        this.hasUnicodeMapping = hasUnicodeMapping;
        this.text = text;
        this.charWidths = charWidths != null ? (double[])charWidths.clone() : new double[]{};
        this.kerning = kerning != null ? (double[])kerning.clone() : null;
        this.m = new double[6];
        this.style = new TextStyle(fontInfo, fontSize, fillPaint, strokePaint);
        this.style.setTextHeight(Math.ceil(fontInfo.getAscend(1) * (float)((int)((double)fontSize * 20.0))) / 20.0);
        transform.getMatrix(this.m);
        double[] dArray = TextElement.getRotationAndShearAngle(transform);
        this.style.setRotation(dArray[0]);
        this.style.setSlope(dArray[1]);
        if (Math.abs(this.style.getTextHeight()) > 100.0) {
            this.style.setTextHeight(fontInfo.getMetrics((int)fontSize).getStringBounds(text, null).getBounds2D().getHeight());
        }
        boolean bl = this.wsWidthArtificial = !fontInfo.hasWhiteSpace();
        if (this.style.getWsWidth() <= 0.0) {
            this.style.setWsWidth(this.style.getTextHeight() * 0.25);
            if (this.style.getWsWidth() <= 0.0) {
                this.style.setWsWidth(Math.abs(this.style.getWsWidth()));
            }
        }
        if (transform.isIdentity()) {
            this.style.setWsWidthScaled(this.style.getWsWidth());
            this.style.setFontSize(fontSize);
        } else {
            d3 = Math.sqrt(transform.getScaleX() * transform.getScaleX() + transform.getShearY() * transform.getShearY());
            this.style.setWsWidthScaled((int)Math.round(this.style.getWsWidth() * d3));
            this.style.setFontSize((float)((double)fontSize * d3));
            if (this.style.getWsWidthScaled() <= 0.0) {
                this.style.setWsWidthScaled(this.style.getWsWidth() * d3);
            }
        }
        this.calculateBounds(transform, this.getTextWidth(), this.getTextHeight());
        d3 = this.style.getSlope();
        if (d3 != 0.0 && d3 != Math.PI && (d2 = Math.abs(d3 > 1.5707963267948966 ? d3 - Math.PI : d3)) > 0.05 && d2 < 0.7853981633974483) {
            this.style.setItalic();
        }
    }

    public double getScale() {
        return Math.sqrt(this.m[0] * this.m[0] + this.m[1] * this.m[1]);
    }

    public TextElement subText(int startIndex, int endIndex) {
        double[] dArray = new double[endIndex - startIndex];
        System.arraycopy(this.getCharacterWidths(), startIndex, dArray, 0, endIndex - startIndex);
        double[] dArray2 = null;
        double d2 = 0.0;
        if (this.getKerningArray() != null) {
            dArray2 = new double[endIndex - startIndex];
            System.arraycopy(this.getKerningArray(), startIndex, dArray2, 0, endIndex - startIndex);
            dArray[0] = dArray[0] - dArray2[0];
            d2 += dArray2[0];
            dArray2[0] = 0.0;
        }
        for (int i = 0; i < startIndex; ++i) {
            d2 += this.charWidths[i];
        }
        AffineTransform affineTransform = new AffineTransform(this.getTransformMatrix());
        affineTransform.translate(d2, 0.0);
        TextElement textElement = new TextElement(this.getPageIndex(), this.getElementID().getDescendant(startIndex));
        textElement.charWidths = dArray;
        textElement.kerning = dArray2;
        textElement.text = this.getText().substring(startIndex, endIndex);
        textElement.style = this.getStyle();
        textElement.clip = this.getClip();
        textElement.hasUnicodeMapping = this.hasUnicodeMapping;
        textElement.border = this.getBorder();
        textElement.isIndex = this.isIndex();
        textElement.m = new double[6];
        affineTransform.getMatrix(textElement.m);
        textElement.calculateBounds(affineTransform, textElement.getTextWidth(), textElement.getTextHeight());
        return textElement;
    }

    public void append(@Nonnull TextElement element) {
        this.text = this.text + element.text;
        int n = this.charWidths.length;
        double[] dArray = new double[n + element.charWidths.length];
        System.arraycopy(this.charWidths, 0, dArray, 0, n);
        System.arraycopy(element.charWidths, 0, dArray, n, element.charWidths.length);
        this.charWidths = dArray;
        if (this.kerning != null || element.kerning != null) {
            double[] dArray2 = new double[this.charWidths.length];
            if (this.kerning != null) {
                System.arraycopy(this.kerning, 0, dArray2, 0, this.kerning.length);
            }
            if (element.kerning != null) {
                System.arraycopy(element.kerning, 0, dArray2, n, element.kerning.length);
            }
            this.kerning = dArray2;
        }
        if (this.clip != null && element.clip != null) {
            Rectangle2D.union(this.clip, element.clip, this.clip);
        } else {
            this.clip = null;
        }
        this.textWidth = -1.0;
        this.hasUnicodeMapping |= element.hasUnicodeMapping;
        this.border = 0;
        this.isIndex &= element.isIndex;
        this.wsWidthArtificial &= element.wsWidthArtificial;
        this.calculateBounds(new AffineTransform(this.m), this.getTextWidth(), this.getTextHeight());
    }

    private static double[] getRotationAndShearAngle(AffineTransform t) {
        if (t.getShearX() == -t.getShearY() && Math.abs(t.getScaleX()) == Math.abs(t.getScaleY())) {
            if (t.getShearX() == 0.0 && t.getScaleX() > 0.0) {
                return DEFAULT_ROTATION;
            }
            return new double[]{Math.atan2(t.getShearY(), t.getScaleX()), 0.0};
        }
        double[] dArray = new double[4];
        t.getMatrix(dArray);
        t = new AffineTransform(dArray);
        Point2D.Double double_ = new Point2D.Double(1.0, 0.0);
        t.transform(double_, double_);
        double d2 = Math.atan2(double_.getY(), double_.getX());
        double_ = new Point2D.Double(0.0, 1.0);
        t.transform(double_, double_);
        double d3 = 1.5707963267948966 + d2 - Math.atan2(double_.getY(), double_.getX());
        return new double[]{d2, d3};
    }

    public void calculateBounds(AffineTransform transform, double textWidth, double textHeight) {
        float f2 = 0.0f;
        if (this.kerning != null && this.kerning.length > 1) {
            double d2 = 0.0;
            f2 = (float)this.kerning[0];
            int n = Math.min(this.kerning.length, 4);
            for (int i = 0; i < n - 1; ++i) {
                f2 = (float)Math.min((double)f2, (d2 += this.charWidths[i]) + this.kerning[i + 1]);
            }
            if (f2 >= 0.0f) {
                f2 = 0.0f;
            } else {
                textWidth -= (double)f2;
            }
        }
        if (transform.getScaleX() == 1.0 && transform.getShearX() == 0.0 && transform.getScaleY() == -1.0 && transform.getShearY() == 0.0) {
            this.bounds = new Rectangle2D.Double(transform.getTranslateX() + (double)f2, transform.getTranslateY(), textWidth, -textHeight);
        } else {
            Rectangle2D.Double double_ = new Rectangle2D.Double(f2, textHeight, textWidth, -textHeight);
            Point2D.Double double_2 = new Point2D.Double();
            transform.transform(new Point2D.Double(double_.x, double_.y), double_2);
            this.bounds = new Rectangle2D.Double(double_2.x, double_2.y, 0.0, 0.0);
            this.bounds.add(transform.transform(new Point2D.Double(double_.x + double_.width, double_.y), double_2));
            this.bounds.add(transform.transform(new Point2D.Double(double_.x + double_.width, double_.y + double_.height), double_2));
            this.bounds.add(transform.transform(new Point2D.Double(double_.x, double_.y + double_.height), double_2));
            if (Math.abs(transform.getTranslateY() - this.bounds.getY()) > 0.5) {
                this.bounds = new Rectangle2D.Double(this.bounds.getX(), this.bounds.getY() + this.bounds.getHeight(), this.bounds.getWidth(), -this.bounds.getHeight());
            }
        }
    }

    public static Rectangle2D.Double createTransformedBounds(AffineTransform at, Rectangle2D.Double rect) {
        Point2D.Double double_ = new Point2D.Double();
        at.transform(new Point2D.Double(rect.x, rect.y), double_);
        Rectangle2D.Double double_2 = new Rectangle2D.Double(double_.x, double_.y, 0.0, 0.0);
        double_2.add(at.transform(new Point2D.Double(rect.x + rect.width, rect.y), double_));
        double_2.add(at.transform(new Point2D.Double(rect.x + rect.width, rect.y + rect.height), double_));
        double_2.add(at.transform(new Point2D.Double(rect.x, rect.y + rect.height), double_));
        return double_2;
    }

    public TextStyle getStyle() {
        return this.style;
    }

    public boolean hasUnicodeMapping() {
        return this.hasUnicodeMapping;
    }

    public void setUnicodeMapping(boolean hasUnicodeMapping) {
        this.hasUnicodeMapping = hasUnicodeMapping;
    }

    public int getWhitespaceWidth() {
        return (int)this.style.getWsWidth();
    }

    public int getWhitespaceWidthScaled() {
        return (int)this.style.getWsWidthScaled();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public double getTextSlope() {
        return this.style.getSlope();
    }

    public FontInfo getFontInfo() {
        return this.style.getFont();
    }

    public double getTextHeight() {
        return this.style.getTextHeight();
    }

    public double[] getCharacterWidths() {
        int n = this.getText().length();
        if (this.charWidths.length > n) {
            double[] dArray = new double[n];
            System.arraycopy(this.charWidths, 0, dArray, 0, n);
            this.charWidths = dArray;
        }
        return this.charWidths;
    }

    public double getTextWidth() {
        if (this.textWidth == -1.0) {
            this.textWidth = 0.0;
            for (int i = 0; i < this.charWidths.length; ++i) {
                this.textWidth += this.charWidths[i];
            }
        }
        return this.textWidth;
    }

    public double[] getKerningArray() {
        return this.kerning;
    }

    public void setKerning(double[] kerning) {
        this.kerning = kerning;
    }

    public void setCharWidths(double[] charWidths) {
        this.charWidths = charWidths;
        this.textWidth = -1.0;
    }

    public Rectangle2D getClip() {
        return this.clip;
    }

    public void setClip(Rectangle2D clip) {
        this.clip = clip;
    }

    public double[] getTransformMatrix() {
        return this.m;
    }

    public void setBorder(int border) {
        if (border < 0 || border > 15) {
            return;
        }
        this.border = border;
    }

    public int getBorder() {
        return this.border;
    }

    public boolean hasBorder() {
        return this.border > 0;
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    @Override
    public double getX() {
        return this.bounds.getX();
    }

    @Override
    public double getY() {
        return this.bounds.getY();
    }

    @Override
    public void setX(double x) {
        double d2 = x - this.bounds.getX();
        this.bounds.setRect(x, this.bounds.getY(), this.bounds.getWidth(), this.bounds.getHeight());
        this.m[4] = this.m[4] + d2;
        if (this.clip != null) {
            this.clip = new Rectangle2D.Double(this.clip.getX() + d2, this.clip.getY(), this.clip.getWidth(), this.clip.getHeight());
        }
    }

    @Override
    public void setY(double y) {
        double d2 = y - this.bounds.getY();
        this.bounds.setRect(this.bounds.getX(), y, this.bounds.getWidth(), this.bounds.getHeight());
        this.m[5] = this.m[5] + d2;
        if (this.clip != null) {
            this.clip = new Rectangle2D.Double(this.clip.getX(), this.clip.getY() + d2, this.clip.getWidth(), this.clip.getHeight());
        }
    }

    public String toString() {
        return "\"" + this.text + "\" (" + this.bounds.getX() + "," + this.bounds.getY() + "," + this.bounds.getWidth() + "," + this.bounds.getHeight() + ")";
    }

    public float getFontSize() {
        return this.style.getFontSize();
    }

    @Override
    public int getCompareHash() {
        return this.text.hashCode();
    }

    @Override
    public double getRotation() {
        return this.style.getRotation();
    }

    public int getStyleOverride() {
        return this.style.getStyle();
    }

    @Override
    public ElementType getType() {
        return ElementType.Text;
    }

    @Override
    public Paint getStrokePaint() {
        return this.style.getStrokePaint();
    }

    @Override
    public Paint getFillPaint() {
        return this.style.getFillPaint();
    }

    public void setIndex(boolean isIndex) {
        this.isIndex = isIndex;
    }

    public boolean isIndex() {
        return this.isIndex;
    }

    public void setTextHeight(double textHeight) {
        this.style.setTextHeight(textHeight);
    }

    public void setBounds(Rectangle2D bounds) {
        this.bounds = bounds instanceof Rectangle2D.Double ? (Rectangle2D.Double)bounds : new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    @Override
    public String getLabel() {
        return this.text;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public boolean hasArtificialWhiteSpace() {
        return this.wsWidthArtificial;
    }

    public void setTransformMatrix(double[] newMatrix) {
        this.m = newMatrix;
    }

    public void overrideWhiteSpaceWidth(double newValue) {
        this.style.setWsWidth((int)newValue);
        if (this.m[0] != 1.0 || this.m[1] != 1.0) {
            double d2 = Math.sqrt(this.m[0] * this.m[0] + this.m[1] * this.m[1]);
            this.style.setWsWidthScaled((int)Math.round(this.style.getWsWidth() * d2));
        } else {
            this.style.setWsWidthScaled(this.style.getWsWidth());
        }
    }
}

