/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.model;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.error.PdfcException;
import com.inet.pdfc.model.DocumentProgressListener;
import com.inet.pdfc.model.EnumerationProgress;
import com.inet.pdfc.model.Page;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;

@InternalApi
public interface Document
extends AutoCloseable {
    public static final String META_TITLE = "title";
    public static final String META_AUTHOR = "author";
    public static final String META_PRODUCER = "producer";
    public static final String META_CREATION_DATE = "creationDate";
    public static final String META_MODIFIED_DATE = "modifiedDate";

    public TextOrientation getTextOrientation();

    public void setProfile(IProfile var1);

    @Deprecated
    public EnumerationProgress getPages(DocumentProgressListener var1, int var2);

    default public EnumerationProgress getPages(DocumentProgressListener listener, int skip, final int numOfPages) {
        final EnumerationProgress enumerationProgress = this.getPages(listener, skip);
        if (numOfPages < 0) {
            return enumerationProgress;
        }
        return new EnumerationProgress(){
            private int jR = 0;

            @Override
            public double getProgress() {
                if (this.jR == 0) {
                    return 0.0;
                }
                return Math.min(1.0, (double)this.jR / (double)numOfPages);
            }

            @Override
            public boolean hasMoreElements() {
                return this.jR < numOfPages && enumerationProgress.hasMoreElements();
            }

            @Override
            public Page nextElement() throws PdfcException, NoSuchElementException {
                ++this.jR;
                return enumerationProgress.nextElement();
            }
        };
    }

    @Override
    public void close();

    public int getEstimatedPageNum();

    @Nonnull
    default public Map<String, String> getMetaData() {
        return new HashMap<String, String>();
    }

    @InternalApi
    public static final class Paging
    extends Enum<Paging> {
        public static final /* enum */ Paging PAGED = new Paging();
        public static final /* enum */ Paging CONTINUOUS = new Paging();
        private static final /* synthetic */ Paging[] jV;

        public static Paging[] values() {
            return (Paging[])jV.clone();
        }

        public static Paging valueOf(String name) {
            return Enum.valueOf(Paging.class, name);
        }

        private static /* synthetic */ Paging[] bu() {
            return new Paging[]{PAGED, CONTINUOUS};
        }

        static {
            jV = Paging.bu();
        }
    }

    @InternalApi
    public static final class TextOrientation
    extends Enum<TextOrientation> {
        public static final /* enum */ TextOrientation LEFTTORIGHT = new TextOrientation();
        public static final /* enum */ TextOrientation RIGHTTOLEFT = new TextOrientation();
        public static final /* enum */ TextOrientation TOPTOBUTTON = new TextOrientation();
        public static final /* enum */ TextOrientation BOTTOMTOTOP = new TextOrientation();
        private static final /* synthetic */ TextOrientation[] jW;

        public static TextOrientation[] values() {
            return (TextOrientation[])jW.clone();
        }

        public static TextOrientation valueOf(String name) {
            return Enum.valueOf(TextOrientation.class, name);
        }

        private static /* synthetic */ TextOrientation[] bv() {
            return new TextOrientation[]{LEFTTORIGHT, RIGHTTOLEFT, TOPTOBUTTON, BOTTOMTOTOP};
        }

        static {
            jW = TextOrientation.bv();
        }
    }
}

