/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.config;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.logging.LogLevel;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.config.DefaultProfile;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.config.ProfileValidator;
import com.inet.pdfc.config.TextStyleType;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.plugin.PluginManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import java.util.stream.Collectors;

@JsonData
@PublicApi
public class SourceProfile
extends DefaultProfile {
    private static final String TEXTSTYLES = Arrays.asList(TextStyleType.values()).stream().map(Enum::name).collect(Collectors.joining(","));

    SourceProfile() {
    }

    public SourceProfile(InputStream xmlConfigFile, String name) throws IllegalArgumentException, InvalidPropertiesFormatException {
        this.loadXML(xmlConfigFile, name);
    }

    protected void loadXML(InputStream xmlConfigFile, String name) throws InvalidPropertiesFormatException, IllegalArgumentException {
        try {
            ProfileValidator profileValidator;
            this.getProperties().loadFromXML(xmlConfigFile);
            Object object = this.getProperties().get(PDFCProperty.LOG_LEVEL.toString());
            Logger logger = LogManager.getConfigLogger();
            if (object != null) {
                if ("OFF".equals(object)) {
                    object = "STATUS";
                }
                if ("ALL".equals(object)) {
                    object = "DEBUG";
                }
                profileValidator = LogLevel.valueOf((String)object.toString());
                PDFCCore.LOGGER_CORE.setLogLevel(profileValidator.getValue());
                PDFCCore.LOGGER_PRESENTER.setLogLevel(profileValidator.getValue());
                logger.setLogLevel(profileValidator.getValue());
            }
            profileValidator = new ProfileValidator();
            profileValidator.migrateConfiguration3to4(this);
            logger.info((Object)Msg.getMsg("Config.loadingProperties", name));
            Map<String, String> map = profileValidator.verifyConfig(this, false);
            if (!map.isEmpty()) {
                logger.info((Object)Msg.getMsg("Config.validation.problemsHeading"));
                for (String string : map.values()) {
                    logger.info((Object)string);
                }
            }
        }
        catch (InvalidPropertiesFormatException invalidPropertiesFormatException) {
            throw invalidPropertiesFormatException;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(Msg.getMsg("Config.fileNotReadable", name, iOException.getMessage()));
        }
        finally {
            if (xmlConfigFile != null) {
                try {
                    xmlConfigFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void verifyConfig(String configName) {
        for (Object object : this.getProperties().keySet()) {
            if ("PROFIL_NAME".equals(object) || "PROFIL_DESCRIPTION".equals(object) || PDFCProperty.valueOf(object.toString()) != null) continue;
            LogManager.getConfigLogger().error((Object)Msg.getMsg("Config.undefinedKey", object, configName));
        }
    }

    static {
        PluginManager.setPluginFilterForAPI();
        PluginManager.initConditionally();
    }
}

