/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.config;

import com.inet.annotations.PublicApi;
import com.inet.id.GUID;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.plugin.persistence.ProfilePersistence;
import com.inet.pdfc.plugin.persistence.ProfilePersistenceManager;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public class DefaultProfileID {
    private static final String aI;
    public static final String ID_TEXT_ONLY = "textonly";
    public static final String ID_TEXT_AND_STYLES = "textandstyles";
    public static final String ID_CONTINUOUS = "continuous";
    public static final String ID_PAGED = "paged";
    public static final String ID_PAGED_IDENTICAL = "pagedlocation";

    @Nonnull
    public static List<String> getAvailableProfileIDs() {
        List list = DynamicExtensionManager.getInstance().get(ProfilePersistence.class);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ProfilePersistence profilePersistence : list) {
            arrayList.add(profilePersistence.getGUID().toString());
        }
        return arrayList;
    }

    public static boolean isAvailable(@Nullable String id) {
        if (id == null) {
            return false;
        }
        id = new GUID(id).toString();
        if (!DefaultProfileID.getAvailableProfileIDs().contains(id)) {
            ProfilePersistenceManager profilePersistenceManager = (ProfilePersistenceManager)ServerPluginManager.getInstance().getSingleInstance(ProfilePersistenceManager.class);
            try {
                return profilePersistenceManager.getUserProfile(UserManager.getInstance().getCurrentUserAccountID(), id) != null;
            }
            catch (IOException iOException) {
                PDFCCore.LOGGER_CORE.error((Throwable)iOException);
                return false;
            }
        }
        return true;
    }

    static {
        String string;
        try {
            string = System.getProperty("user.name").toLowerCase();
        }
        catch (Throwable throwable) {
            string = "unknown";
        }
        aI = string;
    }
}

