/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.config;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PDFCProperty;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

@JsonData
@PublicApi
public class DefaultProfile
implements IProfile {
    private Properties properties = new Properties();
    private transient Set<ProfileChangeListener> listeners = new HashSet<ProfileChangeListener>();

    public DefaultProfile() {
    }

    public DefaultProfile(IProfile sourceProfile) {
        if (sourceProfile instanceof DefaultProfile) {
            DefaultProfile defaultProfile = (DefaultProfile)sourceProfile;
            this.properties.putAll((Map<?, ?>)defaultProfile.properties);
        } else {
            for (PDFCProperty<?> pDFCProperty : PDFCProperty.values()) {
                this.putValue(pDFCProperty, String.valueOf(sourceProfile.getObject(pDFCProperty)));
            }
        }
        this.putValue("PROFIL_NAME", sourceProfile.getString("PROFIL_NAME"));
        this.putValue("PROFIL_DESCRIPTION", sourceProfile.getString("PROFIL_DESCRIPTION"));
    }

    public void addProfileChangeListener(ProfileChangeListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    public void removeProfileChangeListener(ProfileChangeListener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }

    @Override
    public boolean getBool(String propertyName) {
        Object object = this.getObject(propertyName);
        return object != null && Boolean.parseBoolean(object.toString());
    }

    @Override
    public int getInt(String propertyName) {
        Object object = this.getObject(propertyName);
        if (object != null) {
            try {
                return Integer.parseInt(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                return (int)Math.round(Double.parseDouble(object.toString()));
            }
        }
        return 0;
    }

    @Override
    public double getDouble(String propertyName) {
        Object object = this.getObject(propertyName);
        if (object != null) {
            try {
                return Double.parseDouble(object.toString());
            }
            catch (Exception exception) {
                try {
                    return DecimalFormat.getNumberInstance(Locale.US).parse(object.toString()).doubleValue();
                }
                catch (Exception exception2) {
                    return 0.0;
                }
            }
        }
        return 0.0;
    }

    @Override
    public Object getObject(String propertyName) {
        if (propertyName == null) {
            return null;
        }
        Object object = this.properties.get(propertyName);
        if (object == null) {
            PDFCProperty<?> pDFCProperty = PDFCProperty.valueOf(propertyName);
            return pDFCProperty != null ? pDFCProperty.getDefaultValue() : null;
        }
        return object;
    }

    @Override
    public String getString(String propertyName) {
        Object object = this.getObject(propertyName);
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    @Override
    public void putValue(PDFCProperty<?> property, String value) {
        if (property != null) {
            this.properties.put(property.name(), value);
            for (ProfileChangeListener profileChangeListener : this.listeners) {
                profileChangeListener.onPropertyUpdate(property, (Object)value);
            }
        }
    }

    @Override
    public void putValue(String propertyName, String value) {
        if (propertyName != null) {
            this.properties.put(propertyName, value.toString());
            for (ProfileChangeListener profileChangeListener : this.listeners) {
                profileChangeListener.onPropertyUpdate(propertyName, (Object)value);
            }
        }
    }

    @Override
    public void putValues(Properties values) {
        if (values != null) {
            HashMap<Object, String> hashMap = new HashMap<Object, String>();
            for (Object object : values.keySet()) {
                if (!(object instanceof String)) continue;
                String string = (String)object;
                String string2 = this.properties.getProperty(string);
                String string3 = values.getProperty(string);
                boolean bl = string2 == null || !string2.equals(string3);
                if (!bl) continue;
                hashMap.put(string, string3);
                this.properties.setProperty(string, string3);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                for (ProfileChangeListener profileChangeListener : this.listeners) {
                    profileChangeListener.onPropertyUpdate((String)entry.getKey(), entry.getValue());
                }
            }
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public Object getObject(PDFCProperty<?> property) {
        return this.getObject(property != null ? property.name() : null);
    }

    @Override
    public String getString(PDFCProperty<?> property) {
        return this.getString(property != null ? property.name() : null);
    }

    @Override
    public int getInt(PDFCProperty<?> property) {
        return this.getInt(property != null ? property.name() : null);
    }

    @Override
    public double getDouble(PDFCProperty<?> property) {
        return this.getDouble(property != null ? property.name() : null);
    }

    @Override
    public boolean getBool(PDFCProperty<?> property) {
        return this.getBool(property != null ? property.name() : null);
    }

    public static interface ProfileChangeListener {
        public void onPropertyUpdate(PDFCProperty<?> var1, Object var2);

        public void onPropertyUpdate(String var1, Object var2);
    }
}

