/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.util;

import com.inet.annotations.InternalApi;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Properties;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@InternalApi
public class PdfcImageIO {
    public static final String VERTICAL_PIXEL_SIZE = "VerticalPixelSize";
    public static final String HORIZONTAL_PIXEL_SIZE = "HorizontalPixelSize";
    public static final float DPI_TO_DPMM = 25.4f;

    public static ImageWithMeta readImage(File path) throws IOException {
        return PdfcImageIO.a(ImageIO.createImageInputStream(path));
    }

    public static ImageWithMeta readImage(InputStream in) throws IOException {
        return PdfcImageIO.a(ImageIO.createImageInputStream(in));
    }

    private static ImageWithMeta a(ImageInputStream imageInputStream) throws IOException {
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
        if (!iterator.hasNext()) {
            return null;
        }
        ImageReader imageReader = iterator.next();
        imageReader.setInput(imageInputStream);
        BufferedImage bufferedImage = imageReader.read(0);
        int n = -1;
        int n2 = -1;
        Properties properties = new Properties();
        IIOMetadata iIOMetadata = imageReader.getImageMetadata(0);
        if (iIOMetadata != null) {
            Node node;
            String[] stringArray = iIOMetadata.getMetadataFormatNames();
            for (String object2 : stringArray) {
                node = (IIOMetadataNode)iIOMetadata.getAsTree(object2);
                PdfcImageIO.a((IIOMetadataNode)node, properties, "");
            }
            IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)iIOMetadata.getAsTree("javax_imageio_1.0");
            NodeList nodeList = iIOMetadataNode.getElementsByTagName(HORIZONTAL_PIXEL_SIZE);
            if (nodeList.getLength() > 0) {
                IIOMetadataNode iIOMetadataNode2 = (IIOMetadataNode)nodeList.item(0);
                NamedNodeMap namedNodeMap = iIOMetadataNode2.getAttributes();
                node = namedNodeMap.item(0);
                n = Math.round(25.4f / Float.parseFloat(node.getNodeValue()));
            }
            if (nodeList.getLength() > 0) {
                nodeList = iIOMetadataNode.getElementsByTagName(VERTICAL_PIXEL_SIZE);
                IIOMetadataNode iIOMetadataNode3 = (IIOMetadataNode)nodeList.item(0);
                NamedNodeMap namedNodeMap = iIOMetadataNode3.getAttributes();
                node = namedNodeMap.item(0);
                n2 = Math.round(25.4f / Float.parseFloat(node.getNodeValue()));
            }
        }
        int n3 = n > 0 ? (n2 > 0 ? (n + n2) / 2 : n) : (n2 > 0 ? n2 : -1);
        return new ImageWithMeta(bufferedImage, n3, properties);
    }

    private static void a(IIOMetadataNode iIOMetadataNode, Properties properties, String object) {
        object = (String)object + (((String)object).isBlank() ? "" : ".") + iIOMetadataNode.getNodeName();
        if (iIOMetadataNode.getAttributes().getLength() != 0) {
            properties.put(object, iIOMetadataNode.getAttributes().item(0).getNodeValue());
        }
        for (int i = 0; i < iIOMetadataNode.getLength(); ++i) {
            PdfcImageIO.a((IIOMetadataNode)iIOMetadataNode.item(i), properties, (String)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeImage(BufferedImage image, int dpi, String format, Object out) throws IOException {
        if (!(out instanceof File) && !(out instanceof OutputStream)) {
            throw new IllegalArgumentException("The parameter 'out' has to be either a File or an OutputStream. A '" + out.getClass().getSimpleName() + "' is not allowe here");
        }
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(format);
        while (iterator.hasNext()) {
            Object object;
            ImageWriter imageWriter = iterator.next();
            ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
            IIOMetadata iIOMetadata = imageWriter.getDefaultImageMetadata(ImageTypeSpecifier.createFromBufferedImageType(((BufferedImage)image).getType()), imageWriteParam);
            if (iIOMetadata.isReadOnly() || !iIOMetadata.isStandardMetadataFormatSupported()) continue;
            if ("png".equalsIgnoreCase(format)) {
                PdfcImageIO.a(iIOMetadata, dpi);
            } else {
                if (((BufferedImage)image).getColorModel().getNumComponents() != 3 && ((BufferedImage)image).getColorModel().getNumComponents() != 1) {
                    object = new BufferedImage(((BufferedImage)image).getWidth(), ((BufferedImage)image).getHeight(), 1);
                    Graphics graphics = ((BufferedImage)object).getGraphics();
                    graphics.drawImage((Image)image, 0, 0, null);
                    graphics.dispose();
                    image = object;
                    iIOMetadata = imageWriter.getDefaultImageMetadata(ImageTypeSpecifier.createFromBufferedImageType(((BufferedImage)image).getType()), imageWriteParam);
                }
                PdfcImageIO.b(iIOMetadata, dpi);
            }
            object = ImageIO.createImageOutputStream(out);
            try {
                imageWriter.setOutput(object);
                imageWriter.write(iIOMetadata, new IIOImage((RenderedImage)image, null, iIOMetadata), imageWriteParam);
                break;
            }
            finally {
                object.close();
            }
        }
    }

    private static void a(IIOMetadata iIOMetadata, int n) throws IOException {
        double d2 = (float)n / 25.4f;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(HORIZONTAL_PIXEL_SIZE);
        iIOMetadataNode.setAttribute("value", Double.toString(d2));
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode(VERTICAL_PIXEL_SIZE);
        iIOMetadataNode2.setAttribute("value", Double.toString(d2));
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("Dimension");
        iIOMetadataNode3.appendChild(iIOMetadataNode);
        iIOMetadataNode3.appendChild(iIOMetadataNode2);
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("javax_imageio_1.0");
        iIOMetadataNode4.appendChild(iIOMetadataNode3);
        iIOMetadata.mergeTree("javax_imageio_1.0", iIOMetadataNode4);
    }

    private static void b(IIOMetadata iIOMetadata, int n) {
        String string = "javax_imageio_jpeg_image_1.0";
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(string);
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("JPEGvariety");
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("markerSequence");
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("app0JFIF");
        iIOMetadataNode4.setAttribute("majorVersion", "1");
        iIOMetadataNode4.setAttribute("minorVersion", "2");
        iIOMetadataNode4.setAttribute("thumbWidth", "0");
        iIOMetadataNode4.setAttribute("thumbHeight", "0");
        iIOMetadataNode4.setAttribute("resUnits", "1");
        iIOMetadataNode4.setAttribute("Xdensity", String.valueOf(n));
        iIOMetadataNode4.setAttribute("Ydensity", String.valueOf(n));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        iIOMetadataNode2.appendChild(iIOMetadataNode4);
        try {
            iIOMetadata.mergeTree(string, iIOMetadataNode);
        }
        catch (IIOInvalidTreeException iIOInvalidTreeException) {
            // empty catch block
        }
    }

    @InternalApi
    public static class ImageWithMeta {
        private BufferedImage pe;
        private int dpi;
        private Properties ug;

        private ImageWithMeta(BufferedImage image, int dpi, Properties allMetaInfo) {
            this.pe = image;
            this.dpi = dpi;
            this.ug = allMetaInfo;
        }

        public BufferedImage getImage() {
            return this.pe;
        }

        public int getDPI() {
            return this.dpi;
        }

        public Properties getMeta() {
            return this.ug;
        }
    }
}

