/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.results.filter;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.model.PagedElement;
import com.inet.pdfc.results.filter.ResultFilter;
import com.inet.pdfc.util.Pair;
import com.inet.plugin.NamedExtension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@JsonData
@InternalApi
public class PerModificationResultFilter
extends ResultFilter
implements NamedExtension {
    public static final String EXTENSION_NAME = "PerModificationFilter";
    private Set<ElementID> filterElementsFirst = new HashSet<ElementID>();
    private Set<ElementID> filterElementsSecond = new HashSet<ElementID>();

    @Override
    public void filterDifferencesImpl(List<? extends DiffGroup> differences) {
        PerModificationResultFilter.idToMod(this.filterElementsFirst, this.filterElementsSecond, differences).forEach(m -> m.setVisible(false));
    }

    @Override
    public void clear() {
        List<Modification> list = PerModificationResultFilter.idToMod(this.filterElementsFirst, this.filterElementsSecond, this.getModel().getDiffs(false, false));
        this.filterElementsFirst = new HashSet<ElementID>();
        this.filterElementsSecond = new HashSet<ElementID>();
        this.toggleVisibilty(list, new ArrayList<Modification>());
    }

    public void addModificationsToFilter(Modification ... modifications) {
        Pair<Set<ElementID>> pair = PerModificationResultFilter.modToID(Arrays.asList(modifications));
        this.filterElementsFirst.addAll((Collection<ElementID>)pair.get(true));
        this.filterElementsSecond.addAll((Collection<ElementID>)pair.get(false));
        this.toggleVisibilty(new ArrayList<Modification>(), Arrays.asList(modifications));
    }

    public void removeModificationsFromFilter(Modification ... modifications) {
        Pair<Set<ElementID>> pair = PerModificationResultFilter.modToID(Arrays.asList(modifications));
        this.filterElementsFirst.removeAll((Collection)pair.get(true));
        this.filterElementsSecond.removeAll((Collection)pair.get(false));
        this.toggleVisibilty(Arrays.asList(modifications), new ArrayList<Modification>());
    }

    private static List<Modification> idToMod(Set<ElementID> idsFirst, Set<ElementID> idsSecond, List<? extends DiffGroup> differences) {
        ArrayList<Modification> arrayList = new ArrayList<Modification>();
        for (DiffGroup diffGroup : differences) {
            if (diffGroup.getType() == DiffGroup.GroupType.Sync) continue;
            block1: for (Modification modification : diffGroup.getModifications()) {
                for (boolean bl : new boolean[]{true, false}) {
                    Set<ElementID> set = bl ? idsFirst : idsSecond;
                    for (PagedElement pagedElement : modification.getAffectedElements(bl)) {
                        if (!(pagedElement instanceof DrawableElement) || !set.contains(((DrawableElement)pagedElement).getElementID())) continue;
                        arrayList.add(modification);
                        continue block1;
                    }
                }
            }
        }
        return arrayList;
    }

    private static Pair<Set<ElementID>> modToID(List<Modification> modifications) {
        Pair<Set<ElementID>> pair = new Pair<Set<ElementID>>(new HashSet(), new HashSet());
        for (Modification modification : modifications) {
            for (boolean bl : new boolean[]{true, false}) {
                Set<ElementID> set = pair.get(bl);
                for (PagedElement pagedElement : modification.getAffectedElements(bl)) {
                    if (!(pagedElement instanceof DrawableElement)) continue;
                    set.add(((DrawableElement)pagedElement).getElementID());
                }
            }
        }
        return pair;
    }

    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    @Override
    public boolean isEmpty() {
        return this.filterElementsFirst.isEmpty() && this.filterElementsSecond.isEmpty();
    }
}

