/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.results;

import com.inet.annotations.PublicApi;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.config.ColorSetting;
import com.inet.pdfc.config.DefaultSetting;
import com.inet.pdfc.config.ObjectSetting;
import com.inet.pdfc.config.Settings;
import com.inet.pdfc.config.SettingsControl;
import com.inet.pdfc.config.VisibilitySetting;
import com.inet.pdfc.error.ExceptionData;
import com.inet.pdfc.generator.filter.ISortFilterFactory;
import com.inet.pdfc.generator.message.HighlightData;
import com.inet.pdfc.generator.message.InfoData;
import com.inet.pdfc.generator.message.PageFilterDone;
import com.inet.pdfc.generator.message.PageReadDone;
import com.inet.pdfc.generator.message.ProgressState;
import com.inet.pdfc.generator.message.State;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.generator.model.IDiffGroupBounds;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.generator.rendercache.PageImageCache;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.HasBounds;
import com.inet.pdfc.model.PagedElement;
import com.inet.pdfc.plugin.PluginManager;
import com.inet.pdfc.presenter.BasePresenter;
import com.inet.pdfc.results.CollapsePagesModelData;
import com.inet.pdfc.results.ResultModelData;
import com.inet.pdfc.results.ResultModelUpdater;
import com.inet.pdfc.results.ResultPage;
import com.inet.pdfc.results.filter.ResultFilter;
import com.inet.pdfc.results.painter.Painter;
import com.inet.pdfc.util.LocationUtils;
import com.inet.plugin.ServerPluginManager;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.RectangularShape;
import java.io.Closeable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@PublicApi
public class ResultModel
implements Closeable,
Serializable {
    private ResultModelData rs = new ResultModelData();
    private transient List<ResultModelChangeListener> no;
    private DefaultSetting settings = new DefaultSetting();
    private HashSet<String> rD;
    private transient List<ResultFilter> rE;
    private transient Consumer<Map<DiffGroup, Set<Modification>>> rF;
    private transient long[] rG;
    private transient long[] rH;

    public ResultModel() {
        for (DiffGroup.GroupType groupType : DiffGroup.GroupType.values()) {
            this.settings.setEnabled(true, groupType);
        }
        this.settings.setEnabled(true, new Painter.HighlightColorSetting("ANNOTATION"));
        this.no = new ArrayList<ResultModelChangeListener>(1);
        this.rF = map -> this.a(new ChangeInfo(this, (Map<DiffGroup, Set<Modification>>)map));
    }

    public ResultModel(ResultModelData data) {
        this();
        this.rs = data;
    }

    private void cY() {
        if (this.rD != null) {
            return;
        }
        this.rD = new HashSet();
        List list = ServerPluginManager.getInstance().get(ISortFilterFactory.class);
        for (ISortFilterFactory iSortFilterFactory : list) {
            this.rD.add(iSortFilterFactory.getExtensionName());
        }
        this.rD.add("ANNOTATION");
    }

    public void addChangeListener(ResultModelChangeListener l) {
        if (this.no == null) {
            this.no = new ArrayList<ResultModelChangeListener>();
        }
        this.no.add(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ResultModelData resultModelData = this.rs;
        synchronized (resultModelData) {
            this.rs.clear();
            this.a(new ChangeInfo(STATE_CHANGE_TYPE.CLEARED, null, this, this.rs.getProgress()));
        }
    }

    @Override
    public void close() {
        this.clear();
    }

    static Rectangle a(DiffGroup diffGroup, boolean bl, boolean bl2, ResultModelData resultModelData) {
        List<PagedElement> list;
        IDiffGroupBounds iDiffGroupBounds = diffGroup.getBoundingElements();
        PagedElement pagedElement = bl ? iDiffGroupBounds.getBeforeFirst() : iDiffGroupBounds.getBeforeSecond();
        PagedElement pagedElement2 = bl ? iDiffGroupBounds.getAfterFirst() : iDiffGroupBounds.getAfterSecond();
        List<PagedElement> list2 = list = bl ? diffGroup.getRemovedElements() : diffGroup.getAddedElements();
        if (pagedElement == null && pagedElement2 == null && list.isEmpty() && !bl2) {
            List<PagedElement> list3 = list = !bl ? diffGroup.getRemovedElements() : diffGroup.getAddedElements();
        }
        if (list.isEmpty()) {
            Rectangle rectangle = new Rectangle();
            if (pagedElement != null || pagedElement2 != null) {
                if (pagedElement == null) {
                    PagedElement pagedElement3 = bl ? iDiffGroupBounds.getAfterSecond() : iDiffGroupBounds.getAfterFirst();
                    List<PagedElement> list4 = bl ? diffGroup.getAddedElements() : diffGroup.getRemovedElements();
                    rectangle.y = resultModelData.getPage(pagedElement2.getPageIndex(), bl).getPageOffset() + (int)LocationUtils.getMinY(pagedElement2.getBounds());
                    if (pagedElement3 != null && list4.size() > 0 && pagedElement3.getPageIndex() == list4.get(list4.size() - 1).getPageIndex()) {
                        PagedElement pagedElement4 = list4.get(list4.size() - 1);
                        Rectangle rectangle2 = LocationUtils.getBounds(pagedElement3);
                        Rectangle rectangle3 = LocationUtils.getBounds(pagedElement4);
                        Point point = new Point(rectangle2.x, rectangle2.y + rectangle2.height);
                        Point point2 = new Point(rectangle3.x + rectangle3.height, rectangle3.y + rectangle3.height);
                        if (point2.y == point.y) {
                            rectangle.y += rectangle3.height / 2;
                            rectangle.x = LocationUtils.getBounds((HasBounds)pagedElement2).x + point2.x - point.x;
                        }
                    }
                } else if (pagedElement2 == null) {
                    PagedElement pagedElement5 = bl ? iDiffGroupBounds.getBeforeSecond() : iDiffGroupBounds.getBeforeFirst();
                    List<PagedElement> list5 = bl ? diffGroup.getAddedElements() : diffGroup.getRemovedElements();
                    rectangle.y = resultModelData.getPage(pagedElement.getPageIndex(), bl).getPageOffset() + (int)LocationUtils.getMaxY(pagedElement.getBounds());
                    if (pagedElement5 != null && list5.size() > 0 && pagedElement5.getPageIndex() == list5.get(0).getPageIndex()) {
                        PagedElement pagedElement6 = list5.get(0);
                        Rectangle rectangle4 = LocationUtils.getBounds(pagedElement5);
                        Rectangle rectangle5 = LocationUtils.getBounds(pagedElement6);
                        Point point = new Point(rectangle4.x + rectangle4.width, rectangle4.y + rectangle4.height);
                        Point point3 = new Point(rectangle5.x, rectangle5.y + rectangle5.height);
                        if (point.y == point3.y) {
                            Rectangle rectangle6 = LocationUtils.getBounds(pagedElement);
                            rectangle.y += point3.y - point.y - rectangle5.height / 2;
                            rectangle.x = rectangle6.x + rectangle6.width + point3.x - point.x;
                        }
                    }
                } else {
                    Rectangle rectangle7 = LocationUtils.getBounds(pagedElement);
                    Rectangle rectangle8 = LocationUtils.getBounds(pagedElement2);
                    if (Math.abs(((RectangularShape)rectangle7).getY() - ((RectangularShape)rectangle8).getY()) < 0.05) {
                        boolean bl3 = pagedElement.getType() == ElementType.TextWord || pagedElement2.getType() == ElementType.TextWord;
                        rectangle.y = resultModelData.getPage(pagedElement.getPageIndex(), bl).getPageOffset() + (int)(LocationUtils.getMinY(rectangle7) + (bl3 ? Math.abs(((RectangularShape)rectangle7).getHeight()) / 2.0 : 0.0));
                        rectangle.x = (int)Math.min(rectangle7.getMaxX(), rectangle8.getMinX());
                        rectangle.width = (int)Math.abs(rectangle8.getMinX() - rectangle7.getMaxX());
                    } else {
                        PagedElement pagedElement7 = !bl ? iDiffGroupBounds.getBeforeFirst() : iDiffGroupBounds.getBeforeSecond();
                        PagedElement pagedElement8 = !bl ? iDiffGroupBounds.getAfterFirst() : iDiffGroupBounds.getAfterSecond();
                        List<PagedElement> list6 = !bl ? diffGroup.getRemovedElements() : diffGroup.getAddedElements();
                        boolean bl4 = ResultModel.i(pagedElement7, list6.size() > 0 ? list6.get(0) : null);
                        boolean bl5 = ResultModel.i(pagedElement8, list6.size() > 0 ? list6.get(list6.size() - 1) : null);
                        if (bl4) {
                            rectangle.y = (int)((double)(resultModelData.getPage(pagedElement.getPageIndex(), bl).getPageOffset() + (int)LocationUtils.getMinY(rectangle7)) + Math.abs(((RectangularShape)rectangle7).getHeight()) / 2.0);
                            rectangle.x = (int)rectangle7.getMaxX();
                        } else if (bl5) {
                            rectangle.y = (int)((double)(resultModelData.getPage(pagedElement2.getPageIndex(), bl).getPageOffset() + (int)LocationUtils.getMinY(rectangle8)) + Math.abs(((RectangularShape)rectangle8).getHeight()) / 2.0);
                            rectangle.x = (int)rectangle8.getMinX() - 3;
                        } else {
                            int n = resultModelData.getPage(pagedElement.getPageIndex(), bl).getPageOffset() + (int)LocationUtils.getMaxY(rectangle7);
                            int n2 = resultModelData.getPage(pagedElement2.getPageIndex(), bl).getPageOffset() + (int)LocationUtils.getMinY(rectangle8);
                            rectangle.y = (n + n2) / 2;
                        }
                    }
                }
            }
            return rectangle;
        }
        int n = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        Rectangle rectangle = new Rectangle();
        for (PagedElement pagedElement9 : list) {
            int n4;
            int n5;
            Rectangle rectangle9 = LocationUtils.getBounds(pagedElement9);
            ResultPage resultPage = resultModelData.getPage(pagedElement9.getPageIndex(), bl);
            if (rectangle9 == null || resultPage == null) {
                PDFCCore.LOGGER_COMPARE.error((Object)("An unexpected state! diffR = " + String.valueOf(rectangle9) + " page = " + String.valueOf(resultPage) + " index = " + pagedElement9.getPageIndex() + " for " + bl));
                continue;
            }
            if (rectangle9.x < 0 || rectangle9.y < 0 || rectangle9.x + rectangle9.width > resultPage.getWidth() || rectangle9.y + rectangle9.height > resultPage.getHeight()) {
                int n6;
                n5 = rectangle9.x + rectangle9.width;
                int n7 = rectangle9.x < 0 ? 0 : (n4 = rectangle9.x > resultPage.getWidth() ? resultPage.getWidth() : rectangle9.x);
                n5 = n5 < 0 ? 0 : (n5 > resultPage.getWidth() ? resultPage.getWidth() : n5);
                int n8 = rectangle9.y + rectangle9.height;
                int n9 = rectangle9.y < 0 ? 0 : (n6 = rectangle9.y > resultPage.getHeight() ? resultPage.getHeight() : rectangle9.y);
                n8 = n8 < 0 ? 0 : (n8 > resultPage.getHeight() ? resultPage.getHeight() : n8);
                rectangle9 = new Rectangle(n4, n6, n5 - n4, n8 - n6);
            }
            n5 = resultPage.getPageOffset() + rectangle9.y;
            n4 = n5 + rectangle9.height;
            n = Math.min(n, n5);
            n3 = Math.max(n3, n4);
        }
        rectangle.y = n;
        rectangle.height = n3 - n;
        return rectangle;
    }

    private void a(ChangeInfo changeInfo) {
        for (int i = this.no.size() - 1; i >= 0; --i) {
            ResultModelChangeListener resultModelChangeListener = this.no.get(i);
            resultModelChangeListener.modelChanged(changeInfo);
        }
    }

    List<ResultModelChangeListener> cZ() {
        return this.no;
    }

    public InfoData getComparisonParameters() {
        return this.rs.getInfo();
    }

    public List<DiffGroup> getDifferences(boolean filtered) {
        return this.rs.getDiffs(filtered, false);
    }

    public int getDifferences(Modification.ModificationType type, boolean filtered) {
        int n = 0;
        for (DiffGroup diffGroup : this.rs.getDiffs(filtered, false)) {
            for (Modification modification : diffGroup.getModifications()) {
                if (modification.getModificationType() != type) continue;
                ++n;
            }
        }
        return n;
    }

    public int getDifferencesCount(boolean filtered) {
        int n = 0;
        List<DiffGroup> list = this.rs.getDiffs(filtered, false);
        if (filtered) {
            for (DiffGroup diffGroup : list) {
                if (diffGroup.getType() == DiffGroup.GroupType.Sync) continue;
                List<Modification> list2 = diffGroup.getModifications();
                for (int i = 0; i < list2.size(); ++i) {
                    if (!list2.get(i).isVisible()) continue;
                    ++n;
                }
            }
        } else {
            for (DiffGroup diffGroup : list) {
                if (diffGroup.getType() == DiffGroup.GroupType.Sync) continue;
                n += diffGroup.getDifferencesCount();
            }
        }
        return n;
    }

    public synchronized HighlightData getHighlightData(String key) {
        return this.rs.getHighlights().get(key);
    }

    public List<HighlightData.Highlight> getHighlightsForPage(int pageNr, boolean firstDocument) {
        LinkedHashMap<String, HighlightData> linkedHashMap = this.rs.getHighlights();
        if (linkedHashMap.isEmpty()) {
            return null;
        }
        if (this.rs.getPage(pageNr, firstDocument) == null) {
            return null;
        }
        if (linkedHashMap.size() == 1) {
            HighlightData highlightData = (HighlightData)linkedHashMap.values().iterator().next();
            String string = highlightData.getFilterKey();
            if (this.settings.isEnabled(new Painter.HighlightColorSetting(string))) {
                List<HighlightData.Highlight> list = highlightData.getPageHighlights(pageNr, firstDocument);
                if (list != null) {
                    list.forEach(highlight -> {
                        if (highlight.getType() == null) {
                            highlight.setType(string);
                        }
                    });
                }
                return list;
            }
            return null;
        }
        ArrayList<HighlightData.Highlight> arrayList = new ArrayList<HighlightData.Highlight>();
        for (HighlightData highlightData : linkedHashMap.values()) {
            List<HighlightData.Highlight> list;
            String string = highlightData.getFilterKey();
            if (!this.settings.isEnabled(new Painter.HighlightColorSetting(string)) || (list = highlightData.getPageHighlights(pageNr, firstDocument)) == null) continue;
            list.forEach(highlight -> {
                if (highlight.getType() == null) {
                    highlight.setType(string);
                }
            });
            arrayList.addAll(list);
        }
        return !arrayList.isEmpty() ? arrayList : null;
    }

    public int getPageCount(boolean first) {
        return this.rs.getPageCount(first);
    }

    ResultModelData getModelData() {
        return this.rs;
    }

    public ResultPage getPage(int pageIndex, boolean first) {
        if (pageIndex < 0 || pageIndex >= this.rs.getPageCount(first)) {
            return null;
        }
        return this.e(pageIndex, first);
    }

    private long @Nonnull [] u(boolean bl) {
        long[] lArray = bl ? this.rG : this.rH;
        int n = this.rs.getPageCount(bl);
        if (lArray != null && lArray.length == n) {
            return lArray;
        }
        lArray = new long[n];
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            ResultPage resultPage = this.rs.getPage(i, bl);
            if (resultPage != null) {
                l = resultPage.getPageOffset();
            }
            lArray[i] = l;
        }
        if (bl) {
            this.rG = lArray;
        } else {
            this.rH = lArray;
        }
        return lArray;
    }

    public ResultPage getPageAt(Point pos, boolean left) {
        if (this.rs.getPageCount(left) == 0) {
            return null;
        }
        if (pos.y < 0) {
            return this.rs.getPage(0, left);
        }
        long[] lArray = this.u(left);
        int n = Arrays.binarySearch(lArray, (long)pos.y);
        if (n < 0) {
            n = -n - 2;
        }
        ResultPage resultPage = this.rs.getPage(n, left);
        while (resultPage != null && !CollapsePagesModelData.isRealPage(resultPage) && resultPage.getHeight() == 0 && resultPage.getPageIndex() > 0) {
            int n2 = resultPage.getPageIndex() - 1;
            resultPage = this.rs.getPage(n2, left);
        }
        return resultPage;
    }

    public PageImageCache getPageImageCache() {
        return this.rs.getPageImageCache();
    }

    ResultPage e(int n, boolean bl) {
        return this.rs.getPage(n, bl);
    }

    public boolean isEmpty() {
        return this.rs.getPageCount(true) == 0 && this.rs.getPageCount(false) == 0;
    }

    public boolean isVisible(VisibilitySetting setting) {
        return this.settings.isEnabled(setting);
    }

    public void removeChangeListener(ResultModelChangeListener l) {
        if (this.no == null) {
            this.no = new ArrayList<ResultModelChangeListener>();
        }
        this.no.remove(l);
    }

    void a(InfoData infoData) {
        this.rs.setInfo(infoData);
        if (infoData.getFirstPageCount() >= 0 && infoData.getSecondPageCount() >= 0) {
            this.a(new ChangeInfo(STATE_CHANGE_TYPE.INIT, null, this, this.rs.getProgress()));
        }
    }

    public void setSetting(Settings settings) {
        Object object;
        if (settings == null) {
            PDFCCore.LOGGER_CORE.warn((Object)"new setting should be set, but the settings is null");
            return;
        }
        HashMap<String, VisibilitySetting> hashMap = new HashMap<String, VisibilitySetting>();
        boolean bl = false;
        ArrayList<Enum> arrayList = new ArrayList<Enum>();
        arrayList.addAll(Arrays.asList(Settings.OPTION.values()));
        arrayList.addAll(Arrays.asList(Settings.EXPORT.values()));
        arrayList.addAll(Arrays.asList(Settings.METAOPTION.values()));
        for (VisibilitySetting visibilitySetting : arrayList) {
            if (this.a(visibilitySetting, settings)) {
                hashMap.put(SettingsControl.getKey(visibilitySetting, SettingsControl.PURPOSE.visibility), visibilitySetting);
            }
            if (!(visibilitySetting instanceof ColorSetting)) continue;
            ColorSetting colorSetting = (ColorSetting)visibilitySetting;
            Color object22 = settings.getColor(colorSetting);
            object = this.settings.getColor(colorSetting);
            if (Objects.equals(object, object22)) continue;
            this.settings.setColor(object22, colorSetting);
            hashMap.put(SettingsControl.getKey(visibilitySetting, SettingsControl.PURPOSE.color), visibilitySetting);
        }
        if (this.settings.isEnabled(Settings.OPTION.ONLYPAGESWITHDIFFS)) {
            if (!(this.rs instanceof CollapsePagesModelData)) {
                this.rs = new CollapsePagesModelData(this.rs);
                this.rs.finish();
                bl = true;
                this.rG = null;
                this.rH = null;
            }
        } else if (this.rs instanceof CollapsePagesModelData) {
            this.rs = ((CollapsePagesModelData)this.rs).getOriginalData();
            bl = true;
            this.rG = null;
            this.rH = null;
        }
        for (Modification.ModificationType modificationType : Modification.ModificationType.values()) {
            if (this.a((VisibilitySetting)modificationType, settings)) {
                hashMap.put(SettingsControl.getKey(modificationType, SettingsControl.PURPOSE.visibility), modificationType);
                bl = true;
            }
            object = settings.getMarkerColor(modificationType);
            Color color = this.settings.getMarkerColor(modificationType);
            if (!Objects.equals(color, object)) {
                this.settings.setMarkerColor((Color)object, modificationType);
                hashMap.put(SettingsControl.getKey(modificationType, SettingsControl.PURPOSE.marker), modificationType);
            }
            object = settings.getOutlineColor(modificationType);
            color = this.settings.getOutlineColor(modificationType);
            if (Objects.equals(color, object)) continue;
            this.settings.setColor((Color)object, modificationType);
            hashMap.put(SettingsControl.getKey(modificationType, SettingsControl.PURPOSE.outline), modificationType);
        }
        this.cY();
        for (String string : this.rD) {
            Painter.HighlightColorSetting highlightColorSetting = new Painter.HighlightColorSetting(string);
            if (this.a((VisibilitySetting)highlightColorSetting, settings)) {
                hashMap.put(SettingsControl.getKey(highlightColorSetting, SettingsControl.PURPOSE.visibility), highlightColorSetting);
            }
            if (!this.a(highlightColorSetting, settings)) continue;
            hashMap.put(SettingsControl.getKey(highlightColorSetting, SettingsControl.PURPOSE.color), highlightColorSetting);
        }
        for (ObjectSetting objectSetting : settings.getAllObjectSettingNames()) {
            String string = objectSetting.name();
            Object object2 = settings.getSetting(string);
            object = this.settings.getSetting(string);
            if (!Objects.equals(object, object2)) {
                this.settings.setSetting(object2, string);
                hashMap.put(SettingsControl.getKey(objectSetting, SettingsControl.PURPOSE.object), objectSetting);
            }
            if (!objectSetting.getTyp().equals(ResultModelUpdater.DIFF_LIMIT.getTyp()) || !this.rs.setDifferencesLimit(object2 != null ? ((Number)object2).intValue() : -1)) continue;
            hashMap.put(SettingsControl.getKey(objectSetting, SettingsControl.PURPOSE.object), objectSetting);
        }
        if (bl) {
            Set set = Arrays.stream(Modification.ModificationType.values()).filter(settings::isEnabled).collect(Collectors.toSet());
            this.rs.setVisibleModTypes(set);
            if (this.rE != null) {
                this.rE.forEach(resultFilter -> resultFilter.setResultModel(this));
            }
        }
        if (hashMap.size() > 0) {
            this.a(new ChangeInfo(this, hashMap, this.rs.getProgress()));
        }
    }

    private boolean a(VisibilitySetting visibilitySetting, Settings settings) {
        boolean bl;
        boolean bl2 = bl = settings.isEnabled(visibilitySetting) != this.settings.isEnabled(visibilitySetting);
        if (bl) {
            this.settings.setEnabled(settings.isEnabled(visibilitySetting), visibilitySetting);
            return true;
        }
        return false;
    }

    private boolean a(ColorSetting colorSetting, Settings settings) {
        boolean bl;
        Color color = settings.getColor(colorSetting);
        boolean bl2 = bl = !Objects.equals(color, this.settings.getColor(colorSetting));
        if (bl) {
            this.settings.setColor(color, colorSetting);
            return true;
        }
        return false;
    }

    public Settings getSettings() {
        return this.settings.copy();
    }

    void addResultFilter(ResultFilter filter) {
        if (this.rE == null) {
            this.rE = new ArrayList<ResultFilter>();
        }
        if (!this.rE.contains(filter)) {
            this.rE.add(filter);
            filter.setResultModel(this);
            filter.addChangeListener(this.rF);
            filter.filterDifferences(this.getDifferences(false));
        }
    }

    void removeResultFilter(ResultFilter filter) {
        if (this.rE == null) {
            return;
        }
        this.rE.remove(filter);
        filter.removeChangeListener(this.rF);
    }

    List<ResultFilter> getResultFilters() {
        return this.rE != null ? new ArrayList<ResultFilter>(this.rE) : new ArrayList(1);
    }

    private static boolean i(PagedElement pagedElement, PagedElement pagedElement2) {
        if (pagedElement == null || pagedElement2 == null) {
            return false;
        }
        return Math.abs(LocationUtils.getMaxY(pagedElement.getBounds()) - LocationUtils.getMaxY(pagedElement2.getBounds())) < 0.5;
    }

    static {
        PluginManager.setPluginFilterForAPI();
        PluginManager.initConditionally();
    }

    public static class ChangeInfo {
        private STATE_CHANGE_TYPE rI;
        private int startL = -1;
        private int startR = -1;
        private int endL = -1;
        private int endR = -1;
        private float progress = 0.0f;
        private ResultModel of;
        private Map<String, VisibilitySetting> rJ = new HashMap<String, VisibilitySetting>();
        private Map<DiffGroup, Set<Modification>> rK;

        public ChangeInfo(ResultModel source, Map<DiffGroup, Set<Modification>> visibilityChanged) {
            this.of = source;
            this.rI = STATE_CHANGE_TYPE.VISIBILITY_CHANGE;
            this.rK = visibilityChanged;
        }

        public ChangeInfo(STATE_CHANGE_TYPE type, ResultModel source, PageReadDone doneChunk, ProgressState progress) {
            this.rI = type;
            this.of = source;
            this.progress = progress.calculateProgressValue();
            this.startL = doneChunk.getStart(true);
            this.startR = doneChunk.getStart(false);
            this.endL = doneChunk.getEnd(true);
            this.endR = doneChunk.getEnd(false);
        }

        public ChangeInfo(STATE_CHANGE_TYPE type, ResultModel source, PageFilterDone doneChunk, ProgressState progress) {
            this.rI = type;
            this.of = source;
            this.progress = progress.calculateProgressValue();
            if (doneChunk.isFirst()) {
                this.startL = doneChunk.getPageIndex();
                this.startR = doneChunk.getPageIndex();
            } else {
                this.endL = doneChunk.getPageIndex();
                this.endR = doneChunk.getPageIndex();
            }
        }

        public ChangeInfo(ResultModel source, Map<String, VisibilitySetting> settingChanges, ProgressState progress) {
            int n;
            this.of = source;
            this.rJ = settingChanges;
            this.rI = STATE_CHANGE_TYPE.FILTER_CHANGE;
            this.progress = progress.calculateProgressValue();
            this.startL = 0;
            this.startR = 0;
            this.endL = n = Math.max(source.getPageCount(true), source.getPageCount(false));
            this.endR = n;
        }

        public ChangeInfo(ResultModel source, ProgressState progress) {
            this.of = source;
            State state = progress.getId();
            this.rI = state == State.START || state == State.COMPARING ? STATE_CHANGE_TYPE.PROGRESS_UPDATE : STATE_CHANGE_TYPE.COMPLETED;
            this.progress = progress.calculateProgressValue();
            this.startL = 0;
            this.startR = 0;
            this.endL = source.getPageCount(true);
            this.endR = source.getPageCount(false);
        }

        public ChangeInfo(STATE_CHANGE_TYPE type, List<? extends DiffGroup> newDiffs, ResultModel source, ProgressState progress) {
            this.rI = type;
            this.of = source;
            this.progress = progress.calculateProgressValue();
            if (newDiffs != null && newDiffs.size() > 0) {
                DiffGroup diffGroup = newDiffs.get(0);
                IDiffGroupBounds iDiffGroupBounds = diffGroup.getBoundingElements();
                if (diffGroup.getRemovedElements() != null && diffGroup.getRemovedElements().size() > 0) {
                    this.startL = diffGroup.getRemovedElements().get(0).getPageIndex();
                } else if (iDiffGroupBounds.getBeforeFirst() != null) {
                    this.startL = iDiffGroupBounds.getBeforeFirst().getPageIndex();
                } else if (iDiffGroupBounds.getAfterFirst() != null) {
                    this.startL = iDiffGroupBounds.getAfterFirst().getPageIndex();
                }
                if (diffGroup.getAddedElements() != null && diffGroup.getAddedElements().size() > 0) {
                    this.startR = diffGroup.getAddedElements().get(0).getPageIndex();
                } else if (iDiffGroupBounds.getBeforeSecond() != null) {
                    this.startR = iDiffGroupBounds.getBeforeSecond().getPageIndex();
                } else if (iDiffGroupBounds.getAfterSecond() != null) {
                    this.startR = iDiffGroupBounds.getAfterSecond().getPageIndex();
                }
                DiffGroup diffGroup2 = newDiffs.get(newDiffs.size() - 1);
                IDiffGroupBounds iDiffGroupBounds2 = diffGroup2.getBoundingElements();
                if (diffGroup2.getRemovedElements() != null && diffGroup2.getRemovedElements().size() > 0) {
                    this.endL = diffGroup2.getRemovedElements().get(diffGroup2.getRemovedElements().size() - 1).getPageIndex();
                } else if (iDiffGroupBounds2.getAfterFirst() != null) {
                    this.endL = iDiffGroupBounds2.getAfterFirst().getPageIndex();
                } else if (iDiffGroupBounds2.getBeforeFirst() != null) {
                    this.endL = iDiffGroupBounds2.getBeforeFirst().getPageIndex();
                }
                if (diffGroup2.getAddedElements() != null && diffGroup2.getAddedElements().size() > 0) {
                    this.endR = diffGroup2.getAddedElements().get(diffGroup2.getAddedElements().size() - 1).getPageIndex();
                } else if (iDiffGroupBounds2.getAfterSecond() != null) {
                    this.endR = iDiffGroupBounds2.getAfterSecond().getPageIndex();
                } else if (iDiffGroupBounds2.getBeforeSecond() != null) {
                    this.endR = iDiffGroupBounds2.getBeforeSecond().getPageIndex();
                }
            }
            if (this.startL < 0 && this.startR >= 0) {
                this.startL = this.startR;
            }
            if (this.startR < 0 && this.startL >= 0) {
                this.startR = this.startL;
            }
            if (this.endL < 0 && this.endR >= 0) {
                this.endL = this.endR;
            }
            if (this.endR < 0 && this.endL >= 0) {
                this.endR = this.endL;
            }
        }

        public Map<String, VisibilitySetting> getChangedSettings() {
            return this.rJ;
        }

        public Map<DiffGroup, Set<Modification>> getVisibilityChanges() {
            return this.rK;
        }

        public int getStartL() {
            return this.startL;
        }

        public int getStartR() {
            return this.startR;
        }

        public int getEndL() {
            return this.endL;
        }

        public int getEndR() {
            return this.endR;
        }

        public STATE_CHANGE_TYPE getType() {
            return this.rI;
        }

        public ResultModel getSource() {
            return this.of;
        }

        public boolean isAffected(int pageNr, boolean first) {
            int n;
            int n2 = first ? this.startL : this.startR;
            int n3 = n = first ? this.endL : this.endR;
            if (n2 < 0 && n < 0) {
                return false;
            }
            if (n < 0) {
                return pageNr >= n2;
            }
            return pageNr >= n2 && pageNr <= n;
        }

        public float getProgress() {
            return this.progress;
        }
    }

    public static final class STATE_CHANGE_TYPE
    extends Enum<STATE_CHANGE_TYPE> {
        public static final /* enum */ STATE_CHANGE_TYPE CLEARED = new STATE_CHANGE_TYPE();
        public static final /* enum */ STATE_CHANGE_TYPE INIT = new STATE_CHANGE_TYPE();
        public static final /* enum */ STATE_CHANGE_TYPE INCREMENTAL = new STATE_CHANGE_TYPE();
        public static final /* enum */ STATE_CHANGE_TYPE COMPLETED = new STATE_CHANGE_TYPE();
        public static final /* enum */ STATE_CHANGE_TYPE FILTER_CHANGE = new STATE_CHANGE_TYPE();
        public static final /* enum */ STATE_CHANGE_TYPE HIGHLIGHT_UPDATE = new STATE_CHANGE_TYPE();
        public static final /* enum */ STATE_CHANGE_TYPE PROGRESS_UPDATE = new STATE_CHANGE_TYPE();
        public static final /* enum */ STATE_CHANGE_TYPE VISIBILITY_CHANGE = new STATE_CHANGE_TYPE();
        private static final /* synthetic */ STATE_CHANGE_TYPE[] rL;

        public static STATE_CHANGE_TYPE[] values() {
            return (STATE_CHANGE_TYPE[])rL.clone();
        }

        public static STATE_CHANGE_TYPE valueOf(String name) {
            return Enum.valueOf(STATE_CHANGE_TYPE.class, name);
        }

        private static /* synthetic */ STATE_CHANGE_TYPE[] da() {
            return new STATE_CHANGE_TYPE[]{CLEARED, INIT, INCREMENTAL, COMPLETED, FILTER_CHANGE, HIGHLIGHT_UPDATE, PROGRESS_UPDATE, VISIBILITY_CHANGE};
        }

        static {
            rL = STATE_CHANGE_TYPE.da();
        }
    }

    public static interface ResultModelChangeListener {
        public boolean errorOcurred(ExceptionData var1, boolean var2, BasePresenter.ERROR_SOURCE var3);

        public void modelChanged(ChangeInfo var1);
    }
}

