/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.plugin.configurations;

import com.inet.annotations.InternalApi;
import com.inet.classloader.I18nMessages;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.pdfc.config.CompareType;
import com.inet.pdfc.config.DefaultProfile;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.config.TextStyleType;
import com.inet.pdfc.generator.filter.ISortFilterFactory;
import com.inet.pdfc.generator.resultfilter.IResultFilterFactory;
import com.inet.pdfc.plugin.persistence.ProfilePersistence;
import com.inet.plugin.ServerPluginManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@InternalApi
public class PreInstalledProfile
extends ProfilePersistence {
    private static final String TEXTSTYLES = Arrays.asList(TextStyleType.values()).stream().map(Enum::name).collect(Collectors.joining(","));
    private String aH;
    private String mj;
    private transient Map<Locale, String> mk = new HashMap<Locale, String>();
    private transient Map<Locale, String> descCache = new HashMap<Locale, String>();

    public PreInstalledProfile(GUID guid, String i18nTypeKey) {
        super(guid, null, new DefaultProfile());
        this.aH = "configuration." + i18nTypeKey + ".name";
        this.mj = "configuration." + i18nTypeKey + ".description";
        this.setMetaProperty("lastmodified", String.valueOf(System.currentTimeMillis()));
        this.setMetaProperty("default", Boolean.TRUE.toString());
        this.bG().putValue("PROFIL_NAME", this.getName(Locale.ENGLISH));
        this.bG().putValue("PROFIL_DESCRIPTION", this.getDescription(Locale.ENGLISH, false));
    }

    protected void setPDFCProperty(PDFCProperty<?> property, String value) {
        this.bG().putValue(property, value);
    }

    private DefaultProfile bG() {
        return super.getProfile();
    }

    protected void setPDFCProperty(String property, String value) {
        this.bG().putValue(property, value);
    }

    public static ProfilePersistence getTextOnlyProfile() {
        PreInstalledProfile preInstalledProfile = new PreInstalledProfile(GUID.valueOf((String)"textonly"), "textonly");
        preInstalledProfile.setPDFCProperty(PDFCProperty.CONTINUOUS_COMPARE, "CONTINUOUS");
        PreInstalledProfile.setTypes(preInstalledProfile, CompareType.TEXT);
        PreInstalledProfile.setFilters(preInstalledProfile, "INVISIBLEELEMENTS", "HEADERFOOTER", "TEXTTRANSFORM", "SOLVEFALSEREPLACE");
        preInstalledProfile.setPDFCProperty(PDFCProperty.COMPARE_TEXT_STYLES, "");
        preInstalledProfile.setPDFCProperty(PDFCProperty.FIXED_HEADER_SIZE, "-1");
        preInstalledProfile.setPDFCProperty(PDFCProperty.FIXED_FOOTER_SIZE, "-1");
        preInstalledProfile.setPDFCProperty("TRANSFORM_OPERATIONS", "REPLACE_IDENTICAL");
        return preInstalledProfile;
    }

    public static ProfilePersistence getTextAndStylesProfile() {
        PreInstalledProfile preInstalledProfile = new PreInstalledProfile(GUID.valueOf((String)"textandstyles"), "textandstyles");
        preInstalledProfile.setPDFCProperty(PDFCProperty.CONTINUOUS_COMPARE, "CONTINUOUS");
        PreInstalledProfile.setTypes(preInstalledProfile, CompareType.TEXT);
        PreInstalledProfile.setFilters(preInstalledProfile, "INVISIBLEELEMENTS", "HEADERFOOTER", "TEXTTRANSFORM", "SOLVEFALSEREPLACE");
        preInstalledProfile.setPDFCProperty(PDFCProperty.COMPARE_TEXT_STYLES, TEXTSTYLES);
        preInstalledProfile.setPDFCProperty(PDFCProperty.FIXED_HEADER_SIZE, "-1");
        preInstalledProfile.setPDFCProperty(PDFCProperty.FIXED_FOOTER_SIZE, "-1");
        preInstalledProfile.setPDFCProperty("TRANSFORM_OPERATIONS", "REPLACE_IDENTICAL");
        return preInstalledProfile;
    }

    public static ProfilePersistence getTextAndStylesMultiColumnProfile() {
        PreInstalledProfile preInstalledProfile = new PreInstalledProfile(GUID.valueOf((String)"textandstylesmulti"), "textandstylesmulti");
        preInstalledProfile.setPDFCProperty(PDFCProperty.CONTINUOUS_COMPARE, "CONTINUOUS");
        PreInstalledProfile.setTypes(preInstalledProfile, CompareType.TEXT);
        PreInstalledProfile.setFilters(preInstalledProfile, "INVISIBLEELEMENTS", "HEADERFOOTER", "MULTICOLUMN", "TEXTTRANSFORM", "SOLVEFALSEREPLACE");
        preInstalledProfile.setPDFCProperty(PDFCProperty.COMPARE_TEXT_STYLES, TEXTSTYLES);
        preInstalledProfile.setPDFCProperty(PDFCProperty.FIXED_HEADER_SIZE, "-1");
        preInstalledProfile.setPDFCProperty(PDFCProperty.FIXED_FOOTER_SIZE, "-1");
        preInstalledProfile.setPDFCProperty("TRANSFORM_OPERATIONS", "REPLACE_IDENTICAL");
        return preInstalledProfile;
    }

    public static ProfilePersistence getTextOCR() {
        PreInstalledProfile preInstalledProfile = new PreInstalledProfile(GUID.valueOf((String)"textocr"), "textOCR");
        preInstalledProfile.setPDFCProperty(PDFCProperty.CONTINUOUS_COMPARE, "CONTINUOUS");
        PreInstalledProfile.setTypes(preInstalledProfile, CompareType.TEXT);
        PreInstalledProfile.setFilters(preInstalledProfile, "INVISIBLEELEMENTS", "HEADERFOOTER", "TEXTTRANSFORM", "SOLVEFALSEREPLACE");
        preInstalledProfile.setPDFCProperty(PDFCProperty.COMPARE_TEXT_STYLES, "");
        preInstalledProfile.setPDFCProperty(PDFCProperty.FIXED_HEADER_SIZE, "-1");
        preInstalledProfile.setPDFCProperty(PDFCProperty.FIXED_FOOTER_SIZE, "-1");
        preInstalledProfile.setPDFCProperty("TRANSFORM_OPERATIONS", "REPLACE_IDENTICAL, REPLACE_CONFUSABLES");
        return preInstalledProfile;
    }

    public static ProfilePersistence getContinuousProfile() {
        PreInstalledProfile preInstalledProfile = new PreInstalledProfile(GUID.valueOf((String)"continuous"), "continuous");
        preInstalledProfile.setPDFCProperty(PDFCProperty.CONTINUOUS_COMPARE, "CONTINUOUS");
        PreInstalledProfile.setTypes(preInstalledProfile, CompareType.TEXT, CompareType.LINE, CompareType.IMAGE, CompareType.ANNOTATION);
        PreInstalledProfile.setFilters(preInstalledProfile, "INVISIBLEELEMENTS", "HEADERFOOTER", "TEXTTRANSFORM", "SOLVEFALSEREPLACE");
        preInstalledProfile.setPDFCProperty(PDFCProperty.FIXED_HEADER_SIZE, "-1");
        preInstalledProfile.setPDFCProperty(PDFCProperty.FIXED_FOOTER_SIZE, "-1");
        preInstalledProfile.setPDFCProperty("TRANSFORM_OPERATIONS", "REPLACE_IDENTICAL");
        return preInstalledProfile;
    }

    public static ProfilePersistence getPagedProfile() {
        PreInstalledProfile preInstalledProfile = new PreInstalledProfile(GUID.valueOf((String)"paged"), "paged");
        preInstalledProfile.setPDFCProperty(PDFCProperty.CONTINUOUS_COMPARE, "STRICT");
        PreInstalledProfile.setTypes(preInstalledProfile, CompareType.TEXT, CompareType.LINE, CompareType.IMAGE, CompareType.ANNOTATION);
        PreInstalledProfile.setFilters(preInstalledProfile, "INVISIBLEELEMENTS", "HEADERFOOTER", "TEXTTRANSFORM", "SOLVEFALSEREPLACE");
        preInstalledProfile.setPDFCProperty(PDFCProperty.FIXED_HEADER_SIZE, "-1");
        preInstalledProfile.setPDFCProperty(PDFCProperty.FIXED_FOOTER_SIZE, "-1");
        preInstalledProfile.setPDFCProperty(PDFCProperty.TOLERANCE_TEXT_LOCATION, "-1");
        preInstalledProfile.setPDFCProperty("TRANSFORM_OPERATIONS", "REPLACE_IDENTICAL");
        return preInstalledProfile;
    }

    public static ProfilePersistence getPagedWithTextLocationProfile() {
        PreInstalledProfile preInstalledProfile = new PreInstalledProfile(GUID.valueOf((String)"pagedlocation"), "pagedlocation");
        preInstalledProfile.setPDFCProperty(PDFCProperty.CONTINUOUS_COMPARE, "STRICT");
        PreInstalledProfile.setTypes(preInstalledProfile, CompareType.TEXT, CompareType.LINE, CompareType.IMAGE, CompareType.ANNOTATION);
        PreInstalledProfile.setFilters(preInstalledProfile, "INVISIBLEELEMENTS", "HEADERFOOTER", "TEXTTRANSFORM", "SOLVEFALSEREPLACE");
        preInstalledProfile.setPDFCProperty(PDFCProperty.FIXED_HEADER_SIZE, "-1");
        preInstalledProfile.setPDFCProperty(PDFCProperty.FIXED_FOOTER_SIZE, "-1");
        preInstalledProfile.setPDFCProperty(PDFCProperty.TOLERANCE_TEXT_LOCATION, "0.01");
        preInstalledProfile.setPDFCProperty(PDFCProperty.TOLERANCE_BOX_ROUND_EDGES, "0.01");
        preInstalledProfile.setPDFCProperty(PDFCProperty.TOLERANCE_IMAGE_DISTANCE, "0.01");
        preInstalledProfile.setPDFCProperty(PDFCProperty.TOLERANCE_IMAGE_SIZE, "0.01");
        preInstalledProfile.setPDFCProperty(PDFCProperty.TOLERANCE_LINE_POSITION, "0.01");
        preInstalledProfile.setPDFCProperty(PDFCProperty.TOLERANCE_LINE_SIZE, "0.01");
        preInstalledProfile.setPDFCProperty(PDFCProperty.TOLERANCE_LINE_THICKNESS, "0.01");
        preInstalledProfile.setPDFCProperty(PDFCProperty.TOLERANCE_UNDERLINE_LENGTH, "0.01");
        preInstalledProfile.setPDFCProperty(PDFCProperty.TOLERANCE_PAGE_SIZE, "0.01");
        preInstalledProfile.setPDFCProperty("TRANSFORM_OPERATIONS", "REPLACE_IDENTICAL");
        return preInstalledProfile;
    }

    public static List<ProfilePersistence> getAllPreInstalledProfiles() {
        ArrayList<ProfilePersistence> arrayList = new ArrayList<ProfilePersistence>();
        arrayList.add(PreInstalledProfile.getTextOnlyProfile());
        arrayList.add(PreInstalledProfile.getTextAndStylesProfile());
        arrayList.add(PreInstalledProfile.getContinuousProfile());
        arrayList.add(PreInstalledProfile.getPagedProfile());
        arrayList.add(PreInstalledProfile.getPagedWithTextLocationProfile());
        return arrayList;
    }

    @Override
    public String getName(Locale locale) {
        return this.getLocaleText(locale, this.mk, this.aH);
    }

    @Override
    public String getDescription(Locale locale, boolean useAutoDescription) {
        return this.getLocaleText(locale, this.descCache, this.mj);
    }

    protected String getLocaleText(Locale locale, Map<Locale, String> cache, String textId) {
        String string = cache.get(locale);
        if (string != null) {
            return string;
        }
        if (locale == null) {
            string = new I18nMessages(this.getClass().getPackage().getName() + ".ConfigMessages", (Object)this).getMsg(Locale.ENGLISH, textId, new Object[0]);
        } else {
            string = new I18nMessages(this.getClass().getPackage().getName() + ".ConfigMessages", (Object)this).getMsg(locale, textId, new Object[0]);
            if (string.startsWith("$") || string.endsWith("$")) {
                string = new I18nMessages(this.getClass().getPackage().getName() + ".ConfigMessages", (Object)this).getMsg(Locale.ENGLISH, textId, new Object[0]);
            }
        }
        cache.put(locale, string);
        return string;
    }

    @Override
    @Nonnull
    public DefaultProfile getProfile() {
        DefaultProfile defaultProfile = new DefaultProfile(super.getProfile());
        defaultProfile.putValue("PROFIL_NAME", this.getName(ClientLocale.getThreadLocale()));
        defaultProfile.putValue("PROFIL_DESCRIPTION", this.getDescription(ClientLocale.getThreadLocale(), false));
        String string2 = defaultProfile.getString(PDFCProperty.FILTERS);
        Set<String> set = PreInstalledProfile.bH();
        String string3 = Arrays.asList(string2.split(",")).stream().filter(string -> set.contains(string.trim())).collect(Collectors.joining(","));
        defaultProfile.putValue(PDFCProperty.FILTERS, string3);
        return defaultProfile;
    }

    protected static void setTypes(PreInstalledProfile config, CompareType ... types) {
        StringBuilder stringBuilder = new StringBuilder();
        for (CompareType compareType : types) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(compareType.name());
        }
        config.bG().putValue(PDFCProperty.COMPARE_TYPES, stringBuilder.toString());
    }

    private static Set<String> bH() {
        ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
        HashSet<String> hashSet = new HashSet<String>();
        serverPluginManager.get(ISortFilterFactory.class).forEach(iSortFilterFactory -> hashSet.add(iSortFilterFactory.getExtensionName()));
        serverPluginManager.get(IResultFilterFactory.class).forEach(iResultFilterFactory -> hashSet.add(iResultFilterFactory.getExtensionName()));
        return hashSet;
    }

    protected static void setFilters(PreInstalledProfile config, String ... filters) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : filters) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(string);
        }
        config.bG().putValue(PDFCProperty.FILTERS, stringBuilder.toString());
    }
}

