/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.model;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.util.PdfcImageIO;
import com.inet.shared.utils.ImageUtils;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.Properties;

@JsonData
@InternalApi
public class ImageMetaData
extends Properties {
    private static int[] rgbTyps = new int[]{5, 6, 7, 2, 3, 4, 1, 9, 8};
    private static int[] alphaTyps = new int[]{6, 7, 2, 3};
    private static int[] grayTyps = new int[]{10, 11, 12};

    public void setMeta(BufferedImage image, Properties metaInfoImage) {
        String[] stringArray = new String[]{"TIFF", "PNG", "JPG"};
        if (this.get((Object)KEY.FORMAT) == null) {
            for (String string : stringArray) {
                if (metaInfoImage.get("javax_imageio_" + string.toLowerCase() + "_image") == null) continue;
                this.put((Object)KEY.FORMAT, string);
                break;
            }
        }
        if (this.get((Object)KEY.COLORMODEL) == null) {
            for (int n : rgbTyps) {
                if (image.getType() != n) continue;
                this.put((Object)KEY.COLORMODEL, "RGB");
            }
            for (int n : grayTyps) {
                if (image.getType() != n) continue;
                this.put((Object)KEY.COLORMODEL, "GRAY");
            }
            for (int n : alphaTyps) {
                if (image.getType() != n) continue;
                this.put((Object)KEY.ALPHAMASK, (Object)true);
            }
            if (this.get((Object)KEY.ALPHAMASK) == null) {
                this.put((Object)KEY.ALPHAMASK, (Object)false);
            }
        }
        if (this.get((Object)KEY.DPI_X) == null) {
            Object object = metaInfoImage.get("javax_imageio_1.0.HorizontalPixelSize");
            if (object != null) {
                this.put((Object)KEY.DPI_X, (Object)Math.round(25.4f / Float.parseFloat((String)object)));
            } else {
                Object object2 = metaInfoImage.get("javax_imageio_1.0.Dimension.HorizontalPixelSize");
                if (object2 != null) {
                    this.put((Object)KEY.DPI_X, (Object)Math.round(25.4f / Float.parseFloat((String)object2)));
                }
            }
        }
        if (this.get((Object)KEY.DPI_Y) == null) {
            Object object = metaInfoImage.get("javax_imageio_1.0.VerticalPixelSize");
            if (object != null) {
                this.put((Object)KEY.DPI_Y, (Object)Math.round(25.4f / Float.parseFloat((String)object)));
            } else {
                Object object3 = metaInfoImage.get("javax_imageio_1.0.Dimension.VerticalPixelSize");
                if (object3 != null) {
                    this.put((Object)KEY.DPI_Y, (Object)Math.round(25.4f / Float.parseFloat((String)object3)));
                }
            }
        }
        if (this.get((Object)KEY.DPI_X) != null && this.get((Object)KEY.DPI_Y) != null) {
            int n = (Integer)this.get((Object)KEY.DPI_X);
            int n2 = (Integer)this.get((Object)KEY.DPI_Y);
            int n3 = n > 0 ? (n2 > 0 ? (n + n2) / 2 : n) : (n2 > 0 ? n2 : -1);
            this.put((Object)KEY.DPI, (Object)n3);
        }
    }

    public void setDPI(int dpi) {
        this.put((Object)KEY.DPI, (Object)dpi);
    }

    public void setFormat(byte[] imageData) {
        this.put((Object)KEY.FORMAT, ImageMetaData.detectImageFormat(imageData));
        try {
            PdfcImageIO.ImageWithMeta imageWithMeta = PdfcImageIO.readImage(new ByteArrayInputStream(imageData));
            if (imageWithMeta != null) {
                this.setMeta(imageWithMeta.getImage(), imageWithMeta.getMeta());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String detectImageFormat(byte[] imageData) {
        String string = ImageUtils.detectImageFormat((byte[])imageData);
        if (string.equals("unknow")) {
            return Msg.getMsg("ImageElement.Meta.Unknown");
        }
        return string;
    }

    @InternalApi
    public static final class KEY
    extends Enum<KEY> {
        public static final /* enum */ KEY DPI = new KEY();
        public static final /* enum */ KEY DPI_X = new KEY();
        public static final /* enum */ KEY DPI_Y = new KEY();
        public static final /* enum */ KEY FORMAT = new KEY();
        public static final /* enum */ KEY COLORMODEL = new KEY();
        public static final /* enum */ KEY ALPHAMASK = new KEY();
        private static final /* synthetic */ KEY[] kj;

        public static KEY[] values() {
            return (KEY[])kj.clone();
        }

        public static KEY valueOf(String name) {
            return Enum.valueOf(KEY.class, name);
        }

        private static /* synthetic */ KEY[] bA() {
            return new KEY[]{DPI, DPI_X, DPI_Y, FORMAT, COLORMODEL, ALPHAMASK};
        }

        static {
            kj = KEY.bA();
        }
    }
}

