/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.postcompare;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.config.DefaultProfile;
import com.inet.pdfc.config.IProfile;
import com.inet.pdfc.config.PDFCProperty;
import com.inet.pdfc.generator.model.forms.TwoSidedPaint;
import com.inet.pdfc.plugin.PluginManager;
import com.inet.pdfc.plugin.interfaces.PaintComparatorFactory;
import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

@InternalApi
public class PaintComparator {
    public static final PaintComparator DEFAULT;
    private final int hk;
    private final double hl;
    private final Map<Class<? extends Paint>, Comparator<Paint>> hm = new HashMap<Class<? extends Paint>, Comparator<Paint>>();

    public PaintComparator(IProfile config) {
        this.hl = config.getDouble(PDFCProperty.TOLERANCE_COLOR);
        this.hk = (int)Math.round(this.hl * 255.0);
        for (PaintComparatorFactory paintComparatorFactory : PluginManager.get(PaintComparatorFactory.class)) {
            this.hm.put(paintComparatorFactory.getComparableClass(), paintComparatorFactory.createComparator(config));
        }
    }

    public boolean isEqual(Paint p1, Paint p2) {
        return this.isEqual(p1, p2, true);
    }

    public boolean isEqual(Paint p1, Paint p2, boolean sameDirection) {
        if (p1 == null) {
            return p2 == null;
        }
        if (p2 == null) {
            return false;
        }
        if (p1.getClass() != p2.getClass()) {
            if (p1 instanceof TwoSidedPaint && !((TwoSidedPaint)p1).hasTwoPaints()) {
                p1 = ((TwoSidedPaint)p1).getAny();
            }
            if (p2 instanceof TwoSidedPaint && !((TwoSidedPaint)p2).hasTwoPaints()) {
                p2 = ((TwoSidedPaint)p2).getAny();
            }
        }
        if (!(p1.getClass() == p2.getClass() || p1 instanceof Color && p2 instanceof Color)) {
            return false;
        }
        if (p1 instanceof RadialGradientPaint) {
            RadialGradientPaint radialGradientPaint = (RadialGradientPaint)p1;
            RadialGradientPaint radialGradientPaint2 = (RadialGradientPaint)p2;
            if (!this.a(radialGradientPaint.getColors(), radialGradientPaint2.getColors())) {
                return false;
            }
            if (radialGradientPaint.getCycleMethod() != radialGradientPaint2.getCycleMethod()) {
                return false;
            }
            if (!radialGradientPaint.getFocusPoint().equals(radialGradientPaint2.getFocusPoint())) {
                return false;
            }
            if (!Arrays.equals(radialGradientPaint.getFractions(), radialGradientPaint2.getFractions())) {
                return false;
            }
            return !(radialGradientPaint.getRadius() - radialGradientPaint2.getRadius() > 1.0f);
        }
        if (p1 instanceof LinearGradientPaint) {
            LinearGradientPaint linearGradientPaint = (LinearGradientPaint)p1;
            LinearGradientPaint linearGradientPaint2 = (LinearGradientPaint)p2;
            if (!this.a(linearGradientPaint.getColors(), linearGradientPaint2.getColors())) {
                return false;
            }
            if (linearGradientPaint.getCycleMethod() != linearGradientPaint2.getCycleMethod()) {
                return false;
            }
            if (!Arrays.equals(linearGradientPaint.getFractions(), linearGradientPaint2.getFractions())) {
                return false;
            }
            if (!linearGradientPaint.getStartPoint().equals(linearGradientPaint2.getStartPoint())) {
                return false;
            }
            return linearGradientPaint.getEndPoint().equals(linearGradientPaint2.getEndPoint());
        }
        if (p1 instanceof Color) {
            return this.a((Color)p1, (Color)p2);
        }
        if (p1 instanceof TwoSidedPaint) {
            TwoSidedPaint twoSidedPaint = (TwoSidedPaint)p1;
            TwoSidedPaint twoSidedPaint2 = (TwoSidedPaint)p2;
            return this.isEqual(twoSidedPaint.getPaint(true), twoSidedPaint2.getPaint(sameDirection)) && this.isEqual(twoSidedPaint.getPaint(false), twoSidedPaint2.getPaint(!sameDirection));
        }
        Comparator<Paint> comparator = this.hm.get(p1.getClass());
        if (comparator != null) {
            return comparator.compare(p1, p2) == 0;
        }
        return p1.equals(p2);
    }

    private boolean a(Color[] colorArray, Color[] colorArray2) {
        if (colorArray == null) {
            return colorArray2 == null;
        }
        if (colorArray2 == null) {
            return false;
        }
        if (colorArray.length != colorArray2.length) {
            return false;
        }
        for (int i = 0; i < colorArray.length; ++i) {
            if (this.a(colorArray[i], colorArray2[i])) continue;
            return false;
        }
        return true;
    }

    private boolean a(Color color, Color color2) {
        if (color == null || color2 == null) {
            return color != null || color2 != null;
        }
        if (Math.abs(color.getRed() - color2.getRed()) <= this.hk && Math.abs(color.getGreen() - color2.getGreen()) <= this.hk && Math.abs(color.getBlue() - color2.getBlue()) <= this.hk && Math.abs(color.getAlpha() - color2.getAlpha()) <= this.hk) {
            return true;
        }
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), new float[3]);
        float[] fArray2 = Color.RGBtoHSB(color2.getRed(), color2.getGreen(), color2.getBlue(), new float[3]);
        return PaintComparator.a(fArray, fArray2, this.hl);
    }

    private static boolean a(float[] fArray, float[] fArray2, double d2) {
        if (!PaintComparator.a(fArray[2], fArray2[2], d2)) {
            return false;
        }
        if (!(fArray[2] + fArray2[2] > 0.0f)) {
            return true;
        }
        if (!PaintComparator.a(fArray[1], fArray2[1], d2 /= (double)((fArray[2] + fArray2[2]) / 2.0f))) {
            return false;
        }
        if (!(fArray[1] + fArray2[1] > 0.0f)) {
            return true;
        }
        if (!PaintComparator.a(fArray[0], fArray2[0], d2 /= (double)((fArray[1] + fArray2[1]) / 2.0f))) {
            float f2;
            float f3 = f2 = fArray2[0] < fArray[0] ? fArray2[0] + 1.0f : fArray2[0] - 1.0f;
            if (!PaintComparator.a(fArray[0], f2, d2)) {
                return false;
            }
        }
        return true;
    }

    private static boolean a(double d2, double d3, double d4) {
        return !(Math.abs(d3 - d2) > d4);
    }

    static {
        DefaultProfile defaultProfile = new DefaultProfile();
        defaultProfile.putValue(PDFCProperty.TOLERANCE_COLOR, "0.001");
        DEFAULT = new PaintComparator(defaultProfile);
    }
}

