/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.model.forms;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.PDFCCore;
import com.inet.pdfc.generator.model.forms.GeomShape;
import com.inet.pdfc.generator.model.forms.LineShapeSegmented;
import com.inet.pdfc.generator.model.forms.TwoSidedPaint;
import com.inet.pdfc.generator.postcompare.PaintComparator;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.ShapeElement;
import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import javax.annotation.Nonnull;

@JsonData
@InternalApi
public class LineShape
extends GeomShape {
    private static final double ANGLE_TOLERANCE = 0.01;
    private static final double ANGLE_TOLERANCE_PARALLEL = 0.005;
    private static final double ANGLE_SMALL_LINE_SIZE = 10.0;
    private static final double ANGLE_SMALL_LINE_MIN = 0.5;
    private static final double ANGLE_SMALL_LINE_LIMIT = 0.1;
    private static final double SAME_SHAPE_ANGLE_FACTOR = 2.0;
    private Line2D line;
    private Line2D originalLine;
    private boolean isUnderline = false;
    @Nonnull
    private final ElementType type;
    private double rotation;
    private static final double TYPE_RATIO = 0.015;

    public LineShape(Line2D line, @Nonnull ShapeElement source, @Nonnull ElementID id) {
        this(line, source.getStrokePaint(), source.getFillPaint(), source.getStroke(), source.getPageIndex(), source, id);
    }

    public LineShape(Line2D object, Paint strokeColor, Paint fillColor, BasicStroke stroke, int pageIndex, @Nonnull ShapeElement sourceElement, @Nonnull ElementID id) {
        super(strokeColor, fillColor, stroke, pageIndex, sourceElement, id);
        double d2 = object.getX2() - object.getX1();
        double d3 = object.getY2() - object.getY1();
        if (d2 != 0.0 && (d3 == 0.0 || Math.abs(d3 / d2) < 0.015)) {
            if (d3 == 0.0 && stroke != null && stroke.getDashArray() == null && (double)stroke.getLineWidth() > Math.abs(d2 * 3.0) && stroke.getLineWidth() > 1.0f && fillColor == null) {
                this.type = ElementType.LineVertical;
                this.rotation = 1.5707963267948966;
                float f2 = stroke.getLineWidth() / 2.0f;
                float f3 = (float)Math.abs(object.getX2() - object.getX1());
                float f4 = (float)(Math.min(object.getX2(), object.getX1()) + (double)(f3 / 2.0f));
                float f5 = (float)object.getY1();
                object = new Line2D.Float(f4, f5 - f2, f4, f5 + f2);
                this.setStroke(new BasicStroke(f3, stroke.getEndCap(), stroke.getLineJoin(), stroke.getMiterLimit()));
            } else {
                this.type = ElementType.LineHorizontal;
                this.rotation = 0.0;
            }
        } else if (d3 != 0.0 && (d2 == 0.0 || Math.abs(d2 / d3) < 0.015)) {
            if (d2 == 0.0 && stroke != null && stroke.getDashArray() == null && (double)stroke.getLineWidth() > Math.abs(d3 * 3.0) && stroke.getLineWidth() > 1.0f && fillColor == null) {
                this.type = ElementType.LineHorizontal;
                this.rotation = 0.0;
                float f6 = stroke.getLineWidth() / 2.0f;
                float f7 = (float)Math.abs(object.getY2() - object.getY1());
                float f8 = (float)(Math.min(object.getY2(), object.getY1()) + (double)(f7 / 2.0f));
                float f9 = (float)object.getX1();
                object = new Line2D.Float(f9 - f6, f8, f9 + f6, f8);
                this.setStroke(new BasicStroke(f7, stroke.getEndCap(), stroke.getLineJoin(), stroke.getMiterLimit()));
            } else {
                this.type = ElementType.LineVertical;
                this.rotation = 1.5707963267948966;
            }
        } else {
            this.type = ElementType.Line;
            this.rotation = Math.atan2(object.getY1() - object.getY2(), object.getX1() - object.getX2());
            if (this.rotation < 0.0) {
                this.rotation += Math.PI;
            }
        }
        this.line = object;
    }

    @Override
    public ElementType getType() {
        return this.type;
    }

    @Override
    public double getRotation() {
        return this.rotation;
    }

    public Line2D getLine() {
        return this.line;
    }

    protected void setLine(Line2D line) {
        this.checkOriginalLineModification(line);
        this.line = line;
    }

    protected void checkOriginalLineModification(Line2D line) {
        if (!line.equals(this.line)) {
            if (this.originalLine != null) {
                PDFCCore.LOGGER_CORE.debug((Object)"Warning: Modification of moved line - may lead to an inconsistent result");
            }
            this.originalLine = this.line;
        }
    }

    @Override
    public Rectangle2D getBounds() {
        return this.line.getBounds2D();
    }

    public String toString() {
        String string = "";
        if (this.getType() == ElementType.LineHorizontal) {
            string = "H";
        }
        if (this.getType() == ElementType.LineVertical) {
            string = "V";
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.##");
        return "Line" + string + " at (" + decimalFormat.format(this.getX()) + "," + decimalFormat.format(this.getY()) + ") with length " + decimalFormat.format(this.line.getP1().distance(this.line.getP2())) + ", angle " + decimalFormat.format(this.getLineAngle() / Math.PI * 180.0) + "\u00b0";
    }

    public String getReadableForm() {
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        String string = decimalFormat.format(this.getX1());
        String string2 = decimalFormat.format(this.getX2());
        String string3 = decimalFormat.format(this.getY1());
        String string4 = decimalFormat.format(this.getY2());
        String string5 = decimalFormat.format(this.getLineAngle() * 180.0 / Math.PI);
        String string6 = "";
        if (Math.abs(this.line.getX1() - this.line.getX2()) < 0.01) {
            string6 = this.line.getY1() > this.line.getY2() ? "\u2191 " : "\u2193 ";
        } else if (Math.abs(this.line.getY1() - this.line.getY2()) < 0.01) {
            string6 = this.line.getX1() > this.line.getX2() ? "\u2190 " : "\u2192 ";
        }
        return string6 + "( " + string + " : " + string3 + " - " + string2 + " : " + string4 + " | " + string5 + "\u00b0 ) [" + String.valueOf(this.getElementID()) + "]";
    }

    public boolean isUnderline() {
        return this.isUnderline;
    }

    public void setUnderline(boolean isUnderline) {
        this.isUnderline = isUnderline;
        if (this.getStrokePaint() == null) {
            Paint paint = this.getFillPaint();
            if (paint instanceof TwoSidedPaint) {
                paint = ((TwoSidedPaint)paint).getPaint(true);
            }
            this.setStrokePaint(paint);
        }
    }

    @Override
    public int getCompareHash() {
        return 5;
    }

    @Override
    public double getY() {
        return this.line.getY1() < this.line.getY2() ? this.line.getY1() : this.line.getY2();
    }

    @Override
    public double getX() {
        return this.line.getX1() < this.line.getX2() ? this.line.getX1() : this.line.getX2();
    }

    @Override
    public void setX(double x) {
        double d2 = x - this.getX();
        if (d2 != 0.0 && this.originalLine == null) {
            this.originalLine = this.line;
        }
        this.line = new Line2D.Double(this.line.getX1() + d2, this.line.getY1(), this.line.getX2() + d2, this.line.getY2());
    }

    @Override
    public void setY(double y) {
        double d2 = y - this.getY();
        if (d2 != 0.0 && this.originalLine == null) {
            this.originalLine = this.line;
        }
        this.line = new Line2D.Double(this.line.getX1(), this.line.getY1() + d2, this.line.getX2(), this.line.getY2() + d2);
    }

    @Override
    public Shape getShape() {
        return this.line;
    }

    @Override
    public double getX1() {
        return this.line.getX1();
    }

    @Override
    public double getY1() {
        return this.line.getY1();
    }

    @Override
    public double getX2() {
        return this.line.getX2();
    }

    @Override
    public double getY2() {
        return this.line.getY2();
    }

    private double getLineAngle() {
        return Math.atan2(this.line.getY2() - this.line.getY1(), this.line.getX2() - this.line.getX1());
    }

    public boolean canMergeByAngle(LineShape other, boolean sameShape) {
        return this.canMergeByAngle(other, sameShape, false);
    }

    private boolean canMergeByAngle(LineShape other, boolean sameShape, boolean perpendicular) {
        double d2;
        double d3 = this.getLineAngle();
        double d4 = Math.abs(d3 - (d2 = other.getLineAngle() + (perpendicular ? 1.5707963267948966 : 0.0))) % Math.PI;
        if (d4 > 0.1 && d4 < 3.041592653589793) {
            return false;
        }
        double d5 = 0.01;
        if (sameShape) {
            d5 /= 2.0;
        }
        if (d4 > d5 && d4 < Math.PI - d5) {
            double d6 = this.getLineLength();
            double d7 = other.getLineLength();
            if (d6 >= 10.0 && d7 >= 10.0) {
                return false;
            }
            double d8 = Math.min(d6, d7);
            if (d8 <= 0.5) {
                d5 = 0.1;
            } else {
                double d9 = (d8 - 0.5) / 9.5;
                d5 = 0.1 - d9 * 0.09000000000000001;
            }
            if (sameShape) {
                d5 /= 2.0;
            }
            if (d4 > d5 && d4 < Math.PI - d5) {
                return false;
            }
        }
        return true;
    }

    public boolean canMerge(LineShape other, double toleranceP, double toleranceH) {
        double d2;
        double d3;
        double d4;
        if (this.isSameParent(other)) {
            return false;
        }
        if (!this.canMergeByAngle(other, false)) {
            return false;
        }
        Line2D line2D = other.line;
        if (!this.hasSameDirection(other) && this.getStrokePaint() == null && other.getStrokePaint() == null && Math.max(d4 = this.getLineLength(), d3 = other.getLineLength()) / Math.min(d4, d3) < 1.0 + toleranceP) {
            d2 = Math.min(3.0, Math.max((d4 + d3) / 2.0 * toleranceP, toleranceP));
            if (this.getLine().getP1().distance(other.getLine().getP2()) < d2 && this.getLine().getP2().distance(other.getLine().getP1()) < d2 && PaintComparator.DEFAULT.isEqual(this.getFillPaint(), other.getFillPaint())) {
                return true;
            }
        }
        if ((d4 = this.line.ptLineDist(line2D.getX1(), line2D.getY1())) > toleranceP) {
            return false;
        }
        d3 = this.line.ptLineDist(line2D.getX2(), line2D.getY2());
        if (d3 > toleranceP) {
            return false;
        }
        d2 = this.getLineLength();
        double d5 = other.getLineLength();
        toleranceH = Math.min(toleranceH, Math.min(d2 / 2.0, d5 / 2.0));
        double d6 = this.getDistanceToP1(line2D.getX1(), line2D.getY1());
        double d7 = this.getDistanceToP1(line2D.getX2(), line2D.getY2());
        if (d6 < 0.0 && d7 < 0.0) {
            return Math.min(-d6, -d7) < toleranceH;
        }
        if (d6 > d2 && d7 > d2) {
            return Math.min(d6 - d2, d7 - d2) < toleranceH;
        }
        return true;
    }

    private boolean isSameParent(LineShape other) {
        int[] nArray = this.getElementID().getRaw();
        int[] nArray2 = other.getElementID().getRaw();
        boolean bl = true;
        if (nArray.length == nArray2.length) {
            for (int i = 0; i < nArray.length - 1; ++i) {
                if (nArray[i] == nArray2[i]) continue;
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public LineShapeSegmented toSegmented() {
        if (this.originalLine != null) {
            PDFCCore.LOGGER_CORE.debug((Object)"Warning: Segmentation of moved line - may lead to an inconsistent result");
        }
        return new LineShapeSegmented(this.line, this.getStrokePaint(), this.getFillPaint(), this.getStroke(), this.getPageIndex(), this.getSource(), this.getElementID());
    }

    public void normalizeDirection() {
        double d2 = this.line.getX1();
        double d3 = this.line.getY1();
        double d4 = this.line.getX2();
        double d5 = this.line.getY2();
        if (d5 < d5 || d5 == d3 && d4 < d2) {
            this.line = new Line2D.Double(d4, d5, d2, d3);
            if (this.getFillPaint() instanceof TwoSidedPaint) {
                this.setFillPaint(((TwoSidedPaint)this.getFillPaint()).copyInverse());
            }
        }
        if (this.originalLine != null) {
            d2 = this.originalLine.getX1();
            d3 = this.originalLine.getY1();
            d4 = this.originalLine.getX2();
            d5 = this.originalLine.getY2();
            if (d5 < d5 || d5 == d3 && d4 < d2) {
                this.originalLine = new Line2D.Double(d4, d5, d2, d3);
            }
        }
    }

    public double getLineLength() {
        return Point2D.distance(this.line.getX1(), this.line.getY1(), this.line.getX2(), this.line.getY2());
    }

    protected double getDistanceToP1(double x, double y) {
        double d2 = this.getLineLength();
        double d3 = Point2D.distance(this.line.getX1(), this.line.getY1(), x, y);
        double d4 = Point2D.distance(this.line.getX2(), this.line.getY2(), x, y);
        return this.getPointToLineRelation(d3, d4, d2);
    }

    private double getPointToLineRelation(double pointToP1, double pointToP2, double lineLen) {
        if (pointToP1 <= lineLen && pointToP2 <= lineLen || pointToP1 > lineLen && pointToP1 > pointToP2) {
            return pointToP1;
        }
        return -pointToP1;
    }

    public boolean hasSameDirection(LineShape other) {
        double d2;
        double d3 = this.getLineAngle();
        double d4 = Math.abs(d3 - (d2 = other.getLineAngle())) % (Math.PI * 2);
        return d4 < 0.01 || Math.PI * 2 - d4 < 0.01;
    }

    public boolean isParallel(LineShape other) {
        double d2;
        double d3 = this.getLineAngle();
        double d4 = Math.abs(d3 - (d2 = other.getLineAngle())) % Math.PI;
        return d4 < 0.005 || Math.PI - d4 < 0.005;
    }

    public LineShape getOriginalLine() {
        if (this.originalLine == null) {
            return this;
        }
        return new LineShape(this.originalLine, this.getStrokePaint(), this.getFillPaint(), this.getStroke(), this.getPageIndex(), this.getSource(), this.getElementID());
    }
}

