/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.model;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.pdfc.config.ColorSetting;
import com.inet.pdfc.generator.model.DifferencePages;
import com.inet.pdfc.generator.model.IDiffGroupBounds;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.i18n.Msg;
import com.inet.pdfc.model.PagedElement;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@JsonData
@PublicApi
public abstract class DiffGroup
implements Serializable {
    public abstract List<PagedElement> getRemovedElements();

    public abstract List<PagedElement> getAddedElements();

    public abstract Rectangle getBounds(boolean var1);

    public abstract int getDifferencesCount();

    public abstract IDiffGroupBounds getBoundingElements();

    public abstract GroupType getType();

    public String toString() {
        return (this.getType() != null ? this.getType().name() : "Equal") + ": " + String.valueOf(this.getRemovedElements()) + " -> " + String.valueOf(this.getAddedElements());
    }

    public abstract List<Modification> getModifications();

    public DifferencePages getDifferencePages(boolean first) {
        List<Modification> list = this.getModifications();
        if (list.size() > 0) {
            Object object;
            int n = -1;
            int n2 = -1;
            for (Modification object2 : list) {
                object = object2.getDifferencePages(first);
                if (object == null) continue;
                if (n == -1) {
                    n = ((DifferencePages)object).getStartPage();
                    n2 = ((DifferencePages)object).getEndPage();
                }
                if (((DifferencePages)object).getStartPage() < n) {
                    n = ((DifferencePages)object).getStartPage();
                }
                if (((DifferencePages)object).getEndPage() <= n2) continue;
                n2 = ((DifferencePages)object).getEndPage();
            }
            if (n == -1) {
                IDiffGroupBounds iDiffGroupBounds = this.getBoundingElements();
                PagedElement pagedElement = first ? iDiffGroupBounds.getBeforeFirst() : iDiffGroupBounds.getBeforeSecond();
                Object object2 = object = first ? iDiffGroupBounds.getAfterFirst() : iDiffGroupBounds.getAfterSecond();
                if (pagedElement != null) {
                    if (object != null) {
                        n = pagedElement.getPageIndex() + 1;
                        n2 = object.getPageIndex() + 1;
                    } else {
                        n = pagedElement.getPageIndex() + 1;
                        n2 = pagedElement.getPageIndex() + 1;
                    }
                } else if (object != null) {
                    n = object.getPageIndex() + 1;
                    n2 = object.getPageIndex() + 1;
                } else {
                    return null;
                }
            }
            if (n == -1) {
                return null;
            }
            return new DifferencePages(n, n2);
        }
        return null;
    }

    public abstract boolean isVisible();

    @PublicApi
    public static final class GroupType
    extends Enum<GroupType>
    implements ColorSetting {
        public static final /* enum */ GroupType AddedOrRemoved = new GroupType(true);
        public static final /* enum */ GroupType Replaced = new GroupType(true);
        public static final /* enum */ GroupType Modified = new GroupType(true);
        public static final /* enum */ GroupType ValidationError = new GroupType(true);
        public static final /* enum */ GroupType MetadataChanged = new GroupType(true);
        public static final /* enum */ GroupType Sync = new GroupType(false);
        private static final GroupType[] fS;
        private boolean fT;
        private static final /* synthetic */ GroupType[] fU;

        public static GroupType[] values() {
            return (GroupType[])fU.clone();
        }

        public static GroupType valueOf(String name) {
            return Enum.valueOf(GroupType.class, name);
        }

        private GroupType(boolean doPaint) {
            this.fT = doPaint;
        }

        public boolean isTypePainted() {
            return this.fT;
        }

        public static GroupType[] valuesVisible() {
            return fS;
        }

        public String getLocalizedName() {
            return Msg.getMsg("Settings." + this.getTranslationKey());
        }

        @Override
        public String getTyp() {
            return "GroupType";
        }

        private static /* synthetic */ GroupType[] aV() {
            return new GroupType[]{AddedOrRemoved, Replaced, Modified, ValidationError, MetadataChanged, Sync};
        }

        static {
            fU = GroupType.aV();
            fS = Arrays.asList(GroupType.values()).stream().filter(groupType -> groupType.fT).collect(Collectors.toList()).toArray(new GroupType[0]);
        }
    }
}

