/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.generator.ComparatorProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

@JsonData
@InternalApi
public class ComparatorProperties
implements Serializable {
    private Map<ComparatorProperty, String> properties = new HashMap<ComparatorProperty, String>();

    public void setComparerProperty(@Nonnull ComparatorProperty key, @Nonnull String value) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("The property key must not be null");
        }
        switch (key) {
            case createHighlightData: 
            case createImages: 
            case createTextSelectionData: {
                if (value != null && (Boolean.TRUE.toString().equals(value.toLowerCase()) || Boolean.FALSE.toString().equals(value.toLowerCase()))) break;
                throw new IllegalArgumentException("A boolean value is required for property " + key.name());
            }
        }
        if (value != null) {
            this.properties.put(key, value);
        } else {
            this.properties.remove((Object)key);
        }
    }

    @Nonnull
    public String getProperty(@Nonnull ComparatorProperty key) {
        String string = this.properties.get((Object)key);
        return string != null ? string : key.getDefault();
    }

    public boolean isCreateImages() {
        return Boolean.valueOf(this.getProperty(ComparatorProperty.createImages));
    }

    public boolean isCreateTextSelectionData() {
        return Boolean.valueOf(this.getProperty(ComparatorProperty.createTextSelectionData));
    }

    public boolean isCreateHighlightData() {
        return Boolean.valueOf(this.getProperty(ComparatorProperty.createHighlightData));
    }
}

