/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.config;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.config.PdfSource;
import com.inet.pdfc.i18n.Msg;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.persistence.RandomAccessRead;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

@JsonData
@InternalApi
public class PersistencePdfSource
extends PdfSource {
    private transient PersistenceEntry pdfFile;

    public PersistencePdfSource(PersistenceEntry pdfFile) {
        super(pdfFile.getName(), pdfFile.getPath(), pdfFile.lastModified(), pdfFile.size());
        if (!pdfFile.exists()) {
            throw new IllegalArgumentException(Msg.getMsg("Error.DoesNotExist", pdfFile.getName()));
        }
        this.pdfFile = pdfFile;
    }

    public PersistencePdfSource(PersistenceEntry pdfFile, String explicitName) {
        this(pdfFile);
        this.getMetaProperties().put("NAME", explicitName);
    }

    public PersistencePdfSource(PersistenceEntry pdfFile, String explicitName, boolean setNoMetaPath) {
        this(pdfFile, explicitName);
        if (setNoMetaPath) {
            this.getMetaProperties().remove("PATH");
        }
    }

    @Override
    public long getLastModified() {
        return this.pdfFile.lastModified();
    }

    @Override
    public long getSize() {
        return this.pdfFile.size();
    }

    @Override
    public String getPath() {
        String string = super.getPath();
        if (string == null) {
            string = this.pdfFile.getPath();
        }
        return string;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.pdfFile.getPath());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        String string = (String)stream.readObject();
        this.pdfFile = Persistence.getInstance().resolve(string);
    }

    @Override
    public RandomAccessRead getContent() throws IOException {
        return this.pdfFile.getRandomAccessRead();
    }
}

