/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.pattern.shadertype4;

import com.inet.pdfview.pattern.shadertype4.VertexTriangle;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class VertexController
implements Serializable {
    private static final long serialVersionUID = 1646834318217997103L;
    private List<VertexTriangle> triangles = new ArrayList<VertexTriangle>();

    public boolean equals(Object obj) {
        if (!(obj instanceof VertexController)) {
            return false;
        }
        return this.triangles.equals(((VertexController)obj).triangles);
    }

    private VertexTriangle getCurrentTriangle() {
        int size = this.triangles.size();
        return size == 0 ? null : this.triangles.get(size - 1);
    }

    public void addVertex(int flag, double vertexX, double vertexY, float[] colorComp) {
        VertexTriangle currentTriangle = this.getCurrentTriangle();
        if (currentTriangle == null) {
            currentTriangle = this.getNewTriangle();
        }
        if (!currentTriangle.addVertex(flag, vertexX, vertexY, colorComp)) {
            VertexTriangle newTriangle = this.getNewTriangle();
            switch (flag) {
                case 0: {
                    break;
                }
                case 1: {
                    newTriangle.addVertex(currentTriangle.getVertexes()[1]);
                    newTriangle.addVertex(currentTriangle.getVertexes()[2]);
                    break;
                }
                case 2: {
                    newTriangle.addVertex(currentTriangle.getVertexes()[0]);
                    newTriangle.addVertex(currentTriangle.getVertexes()[2]);
                }
            }
            newTriangle.addVertex(flag, vertexX, vertexY, colorComp);
        }
    }

    private VertexTriangle getNewTriangle() {
        VertexTriangle newTriangle = new VertexTriangle();
        this.triangles.add(newTriangle);
        return newTriangle;
    }

    public List<VertexTriangle> transformVertexCoordinates(AffineTransform xform) {
        if (xform.isIdentity()) {
            return this.triangles;
        }
        ArrayList<VertexTriangle> transformedTriangles = new ArrayList<VertexTriangle>();
        for (VertexTriangle triangle : this.triangles) {
            VertexTriangle transformedTriangle = triangle.getTtransformedTriangle(xform);
            transformedTriangle.normalize();
            transformedTriangles.add(transformedTriangle);
        }
        return transformedTriangles;
    }
}

