/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.pattern.shadertype4;

import java.awt.geom.Point2D;
import java.io.Serializable;

public class ColorVertex
implements Comparable<ColorVertex>,
Serializable {
    private static final long serialVersionUID = -5118690053204071241L;
    private static final double EPS = 0.001;
    private int flag;
    private Point2D vertexPoint;
    private float[] colorComps;

    ColorVertex(int flag, Point2D point, float[] colorComps) {
        this.flag = flag;
        this.vertexPoint = point;
        this.colorComps = colorComps;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ColorVertex)) {
            return false;
        }
        ColorVertex other = (ColorVertex)obj;
        if (this.flag != other.flag) {
            return false;
        }
        if (this.vertexPoint.distance(other.vertexPoint) > (double)0.1f) {
            return false;
        }
        if (this.colorComps.length != other.colorComps.length) {
            return false;
        }
        for (int i = 0; i < this.colorComps.length; ++i) {
            if (!((double)Math.abs(this.colorComps[i] - other.colorComps[i]) > 0.05)) continue;
            return false;
        }
        return true;
    }

    Point2D getVertexPoint() {
        return this.vertexPoint;
    }

    int getFlag() {
        return this.flag;
    }

    double getY() {
        return this.vertexPoint.getY();
    }

    double getX() {
        return this.vertexPoint.getX();
    }

    float[] getColorComp() {
        return this.colorComps;
    }

    @Override
    public int compareTo(ColorVertex v) {
        if (this.getY() < v.getY() - 0.001) {
            return -1;
        }
        if (this.getY() > v.getY() + 0.001) {
            return 1;
        }
        return this.getX() - v.getX() < 0.0 ? -1 : 1;
    }

    boolean hasTheSameYPosAs(ColorVertex other) {
        return Math.abs(this.getY() - other.getY()) < 0.001;
    }
}

