/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.pattern;

import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFPaint;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.PDFRenderer;
import com.inet.pdfview.PDFXref;
import com.inet.pdfview.colorspace.PDFColorSpace;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.function.PDFFunction;
import com.inet.pdfview.pattern.PDFShader;
import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.Serializable;

public class ShaderType2
extends PDFShader
implements Serializable {
    private static final long serialVersionUID = -6539001381818041169L;
    private Point2D axisStart;
    private Point2D axisEnd;
    private float minT = 0.0f;
    private float maxT = 1.0f;
    private float[] tValues = new float[]{this.minT, this.maxT};
    private boolean extendStart = false;
    private boolean extendEnd = false;
    private PDFFunction[] functions;
    private Paint smask;

    public ShaderType2() {
        super(2);
    }

    @Override
    public void parse(PDFObject shaderObj, PDFDecrypter decrypter, AffineTransform transform, Paint smask, boolean isAlphaChannel) throws PDFParseException {
        PDFObject functionObj;
        this.smask = smask;
        PDFObject coordsObj = shaderObj.getDictRef("Coords");
        if (coordsObj == null) {
            throw new PDFParseException("No coordinates found!");
        }
        PDFObject[] coords = coordsObj.getArray();
        Point2D.Float start = new Point2D.Float(coords[0].getFloatValue(), coords[1].getFloatValue());
        Point2D.Float end = new Point2D.Float(coords[2].getFloatValue(), coords[3].getFloatValue());
        transform.transform(start, start);
        transform.transform(end, end);
        if (((Point2D)start).getX() == ((Point2D)end).getX() && ((Point2D)start).getY() == ((Point2D)end).getY()) {
            ((Point2D)end).setLocation(((Point2D)end).getX() + (double)1.0E-4f, ((Point2D)end).getY());
        }
        this.setAxisStart(start);
        this.setAxisEnd(end);
        PDFObject domainObj = shaderObj.getDictRef("Domain");
        if (domainObj != null) {
            PDFObject[] domain = domainObj.getArray();
            this.setMinT(domain[0].getFloatValue());
            this.setMaxT(domain[1].getFloatValue());
        }
        if ((functionObj = shaderObj.getDictRef("Function")) == null) {
            throw new PDFParseException("No function defined for shader!");
        }
        PDFXref ref = functionObj.getRefValue();
        PDFObject[] functionArray = functionObj.getArray();
        PDFFunction[] functions = new PDFFunction[functionArray.length];
        for (int i = 0; i < functions.length; ++i) {
            functions[i] = PDFFunction.getFunction(functionArray[i], decrypter, ref);
            this.tValues = functions[i].getSubDomains();
        }
        this.setFunctions(functions);
        PDFObject extendObj = shaderObj.getDictRef("Extend");
        if (extendObj != null) {
            PDFObject[] extendArray = extendObj.getArray();
            this.setExtendStart(extendArray[0].getBooleanValue());
            this.setExtendEnd(extendArray[1].getBooleanValue());
        }
    }

    private LinearGradientPaint getLinearGradient() {
        Color[] colorsTmp;
        Color[] colors = new Color[this.tValues.length];
        PDFColorSpace colorSpace = this.getColorSpace();
        int componentCount = colorSpace.getNumComponents();
        float[] inputs = new float[1];
        float[] outputs = new float[componentCount];
        for (int i = 0; i < this.tValues.length; ++i) {
            inputs[0] = this.tValues[i];
            colors[i] = this.calculateColor(inputs, outputs);
        }
        if (this.smask != null) {
            if (this.smask instanceof LinearGradientPaint) {
                LinearGradientPaint linearGradientPaint = (LinearGradientPaint)this.smask;
                Color[] colorsAlphaChannel = linearGradientPaint.getColors();
                this.mergeAlphaChannel(colors, colorsAlphaChannel);
            } else {
                PDFParser.LOGGER.error((Object)"LinearGradient SMASK with RadialGradient ALPHA channel is not yet supported");
            }
        }
        float[] fractions = new float[this.tValues.length];
        float unit = this.getMaxT() - this.getMinT();
        for (int i = 0; i < this.tValues.length; ++i) {
            fractions[i] = this.tValues[i] / unit;
        }
        if (!this.getExtendStart()) {
            float[] tmp = new float[fractions.length + 1];
            System.arraycopy(fractions, 0, tmp, 1, fractions.length);
            tmp[0] = tmp[1];
            fractions = tmp;
            colorsTmp = new Color[colors.length + 1];
            System.arraycopy(colors, 0, colorsTmp, 1, colors.length);
            colorsTmp[0] = TRANSPARENT;
            colors = colorsTmp;
        }
        if (!this.getExtendEnd()) {
            float[] tmp = new float[fractions.length + 1];
            System.arraycopy(fractions, 0, tmp, 0, fractions.length);
            tmp[tmp.length - 1] = tmp[fractions.length - 1];
            fractions = tmp;
            colorsTmp = new Color[colors.length + 1];
            System.arraycopy(colors, 0, colorsTmp, 0, colors.length);
            colorsTmp[colorsTmp.length - 1] = TRANSPARENT;
            colors = colorsTmp;
        }
        fractions = ShaderType2.normalize(fractions);
        return new LinearGradientPaint(this.getAxisStart(), this.getAxisEnd(), fractions, colors);
    }

    @Override
    public PDFPaint getPaint() {
        return PDFPaint.getPaint(this.getLinearGradient());
    }

    @Override
    public PDFPaint getPatternPaint() {
        return new PDFPaintWrapper(this.getLinearGradient());
    }

    private Color calculateColor(float[] inputs, float[] outputs) {
        Color res = null;
        if (this.functions.length == 1) {
            this.functions[0].calculate(inputs, 0, outputs, 0);
        } else {
            for (int f = 0; f < this.functions.length; ++f) {
                this.functions[f].calculate(inputs, 0, outputs, f);
            }
        }
        PDFPaint pdfpaint0 = this.getColorSpace().getPaint(outputs);
        Paint p = pdfpaint0.getPaint(null);
        if (p instanceof Color) {
            res = (Color)p;
        }
        return res;
    }

    public Point2D getAxisStart() {
        return this.axisStart;
    }

    protected void setAxisStart(Point2D axisStart) {
        this.axisStart = axisStart;
    }

    public Point2D getAxisEnd() {
        return this.axisEnd;
    }

    protected void setAxisEnd(Point2D axisEnd) {
        this.axisEnd = axisEnd;
    }

    public float getMinT() {
        return this.minT;
    }

    protected void setMinT(float minT) {
        this.minT = minT;
    }

    public float getMaxT() {
        return this.maxT;
    }

    protected void setMaxT(float maxT) {
        this.maxT = maxT;
    }

    public boolean getExtendStart() {
        return this.extendStart;
    }

    protected void setExtendStart(boolean extendStart) {
        this.extendStart = extendStart;
    }

    public boolean getExtendEnd() {
        return this.extendEnd;
    }

    protected void setExtendEnd(boolean extendEnd) {
        this.extendEnd = extendEnd;
    }

    public PDFFunction[] getFunctions() {
        return this.functions;
    }

    protected void setFunctions(PDFFunction[] functions) {
        this.functions = functions;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ShaderType2)) {
            return false;
        }
        ShaderType2 sobj = (ShaderType2)obj;
        if (!this.axisStart.equals(sobj.axisStart) || !this.axisEnd.equals(sobj.axisEnd) || this.functions.length != sobj.functions.length) {
            return false;
        }
        for (int i = 0; i < this.functions.length; ++i) {
            if (this.functions[i].equals(sobj.functions[i])) continue;
            return false;
        }
        return true;
    }

    private class PDFPaintWrapper
    extends PDFPaint {
        private Point2D start;
        private Point2D end;
        private final float[] fractions;
        private final Color[] colors;
        private LinearGradientPaint gradientPaint;

        public PDFPaintWrapper(LinearGradientPaint gradientPaint) {
            super(gradientPaint);
            this.start = gradientPaint.getStartPoint();
            this.end = gradientPaint.getEndPoint();
            this.fractions = gradientPaint.getFractions();
            this.colors = gradientPaint.getColors();
            this.gradientPaint = gradientPaint;
        }

        @Override
        public Paint getPaint(PDFRenderer state) {
            if (state != null) {
                try {
                    this.start = this.gradientPaint.getStartPoint();
                    this.end = this.gradientPaint.getEndPoint();
                    AffineTransform inverse = state.getTransform().createInverse();
                    inverse.transform(this.start, this.start);
                    inverse.transform(this.end, this.end);
                }
                catch (NoninvertibleTransformException e) {
                    PDFParser.LOGGER.warn((Object)"NoninvertibleTransform by Shader2, some object are incorrect.");
                }
            }
            return new LinearGradientPaint(this.start, this.end, this.fractions, this.colors);
        }
    }
}

