/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.pattern;

import com.inet.pdfview.CacheAccess;
import com.inet.pdfview.PDFFile;
import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFPage;
import com.inet.pdfview.PDFPaint;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.PDFRenderer;
import com.inet.pdfview.command.PDFCmd;
import com.inet.pdfview.command.PDFCompositeCmd;
import com.inet.pdfview.command.PDFImageCmd;
import com.inet.pdfview.command.PDFShapeCmd;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.pattern.PDFPattern;
import com.inet.shared.utils.LayerGraphics2D;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.util.Map;

public class PatternType1
extends PDFPattern {
    public static final int PAINT_COLORED = 1;
    public static final int PAINT_UNCOLORED = 2;
    public static final int TILE_CONSTANT = 1;
    public static final int TILE_NODISTORT = 2;
    public static final int TILE_FASTER = 3;
    private Map<String, PDFObject> resources;
    private int paintType;
    private int tilingType;
    private Rectangle2D bbox;
    private double xStep;
    private double yStep;
    private byte[] data;
    private PDFDecrypter decrypter;
    private PDFFile owner;
    private CacheAccess fontGenerationListener;

    public PatternType1(PDFDecrypter decrypter, PDFFile owner, CacheAccess fontGenerationListener) {
        super(1);
        this.decrypter = decrypter;
        this.owner = owner;
        this.fontGenerationListener = fontGenerationListener;
    }

    @Override
    protected void parse(PDFObject patternObj, Map<String, PDFObject> rsrc, PDFDecrypter decrypter, boolean isAlphaChannel) throws PDFParseException {
        this.data = patternObj.getStream(decrypter == null ? null : patternObj.getRefValue(), decrypter, true);
        this.resources = patternObj.getDictRef("Resources").getDictionary();
        this.paintType = patternObj.getDictRef("PaintType").getIntValue();
        this.tilingType = patternObj.getDictRef("TilingType").getIntValue();
        PDFObject bboxObj = patternObj.getDictRef("BBox");
        this.bbox = PDFFile.parseRect(bboxObj);
        this.xStep = patternObj.getDictRef("XStep").getDoubleValue();
        this.yStep = patternObj.getDictRef("YStep").getDoubleValue();
    }

    @Override
    public PDFPaint getPaint(PDFPaint basePaint) {
        PDFPage page = new PDFPage(-1, this.bbox, 0, this.decrypter, null, null);
        if (basePaint != null) {
            page.addFillPaint(basePaint);
            page.addStrokePaint(basePaint);
        }
        PDFParser prc = new PDFParser(page, this.data, this.resources, this.fontGenerationListener, this.owner);
        prc.go(true);
        AffineTransform transform = new AffineTransform(this.getTransform());
        return new TilingPatternPaint(page, this.xStep, this.yStep, transform);
    }

    public static class TilingPatternPaint
    extends PDFPaint {
        private PDFPage page;
        private AWTPaint paint;
        private AffineTransform lastTx;
        private double xStep;
        private double yStep;
        private AffineTransform transform;

        public TilingPatternPaint(PDFPage page, double xStep, double yStep, AffineTransform transform) {
            super(null);
            this.page = page;
            this.xStep = xStep;
            this.yStep = yStep;
            this.transform = transform;
        }

        @Override
        public void fill(PDFRenderer state, Graphics2D g, Shape s) {
            AffineTransform tx = new AffineTransform();
            try {
                tx = state.getTransform().createInverse();
            }
            catch (NoninvertibleTransformException e) {
                PDFParser.LOGGER.warn((Object)e);
            }
            tx.concatenate(state.getInitialTransform());
            state.push();
            if (!tx.equals(this.lastTx)) {
                this.paint = new AWTPaint(tx, this.page, this.xStep, this.yStep);
                this.lastTx = tx;
            }
            g.setPaint(this.paint);
            g.fill(s);
            state.pop();
        }

        @Override
        public Paint getPaint(PDFRenderer state) {
            AffineTransform tx = new AffineTransform();
            try {
                tx = state.getTransform().createInverse();
            }
            catch (NoninvertibleTransformException e) {
                PDFParser.LOGGER.warn((Object)e);
            }
            tx.concatenate(this.transform);
            return new AWTPaint(tx, this.page, this.xStep, this.yStep);
        }
    }

    public static class AWTPaint
    implements Paint {
        private static final int MAX_TEXTURE_SIZE = 512;
        private static final int MAX_IMAGE_TEXTURE_SIZE = 2048;
        private AffineTransform transform;
        private double xStep;
        private double yStep;
        private boolean hasImage;
        private boolean hasSMask;
        private PDFPage page;

        public AWTPaint(AffineTransform initialTransform, PDFPage page, double xStep, double yStep) {
            this.transform = initialTransform;
            this.page = page;
            this.xStep = xStep;
            this.yStep = yStep;
            this.checkImageAndSMask();
        }

        @Override
        public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
            double patternWidth = deviceBounds.width;
            double patternHeight = deviceBounds.height;
            AffineTransform tx = new AffineTransform(xform);
            tx.concatenate(this.transform);
            if (this.hasImage && (this.xStep > 2048.0 || this.yStep > 2048.0)) {
                double tileWidth = this.xStep > patternWidth ? (double)deviceBounds.width + Math.min(1000.0, this.xStep - patternWidth) : this.xStep;
                double tileHeight = this.yStep > patternHeight ? patternHeight + Math.min(1000.0, this.yStep - patternHeight) : this.yStep;
                double aX = this.xStep <= patternWidth ? deviceBounds.getX() : this.transform.getTranslateX();
                double aY = this.yStep <= patternHeight ? deviceBounds.getY() : this.transform.getTranslateY();
                BufferedImage img = new BufferedImage((int)tileWidth, (int)tileHeight, 2);
                Graphics2D g = img.createGraphics();
                Color color = new Color(255, 255, 255, 1);
                g.setColor(color);
                g.fillRect(0, 0, (int)tileWidth, (int)tileHeight);
                this.draw(g);
                g.dispose();
                Rectangle2D.Double anchor = new Rectangle2D.Double(aX, aY, tileWidth, tileHeight);
                return new TexturePaint(img, anchor).createContext(cm, deviceBounds, userBounds, xform, hints);
            }
            double scaleLimitX = 512.0 / this.xStep;
            double scaleX = (double)((int)Math.round(Math.abs(tx.getScaleX()) * 1000000.0)) / 1000000.0;
            if (scaleX > scaleLimitX) {
                scaleX = scaleLimitX;
            }
            while ((int)Math.round(Math.max(this.xStep * scaleX, 1.0)) > 512) {
                this.xStep /= 2.0;
                scaleLimitX = 512.0 / this.xStep;
                if (!(scaleX > scaleLimitX)) continue;
                scaleX = scaleLimitX;
            }
            double scaleLimitY = 512.0 / this.yStep;
            double scaleY = (double)((int)Math.round(Math.abs(tx.getScaleY()) * 1000000.0)) / 1000000.0;
            if (scaleY > scaleLimitY) {
                scaleY = scaleLimitY;
            }
            while ((int)Math.round(Math.max(this.yStep * scaleY, 1.0)) > 512) {
                this.yStep /= 2.0;
                scaleLimitY = 512.0 / this.yStep;
                if (!(scaleY > scaleLimitY)) continue;
                scaleY = scaleLimitY;
            }
            tx.scale(1.0 / scaleX, 1.0 / scaleY);
            int width = (int)Math.floor(Math.max(this.xStep * scaleX, 1.0));
            int height = (int)Math.floor(Math.max(this.yStep * scaleY, 1.0));
            BufferedImage img = new BufferedImage(width, height, 2);
            Graphics2D g = img.createGraphics();
            g.scale(scaleX, scaleY);
            this.draw(g);
            Rectangle2D.Double anchor = new Rectangle2D.Double(0.0, 0.0, img.getWidth(), img.getHeight());
            return new TexturePaint(img, anchor).createContext(cm, this.transform.createTransformedShape(userBounds).getBounds(), userBounds, tx, hints);
        }

        private boolean checkImageAndSMask() {
            for (PDFCmd pdfCmd : this.page.getCommands()) {
                PDFCompositeCmd comp;
                if (pdfCmd instanceof PDFCompositeCmd && (comp = (PDFCompositeCmd)pdfCmd).hasSMask()) {
                    this.hasImage = true;
                    this.hasSMask = true;
                }
                if (pdfCmd instanceof PDFImageCmd) {
                    this.hasImage = true;
                    continue;
                }
                if (!(pdfCmd instanceof PDFShapeCmd)) continue;
                this.hasImage = false;
            }
            return false;
        }

        @Override
        public int getTransparency() {
            return 3;
        }

        public boolean hasImage() {
            return this.hasImage;
        }

        public AffineTransform getTransform() {
            return this.transform;
        }

        public double getXStep() {
            return this.xStep;
        }

        public double getYStep() {
            return this.yStep;
        }

        public Rectangle getPatternSize() {
            Rectangle bounds = this.page.getBounds().getBounds();
            AffineTransform transform = this.getTransform();
            double scaleX = transform.getScaleX();
            double scaleY = transform.getScaleY();
            int x = (int)(bounds.getX() * scaleX);
            int y = (int)(bounds.getY() * scaleY);
            int width = Math.max(1, (int)Math.ceil(bounds.getWidth() * scaleX));
            int height = Math.max(1, (int)Math.ceil(bounds.getHeight() * scaleY));
            return new Rectangle(x, y, width, height);
        }

        public void draw(Graphics2D g) {
            double offsetX = this.page.getBounds().getX();
            double offsetY = this.page.getBounds().getY();
            double x0 = Math.floor(-offsetX / this.xStep) * this.xStep;
            double y0 = Math.floor(-offsetY / this.yStep) * this.yStep;
            double x1 = Math.ceil((this.xStep - offsetX) / this.xStep) * this.xStep;
            double y1 = Math.ceil((this.yStep - offsetY) / this.yStep) * this.yStep;
            this.page.setBuildPageImage(true);
            double scaleX = 1.0;
            double scaleY = 1.0;
            Shape oclip = g.getClip();
            AffineTransform otx = g.getTransform();
            if (this.page.getWidth() > 512.0f) {
                scaleX = this.page.getWidth() / 512.0f;
            }
            if (this.page.getHeight() > 512.0f) {
                scaleY = this.page.getHeight() / 512.0f;
            }
            Rectangle2D.Double imgbounds = new Rectangle2D.Double(0.0, 0.0, (double)this.page.getWidth() / scaleX, (double)this.page.getHeight() / scaleY);
            BufferedImage pageImage = new BufferedImage((int)((RectangularShape)imgbounds).getWidth(), (int)((RectangularShape)imgbounds).getHeight(), 2);
            Graphics2D imgGraphics = (Graphics2D)pageImage.getGraphics();
            LayerGraphics2D layerGraphics2D = new LayerGraphics2D();
            layerGraphics2D.setGraphics(imgGraphics);
            PDFRenderer pdfRenderer = new PDFRenderer(this.page, (Graphics2D)layerGraphics2D, imgbounds, null);
            pdfRenderer.go(true);
            for (double dx = x0; dx < x1; dx += this.xStep) {
                for (double dy = y0; dy < y1; dy += this.yStep) {
                    g.setTransform(otx);
                    g.setClip(oclip);
                    g.translate(dx, dy);
                    g.clip(this.page.getBounds());
                    g.transform(this.page.getInitialTransform());
                    g.scale(scaleX, scaleY);
                    g.drawImage((Image)pageImage, 0, 0, null);
                }
            }
        }
    }
}

