/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.pattern;

import com.inet.pdfview.CacheAccess;
import com.inet.pdfview.PDFFile;
import com.inet.pdfview.PDFObject;
import com.inet.pdfview.PDFPage;
import com.inet.pdfview.PDFPaint;
import com.inet.pdfview.PDFParser;
import com.inet.pdfview.decrypt.PDFDecrypter;
import com.inet.pdfview.error.PDFParseException;
import com.inet.pdfview.pattern.PatternType1;
import com.inet.pdfview.pattern.PatternType2;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.util.Map;

public abstract class PDFPattern {
    private int type;
    private AffineTransform xform;

    protected PDFPattern(int type) {
        this.type = type;
    }

    public static PDFPattern getPattern(PDFObject patternObj, Map<String, PDFObject> resources, PDFDecrypter decrypter, CacheAccess fontGenerationListener, PDFPage pdfPage, boolean isAlphaChannel) throws PDFParseException {
        PDFPattern pattern = (PDFPattern)patternObj.getCache();
        if (pattern != null) {
            return pattern;
        }
        PDFFile owner = patternObj.getOwner();
        if (patternObj.getDictRef("PatternType") == null) {
            String message = patternObj.getRefValue() == null ? "for inner pdf object" : "for pdf object id " + patternObj.getRefValue().getID();
            PDFParser.LOGGER.error((Object)("PatternType not defined " + message + "\nAdobe say: Beim Verarbeiten einer Seite ist ein Fehler aufgetreten. Beim Lesen dieses Dokuments ist ein Problem aufgegtreten (16)."));
            return new PDFPattern(-1){

                @Override
                protected void parse(PDFObject patternObj, Map<String, PDFObject> resources, PDFDecrypter decrypter, boolean isAlphaChannel) throws PDFParseException {
                }

                @Override
                public PDFPaint getPaint(PDFPaint basePaint) {
                    return new PDFPaint(new Color(0, 0, 0, 0));
                }
            };
        }
        int type = patternObj.getDictRef("PatternType").getIntValue();
        PDFObject matrix = patternObj.getDictRef("Matrix");
        AffineTransform xform = null;
        if (matrix == null) {
            xform = new AffineTransform();
        } else {
            float[] elts = new float[6];
            for (int i = 0; i < elts.length; ++i) {
                elts[i] = matrix.getAt(i).getFloatValue();
            }
            xform = new AffineTransform(elts);
        }
        switch (type) {
            case 1: {
                pattern = new PatternType1(decrypter, owner, fontGenerationListener);
                break;
            }
            case 2: {
                pattern = new PatternType2();
                break;
            }
            default: {
                PDFParser.LOGGER.warn((Object)("Unknown pattern type " + type));
                return new PDFPattern(type){

                    @Override
                    protected void parse(PDFObject patternObj, Map<String, PDFObject> resources, PDFDecrypter decrypter, boolean isAlphaChannel) throws PDFParseException {
                    }

                    @Override
                    public PDFPaint getPaint(PDFPaint basePaint) {
                        return new PDFPaint(new Color(0, 0, 0, 0));
                    }
                };
            }
        }
        AffineTransform transform = pdfPage.getInitialTransform();
        transform.concatenate(xform);
        pattern.setTransform(transform);
        pattern.parse(patternObj, resources, decrypter, isAlphaChannel);
        patternObj.setCache(pattern);
        return pattern;
    }

    public int getPatternType() {
        return this.type;
    }

    public AffineTransform getTransform() {
        return this.xform;
    }

    protected void setTransform(AffineTransform xform) {
        this.xform = xform;
    }

    protected abstract void parse(PDFObject var1, Map<String, PDFObject> var2, PDFDecrypter var3, boolean var4) throws PDFParseException;

    public abstract PDFPaint getPaint(PDFPaint var1);
}

