/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfview.pattern;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class BitReader {
    private InputStream in;
    private byte currentByte;
    private byte bitPosition = (byte)8;

    public BitReader(InputStream in) {
        this.in = in;
    }

    public boolean read() throws IOException, EOFException {
        if (this.bitPosition == 8) {
            int read = this.in.read();
            if (read == -1) {
                throw new EOFException();
            }
            this.currentByte = (byte)read;
            this.bitPosition = 0;
        }
        byte by = this.bitPosition;
        this.bitPosition = (byte)(by + 1);
        return (this.currentByte & 1 << 7 - by) != 0;
    }

    public int read(int bits) throws IOException, EOFException {
        int value = 0;
        for (int i = bits - 1; i >= 0; --i) {
            if (!this.read()) continue;
            value |= 1 << i;
        }
        return value;
    }

    long readUnsignedInt(int bytelength) throws UnsupportedOperationException, IOException {
        if (bytelength > 7) {
            throw new UnsupportedOperationException("invalid length of int value: " + bytelength + " bytes. The length value must be between 1 aand 7");
        }
        if (this.in.available() < bytelength) {
            throw new EOFException();
        }
        byte[] byteValues = new byte[bytelength];
        this.in.read(byteValues);
        long value = 0L;
        for (int i = 0; i < byteValues.length; ++i) {
            value = (value << 8) + (long)(byteValues[i] & 0xFF);
        }
        return value;
    }
}

